/*
 * Decompiled with CFR 0.152.
 */
package bars;

import bars.BarsAboutForm;
import bars.BarsCalcRecord;
import bars.BarsHelpForm;
import bars.BarsMIDlet;
import bars.BarsVolumeCalc_GOST_2708_75;
import bars.BarsVolumeCalc_ISO_4480_83;
import bars.BarsVolumeCalculator;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class BarsVolumeCalculatorForm
extends Form
implements CommandListener,
ItemCommandListener {
    private BarsMIDlet midlet;
    private TextField logDiameter;
    private TextField logLength;
    private TextField quantityOfLogs;
    private List totalsList;
    private List settingsList;
    private Command okCommand = new Command(">", 4, 1);
    private Command aboutCommand = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 8, 2);
    private Command settingsCommand = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 1, 3);
    private Command helpCommand = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 5, 4);
    private Command exitCommand = new Command("\u0412\u044b\u0439\u0442\u0438", 7, 5);
    private Command editCommand = new Command("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", 1, 2);
    private Command deleteCommand = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 1, 3);
    private Command clearCommand = new Command("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c", 1, 4);
    private Command backCommand = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    private BarsVolumeCalculator calculator;
    private int d;
    private int l;
    private int q;
    private Vector calculations;
    private boolean editing;
    private int editingIndex;

    public BarsVolumeCalculatorForm(BarsMIDlet midlet) {
        super("Bars Timber Volume");
        this.midlet = midlet;
        this.calculations = new Vector(5, 5);
        this.editing = false;
        this.logLength = new TextField("\u0414\u043b\u0438\u043d\u0430 (\u043c):", "", 4, 5);
        this.logLength.setLayout(1);
        this.logLength.setDefaultCommand(this.okCommand);
        this.logLength.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.logLength);
        this.logDiameter = new TextField("\u0414\u0438\u0430\u043c\u0435\u0442\u0440 (\u0441\u043c):", "", 4, 2);
        this.logDiameter.setLayout(1);
        this.logDiameter.setDefaultCommand(this.okCommand);
        this.logDiameter.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.logDiameter);
        this.quantityOfLogs = new TextField("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:", "", 4, 2);
        this.quantityOfLogs.setLayout(1);
        this.quantityOfLogs.setDefaultCommand(this.okCommand);
        this.quantityOfLogs.setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.quantityOfLogs);
        this.totalsList = new List("Calculations", 3);
        this.totalsList.setSelectCommand(this.okCommand);
        this.totalsList.addCommand(this.clearCommand);
        this.totalsList.addCommand(this.editCommand);
        this.totalsList.addCommand(this.deleteCommand);
        this.totalsList.setCommandListener((CommandListener)this);
        this.settingsList = new List("\u0418\u0441\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435", 1);
        this.settingsList.append("GOST 2708-75", null);
        this.settingsList.append("ISO 4480-83", null);
        this.settingsList.addCommand(this.backCommand);
        this.settingsList.setCommandListener((CommandListener)this);
        this.RecreateCalculator();
        try {
            this.setCommandListener(this);
            this.addCommand(this.settingsCommand);
            this.addCommand(this.aboutCommand);
            this.addCommand(this.helpCommand);
            this.addCommand(this.exitCommand);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7) {
            this.midlet.destroyApp(true);
        } else if (command.getCommandType() == 4) {
            if (displayable == this) {
                this.DoCalculation();
            } else if (displayable == this.totalsList) {
                this.PrepareToNextCalculation();
            }
        } else if (command.getCommandType() == 1) {
            if (displayable.equals(this.totalsList)) {
                if (command.equals(this.clearCommand)) {
                    this.calculations.removeAllElements();
                    this.PrepareToNextCalculation();
                } else {
                    int selNo = this.totalsList.getSelectedIndex();
                    if (selNo > this.calculations.size() - 1) {
                        return;
                    }
                    if (command.equals(this.deleteCommand)) {
                        this.calculations.removeElementAt(selNo);
                        if (selNo > this.totalsList.size() - 1) {
                            selNo = this.totalsList.size() - 1;
                        }
                        this.ShowTotals(selNo);
                    } else if (command.equals(this.editCommand)) {
                        BarsCalcRecord cr = (BarsCalcRecord)this.calculations.elementAt(selNo);
                        this.logDiameter.setString(cr.sd);
                        this.logLength.setString(cr.sl);
                        this.quantityOfLogs.setString(cr.sq);
                        this.editing = true;
                        this.editingIndex = selNo;
                        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
                    }
                }
            } else if (displayable == this && command.equals(this.settingsCommand)) {
                this.ShowSettings();
            }
        } else if (command.getCommandType() == 8) {
            BarsAboutForm aboutForm = new BarsAboutForm(this.midlet, this);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)aboutForm);
        } else if (command.getCommandType() == 5) {
            BarsHelpForm helpForm = new BarsHelpForm(this.midlet, this);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)helpForm);
        } else if (command.getCommandType() == 2 && displayable == this.settingsList) {
            int newMode = this.settingsList.getSelectedIndex();
            if (newMode != this.midlet.GetMode()) {
                this.midlet.SetMode(newMode);
                this.RecreateCalculator();
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        }
    }

    public void commandAction(Command command, Item item) {
        if (command.getCommandType() == 4) {
            this.DoCalculation();
        }
    }

    private void PrepareToNextCalculation() {
        this.logDiameter.setString("");
        this.quantityOfLogs.setString("");
        this.editing = false;
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
    }

    private void DoCalculation() {
        if (!(this.ParseDiameter() && this.ParseLength() && this.ParseQuantity())) {
            return;
        }
        this.calculator.CalcVolume(this.d, this.l, this.q);
        if (!this.calculator.VolumeIsCalculated()) {
            this.ShowError("It is not possible to calculate volume!\n");
            return;
        }
        BarsCalcRecord cr = new BarsCalcRecord(this.logDiameter.getString(), this.logLength.getString(), this.quantityOfLogs.getString(), this.calculator.GetVolumeAsString(), this.calculator.GetVolume());
        if (this.editing) {
            this.calculations.setElementAt(cr, this.editingIndex);
            this.ShowTotals(this.editingIndex);
        } else {
            this.calculations.addElement(cr);
            this.ShowTotals(this.calculations.size() - 1);
        }
    }

    private boolean ParseDiameter() {
        String sd = this.logDiameter.getString();
        if (sd.length() == 0) {
            this.ShowError("\u0412\u0432\u0435\u0434\u0438 \u0434\u0438\u0430\u043c\u0435\u0442\u0440!");
            return false;
        }
        try {
            this.d = Integer.parseInt(sd);
        }
        catch (NumberFormatException ex) {
            this.ShowError("The diameter should be numerical value!");
            return false;
        }
        int minDiam = this.calculator.GetMinDiameter();
        int maxDiam = this.calculator.GetMaxDiameter();
        if (this.d < minDiam || this.d > maxDiam) {
            this.ShowError("\u0414\u0438\u0430\u043c\u0435\u0442\u0440 \u043e\u0442 " + Integer.toString(minDiam) + " \u0438 \u0434\u043e " + Integer.toString(maxDiam) + " \u0441\u0430\u043d\u0442\u0438\u043c\u0435\u0442\u0440\u043e\u0432!");
            return false;
        }
        return true;
    }

    private boolean ParseLength() {
        String sl = this.logLength.getString();
        if (sl.length() == 0) {
            this.ShowError("\u0412\u0432\u0435\u0434\u0438 \u0434\u043b\u0438\u043d\u0443!");
            return false;
        }
        int pp = sl.indexOf(".");
        if (pp == -1) {
            sl = sl.concat("00");
        } else {
            String n = sl.substring(0, pp);
            String m = pp < sl.length() - 1 ? sl.substring(pp + 1) : "";
            if (m.length() > 2) {
                m = m.substring(0, 1);
            } else {
                while (m.length() < 2) {
                    m = m.concat("0");
                }
            }
            sl = n.concat(m);
        }
        try {
            this.l = Integer.parseInt(sl);
        }
        catch (NumberFormatException ex) {
            this.ShowError("The length should be numerical value!");
            return false;
        }
        int minLen = this.calculator.GetMinLength();
        int maxLen = this.calculator.GetMaxLength();
        if (this.l < minLen || this.l > maxLen) {
            this.ShowError("\u0414\u043b\u0438\u043d\u0430 \u043e\u0442 " + BarsVolumeCalculator.GetAsString(minLen, 2) + " \u0438 \u0434\u043e " + BarsVolumeCalculator.GetAsString(maxLen, 2) + " \u043c\u0435\u0442\u0440\u043e\u0432!");
            return false;
        }
        return true;
    }

    private boolean ParseQuantity() {
        String sq = this.quantityOfLogs.getString();
        if (sq.length() == 0) {
            this.ShowError("\u0412\u0432\u0435\u0434\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e!");
            return false;
        }
        try {
            this.q = Integer.parseInt(sq);
        }
        catch (NumberFormatException ex) {
            this.ShowError("The quantity should be the whole positive number!");
            return false;
        }
        if (this.q < 1) {
            this.ShowError("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1!");
            return false;
        }
        return true;
    }

    private void ShowError(String errMsg) {
        Alert al = new Alert("\u041a\u0443\u0431\u0430\u0442\u0443\u0440\u043d\u0438\u043a", errMsg, null, AlertType.ERROR);
        al.setTimeout(5000);
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)al);
    }

    private void ShowTotals(int selIndex) {
        long totalVolume = 0L;
        this.totalsList.deleteAll();
        for (int i = 0; i < this.calculations.size(); ++i) {
            BarsCalcRecord cr = (BarsCalcRecord)this.calculations.elementAt(i);
            totalVolume += cr.volume;
            this.totalsList.append(cr.toString(), null);
        }
        this.totalsList.append("\u0412\u0441\u0435\u0433\u043e: ".concat(BarsVolumeCalculator.GetAsString(totalVolume, 10)), null);
        this.totalsList.setSelectedIndex(selIndex, true);
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.totalsList);
    }

    private void ShowSettings() {
        this.settingsList.setSelectedIndex(this.midlet.GetMode(), true);
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.settingsList);
    }

    private void RecreateCalculator() {
        this.calculator = this.midlet.GetMode() == 0 ? new BarsVolumeCalc_GOST_2708_75(this.midlet) : new BarsVolumeCalc_ISO_4480_83(this.midlet);
    }
}

