/*
 * Decompiled with CFR 0.152.
 */
package mobiledevtools.keys;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import mobiledevtools.keys.KeyState;

public class KeyStateList {
    int listSize;
    int numEntries;
    int[] keyCodes;
    KeyState[] keyStates;

    public KeyStateList(Canvas canvas, Font font) {
        this.listSize = canvas.getHeight() / (font.getHeight() + 1);
        this.keyCodes = new int[this.listSize];
        this.keyStates = new KeyState[this.listSize];
        this.numEntries = 0;
        for (int i = 0; i < this.listSize; ++i) {
            this.keyStates[i] = new KeyState();
        }
    }

    public int getSize() {
        return this.listSize;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void addEntry(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.numEntries; ++n3) {
            if (this.keyCodes[n3] != n) continue;
            this.keyStates[n3].set(n2);
            return;
        }
        if (this.listSize == this.numEntries) {
            --this.numEntries;
        }
        n3 = this.numEntries + 1;
        while (1 < n3--) {
            this.keyCodes[n3] = this.keyCodes[n3 - 1];
            this.keyStates[n3].reset(this.keyStates[n3 - 1]);
        }
        this.keyCodes[0] = n;
        this.keyStates[0].reset(n2);
        ++this.numEntries;
    }

    public int getCode(int n) {
        if (0 > n || this.numEntries <= n) {
            System.err.println("getCode(" + n + ") invalid index");
            return 0;
        }
        return this.keyCodes[n];
    }

    public KeyState getState(int n) {
        if (0 > n || this.numEntries <= n) {
            System.err.println("getState(" + n + ") invalid index");
            return null;
        }
        return this.keyStates[n];
    }
}

