/*
 * Decompiled with CFR 0.152.
 */
package mobiledevtools.keys;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import mobiledevtools.keys.KeyState;
import mobiledevtools.keys.KeyStateList;

public class KeyStateCanvas
extends Canvas {
    static final int backgroundColour = 0xFFFFFF;
    static final int borderColour = 0;
    static final int textColour = 0x1010C0;
    Font fonText = Font.getFont((int)64, (int)0, (int)8);
    KeyStateList list = new KeyStateList(this, this.fonText);
    int fontHeight;
    int listSize = this.list.getSize();

    public KeyStateCanvas() {
        this.fontHeight = this.fonText.getHeight() + 1;
    }

    private String getFullKeyName(int n) {
        int n2;
        boolean bl = true;
        int n3 = 32;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = 0;
        }
        if (48 == n) {
            n3 = 48;
        } else if (49 == n) {
            n3 = 49;
        } else if (50 == n) {
            n3 = 50;
        } else if (51 == n) {
            n3 = 51;
        } else if (52 == n) {
            n3 = 52;
        } else if (53 == n) {
            n3 = 53;
        } else if (54 == n) {
            n3 = 54;
        } else if (55 == n) {
            n3 = 55;
        } else if (56 == n) {
            n3 = 56;
        } else if (57 == n) {
            n3 = 57;
        } else if (35 == n) {
            n3 = 35;
        } else if (42 == n) {
            n3 = 42;
        } else {
            bl = false;
        }
        if (bl && 0 != n2) {
            stringBuffer.append('(');
        }
        if (1 == n2) {
            stringBuffer.append("UP");
        } else if (6 == n2) {
            stringBuffer.append("DOWN");
        } else if (2 == n2) {
            stringBuffer.append("LEFT");
        } else if (5 == n2) {
            stringBuffer.append("RIGHT");
        } else if (8 == n2) {
            stringBuffer.append("FIRE");
        } else if (9 == n2) {
            stringBuffer.append("GAMEA");
        } else if (10 == n2) {
            stringBuffer.append("GAMEB");
        } else if (11 == n2) {
            stringBuffer.append("GAMEC");
        } else if (12 == n2) {
            stringBuffer.append("GAMED");
        } else if (!bl) {
            stringBuffer.append("Key " + n);
        }
        if (bl) {
            if (0 != n2) {
                stringBuffer.append(") ");
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private String getStateName(KeyState keyState) {
        StringBuffer stringBuffer = new StringBuffer();
        if (keyState.isPressed()) {
            stringBuffer.append("Dn ");
        }
        if (keyState.isRepeated()) {
            stringBuffer.append(".. ");
        }
        if (keyState.isReleased()) {
            stringBuffer.append("Up ");
        }
        return stringBuffer.toString();
    }

    private void drawEntry(Graphics graphics, int n, int n2, KeyState keyState) {
        int n3 = this.getWidth();
        int n4 = n3 / 2;
        graphics.setColor(0);
        graphics.drawRect(0, n, n3 - 1, this.fontHeight);
        graphics.setColor(0x1010C0);
        graphics.drawString(this.getFullKeyName(n2), n4 - 1, n + 1, 24);
        graphics.drawString(this.getStateName(keyState), n4 + 1, n + 1, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        KeyStateList keyStateList = this.list;
        synchronized (keyStateList) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n2 / this.listSize;
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, n, --n2);
            graphics.setFont(this.fonText);
            int n4 = this.list.getNumEntries();
            for (int i = 0; i < n4; ++i) {
                this.drawEntry(graphics, n2 -= n3, this.list.getCode(i), this.list.getState(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int n) {
        KeyStateList keyStateList = this.list;
        synchronized (keyStateList) {
            this.list.addEntry(n, 1);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyRepeated(int n) {
        KeyStateList keyStateList = this.list;
        synchronized (keyStateList) {
            this.list.addEntry(n, 4);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyReleased(int n) {
        KeyStateList keyStateList = this.list;
        synchronized (keyStateList) {
            this.list.addEntry(n, 2);
        }
        this.repaint();
    }
}

