/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.util.Calendar;
import java.util.Date;
import net.sf.zipme.ZipConstants;

public class ZipEntry
implements ZipConstants {
    private static final int KNOWN_SIZE = 1;
    private static final int KNOWN_CSIZE = 2;
    private static final int KNOWN_CRC = 4;
    private static final int KNOWN_TIME = 8;
    private static final int KNOWN_EXTRA = 16;
    private static Calendar cal;
    private String name;
    private int size;
    private long compressedSize = -1L;
    private int crc;
    private int dostime;
    private short known = 0;
    private short method = (short)-1;
    private byte[] extra = null;
    private String comment = null;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String name) {
        int length = name.length();
        if (length > 65535) {
            throw new IllegalArgumentException("name length is " + length);
        }
        this.name = name;
    }

    public ZipEntry(ZipEntry e) {
        this(e, e.name);
    }

    ZipEntry(ZipEntry e, String name) {
        this.name = name;
        this.known = e.known;
        this.size = e.size;
        this.compressedSize = e.compressedSize;
        this.crc = e.crc;
        this.dostime = e.dostime;
        this.method = e.method;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    final void setDOSTime(int dostime) {
        this.dostime = dostime;
        this.known = (short)(this.known | 8);
    }

    final int getDOSTime() {
        if ((this.known & 8) == 0) {
            return 0;
        }
        return this.dostime;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(long time) {
        Calendar cal;
        Calendar calendar = cal = ZipEntry.getCalendar();
        synchronized (calendar) {
            cal.setTime(new Date(time));
            this.dostime = (cal.get(1) - 1980 & 0x7F) << 25 | cal.get(2) + 1 << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        }
        this.known = (short)(this.known | 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTime() {
        this.parseExtra();
        if ((this.known & 8) == 0) {
            return -1L;
        }
        int sec = 2 * (this.dostime & 0x1F);
        int min = this.dostime >> 5 & 0x3F;
        int hrs = this.dostime >> 11 & 0x1F;
        int day = this.dostime >> 16 & 0x1F;
        int mon = (this.dostime >> 21 & 0xF) - 1;
        int year = (this.dostime >> 25 & 0x7F) + 1980;
        try {
            Calendar calendar = cal = ZipEntry.getCalendar();
            synchronized (calendar) {
                cal.set(1, year);
                cal.set(2, mon);
                cal.set(5, day);
                cal.set(11, hrs);
                cal.set(12, min);
                cal.set(13, sec);
                return cal.getTime().getTime();
            }
        }
        catch (RuntimeException ex) {
            this.known = (short)(this.known & 0xFFFFFFF7);
            return -1L;
        }
    }

    private static synchronized Calendar getCalendar() {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return cal;
    }

    public void setSize(long size) {
        if ((size & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)size;
        this.known = (short)(this.known | 1);
    }

    public long getSize() {
        return (this.known & 1) != 0 ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long csize) {
        this.compressedSize = csize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCrc(long crc) {
        if ((crc & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)crc;
        this.known = (short)(this.known | 4);
    }

    public long getCrc() {
        return (this.known & 4) != 0 ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (short)method;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] extra) {
        if (extra == null) {
            this.extra = null;
            return;
        }
        if (extra.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = extra;
    }

    private void parseExtra() {
        if ((this.known & 0x10) != 0) {
            return;
        }
        if (this.extra == null) {
            this.known = (short)(this.known | 0x10);
            return;
        }
        try {
            int len;
            for (int pos = 0; pos < this.extra.length; pos += len) {
                byte flags;
                int sig = this.extra[pos++] & 0xFF | (this.extra[pos++] & 0xFF) << 8;
                len = this.extra[pos++] & 0xFF | (this.extra[pos++] & 0xFF) << 8;
                if (sig != 21589 || ((flags = this.extra[pos]) & 1) == 0) continue;
                long time = this.extra[pos + 1] & 0xFF | (this.extra[pos + 2] & 0xFF) << 8 | (this.extra[pos + 3] & 0xFF) << 16 | (this.extra[pos + 4] & 0xFF) << 24;
                this.setTime(time);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.known = (short)(this.known | 0x10);
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int nlen = this.name.length();
        return nlen > 0 && this.name.charAt(nlen - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

