/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.io.IOException;
import java.io.InputStream;
import net.sf.zipme.Checksum;

public class CheckedInputStream
extends InputStream {
    protected InputStream in;
    private Checksum sum;

    public CheckedInputStream(InputStream in, Checksum sum) {
        this.in = in;
        this.sum = sum;
    }

    public Checksum getChecksum() {
        return this.sum;
    }

    public int read() throws IOException {
        int x = this.in.read();
        if (x != -1) {
            this.sum.update(x);
        }
        return x;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int r = this.in.read(buf, off, len);
        if (r != -1) {
            this.sum.update(buf, off, r);
        }
        return r;
    }

    public long skip(long n) throws IOException {
        int r;
        if (n == 0L) {
            return 0L;
        }
        int min = (int)Math.min(n, 1024L);
        byte[] buf = new byte[min];
        long s = 0L;
        while (n > 0L && (r = this.in.read(buf, 0, min)) != -1) {
            s += (long)r;
            min = (int)Math.min(n -= (long)r, 1024L);
            this.sum.update(buf, 0, r);
        }
        return s;
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

