/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

class PendingBuffer {
    protected byte[] buf;
    int start;
    int end;
    int bits;
    int bitCount;

    public PendingBuffer() {
        this(4096);
    }

    public PendingBuffer(int bufsize) {
        this.buf = new byte[bufsize];
    }

    public final void reset() {
        this.bitCount = 0;
        this.end = 0;
        this.start = 0;
    }

    public final void writeByte(int b) {
        this.buf[this.end++] = (byte)b;
    }

    public final void writeShort(int s) {
        this.buf[this.end++] = (byte)s;
        this.buf[this.end++] = (byte)(s >> 8);
    }

    public final void writeInt(int s) {
        this.buf[this.end++] = (byte)s;
        this.buf[this.end++] = (byte)(s >> 8);
        this.buf[this.end++] = (byte)(s >> 16);
        this.buf[this.end++] = (byte)(s >> 24);
    }

    public final void writeBlock(byte[] block, int offset, int len) {
        System.arraycopy(block, offset, this.buf, this.end, len);
        this.end += len;
    }

    public final int getBitCount() {
        return this.bitCount;
    }

    public final void alignToByte() {
        if (this.bitCount > 0) {
            this.buf[this.end++] = (byte)this.bits;
            if (this.bitCount > 8) {
                this.buf[this.end++] = (byte)(this.bits >>> 8);
            }
        }
        this.bits = 0;
        this.bitCount = 0;
    }

    public final void writeBits(int b, int count) {
        this.bits |= b << this.bitCount;
        this.bitCount += count;
        if (this.bitCount >= 16) {
            this.buf[this.end++] = (byte)this.bits;
            this.buf[this.end++] = (byte)(this.bits >>> 8);
            this.bits >>>= 16;
            this.bitCount -= 16;
        }
    }

    public final void writeShortMSB(int s) {
        this.buf[this.end++] = (byte)(s >> 8);
        this.buf[this.end++] = (byte)s;
    }

    public final boolean isFlushed() {
        return this.end == 0;
    }

    public final int flush(byte[] output, int offset, int length) {
        if (this.bitCount >= 8) {
            this.buf[this.end++] = (byte)this.bits;
            this.bits >>>= 8;
            this.bitCount -= 8;
        }
        if (length > this.end - this.start) {
            length = this.end - this.start;
            System.arraycopy(this.buf, this.start, output, offset, length);
            this.start = 0;
            this.end = 0;
        } else {
            System.arraycopy(this.buf, this.start, output, offset, length);
            this.start += length;
        }
        return length;
    }

    public final byte[] toByteArray() {
        byte[] ret = new byte[this.end - this.start];
        System.arraycopy(this.buf, this.start, ret, 0, ret.length);
        this.start = 0;
        this.end = 0;
        return ret;
    }
}

