/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.Checksum;

public class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private int checksum;

    public Adler32() {
        this.reset();
    }

    public void reset() {
        this.checksum = 1;
    }

    public void update(int n2) {
        int n3 = this.checksum & 0xFFFF;
        int n4 = this.checksum >>> 16;
        n3 = (n3 + (n2 & 0xFF)) % 65521;
        n4 = (n3 + n4) % 65521;
        this.checksum = (n4 << 16) + n3;
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n2, int n3) {
        int n4 = this.checksum & 0xFFFF;
        int n5 = this.checksum >>> 16;
        while (n3 > 0) {
            int n6 = 3800;
            if (n6 > n3) {
                n6 = n3;
            }
            n3 -= n6;
            while (--n6 >= 0) {
                n5 += (n4 += byArray[n2++] & 0xFF);
            }
            n4 %= 65521;
            n5 %= 65521;
        }
        this.checksum = n5 << 16 | n4;
    }

    public long getValue() {
        return (long)this.checksum & 0xFFFFFFFFL;
    }
}

