/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

class StreamManipulator {
    public byte[] window;
    public int window_start = 0;
    public int window_end = 0;
    public int buffer = 0;
    public int bits_in_buffer = 0;

    public final int getBits(int n2) {
        int n3;
        int n4 = this.bits_in_buffer >= n2 ? this.buffer & (1 << n2) - 1 : (n3 = this.window_start != this.window_end ? (this.buffer |= (this.window[this.window_start++] & 0xFF | (this.window[this.window_start++] & 0xFF) << 8) << (this.bits_in_buffer += 16) - 16) & (1 << n2) - 1 : -1);
        if (n3 >= 0) {
            this.buffer >>>= n2;
        }
        this.bits_in_buffer -= n2;
        return n3;
    }

    public final int getAvailableBits() {
        return this.bits_in_buffer;
    }

    public final int getAvailableBytes() {
        return this.window_end - this.window_start + (this.bits_in_buffer >> 3);
    }

    public void skipToByteBoundary() {
        this.buffer >>= this.bits_in_buffer & 7;
        this.bits_in_buffer &= 0xFFFFFFF8;
    }

    public final boolean needsInput() {
        return this.window_start == this.window_end;
    }

    public int copyBytes(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("length negative");
        }
        if ((this.bits_in_buffer & 7) != 0) {
            throw new IllegalStateException("Bit buffer is not aligned!");
        }
        int n4 = 0;
        while (this.bits_in_buffer > 0 && n3 > 0) {
            byArray[n2++] = (byte)this.buffer;
            this.buffer >>>= 8;
            this.bits_in_buffer -= 8;
            --n3;
            ++n4;
        }
        if (n3 == 0) {
            return n4;
        }
        int n5 = this.window_end - this.window_start;
        if (n3 > n5) {
            n3 = n5;
        }
        System.arraycopy(this.window, this.window_start, byArray, n2, n3);
        this.window_start += n3;
        if ((this.window_start - this.window_end & 1) != 0) {
            this.buffer = this.window[this.window_start++] & 0xFF;
            this.bits_in_buffer = 8;
        }
        return n4 + n3;
    }

    public void reset() {
        this.bits_in_buffer = 0;
        this.buffer = 0;
        this.window_end = 0;
        this.window_start = 0;
    }

    public void setInput(byte[] byArray, int n2, int n3) {
        if (this.window_start < this.window_end) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int n4 = n2 + n3;
        if (0 > n2 || n2 > n4 || n4 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if ((n3 & 1) != 0) {
            this.buffer |= (byArray[n2++] & 0xFF) << this.bits_in_buffer;
            this.bits_in_buffer += 8;
        }
        this.window = byArray;
        this.window_start = n2;
        this.window_end = n4;
    }
}

