/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.zipme.Checksum;

public class CheckedOutputStream
extends OutputStream {
    protected OutputStream out;
    private Checksum sum;

    public CheckedOutputStream(OutputStream out, Checksum cksum) {
        this.out = out;
        this.sum = cksum;
    }

    public Checksum getChecksum() {
        return this.sum;
    }

    public void write(int bval) throws IOException {
        this.out.write(bval);
        this.sum.update(bval);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
        this.sum.update(buf, off, len);
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

