/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.CustomFont;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.SystemFont;
import java.util.Hashtable;

public abstract class Font {
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FACE_SYSTEM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int STYLE_PLAIN = 0;
    private static Font defaultFont;
    private static Hashtable bitmapCache;

    protected Font() {
    }

    public static Font getBitmapFont(String fontName) {
        return (Font)bitmapCache.get(fontName);
    }

    public static void clearBitmapCache() {
        bitmapCache.clear();
    }

    public void addContrast(byte value) {
    }

    public static Font createBitmapFont(String name, Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        Font f = Font.createBitmapFont(bitmap, cutOffsets, charWidth, charsets);
        bitmapCache.put(name, f);
        return f;
    }

    public static Font createBitmapFont(Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        return new CustomFont(bitmap, cutOffsets, charWidth, charsets);
    }

    public static Font createSystemFont(int face, int style, int size) {
        return new SystemFont(face, style, size);
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int retVal = 0;
        for (int i = 0; i < length; ++i) {
            retVal += this.charWidth(ch[i + offset]);
        }
        return retVal;
    }

    public int substringWidth(String str, int offset, int len) {
        return this.charsWidth(str.toCharArray(), offset, len);
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return this.substringWidth(str, 0, str.length());
    }

    public abstract int charWidth(char var1);

    public abstract int getHeight();

    abstract void drawChar(Graphics var1, char var2, int var3, int var4);

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            defaultFont = SystemFont.defaultFont;
        }
        return defaultFont;
    }

    public static void setDefaultFont(Font f) {
        if (f != null) {
            defaultFont = f;
        }
    }

    void drawChars(Graphics g, char[] data, int offset, int length, int x, int y) {
        for (int i = 0; i < length; ++i) {
            char c = data[offset + i];
            this.drawChar(g, c, x, y);
            x += this.charWidth(c);
        }
    }

    public int getFace() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public int getStyle() {
        return 0;
    }

    public String getCharset() {
        return null;
    }

    static {
        bitmapCache = new Hashtable();
    }
}

