/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class GridLayout
extends Layout {
    private int rows;
    private int columns;

    public GridLayout(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    public void layoutContainer(Container parent) {
        int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(3) - parent.getStyle().getPadding(1);
        int height = parent.getLayoutHeight() - parent.getBottomGap() - parent.getStyle().getPadding(2) - parent.getStyle().getPadding(0);
        int x = parent.getStyle().getPadding(1);
        int y = parent.getStyle().getPadding(0);
        int numOfcomponents = parent.getComponentCount();
        int cmpWidth = width / this.columns;
        int cmpHeight = numOfcomponents > this.rows * this.columns ? height / (numOfcomponents / this.columns + 1) : height / this.rows;
        int row = 0;
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            Style cmpStyle = cmp.getStyle();
            int marginLeft = cmpStyle.getMargin(1);
            int marginTop = cmpStyle.getMargin(0);
            cmp.setWidth(cmpWidth - marginLeft - cmpStyle.getMargin(3));
            cmp.setHeight(cmpHeight - marginTop - cmpStyle.getMargin(2));
            cmp.setX(x + i % this.columns * cmpWidth + marginLeft);
            cmp.setY(y + row * cmpHeight + marginTop);
            if ((i + 1) % this.columns != 0) continue;
            ++row;
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int width = 0;
        int height = 0;
        int numOfcomponents = parent.getComponentCount();
        boolean row = false;
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            width = Math.max(width, cmp.getPreferredW() + cmp.getStyle().getMargin(1) + cmp.getStyle().getMargin(3));
            height = Math.max(height, cmp.getPreferredH() + cmp.getStyle().getMargin(0) + cmp.getStyle().getMargin(2));
        }
        if (this.columns > 1) {
            width *= this.columns;
        }
        if (this.rows > 1) {
            height = numOfcomponents > this.rows * this.columns ? (height *= numOfcomponents / this.columns + 1) : (height *= this.rows);
        }
        return new Dimension(width + parent.getStyle().getPadding(1) + parent.getStyle().getPadding(3), height + parent.getStyle().getPadding(0) + parent.getStyle().getPadding(2));
    }
}

