/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Calendar;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public abstract class LookAndFeel {
    private int defaultFormTintColor = 0x7F000000;
    private int disableColor = 0xCCCCCC;
    private Transition defaultFormTransitionIn;
    private Transition defaultFormTransitionOut;
    private Transition defaultMenuTransitionIn;
    private Transition defaultMenuTransitionOut;
    private Transition defaultDialogTransitionIn;
    private Transition defaultDialogTransitionOut;
    private boolean defaultSmoothScrolling = true;
    private int defaultSmoothScrollingSpeed = 150;
    private boolean reverseSoftButtons;
    private ListCellRenderer menuRenderer;
    private Image[] menuIcons = new Image[3];

    public void bind(Component cmp) {
    }

    public void uninstall() {
    }

    public abstract void drawButton(Graphics var1, Button var2);

    public abstract void drawCheckBox(Graphics var1, CheckBox var2);

    public abstract void drawComboBox(Graphics var1, ComboBox var2);

    public abstract void drawLabel(Graphics var1, Label var2);

    public abstract void drawList(Graphics var1, List var2);

    public abstract void drawMonthView(Graphics var1, Calendar var2, Component var3);

    public abstract long findDayAt(int var1, int var2, Calendar var3, Component var4);

    public abstract void drawRadioButton(Graphics var1, RadioButton var2);

    public abstract void drawTextArea(Graphics var1, TextArea var2);

    public abstract void drawTextField(Graphics var1, TextField var2);

    public abstract void drawTextFieldCursor(Graphics var1, TextField var2);

    public abstract void drawTabbedPane(Graphics var1, TabbedPane var2);

    public abstract Dimension getButtonPreferredSize(Button var1);

    public abstract Dimension getCheckBoxPreferredSize(CheckBox var1);

    public abstract Dimension getLabelPreferredSize(Label var1);

    public abstract Dimension getListPreferredSize(List var1);

    public abstract Dimension getMonthViewPreferredSize(Component var1);

    public abstract Dimension getRadioButtonPreferredSize(RadioButton var1);

    public abstract Dimension getTextAreaPreferredSize(TextArea var1);

    public abstract Dimension getTextFieldPreferredSize(TextField var1);

    public abstract Dimension getComboBoxPreferredSize(ComboBox var1);

    public void drawVerticalScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio) {
        int x = c.getX() + c.getWidth() - this.getVerticalScrollWidth();
        int y = c.getY();
        int height = c.getHeight();
        Style s = UIManager.getInstance().getComponentStyle("Scroll");
        Style st = UIManager.getInstance().getComponentStyle("ScrollThumb");
        g.setColor(s.getFgColor());
        int width = this.getVerticalScrollWidth();
        int marginLeft = s.getMargin(1);
        int marginTop = s.getMargin(0);
        x += marginLeft;
        width -= marginLeft + s.getMargin(3);
        y += marginTop;
        height -= marginTop + s.getMargin(2);
        if (s.getBgImage() != null) {
            this.drawBackgroundImage(g, s, x, y, width, height);
        } else {
            g.fillRect(x, y, width, height, s.getBgTransparency());
            g.setColor(s.getBgColor());
            g.fillRoundRect(x, y + 1, width, height - 2, 10, 10);
        }
        marginLeft = st.getMargin(1);
        marginTop = st.getMargin(0);
        x += marginLeft;
        width -= marginLeft + st.getMargin(3);
        y += marginTop;
        int offset = (int)((float)(height -= marginTop + st.getMargin(2)) * offsetRatio);
        int blockSize = (int)((float)height * blockSizeRatio);
        if (st.getBgImage() != null) {
            this.drawBackgroundImage(g, st, x, y + offset, width, blockSize);
        } else {
            g.setColor(st.getFgColor());
            g.fillRoundRect(x, y + offset, width, blockSize, 10, 10);
        }
    }

    private void drawBackgroundImage(Graphics g, Style s, int x, int y, int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        Image bgImage = s.getBgImage();
        if (bgImage != null) {
            if (s.isScaleImage()) {
                if (bgImage.getWidth() != width || bgImage.getHeight() != height) {
                    bgImage = bgImage.scaled(width, height);
                }
                g.drawImage(bgImage, x, y);
            } else {
                int iW = bgImage.getWidth();
                int iH = bgImage.getHeight();
                for (int xPos = 0; xPos < width; xPos += iW) {
                    for (int yPos = 0; yPos < height; yPos += iH) {
                        g.drawImage(bgImage, x + xPos, y + yPos);
                    }
                }
            }
        }
    }

    public void drawHorizontalScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio) {
        int x = c.getX();
        int y = c.getY() + c.getHeight() - this.getHorizontalScrollHeight();
        int width = c.getWidth();
        Style s = UIManager.getInstance().getComponentStyle("Scroll");
        g.setColor(s.getFgColor());
        int height = this.getHorizontalScrollHeight();
        Painter p = s.getBgPainter();
        if (p != null) {
            p.paint(g, new Rectangle(x, y, width, height));
        } else {
            g.fillRect(x, y, width, height, s.getBgTransparency());
        }
        g.setColor(s.getBgColor());
        g.fillRoundRect(x + 1, y, width - 2, height, 10, 10);
        g.setColor(s.getFgColor());
        int offset = (int)((float)width * offsetRatio);
        int blockSize = (int)((float)width * blockSizeRatio);
        g.fillRoundRect(x + offset, y, blockSize, height, 10, 10);
    }

    public void setFG(Graphics g, Component c) {
        Style s = c.getStyle();
        g.setFont(s.getFont());
        if (c.isEnabled()) {
            if (c.hasFocus() && c.isFocusPainted()) {
                g.setColor(s.getFgSelectionColor());
            } else {
                g.setColor(s.getFgColor());
            }
        } else {
            g.setColor(this.disableColor);
        }
    }

    public int getVerticalScrollWidth() {
        Style s = UIManager.getInstance().getComponentStyle("Scroll");
        return s.getMargin(1) + s.getMargin(3) + s.getPadding(1) + s.getPadding(3);
    }

    public int getHorizontalScrollHeight() {
        Style s = UIManager.getInstance().getComponentStyle("Scroll");
        return s.getMargin(0) + s.getMargin(2) + s.getPadding(0) + s.getPadding(2);
    }

    void drawBorder(Graphics g, Component c, int color, int borderWidth) {
        this.drawBorder(g, c, color, color, borderWidth);
    }

    void drawBorder(Graphics g, Component c, int topAndRightColor, int bottomAndLeftColor, int borderWidth) {
        g.setColor(topAndRightColor);
        g.fillRect(c.getX(), c.getY(), c.getWidth(), borderWidth);
        g.fillRect(c.getX(), c.getY(), borderWidth, c.getHeight());
        g.setColor(bottomAndLeftColor);
        g.fillRect(c.getX(), c.getY() + c.getHeight() - borderWidth, c.getWidth(), borderWidth);
        g.fillRect(c.getX() + c.getWidth() - borderWidth, c.getY(), borderWidth, c.getHeight());
    }

    public abstract Component getTabbedPaneCell(TabbedPane var1, String var2, Image var3, boolean var4, boolean var5, Style var6, Style var7, int var8, int var9, Dimension var10, Dimension var11);

    public abstract void drawTabbedPaneContentPane(TabbedPane var1, Graphics var2, Rectangle var3, Dimension var4, int var5, int var6, Dimension var7, int var8, int var9);

    public Transition getDefaultFormTransitionIn() {
        return this.defaultFormTransitionIn;
    }

    public void setDefaultFormTransitionIn(Transition defaultFormTransitionIn) {
        this.defaultFormTransitionIn = defaultFormTransitionIn;
    }

    public Transition getDefaultFormTransitionOut() {
        return this.defaultFormTransitionOut;
    }

    public void setDefaultFormTransitionOut(Transition defaultFormTransitionOut) {
        this.defaultFormTransitionOut = defaultFormTransitionOut;
    }

    public Transition getDefaultMenuTransitionIn() {
        return this.defaultMenuTransitionIn;
    }

    public void setDefaultMenuTransitionIn(Transition defaultMenuTransitionIn) {
        this.defaultMenuTransitionIn = defaultMenuTransitionIn;
    }

    public Transition getDefaultMenuTransitionOut() {
        return this.defaultMenuTransitionOut;
    }

    public void setDefaultMenuTransitionOut(Transition defaultMenuTransitionOut) {
        this.defaultMenuTransitionOut = defaultMenuTransitionOut;
    }

    public Transition getDefaultDialogTransitionIn() {
        return this.defaultDialogTransitionIn;
    }

    public void setDefaultDialogTransitionIn(Transition defaultDialogTransitionIn) {
        this.defaultDialogTransitionIn = defaultDialogTransitionIn;
    }

    public Transition getDefaultDialogTransitionOut() {
        return this.defaultDialogTransitionOut;
    }

    public void setDefaultDialogTransitionOut(Transition defaultDialogTransitionOut) {
        this.defaultDialogTransitionOut = defaultDialogTransitionOut;
    }

    public int getDefaultFormTintColor() {
        return this.defaultFormTintColor;
    }

    public void setDefaultFormTintColor(int defaultFormTintColor) {
        this.defaultFormTintColor = defaultFormTintColor;
    }

    public int getDisableColor() {
        return this.disableColor;
    }

    public void setDisableColor(int disableColor) {
        this.disableColor = disableColor;
    }

    public boolean isDefaultSmoothScrolling() {
        return this.defaultSmoothScrolling;
    }

    public void setDefaultSmoothScrolling(boolean defaultSmoothScrolling) {
        this.defaultSmoothScrolling = defaultSmoothScrolling;
    }

    public int getDefaultSmoothScrollingSpeed() {
        return this.defaultSmoothScrollingSpeed;
    }

    public void setDefaultSmoothScrollingSpeed(int defaultSmoothScrollingSpeed) {
        this.defaultSmoothScrollingSpeed = defaultSmoothScrollingSpeed;
    }

    public boolean isReverseSoftButtons() {
        return this.reverseSoftButtons;
    }

    public void setReverseSoftButtons(boolean reverseSoftButtons) {
        this.reverseSoftButtons = reverseSoftButtons;
    }

    public ListCellRenderer getMenuRenderer() {
        return this.menuRenderer;
    }

    public void setMenuRenderer(ListCellRenderer menuRenderer) {
        this.menuRenderer = menuRenderer;
    }

    public void setMenuIcons(Image select, Image cancel, Image menu) {
        this.menuIcons[0] = select;
        this.menuIcons[1] = cancel;
        this.menuIcons[2] = menu;
    }

    public Image[] getMenuIcons() {
        return this.menuIcons;
    }
}

