/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class UIManager {
    private LookAndFeel current = new DefaultLookAndFeel();
    private Hashtable styles = new Hashtable();
    private Hashtable themeProps;
    private static UIManager instance = new UIManager();
    private Style defaultStyle = new Style();
    static boolean accessible = true;
    private Hashtable imageCache = new Hashtable();
    private Hashtable resourceBundle;

    private UIManager() {
        this.resetThemeProps();
    }

    public static UIManager getInstance() {
        return instance;
    }

    public LookAndFeel getLookAndFeel() {
        return this.current;
    }

    public void setLookAndFeel(LookAndFeel plaf) {
        this.current.uninstall();
        this.current = plaf;
    }

    public void setComponentStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.styles.put(id, style);
    }

    public Style getComponentStyle(String id) {
        Style style = null;
        style = (Style)this.styles.get(id = id == null || id.length() == 0 ? "" : id + ".");
        if (style == null) {
            style = this.createStyle(id);
            this.styles.put(id, style);
        }
        return new Style(style);
    }

    public void loadTheme(InputStream input) throws IOException {
        Hashtable<String, String> theme = new Hashtable<String, String>();
        byte[] buffer = new byte[1024];
        int size = input.read(buffer);
        StringBuffer stringBuffer = new StringBuffer();
        while (size > -1) {
            stringBuffer.append(new String(buffer));
            size = input.read(buffer);
        }
        String file = stringBuffer.toString();
        stringBuffer = null;
        int previousOffset = 0;
        int fileOffset = this.nextNewline(file, 0);
        while (previousOffset < file.length() && previousOffset > -1) {
            String recordStr = file.substring(previousOffset, fileOffset);
            char currentChar = Character.toUpperCase(recordStr.charAt(0));
            while ((currentChar < 'A' || currentChar > 'Z') && recordStr.length() > 1) {
                recordStr = recordStr.substring(1, recordStr.length());
                currentChar = Character.toUpperCase(recordStr.charAt(0));
            }
            previousOffset = fileOffset;
            fileOffset = this.nextNewline(file, previousOffset + 1);
            if (recordStr.indexOf("=") <= 0 || recordStr.startsWith("#")) continue;
            int spacesLoc = -1;
            while ((spacesLoc = recordStr.indexOf(" ")) > -1) {
                recordStr = recordStr.substring(0, spacesLoc) + recordStr.substring(spacesLoc + 1, recordStr.length());
            }
            String key = recordStr.substring(0, recordStr.indexOf("="));
            String value = recordStr.substring(recordStr.indexOf("=") + 1, recordStr.length());
            while (value.charAt(value.length() - 1) == '\n' || value.charAt(value.length() - 1) == '\r') {
                value = value.substring(0, value.length() - 1);
            }
            theme.put(key, value);
        }
        this.setThemeProps(theme);
    }

    private int nextNewline(String str, int offset) {
        int newline = str.indexOf(10, offset);
        if (newline < 0) {
            return str.length();
        }
        return newline;
    }

    public String getThemeName() {
        if (this.themeProps != null) {
            return (String)this.themeProps.get("name");
        }
        return null;
    }

    private void resetThemeProps() {
        this.themeProps = new Hashtable();
        this.themeProps.put("Button.border", Border.getDefaultBorder());
        this.themeProps.put("TextArea.border", Border.getDefaultBorder());
        this.themeProps.put("List.border", Border.getDefaultBorder());
        this.themeProps.put("TextField.border", Border.getDefaultBorder());
        this.themeProps.put("ComboBox.border", Border.getDefaultBorder());
        this.themeProps.put("ComboBoxPopup.border", Border.getDefaultBorder());
        this.themeProps.put("Title.margin", "0,0,0,0");
        this.themeProps.put("CommandList.margin", "0,0,0,0");
        this.themeProps.put("CommandList.transparency", "0");
        this.themeProps.put("Command.margin", "0,0,0,0");
        this.themeProps.put("Container.transparency", "0");
        this.themeProps.put("ComboBoxPopup.transparency", "0");
        this.themeProps.put("List.transparency", "0");
        this.themeProps.put("SoftButton.transparency", "255");
        this.themeProps.put("List.margin", "0,0,0,0");
        this.themeProps.put("SoftButton.margin", "0,0,0,0");
        this.themeProps.put("SoftButton.padding", "2,2,2,2");
        this.themeProps.put("Container.margin", "0,0,0,0");
        this.themeProps.put("Container.padding", "0,0,0,0");
        this.themeProps.put("Title.transparency", "255");
        this.themeProps.put("TabbedPane.margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.padding", "0,0,0,0");
        this.themeProps.put("ScrollThumb.padding", "0,0,0,0");
        this.themeProps.put("ScrollThumb.margin", "0,0,0,0");
        this.themeProps.put("Form.padding", "0,0,0,0");
        this.themeProps.put("Form.margin", "0,0,0,0");
        this.themeProps.put("transparency", "255");
    }

    public void setThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.setThemePropsImpl(themeProps);
        }
    }

    void setThemePropsImpl(Hashtable themeProps) {
        this.resetThemeProps();
        Enumeration e = themeProps.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.themeProps.put(key, themeProps.get(key));
        }
        this.styles.clear();
        this.imageCache.clear();
        this.defaultStyle = new Style();
        this.defaultStyle = this.createStyle("");
    }

    private Style createStyle(String id) {
        Style style = new Style(this.defaultStyle);
        if (this.themeProps != null) {
            String bgColor = (String)this.themeProps.get(id + "bgColor");
            String fgColor = (String)this.themeProps.get(id + "fgColor");
            Object bgImage = this.themeProps.get(id + "bgImage");
            String bgSelColor = (String)this.themeProps.get(id + "bgSelectionColor");
            String fgSelColor = (String)this.themeProps.get(id + "fgSelectionColor");
            String transperency = (String)this.themeProps.get(id + "transparency");
            String margin = (String)this.themeProps.get(id + "margin");
            String padding = (String)this.themeProps.get(id + "padding");
            Object font = this.themeProps.get(id + "font");
            Object border = this.themeProps.get(id + "border");
            Object scale = this.themeProps.get(id + "scaledImage");
            if (bgColor != null) {
                style.setBgColor(Integer.valueOf(bgColor, 16));
            }
            if (fgColor != null) {
                style.setFgColor(Integer.valueOf(fgColor, 16));
            }
            if (bgSelColor != null) {
                style.setBgSelectionColor(Integer.valueOf(bgSelColor, 16));
            }
            if (fgSelColor != null) {
                style.setFgSelectionColor(Integer.valueOf(fgSelColor, 16));
            }
            if (transperency != null) {
                style.setBgTransparency(Integer.valueOf(transperency));
            }
            if (margin != null) {
                int[] marginArr = this.toIntArray(margin.trim());
                style.setMargin(marginArr[0], marginArr[1], marginArr[2], marginArr[3]);
            }
            if (padding != null) {
                int[] paddingArr = this.toIntArray(padding.trim());
                style.setPadding(paddingArr[0], paddingArr[1], paddingArr[2], paddingArr[3]);
            }
            if (scale != null) {
                style.setScaleImage(!scale.equals("false"));
            }
            if (bgImage != null) {
                Image im = null;
                if (bgImage instanceof String) {
                    try {
                        String bgImageStr = (String)bgImage;
                        if (this.imageCache.contains(bgImageStr)) {
                            im = (Image)this.imageCache.get(bgImageStr);
                        } else {
                            im = bgImageStr.startsWith("/") ? Image.createImage(bgImageStr) : UIManager.parseImage((String)bgImage);
                            this.imageCache.put(bgImageStr, im);
                        }
                        this.themeProps.put(id + "bgImage", im);
                    }
                    catch (IOException ex) {
                        System.out.println("failed to parse image for id = " + id + "bgImage");
                    }
                } else {
                    im = (Image)bgImage;
                }
                if (id.indexOf("Form") > -1 && (im.getWidth() != Display.getInstance().getDisplayWidth() || im.getHeight() != Display.getInstance().getDisplayHeight()) && style.isScaleImage() && accessible) {
                    im.scale(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                }
                style.setBgImage(im);
            }
            if (font != null) {
                if (font instanceof String) {
                    style.setFont(UIManager.parseFont((String)font));
                } else {
                    style.setFont((Font)font);
                }
            }
            style.setBorder((Border)border);
            style.resetModifiedFlag();
        }
        return style;
    }

    private int[] toIntArray(String str) {
        int[] retVal = new int[4];
        str = str + ",";
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = Integer.parseInt(str.substring(0, str.indexOf(",")));
            str = str.substring(str.indexOf(",") + 1, str.length());
        }
        return retVal;
    }

    private static Image parseImage(String value) throws IOException {
        byte[] imageData = new byte[value.length() / 2];
        for (int index = 0; index < value.length(); index += 2) {
            String byteStr = value.substring(index, index + 2);
            imageData[index / 2] = Integer.valueOf(byteStr, 16).byteValue();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        Image image = Image.createImage(in);
        in.close();
        return image;
    }

    private static Font parseFont(String fontStr) {
        if (fontStr.startsWith("System")) {
            int face = 0;
            int style = 0;
            int size = 0;
            String sysFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
            String faceStr = sysFont.substring(0, sysFont.indexOf(";"));
            sysFont = sysFont.substring(sysFont.indexOf(";") + 1, sysFont.length());
            String styleStr = sysFont.substring(0, sysFont.indexOf(";"));
            String sizeStr = sysFont.substring(sysFont.indexOf(";") + 1, sysFont.length());
            if (faceStr.indexOf("FACE_SYSTEM") > -1) {
                face = 0;
            } else if (faceStr.indexOf("FACE_MONOSPACE") > -1) {
                face = 32;
            } else if (faceStr.indexOf("FACE_PROPORTIONAL") > -1) {
                face = 64;
            }
            if (styleStr.indexOf("STYLE_PLAIN") > -1) {
                style = 0;
            } else {
                if (styleStr.indexOf("STYLE_BOLD") > -1) {
                    style = 1;
                }
                if (styleStr.indexOf("STYLE_ITALIC") > -1) {
                    style |= 2;
                }
                if (styleStr.indexOf("STYLE_UNDERLINED") > -1) {
                    style |= 4;
                }
            }
            if (sizeStr.indexOf("SIZE_SMALL") > -1) {
                size = 8;
            } else if (sizeStr.indexOf("SIZE_MEDIUM") > -1) {
                size = 0;
            } else if (sizeStr.indexOf("SIZE_LARGE") > -1) {
                size = 16;
            }
            return Font.createSystemFont(face, style, size);
        }
        if (fontStr.toLowerCase().startsWith("bitmap")) {
            try {
                String bitmapFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
                String nameStr = bitmapFont.substring(0, bitmapFont.length());
                if (nameStr.toLowerCase().startsWith("highcontrast")) {
                    nameStr = nameStr.substring(nameStr.indexOf(";") + 1, nameStr.length());
                    Font f = Font.getBitmapFont(nameStr);
                    f.addContrast((byte)30);
                    return f;
                }
                return Font.getBitmapFont(nameStr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Hashtable getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(Hashtable resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String localize(String key, String defaultValue) {
        Object o;
        if (this.resourceBundle != null && (o = this.resourceBundle.get(key)) != null) {
            return (String)o;
        }
        return defaultValue;
    }
}

