// ==UserScript==
// @name    Linkifier
// @version     1.06
// @date        2008-10-10
// @author      Mike Samokhvalov <mikivanch@gmail.com>
// @download    http://www.puzzleclub.ru/files/linkifier.js
// ==/UserScript==

// By motive of Greasemonkey user script "Linkifier":
// http://userscripts.org/scripts/show/1024

(function(){
  ///////////////////////////////////////////////////////////////////
  // SETTINGS
  var anchorAttribute = 'ujs_linkifier';
  // Anchor style. Examples:
  // 'text-decoration: overline !important;'
  // 'border-width: 1px 0 !important; border-style: dotted !important;'  
  // 'border-width: 1px 0 !important; border-style: dashed !important;'
  var anchorStyle = '';
  
  // END OF SETTINGS
  ///////////////////////////////////////////////////////////////////
  
  ///////////////////////////////////////////////////////////////////
  // DO NOT EDIT
  
  // Modified regular expression from http://regexlib.com/  
  var uriRe = /\b(?:(?:(?:file|gopher|news|nntp|telnet|http|ftp|https|ftps|sftp|irc):\/\/(?:[^:@\s\.\,\/\\]+(?::[^:@\s\.\,\/\\]+)?@)?)|(?:www\.|ftp\.|irc\.))(?:(?:[\w\.-]+\.[a-zA-Z]{2,6})|(?:[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}))(?:\:\d+)?(?:\/(?:[\w\-\.\?\!\,\'\/\\\+&%\$#\=~:;\[\]\(\)]+[\w\-\/\\\+&%\$#\=~]+)?)?/gi;
  
  var linkify = function(obj)
  {
    if(!obj)
      return;
      
    if(obj.tagName.match(/^(a|head|meta|title|applet|object|param|embed|script|style|frameset|frame|iframe|textarea|input|button|select|option|img|map)$/i))
      return;

    if(obj.tagName == 'PRE' || obj.tagName == 'CODE')
    {
      obj.innerHTML = obj.innerHTML.replace(/(?:\r\n|\n|\r)/g, function(s){
        return '\r\n';
      });
    }

    var cn = obj.childNodes;
    for(var i = cn.length - 1; i >= 0; i--)
    {
      if(cn[i].nodeType == 1)
      {
        linkify(cn[i]);
      }
      else if(cn[i].nodeType == 3)
      {
        if(cn[i].nodeValue.match(uriRe))
        {
          var v = cn[i].nodeValue.replace(/&/g, '&amp;');
          v = v.replace(/</g, '&lt;');
          v = v.replace(/>/g, '&gt;');

          v = v.replace(uriRe, function(s){          
            var url = s;
            if(url.indexOf('www.') == 0)
              url = 'http://' + url;
            if(url.indexOf('ftp.') == 0)
              url = 'ftp://' + url;
            if(url.indexOf('irc.') == 0)
              url = 'irc://' + url;
              
            return '<a href="' + url + '" ' + anchorAttribute + '="1">' + s + '</a>';
          });

          var s = document.createElement('span');
          document.documentElement.appendChild(s);
          cn[i].parentNode.replaceChild(s, cn[i]);          
          s.outerHTML = v;
        }
      }
    }      
  };
  
  var addStyle = function(css)
  {
    if(!document || !document.documentElement)
      return;
      
    var s = document.createElement('style');
    s.setAttribute('type', 'text/css');
    s.setAttribute('style', 'display:none !important;');			
    s.appendChild(document.createTextNode(css));
    document.documentElement.appendChild(s); 
  };
  
  var onLoad = function(e)
  {
    if(document.body)
    {
      if(anchorStyle)
        addStyle('a[' + anchorAttribute + '] {' + anchorStyle + '}');
        
      linkify(document.body);
    }
  };
  
  if(typeof(opera.version) == 'function' && opera.version() >= 9)
    document.addEventListener('DOMContentLoaded', onLoad, false);    
  else  
    document.addEventListener('load', onLoad, false);
})();
