// ==UserScript==
// @name        Rapidshare.com helper for Opera 8 - 9
// @version     2.03
// @date        2008-12-27
// @author      Igor47 <igor_dan100@rambler.ru> (as source used scripts of Mike Samokhvalov <mikivanch@gmail.com> v1.27 2007-10-08 and Menashe Elyashuv <mnashe@013.net> 2008-06-04)
// @download    http://www.puzzleclub.ru/files/rapidshare_com.js
// @include http://*.rapidshare.com/*
// @include http://rapidshare.com/*
// ==/UserScript==

(function(){
  // For those who have the "Cached Images" mode.
  var autoReloadCaptchaImage = false;
  var happy_hours_autostart = true;
  var show_mirrors = true;
  var make_link = true;//false;

  var latKB = 'qwertyuiopasdfghjklzxcvbnm';
  var altKB_lower = '\u0439\u0446\u0443\u043A\u0435\u043D\u0433\u0448\u0449\u0437\u0444\u044B\u0432\u0430\u043F\u0440\u043E\u043B\u0434\u044F\u0447\u0441\u043C\u0438\u0442\u044C';
  var altKB_upper = '\u0419\u0426\u0423\u041A\u0415\u041D\u0413\u0428\u0429\u0417\u0424\u042B\u0412\u0410\u041F\u0420\u041E\u041B\u0414\u042F\u0427\u0421\u041C\u0418\u0422\u042C';

  // Sound
  var bPlaySound = true;
  var soundSource = 'data:audio/midi;base64,TVRoZAAAAAYAAQACAPBNVHJrAAAAGwD/WAQEAhgIAP9RAwknwI8A/1EDB6EgAP8vAE1UcmsAAAAtAP8DBVN0YWZmAMANVpBNfx5IfyGATQAOSACBDpBNfxlIfx6ATQAOSAAA/y8A';
  // Repetition interval in milliseconds. 0 - disable repetition.
  var soundRepetitionInterval = 60000; // 1 minute;

  var timerId = '';
  var soundTimerId = '';
  var captchaName = 'accesscode';
  var submitName = 'actionstring';

  var minWait = 0;

  var addStyle = function(css)
  {
    if (!document || !document.documentElement) return;

    var s = document.createElement('style');
    s.setAttribute('type', 'text/css');
    s.setAttribute('style', 'display:none !important;');
    s.appendChild(document.createTextNode(css));
    document.documentElement.appendChild(s);
  };

  var clickFreeButton = function()
  {
    var inputs = document.getElementsByTagName('input')
    for (var i=0; i<inputs.length; i++)
    {
      if (inputs[i].type == 'submit' && inputs[i].value.toLowerCase() == 'free user')
      {
        inputs[i].click();
        return true;
      }
    }
    return false;
  };

  var handle_form = function()
  {
    var divtop = document.getElementById('divtop');
    if (window.c != undefined)
    {
      if (window.c <= 0)
        document.title = 'RS: ready';
      else
      {
        var d = window.c / 60;
        if (d)
        {
          d = d.toFixed(1);
          if (minWait != d)
          {
            minWait = d;
            document.title = 'RS: ' + d + ' minutes';
            divtop.innerHTML = '<table style="border-collapse: collapse; border: none; margin: 0 auto;"><tr><td>Wait ' + d + ' minutes</td></tr></table>';
          }
        }
      }
    }

    var form = document.forms['dl'];
    if (!form) form = document.forms['dlf'];
    if (!form) return;

    if (show_mirrors)
    {
      var mirp = document.getElementById('p1');
      if (mirp && mirp.style.display && anzeigen) anzeigen('1');
      show_mirrors = false;
    }

    if (autoReloadCaptchaImage)
    {
      var img = document.getElementsByTagName('img');
      for (var i = 0; i < img.length; i++)
      {
        if (!img[i].complete && img[i].src && img[i].src.indexOf('access') > 0)
        {
          reloadImage(img[i]);
          break;
        }
      }
    }

    clearInterval(timerId);

    if (bPlaySound) playSound();

    var captcha = form.elements[captchaName];

    if (captcha)
    {
      if (captcha.focus) captcha.focus();

      captcha.addEventListener('blur', function(e) {
        if (captcha.focus) captcha.focus();
      }, false);

      form.addEventListener('keyUp', function(e) {
        var n;
        var s=captcha.value;
        for (var i=0; i < s.length; i++)
          if ((n = Math.max(altKB_lower.indexOf(s.charAt(i)),altKB_upper.indexOf(s.charAt(i)))) >= 0)
            captcha.value = s.substring(0,i)+latKB.charAt(n)+s.substring(i+1);
      }, false);
    }

    var submit = form.elements[submitName];
    if (!submit)
    {
      var inputs = document.getElementsByTagName('input');
      for (var i=0; i<inputs.length; i++)
        //if (inputs[i].src && inputs[i].src.indexOf('download_file') >= 0)
        if (inputs[i].src && inputs[i].type == 'image')
        {
          submit = inputs[i];
          break;
        }

      if (!submit) return;
    }

    divtop.innerHTML = '<table style="border-collapse: collapse; border: none; margin: 0 auto;"><tr><td>';
    //var inputs = document.getElementsByTagName('input');
    //j = 1;
    //for (var i=0; i<inputs.length; i++)
      //if (inputs[i].name=='mirror' && inputs[i].type == 'radio')
      //{
        //inputs[i].click;
        divtop.innerHTML += '<a id="toplink" href="'+form.action+'">'+form.action+'</a>&nbsp;&nbsp;';
        //j++;
      //}
    divtop.innerHTML += '</td></tr></table>';

    form.addEventListener('change', function(e) {
      var form = document.forms['dl'];
      if (!form) form = document.forms['dlf'];
      if (!form) return;
      var lnk = document.getElementById('toplink');
      lnk.href = form.action;
      lnk.innerText = form.action;
      var lnk = document.getElementById('bottomlink');
      lnk.href = form.action;
      lnk.innerText = form.action;
    }, false);

    form.addEventListener('submit', function(e) {
      if (captcha)
      {
        var code = captcha.value;

        if (code.length!=4)
        {
          e.preventDefault();
          alert('Please enter the captcha code.');
          return;
        }
      }

      clearInterval(soundTimerId);

      if (e.ctrlKey == make_link) return;

      e.preventDefault();

      var link = document.createElement('a');
      link.href = form.action;// + "?actionstring=" + encodeURIComponent(form.action) + "&accesscode=" + code;
      link.id = 'bottomlink';
      if (submit.value.length)
        link.innerText = submit.value;
      else
        link.innerText = form.action;
      submit.outerHTML = link.outerHTML;

    }, false);
  };

  var refreshPage = function()
  {
    window.history.go(0);
  };

  var showWaitTime = function(minutes, obj)
  {
    if (typeof(minutes) == 'number' &&  minutes <= 0)
    {
      setTimeout(refreshPage, 1000);
    }
    else
    {
      document.title = 'RS: ' + minutes.toString() + ' minutes';
      obj.innerHTML = obj.innerHTML.replace(/or wait (\d+) minute/i, 'Or wait ' + minutes + ' minute');
      setTimeout(showWaitTime, 60000, minutes - 1, obj);
    }
  };

  function playSound()
  {
    var f = document.createElement('IFRAME');
    f.src = soundSource;
    f.width = 0;
    f.height = 0;
    f.frameBorder = 'no';
    f.scrolling = 'no';
    document.documentElement.appendChild(f);

    var i = 0;
    var soundLoop = function()
    {
      var s = soundSource + '#' + i;
      f.setAttribute('src', s, false);
      i++;
    };

    if (soundRepetitionInterval > 0)
      soundTimerId = setInterval(soundLoop, soundRepetitionInterval);
  }

  var restoreImage = function(img){};
  if (typeof(opera.version) == 'function' && opera.version() >= 9.10)
  {
    var restoreImage = function(img)
    {
      if (!img) return;

      var refreshImg = function(i, d)
      {
        i.style.display = d;
      };

      if (img.currentStyle.display != 'none')
      {
        var display = img.currentStyle.display;
        img.style.display = 'none';
        setTimeout(refreshImg, 10, img, display);
      }
    };
  }

  var reloadImage = function(img)
  {
    var f = document.createElement('iframe');
    f.src = img.src;
    f.width = 0;
    f.height = 0;
    f.frameBorder = 'no';
    f.scrolling = 'no';
    f.onload = function(){
      this.parentNode.removeChild(this);
      restoreImage(img);
    };
    document.documentElement.appendChild(f);
  };

  var modifyPage = function()
  {
    var fname = document.location.href;
    fname = fname.substring(fname.lastIndexOf('/')+1);
    document.title = 'Rapidshare: '+fname;

    var p = document.createElement('div');//#003399
    p.setAttribute('style', 'display:block; color:#000000; background-color:#cfdfff; border:1px solid #8fb5ff; padding:5px 0; text-align:center; font-size:11pt; font-weight:bold;', false);
    p.setAttribute('id', 'divtop', false);
    p.innerHTML = '<table style="border-collapse: collapse; border: none; margin: 0 auto;"><tr><td>Wait...</td></tr></table>';
    document.body.insertBefore(p, document.body.firstChild);

    var imgs = document.getElementsByTagName('img');
    for (var i=0; i<imgs.length; i++)
    {
      if (imgs[i].src.indexOf('/img2/')>0)
      {
        imgs[i].style.display = 'none';
      }
    }
    for (var i=0; i<imgs.length; i++)
    {
      if (imgs[i].src.indexOf('rslogo') >= 0)
      {
        imgs[i].style.display = 'none';
        break;
      }
    }

    var form = document.forms['dl'];
    if (!form) form = document.forms['dlf'];
    if (form) if (happy_hours_autostart || make_link)
    {
      var inputs = document.getElementsByTagName('input');
      for (var i=0; i<inputs.length; i++)
        //if (inputs[i].src && inputs[i].src.indexOf('download_file') >= 0)
        if (inputs[i].src && inputs[i].type == 'image')
        {
          if (happy_hours_autostart)
          {
            inputs[i].click();
            return;
          }
          var link = document.createElement('a');
          link.id = 'bottomlink';
          link.href = form.action;// + "?actionstring=" + encodeURIComponent(form.action);
          link.innerText = form.action;
          inputs[i].outerHTML = link.outerHTML;
          return;
        }
    }

    var css = (
      'form[name="ul"] {display: none !important;}'
      +'table#premiumtable2 {display: none !important;}'
    );

    if (window.c != undefined || form)
    {
      addStyle(css);
      timerId = setInterval(handle_form, 1000);
    }
    else
    {
      var p = document.getElementsByTagName('p');
      var obj = null;
      var min;
      for (var i = 0; i < p.length; i++)
      {
        if (p[i].innerText)
        {
          if (p[i].innerText.indexOf('You have reached the ') == 0)
          {
            obj = p[i];
            min = p[i].innerText.match(/wait (\d+) minute/i);
            break;
          }
          else if (p[i].innerText.search(/your ip address[\d\.\s]*is already downloading a file/i) != -1)
          {
            addStyle(css);
            setTimeout(refreshPage, 60000);
            return;
          }
          else if (p[i].innerText.search(/too many users downloading right now/i) != -1)
          {
            addStyle(css);
            setTimeout(refreshPage, 60000);
            return;
          }
        }
      }

      if (min && min.length > 1)
      {
        min = parseInt(min[1]);
        if (isNaN(min)) return;
        else
        {
          addStyle(css);
          showWaitTime(min, obj);
        }
      }
      else return;
    }
  }

  addStyle('div.hauptmenue {display: none !important;}');
  addStyle('img[title="logo"] {display: none !important;}');
  addStyle('img[title="vorteile"] {display: none !important;}');
  addStyle('input[value="Create Premium Account"] {display: none !important;}');
  //addStyle('h2[text="Create Premium Account"] {display: none !important;}');
  addStyle('p#small {display: none !important;}');
  addStyle('div.untermenue {display: none !important;}');

  if (typeof(opera.version) == 'function' && opera.version() >= 9)
  {
    document.addEventListener('DOMContentLoaded', function(e){
      if (!clickFreeButton())
        modifyPage();
    }, false);
  }
  else
  {
    document.addEventListener('load', function(e){
      if (!clickFreeButton())
        modifyPage();
    }, false);
  }
})();
