/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.astro;

import henson.midp.Float;
import org.qcontinuum.astro.EarthHeading;

public class EarthPosition {
    private Float a;
    private Float b;

    public EarthPosition(int n, int n2) {
        this.a = new Float(n).Div(60L);
        this.b = new Float(n2).Div(60L);
    }

    public EarthPosition(int n, int n2, int n3, int n4) {
        this.a = new Float(n).Add(new Float(n2).Div(n < 0 ? -60L : 60L));
        this.b = new Float(n3).Add(new Float(n4).Div(n3 < 0 ? -60L : 60L));
    }

    public EarthPosition(Float float_, Float float_2) {
        this.a = float_;
        this.b = float_2;
    }

    public int latTotalMinutes() {
        return (int)Float.Int(this.a.Mul(60L)).toLong();
    }

    public int longTotalMinutes() {
        return (int)Float.Int(this.b.Mul(60L)).toLong();
    }

    public Float getLatitude() {
        return this.a;
    }

    public Float getLongitude() {
        return this.b;
    }

    public String latString() {
        return Math.abs(this.latTotalMinutes() / 60) + "\u00b0 " + Math.abs(this.latTotalMinutes()) % 60 + "' " + (this.latTotalMinutes() < 0 ? "\u042e\u0433" : "\u0421\u0435\u0432\u0435\u0440");
    }

    public String longString() {
        return Math.abs(this.longTotalMinutes() / 60) + "\u00b0 " + Math.abs(this.longTotalMinutes()) % 60 + "' " + (this.longTotalMinutes() < 0 ? "\u0417\u0430\u043f\u0430\u0434" : "\u0412\u043e\u0441\u0442\u043e\u043a");
    }

    public String toString() {
        return this.latString() + "\n" + this.longString();
    }

    public Float getDistance(EarthPosition earthPosition) {
        Float float_ = Float.abs(this.b.Sub(earthPosition.b).Mul(111111L));
        Float float_2 = Float.abs(this.a.Sub(earthPosition.a).Mul(111111L).Mul(Float.cos(Float.toRadians(this.a))));
        return Float.sqrt(float_.Mul(float_).Add(float_2.Mul(float_2)));
    }

    public EarthHeading toEarthHeading(EarthPosition earthPosition) {
        Float float_ = Float.PI.Div(180L);
        Float float_2 = Float.toRadians(this.a);
        Float float_3 = Float.toRadians(earthPosition.a);
        Float float_4 = Float.toRadians(this.b.Neg());
        Float float_5 = Float.toRadians(earthPosition.b.Neg());
        Float float_6 = Float.sin(float_2.Sub(float_3).Div(2L));
        Float float_7 = Float.sin(float_4.Sub(float_5).Div(2L));
        Float float_8 = Float.asin(Float.sqrt(float_6.Mul(float_6).Add(Float.cos(float_2).Mul(Float.cos(float_3)).Mul(float_7.Mul(float_7))))).Mul(2L);
        Float float_9 = Float.ZERO;
        if (float_8.Great(Float.ZERO)) {
            float_9 = Float.sin(float_5.Sub(float_4)).Less(0L) ? Float.acos(Float.sin(float_3).Sub(Float.sin(float_2).Mul(Float.cos(float_8))).Div(Float.sin(float_8).Mul(Float.cos(float_2)))) : Float.PImul2.Sub(Float.acos(Float.sin(float_3).Sub(Float.sin(float_2).Mul(Float.cos(float_8))).Div(Float.sin(float_8).Mul(Float.cos(float_2)))));
        }
        return new EarthHeading((int)float_9.Div(float_).toLong(), float_8.Mul(6371000L).toLong());
    }
}

