/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.compass;

import java.util.Date;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import org.qcontinuum.astro.EarthHeading;
import org.qcontinuum.astro.UtcDate;
import org.qcontinuum.compass.Compass;
import org.qcontinuum.compass.InfoDisplay;
import org.qcontinuum.compass.InfoMoon;
import org.qcontinuum.compass.InfoSun;
import org.qcontinuum.compass.InfoTwilight;
import org.qcontinuum.compass.Location;
import org.qcontinuum.compass.Preferences;
import org.qcontinuum.compass.SunMoonPosition;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InfoMenu
extends List
implements CommandListener {
    private Displayable a;
    private Command a;
    private Command b;

    public InfoMenu(Displayable displayable) {
        super("\u0418\u043d\u0444\u043e", 3);
        this.a = displayable;
        this.append("\u0412\u0440\u0435\u043c\u044f", null);
        this.append("\u0421\u043e\u043b\u043d\u0446\u0435", null);
        this.append("\u041b\u0443\u043d\u0430", null);
        this.append("\u0414\u043e\u043b\u0433\u043e\u0442\u0430 \u0434\u043d\u044f", null);
        if (Compass.getPreferences().getDestination() != null) {
            this.append("\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f", null);
        }
        this.a = new Command("\u041e\u0442\u043c\u0435\u043d\u0430", 3, 1);
        this.addCommand(this.a);
        this.b = new Command("\u0414\u0430", 4, 1);
        this.addCommand(this.b);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.b || command == List.SELECT_COMMAND) {
            switch (this.getSelectedIndex()) {
                case 0: {
                    this.infoTime();
                    break;
                }
                case 1: {
                    Compass.display((Displayable)new InfoSun((Displayable)this));
                    break;
                }
                case 2: {
                    Compass.display((Displayable)new InfoMoon((Displayable)this));
                    break;
                }
                case 3: {
                    Compass.display((Displayable)new InfoTwilight((Displayable)this));
                    break;
                }
                case 4: {
                    this.infoDestination();
                }
            }
            return;
        }
        if (command == this.a) {
            Compass.display(this.a);
        }
    }

    public void infoTime() {
        InfoDisplay infoDisplay = new InfoDisplay("\u0412\u0440\u0435\u043c\u044f", (Displayable)this);
        Preferences preferences = Compass.getPreferences();
        Location location = preferences.getLocation();
        Location location2 = preferences.getDestination();
        Date date = Compass.getDate();
        Date date2 = location.getGmt(date);
        infoDisplay.append((Item)new StringItem("\u041b\u043e\u043a\u0430\u0446\u0438\u044f:", Compass.getTime(new UtcDate(date)) + "\n"));
        infoDisplay.append((Item)new StringItem("GMT:", Compass.getTime(new UtcDate(date2)) + "\n"));
        if (location2 != null && location2.timeZone != null) {
            Date date3 = location2.getLocalTime(date2);
            infoDisplay.append((Item)new StringItem("\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f:", Compass.getTime(new UtcDate(date3)) + "\n"));
        }
        Compass.display((Displayable)infoDisplay);
    }

    public void infoDestination() {
        Date date = Compass.getDate();
        SunMoonPosition sunMoonPosition = new SunMoonPosition(date);
        EarthHeading earthHeading = sunMoonPosition.getDestinationHeading();
        InfoDisplay infoDisplay = new InfoDisplay("\u0414\u0438\u0441\u0442\u0430\u043d\u0446\u0438\u044f", (Displayable)this);
        if (earthHeading != null) {
            infoDisplay.append((Item)new StringItem("\u0413\u0440\u0430\u0434\u0443\u0441\u044b:", earthHeading.getHeading() + "\u00b0\n"));
            infoDisplay.append((Item)new StringItem("\u0420\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435:", earthHeading.getMetres() / 1000L + " \u043a\u043c\n"));
        }
        Compass.display((Displayable)infoDisplay);
    }
}

