/*
 * Decompiled with CFR 0.152.
 */
class MobileChessBoard {
    static final int OUT = 8888;
    static final int VOID = -1;
    static final int PAWN = 2;
    static final int ROOK = 6;
    static final int KNIGHT = 8;
    static final int BISSHOP = 10;
    static final int QUEEN = 12;
    static final int KING = 14;
    static final int FRESHKING = 114;
    static final int FRESHROOK = 106;
    static final int ENPASSANT = 3;
    static final int CASTLE = 5;
    static final int CAASTLE = 7;
    static final int WHITE = 0;
    static final int BLACK = 1;
    static final int CHECKMATE = 0;
    static final int CHECK = 1;
    static final int DRAW = 2;
    static final int OPEN = 3;
    public int[] A = new int[144];
    static int OldMoveSize = 64;
    static int MaxListSize = 80;
    public int[] OldMove;
    public int[] UndoInf;
    public int Moves;
    public int Status;
    static final int[] KnightJump = new int[]{-10, 10, -14, 14, -23, 23, -25, 25};
    static final int[] KingJump = new int[]{-1, 1, -13, -12, -11, 13, 12, 11};
    static final int[] BisshopDir = new int[]{13, -13, 11, -11};
    static final int[] RookDir = new int[]{1, -1, 12, -12};
    static final int NULLMOVE = 0;

    MobileChessBoard() {
        int n = 0;
        while (n < 144) {
            this.A[n] = 8888;
            ++n;
        }
        this.Setup();
        this.OldMove = new int[OldMoveSize];
        this.UndoInf = new int[OldMoveSize];
    }

    MobileChessBoard(MobileChessBoard mobileChessBoard) {
        int n = 0;
        while (n < 144) {
            this.A[n] = mobileChessBoard.A[n];
            ++n;
        }
        this.OldMove = new int[OldMoveSize];
        this.UndoInf = new int[OldMoveSize];
        int n2 = 0;
        while (n2 < OldMoveSize) {
            this.OldMove[n2] = mobileChessBoard.OldMove[n2];
            this.UndoInf[n2] = mobileChessBoard.UndoInf[n2];
            ++n2;
        }
        this.Moves = mobileChessBoard.Moves;
        this.Status = mobileChessBoard.Status;
    }

    void Setup() {
        int n = 2;
        while (n < 10) {
            int n2 = 4;
            while (n2 < 8) {
                this.A[n + 12 * n2] = -1;
                ++n2;
            }
            int[] nArray = new int[]{106, 8, 10, 12, 114, 10, 8, 106};
            this.A[n + 24] = nArray[n - 2] + 0;
            this.A[n + 108] = nArray[n - 2] + 1;
            this.A[n + 36] = 2;
            this.A[n + 96] = 3;
            ++n;
        }
        this.Moves = 0;
        this.Status = 3;
    }

    boolean InBoard(int n) {
        if (n < 0 || n >= 144) {
            return false;
        }
        return this.A[n] != 8888;
    }

    int GetSide() {
        return this.Moves % 2;
    }

    int GetSide(int n) {
        if (!this.InBoard(n)) {
            return 0;
        }
        return this.A[n] % 2;
    }

    int GetPiece(int n) {
        return this.A[n] % 100 - this.A[n] % 2;
    }

    int GetKing(int n) {
        int n2 = 14 + n;
        int n3 = 114 + n;
        int n4 = 0;
        while (n4 < 144) {
            if (this.A[n4] == n2 || this.A[n4] == n3) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    boolean GetFresh(int n) {
        return this.A[n] > 100;
    }

    boolean Check(int n) {
        int n2 = this.GetKing(n);
        if (n2 == -1) {
            return false;
        }
        return this.Attack(n2, 1 - n);
    }

    boolean IllMoveDone() {
        return this.Check(1 - this.GetSide());
    }

    static int NewMove(int n, int n2) {
        return n + 144 * n2;
    }

    static int NewMove(int n, int n2, int n3) {
        return n + 144 * (n2 + 144 * n3);
    }

    static int MoveFrom(int n) {
        return n % 144;
    }

    static int MoveTo(int n) {
        return n / 144 % 144;
    }

    static int MoveNewPiece(int n) {
        return n / 20736;
    }

    void StoreMove(int n, int n2, boolean bl) {
        this.OldMove[this.Moves % MobileChessBoard.OldMoveSize] = n;
        this.UndoInf[this.Moves % MobileChessBoard.OldMoveSize] = bl ? n2 + 8888 : n2;
    }

    int GetStoredM(int n) {
        return this.OldMove[n % OldMoveSize];
    }

    int GetStoredVictim() {
        int n = this.UndoInf[this.Moves % OldMoveSize];
        if (n < 8000) {
            return n;
        }
        return n - 8888;
    }

    boolean GetStoredFresh() {
        return this.UndoInf[this.Moves % OldMoveSize] > 8000;
    }

    boolean Attack(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while (n5 < 8) {
            n4 = n + KnightJump[n5];
            if (this.InBoard(n4) && this.GetPiece(n4) == 8 && this.GetSide(n4) == n2) {
                return true;
            }
            n4 = n + KingJump[n5];
            if (this.InBoard(n4) && this.GetPiece(n4) == 14 && this.GetSide(n4) == n2) {
                return true;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < 4) {
            n4 = n;
            n5 = 0;
            while (n5 < 7) {
                if (!this.InBoard(n4 += RookDir[n6])) break;
                if (this.GetSide(n4) != -1) {
                    n3 = this.GetPiece(n4);
                    if (this.GetSide(n4) != n2 || n3 != 6 && n3 != 12) break;
                    return true;
                }
                ++n5;
            }
            n4 = n;
            n5 = 0;
            while (n5 < 7) {
                if (!this.InBoard(n4 += BisshopDir[n6])) break;
                if (this.GetSide(n4) != -1) {
                    n3 = this.GetPiece(n4);
                    if (this.GetSide(n4) != n2 || n3 != 10 && n3 != 12) break;
                    return true;
                }
                ++n5;
            }
            ++n6;
        }
        n3 = n2 == 0 ? -1 : 1;
        n4 = n + n3 * 11;
        n5 = 0;
        while (n5 < 2) {
            if (this.InBoard(n4) && this.GetPiece(n4) == 2 && this.GetSide(n4) == n2) {
                return true;
            }
            n4 = n + n3 * 13;
            ++n5;
        }
        return false;
    }

    void VisualDoMove(int n) {
        this.DoMove(n);
        int[] nArray = this.ListOfMoves();
        this.Status = MobileChessBoard.GetLength(nArray) > 0 ? (this.Check(this.GetSide()) ? 1 : 3) : (this.Check(this.GetSide()) ? 0 : 2);
    }

    int VisualUndoMove() {
        if (this.Moves < 2) {
            return -2;
        }
        int n = 0;
        while (n < 2) {
            this.UndoMove();
            ++n;
        }
        this.Status = this.Check(this.GetSide()) ? 1 : 3;
        return this.GetPrevCursorPos();
    }

    int GetPrevCursorPos() {
        if (this.Moves == 0) {
            return -1;
        }
        int n = this.GetStoredM(this.Moves - 1);
        return MobileChessBoard.MoveTo(n);
    }

    void DoMove(int n) {
        if (n == 0) {
            this.StoreMove(n, -1, false);
            ++this.Moves;
            return;
        }
        int n2 = MobileChessBoard.MoveFrom(n);
        int n3 = MobileChessBoard.MoveTo(n);
        int n4 = MobileChessBoard.MoveNewPiece(n);
        boolean bl = false;
        if (this.A[n2] > 100) {
            bl = true;
            this.A[n2] = this.A[n2] - 100;
        }
        int n5 = this.A[n3];
        this.A[n3] = this.A[n2];
        this.A[n2] = -1;
        if (n4 == 3) {
            this.A[n3 % 12 + 12 * (n2 / 12)] = -1;
        } else if (n4 == 5) {
            this.A[n2 - n2 % 12 + 9] = -1;
            this.A[n2 - n2 % 12 + 7] = 6 + this.GetSide();
        } else if (n4 == 7) {
            this.A[n2 - n2 % 12 + 2] = -1;
            this.A[n2 - n2 % 12 + 5] = 6 + this.GetSide();
        } else if (n4 != 0) {
            this.A[n3] = 12 + this.GetSide();
        }
        this.StoreMove(n, n5, bl);
        ++this.Moves;
    }

    void UndoMove() {
        if (this.Moves == 0) {
            return;
        }
        --this.Moves;
        int n = this.GetStoredM(this.Moves);
        if (n == 0) {
            return;
        }
        int n2 = MobileChessBoard.MoveFrom(n);
        int n3 = MobileChessBoard.MoveTo(n);
        int n4 = MobileChessBoard.MoveNewPiece(n);
        this.A[n2] = this.A[n3];
        this.A[n3] = this.GetStoredVictim();
        if (this.GetStoredFresh()) {
            int n5 = n2;
            this.A[n5] = this.A[n5] + 100;
        }
        if (n4 == 3) {
            this.A[n3 % 12 + 12 * (n2 / 12)] = 2 + (1 - this.GetSide());
        } else if (n4 == 5) {
            this.A[n2 - n2 % 12 + 7] = -1;
            this.A[n2 - n2 % 12 + 9] = 106 + this.GetSide();
        } else if (n4 == 7) {
            this.A[n2 - n2 % 12 + 5] = -1;
            this.A[n2 - n2 % 12 + 2] = 106 + this.GetSide();
        } else if (n4 != 0) {
            this.A[n2] = 2 + this.GetSide();
        }
    }

    static int[] NewList() {
        int[] nArray = new int[MaxListSize + 1];
        nArray[0] = 0;
        return nArray;
    }

    static int GetLength(int[] nArray) {
        return nArray[0];
    }

    static void Add(int[] nArray, int n) {
        if (nArray[0] < MaxListSize) {
            nArray[0] = nArray[0] + 1;
            nArray[nArray[0]] = n;
        }
    }

    static void Delete(int[] nArray, int n) {
        nArray[n] = nArray[nArray[0]];
        nArray[0] = nArray[0] - 1;
    }

    static void PromotionAdd(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[]{12, 8, 6, 10};
        int n3 = 0;
        while (n3 < 4) {
            MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n, n2, nArray2[n3]));
            ++n3;
        }
    }

    void AddPawnMoves(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n == 0) {
            n5 = 12;
            n4 = 3;
            n3 = 8;
        } else {
            n5 = -12;
            n4 = 8;
            n3 = 3;
        }
        if (n2 / 12 == n3) {
            if (this.GetSide(n2 + n5) == -1) {
                MobileChessBoard.PromotionAdd(nArray, n2, n2 + n5);
            }
            if (this.InBoard(n2 + n5 + 1) && this.GetSide(n2 + n5 + 1) == 1 - n) {
                MobileChessBoard.PromotionAdd(nArray, n2, n2 + n5 + 1);
            }
            if (this.InBoard(n2 + n5 - 1) && this.GetSide(n2 + n5 - 1) == 1 - n) {
                MobileChessBoard.PromotionAdd(nArray, n2, n2 + n5 - 1);
            }
            return;
        }
        if (this.GetSide(n2 + n5) == -1) {
            MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n2, n2 + n5));
            if (n2 / 12 == n4 && this.GetSide(n2 + 2 * n5) == -1) {
                MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n2, n2 + 2 * n5));
            }
        }
        if (this.InBoard(n2 + n5 + 1) && this.GetSide(n2 + n5 + 1) == 1 - n) {
            MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n2, n2 + n5 + 1));
        }
        if (this.InBoard(n2 + n5 - 1) && this.GetSide(n2 + n5 - 1) == 1 - n) {
            MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n2, n2 + n5 - 1));
        }
    }

    void AddJumpMoves(int[] nArray, int n, int n2, int[] nArray2) {
        int n3 = 0;
        while (n3 < 8) {
            if (this.InBoard(n2 + nArray2[n3]) && this.GetSide(n2 + nArray2[n3]) != n) {
                MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n2, n2 + nArray2[n3]));
            }
            ++n3;
        }
    }

    void AddSlideMoves(int[] nArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        while (n5 < 7) {
            if (!this.InBoard(n4 += n3) || this.GetSide(n4) == n) break;
            MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n2, n4));
            if (this.GetSide(n4) == 1 - n) break;
            ++n5;
        }
    }

    int[] ListOfMoves() {
        int[] nArray = this.ListOfPseudoMoves();
        int n = 1;
        while (n <= nArray[0]) {
            this.DoMove(nArray[n]);
            boolean bl = this.IllMoveDone();
            this.UndoMove();
            if (bl) {
                MobileChessBoard.Delete(nArray, n);
                continue;
            }
            ++n;
        }
        return nArray;
    }

    int[] ListOfPseudoMoves() {
        int n;
        int n2;
        int n3;
        int[] nArray = MobileChessBoard.NewList();
        if (this.Status != 3 && this.Status != 1) {
            return nArray;
        }
        int n4 = this.GetSide();
        int n5 = 0;
        while (n5 < 144) {
            if (this.InBoard(n5) && this.GetSide(n5) == this.GetSide()) {
                switch (this.GetPiece(n5)) {
                    case 2: {
                        this.AddPawnMoves(nArray, n4, n5);
                        break;
                    }
                    case 8: {
                        this.AddJumpMoves(nArray, n4, n5, KnightJump);
                        break;
                    }
                    case 14: {
                        this.AddJumpMoves(nArray, n4, n5, KingJump);
                        break;
                    }
                    case 6: {
                        n3 = 0;
                        while (n3 < 4) {
                            this.AddSlideMoves(nArray, n4, n5, RookDir[n3]);
                            ++n3;
                        }
                        break;
                    }
                    case 10: {
                        n2 = 0;
                        while (n2 < 4) {
                            this.AddSlideMoves(nArray, n4, n5, BisshopDir[n2]);
                            ++n2;
                        }
                        break;
                    }
                    case 12: {
                        n = 0;
                        while (n < 4) {
                            this.AddSlideMoves(nArray, n4, n5, RookDir[n]);
                            this.AddSlideMoves(nArray, n4, n5, BisshopDir[n]);
                            ++n;
                        }
                        break;
                    }
                }
            }
            ++n5;
        }
        int n6 = n3 = n4 == 0 ? 24 : 108;
        if (this.GetFresh(n3 + 6)) {
            if (this.GetFresh(n3 + 2) && this.GetSide(n3 + 3) == -1 && this.GetSide(n3 + 4) == -1 && this.GetSide(n3 + 5) == -1 && !this.Attack(n3 + 4, 1 - n4) && !this.Attack(n3 + 5, 1 - n4) && !this.Attack(n3 + 6, 1 - n4)) {
                MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n3 + 6, n3 + 4, 7));
            }
            if (this.GetFresh(n3 + 9) && this.GetSide(n3 + 7) == -1 && this.GetSide(n3 + 8) == -1 && !this.Attack(n3 + 6, 1 - n4) && !this.Attack(n3 + 7, 1 - n4) && !this.Attack(n3 + 8, 1 - n4)) {
                MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n3 + 6, n3 + 8, 5));
            }
        }
        if (this.Moves != 0) {
            n2 = n4 == 0 ? 12 : -12;
            n = this.GetStoredM(this.Moves - 1);
            int n7 = MobileChessBoard.MoveTo(n);
            int n8 = MobileChessBoard.MoveFrom(n);
            if (this.GetPiece(n7) == 2 && n8 - n7 == 2 * n2) {
                if (this.InBoard(n7 + 1) && this.GetSide(n7 + 1) == n4 && this.GetPiece(n7 + 1) == 2 && this.GetSide(n7 + n2) == -1) {
                    MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n7 + 1, n7 + n2, 3));
                }
                if (this.InBoard(n7 - 1) && this.GetSide(n7 - 1) == n4 && this.GetPiece(n7 - 1) == 2 && this.GetSide(n7 + n2) == -1) {
                    MobileChessBoard.Add(nArray, MobileChessBoard.NewMove(n7 - 1, n7 + n2, 3));
                }
            }
        }
        return nArray;
    }
}

