/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class WCanvas
extends Canvas
implements Runnable {
    public static final int MODE_COMPANY = 0;
    public static final int MODE_PRACTICE = 1;
    public static int gameMode = 0;
    public static final int TYPE_CLASSIC = 0;
    public static final int TYPE_ARCADE = 1;
    public static int gameType = 1;
    public static final int SOFT_KEY_L = -6;
    public static final int SOFT_KEY_R = -7;
    public static final int LEFT = -3;
    public static final int RIGHT = -4;
    public static final int UP = -1;
    public static final int DOWN = -2;
    public static final int FIRE = -5;
    public static final int STATE_MENU = 0;
    public static final int STATE_GAME = 1;
    public static int midState = 0;
    public static final int SCR_WIDTH = 240;
    public static final int SCR_HEIGHT = 320;
    public static int SCR_WIDTH_2 = 120;
    public static int SCR_HEIGHT_2 = 160;
    public static final int TILE_SIZE = 16;
    public static final int PAN_HEIGHT = 32;
    public static final int BUF_WIDTH = 240;
    public static final int BUF_HEIGHT = 320;
    public static final int BUU_W_TILES = 15;
    public static final int BUU_H_TILES = 20;
    private static Image buffer;
    private static Graphics bufGraphics;
    public static Image imgTiles;
    public static Image imgTiles1;
    private static Image imgCursor;
    public static Image imgPan;
    public static Image imgTrubi;
    public static Image imgTrubiS;
    public static Image imgWater;
    public static Image imgMenuBack;
    public static Image imgCompanyLogo;
    public static Image imgGameLogo;
    public static Image imgLogo;
    public static Image imgStrip;
    public static Image imgStripTits;
    public static final int[][] trubiCords;
    public static final int[][] waterCords;
    public static final int[][] trubiSCords;
    public static Snd sndLogo;
    public static Snd sndBattle;
    public static Snd sndWash;
    public static int[] font2Width;
    public static int[] font1Width;
    public static int[] font3Width;
    public static final DrawFont wh14;
    public static final DrawFont numSmall;
    public static final DrawFont bl10;
    public static final int[] LEVEL_TIME;
    public static final int MAX_LEVEL = 9;
    public static int level;
    public static int levelMaxed;
    public static long levelTime;
    public static Midlet instance;
    static boolean solved;
    static boolean loosed;
    static int solvedCnt;
    static int lastAddedColumn;
    static long lastTimeAdded;
    int pipeToAdd = WCanvas.rnd(0, 6);
    public static final int[] TIME_TO_ADD_NEW_PIPE;
    public static int deleteConnectedState;
    public boolean showDelete = false;
    public static int[] SCORE_TO_WIN;
    int addedPipeY = 48;
    int addedPipeYCnt = 0;
    public static int waterCnt;
    public static final int LEVEL_X = 16;
    private static int curX;
    private static int curY;
    public static int score;
    private static final String[] GIRLS_NAMES;
    public static final int PAN_TXT_BOT = 296;
    private static boolean pause;
    public static boolean loading;
    public static int loadCnt;
    public static final int NUM_WORDS = 50;
    public static final int NUM_STRINGS = 30;
    public static final int STR_W_BREAK_VPAD = 2;
    public static final int LEVEL_TOP = 64;
    public static final int LEVEL_HEIGHT = 12;
    public static int LEVEL_WIDTH;
    public static int[] LEVEL_DATA;
    private static final Random _rnd;
    public static final String SET_STORE_NAME = "SSTORE";
    public static final String GAME_SAVE_STORE_NAME = "GSTORE";
    public static boolean hasSave;
    public static boolean justLoaded;

    public WCanvas(Midlet _instance) {
        instance = _instance;
        WCanvas.loadSettings();
        WCanvas.loadGameSave();
        hasSave = WCanvas.hasRS(GAME_SAVE_STORE_NAME);
        System.out.println(" ---------------- hasSave " + hasSave);
        this.setFullScreenMode(true);
        midState = 0;
        this.loadMenuData();
        Thread t = new Thread(this);
        t.start();
        Menu.wC = this;
    }

    public static void startNewLevel() {
        WCanvas.generateLevel();
        solved = false;
        loosed = false;
        levelTime = System.currentTimeMillis();
        score = 0;
        lastAddedColumn = 1;
        curY = 11;
        curX = 1;
        pause = false;
    }

    public static void startNewGame() {
        level = 0;
    }

    protected void paint(Graphics _g) {
        if (loading) {
            WCanvas.renderLoading(_g);
            return;
        }
        switch (midState) {
            case 0: {
                Menu.renderMenu(_g);
                break;
            }
            case 1: {
                this.renderGame(_g);
            }
        }
    }

    protected void hideNotify() {
        Snd.stopAll();
        if (!solved && !loosed) {
            pause = true;
        }
    }

    protected void showNotify() {
    }

    private void renderGame(Graphics _g) {
        WCanvas.renderBackground(_g);
        WCanvas.renderPanels(_g);
        if (gameType == 1 && !this.showDelete && !pause) {
            this.updateLevel();
        }
        WCanvas.renderLevel(_g);
        if (gameType == 1 && !this.showDelete) {
            if (!(pause || solved || loosed)) {
                this.updatePipeFalling();
            }
            this.renderPipeFalling(_g);
        }
        if (gameType == 1 && this.showDelete) {
            this.animateDeletion();
        }
        if (!solved && !loosed) {
            WCanvas.renderCursor(_g);
        }
        if (pause) {
            WCanvas.renderPause(_g);
        }
        if (solved) {
            wh14.paint(_g, "\u00c3\u00ee\u00f2\u00ee\u00e2\u00ee!", SCR_WIDTH_2, SCR_HEIGHT_2, 33);
            bl10.paint(_g, "\u00cf\u00ee\u00e4\u00f1\u00ec\u00ee\u00f2\u00f0\u00e5\u00f2\u00fc", 10, 285, 36);
            bl10.paint(_g, "\u00cc\u00e5\u00ed\u00fe", 230, 285, 40);
            pause = false;
        }
        if (loosed) {
            wh14.paint(_g, "\u00c2\u00fb \u00ef\u00f0\u00ee\u00e8\u00e3\u00f0\u00e0\u00eb\u00e8!", SCR_WIDTH_2, SCR_HEIGHT_2, 33);
            bl10.paint(_g, "\u00cc\u00e5\u00ed\u00fe", 230, 285, 40);
            pause = false;
        }
    }

    public void updateLevel() {
        if (!solved && !pause) {
            this.checkIfConnected();
            this.addNewPipes();
        }
    }

    private void updateAfterDelete() {
        System.out.println("updateAfterDelete()");
        for (int i = 1; i < LEVEL_WIDTH - 1; ++i) {
            int j = LEVEL_DATA.length - LEVEL_WIDTH + i;
            int last = -1;
            while (j >= i) {
                if (LEVEL_DATA[j] != -1) {
                    if (last == -1) {
                        j -= LEVEL_WIDTH;
                        continue;
                    }
                    WCanvas.LEVEL_DATA[last] = LEVEL_DATA[j];
                    WCanvas.LEVEL_DATA[j] = -1;
                    j = last;
                    last = -1;
                    continue;
                }
                if (last == -1) {
                    last = j;
                }
                j -= LEVEL_WIDTH;
            }
        }
    }

    private void addNewPipes() {
        int timToAdd;
        if (score / 5000 < TIME_TO_ADD_NEW_PIPE.length - 1) {
            timToAdd = gameMode == 0 ? TIME_TO_ADD_NEW_PIPE[level] : TIME_TO_ADD_NEW_PIPE[score / 5000];
        } else {
            int n = timToAdd = gameMode == 0 ? TIME_TO_ADD_NEW_PIPE[level] : TIME_TO_ADD_NEW_PIPE[9];
        }
        if (System.currentTimeMillis() - lastTimeAdded < (long)timToAdd) {
            return;
        }
        if (LEVEL_DATA[lastAddedColumn] == -1) {
            for (int i = 0; i < 12; ++i) {
                if (i != 11 && LEVEL_DATA[lastAddedColumn + (i + 1) * LEVEL_WIDTH] == -1) continue;
                WCanvas.LEVEL_DATA[WCanvas.lastAddedColumn + i * WCanvas.LEVEL_WIDTH] = this.pipeToAdd;
                lastTimeAdded = System.currentTimeMillis();
                this.pipeToAdd = WCanvas.rnd(0, 6);
                this.addedPipeY = 48;
                loosed = true;
                for (int k = 1; k < LEVEL_WIDTH - 1; ++k) {
                    if (LEVEL_DATA[k] != -1) continue;
                    loosed = false;
                    break;
                }
                lastAddedColumn = lastAddedColumn < LEVEL_WIDTH - 2 ? ++lastAddedColumn : 1;
                while (LEVEL_DATA[lastAddedColumn] != -1 && !loosed) {
                    if (lastAddedColumn < LEVEL_WIDTH - 2) {
                        ++lastAddedColumn;
                        continue;
                    }
                    lastAddedColumn = 1;
                }
                break;
            }
        } else {
            loosed = true;
            for (int i = 1; i < LEVEL_WIDTH - 1; ++i) {
                if (LEVEL_DATA[i] != -1) continue;
                loosed = false;
                break;
            }
            while (LEVEL_DATA[lastAddedColumn] != -1 && !loosed) {
                if (lastAddedColumn < LEVEL_WIDTH - 2) {
                    ++lastAddedColumn;
                    continue;
                }
                lastAddedColumn = 1;
            }
        }
    }

    private void checkIfConnected() {
        for (int i = 0; i < 1; ++i) {
            for (int k = 0; k < 1; ++k) {
                Pathfinding.initPathfinding(i * LEVEL_WIDTH, k * LEVEL_WIDTH + (LEVEL_WIDTH - 1), LEVEL_DATA, LEVEL_WIDTH, 12);
                if (!Pathfinding.reallyFind) continue;
                this.showDelete = true;
                deleteConnectedState = 0;
            }
        }
    }

    public void animateDeletion() {
        if (deleteConnectedState < 20) {
            if (deleteConnectedState == 0) {
                for (int j = 0; j < Pathfinding.finalPath.length; ++j) {
                    if (Pathfinding.finalPath[j] % LEVEL_WIDTH == 0 || Pathfinding.finalPath[j] % LEVEL_WIDTH == LEVEL_WIDTH - 1) continue;
                    WCanvas.LEVEL_DATA[Pathfinding.finalPath[j]] = LEVEL_DATA[Pathfinding.finalPath[j]] + 9;
                }
            }
            ++deleteConnectedState;
        } else {
            for (int j = 0; j < Pathfinding.finalPath.length; ++j) {
                if (Pathfinding.finalPath[j] % LEVEL_WIDTH == 0 || Pathfinding.finalPath[j] % LEVEL_WIDTH == LEVEL_WIDTH - 1) continue;
                WCanvas.LEVEL_DATA[Pathfinding.finalPath[j]] = -1;
            }
            this.updateAfterDelete();
            if (gameMode == 0) {
                if ((score += Pathfinding.finalPath.length * 10) >= SCORE_TO_WIN[level]) {
                    solved = true;
                }
            } else {
                score += Pathfinding.finalPath.length * 10;
            }
            sndBattle.play(false);
            deleteConnectedState = 0;
            this.showDelete = false;
        }
    }

    public void updatePipeFalling() {
        int curTile = (this.addedPipeY + 16 - 64) / 16;
        boolean free = true;
        if (LEVEL_DATA[lastAddedColumn + curTile * LEVEL_WIDTH] != -1) {
            free = false;
        }
        if (this.addedPipeYCnt < 2) {
            ++this.addedPipeYCnt;
        } else if (free) {
            this.addedPipeYCnt = 0;
            ++this.addedPipeY;
        }
    }

    public void renderPipeFalling(Graphics _g) {
        WCanvas.renderSubImage(_g, imgTrubi, trubiCords[this.pipeToAdd], lastAddedColumn * 16 + 16, this.addedPipeY, 0);
    }

    public static void renderLevel(Graphics _g) {
        WCanvas.renderSubImage(_g, imgTrubi, trubiCords[8], 208, 256, 0);
        WCanvas.renderSubImage(_g, imgTrubi, trubiCords[16], 222, 64, 40);
        for (int i = 0; i < LEVEL_DATA.length; ++i) {
            if (LEVEL_DATA[i] == -1) continue;
            WCanvas.renderSubImage(_g, imgTrubi, trubiCords[LEVEL_DATA[i]], i % LEVEL_WIDTH * 16 + 16, 64 + i / LEVEL_WIDTH * 16, 0);
        }
    }

    public static final void renderCursor(Graphics _g) {
        if (gameType != 0) {
            _g.drawImage(imgCursor, curX * 16 + 16, 64 + curY * 16, 0);
        }
    }

    public static void renderBackground(Graphics _g) {
        _g.drawImage(buffer, 0, 0, 0);
        _g.drawImage(imgStrip, SCR_WIDTH_2, 0, 17);
    }

    public static void renderPanels(Graphics _g) {
        _g.drawImage(imgPan, 0, 320, 36);
        if (gameMode != 0 || gameType != 0) {
            if (gameType == 1) {
                wh14.paint(_g, "" + score, 175, 296, 17);
                if (gameMode == 0) {
                    wh14.paint(_g, GIRLS_NAMES[level], 68, 296, 17);
                    wh14.paint(_g, "" + (level + 1), 14, 296, 17);
                } else {
                    bl10.paint(_g, "\u00cf\u00e0\u00f3\u00e7\u00e0", 14, 296, 0);
                }
            } else {
                wh14.paint(_g, "-", 14, 296, 17);
            }
        }
    }

    public static void fillBuffer() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 20; ++j) {
                if (i != 0 && i != 14) {
                    bufGraphics.drawImage(imgTiles, i * 16, j * 16, 0);
                    continue;
                }
                bufGraphics.drawImage(imgTiles1, i * 16, j * 16, 0);
            }
        }
    }

    private static void renderPause(Graphics _g) {
        _g.setColor(15322601);
        _g.fillRect(SCR_WIDTH_2 - 70, SCR_HEIGHT_2 - 45, 140, 80);
        _g.setColor(9916193);
        _g.drawRect(SCR_WIDTH_2 - 70, SCR_HEIGHT_2 - 45, 140, 80);
        wh14.paint(_g, "\u00cf\u00e0\u00f3\u00e7\u00e0", SCR_WIDTH_2, SCR_HEIGHT_2, 33);
        bl10.paint(_g, "\u00cf\u00f0\u00ee\u00e4\u00ee\u00eb\u00e6\u00e8\u00f2\u00fc", SCR_WIDTH_2 - 70 + 6, SCR_HEIGHT_2 + 35 - 5, 36);
    }

    public static void renderLoading(Graphics _g) {
        _g.setColor(-1);
        _g.fillRect(0, 0, 240, 320);
        wh14.paint(_g, "\u00c7\u00c0\u00c3\u00d0\u00d3\u00c7\u00ca\u00c0", SCR_WIDTH_2, SCR_HEIGHT_2, 33);
        _g.setColor(65280);
        _g.drawRect(SCR_WIDTH_2 - 50, SCR_HEIGHT_2 + 30, 100, 10);
        _g.fillRect(SCR_WIDTH_2 - 50, SCR_HEIGHT_2 + 30 + 2, loadCnt, 6);
    }

    public static void drawStrWBreak(Graphics _g, String _text, int _width, int _x, int _y) {
        String[] tmp1Str = new String[30];
        if (bl10.getStringWidth(_text) > _width) {
            WCanvas.breakTxtToStrings(_text, _width, tmp1Str, 50);
        } else {
            bl10.paint(_g, _text, _x, _y, 17);
        }
        for (int i = 0; i < 30; ++i) {
            if (tmp1Str[i] == null) continue;
            bl10.paint(_g, tmp1Str[i], _x, _y, 17);
            _y += bl10.getHeight() + 2;
        }
    }

    public static void breakTxtToStrings(String _text, int _width, String[] tmp1Str, int _numWords) {
        String[] tmpStr = new String[_numWords];
        int from = 0;
        int i = 0;
        int index = _text.indexOf(" ", from);
        while (index != -1) {
            tmpStr[i] = _text.substring(from, index);
            from = index + 1;
            ++i;
            index = _text.indexOf(" ", from);
            if (index != -1) continue;
            tmpStr[i] = _text.substring(from);
        }
        int k = 0;
        int j = 0;
        while (j < _numWords && tmpStr[j] != null) {
            tmp1Str[k] = tmpStr[j];
            ++j;
            while (bl10.getStringWidth(tmp1Str[k] + tmpStr[j]) < _width && tmpStr[j] != null) {
                int n = k;
                tmp1Str[n] = tmp1Str[n] + " " + tmpStr[j];
                ++j;
            }
            ++k;
        }
    }

    protected void keyPressed(int _keyCode) {
        if (midState == 1) {
            this.keyPressedGame(_keyCode);
        } else {
            Menu.keyPressedMenu(_keyCode);
        }
    }

    private void keyPressedGame(int _keyCode) {
        if (pause && _keyCode != -6) {
            return;
        }
        switch (_keyCode) {
            case -3: 
            case 52: {
                int tmp;
                int n = tmp = gameType == 1 ? 1 : 0;
                if (curX > tmp) {
                    --curX;
                    break;
                }
                curX = LEVEL_WIDTH - (tmp + 1);
                break;
            }
            case -4: 
            case 54: {
                int tmp;
                int n = tmp = gameType == 1 ? 2 : 1;
                if (curX < LEVEL_WIDTH - tmp) {
                    ++curX;
                    break;
                }
                curX = tmp - 1;
                break;
            }
            case -1: 
            case 50: {
                if (curY > 0) {
                    --curY;
                    break;
                }
                curY = 11;
                break;
            }
            case -2: 
            case 56: {
                if (curY < 11) {
                    ++curY;
                    break;
                }
                curY = 0;
                break;
            }
            case -6: {
                if (solved) {
                    midState = 0;
                    if (gameMode == 0) {
                        if (levelMaxed < level) {
                            ++levelMaxed;
                        }
                        if (level <= 9) {
                            ++level;
                            WCanvas.startNewLevel();
                            hasSave = true;
                        } else {
                            hasSave = false;
                        }
                        waterCnt = 0;
                    }
                    Menu.menuState = 13;
                    instance.loadData(0);
                    sndWash.play(true);
                    System.out.println("sndWash.play(true)");
                    break;
                }
                if (loosed) {
                    midState = 0;
                    Menu.menuState = 1;
                    instance.loadData(0);
                    sndLogo.play(true);
                    hasSave = false;
                    break;
                }
                pause = !pause;
                break;
            }
            case -5: 
            case 53: {
                int curCur = curY * LEVEL_WIDTH + curX;
                if (LEVEL_DATA[curCur] < 0) break;
                if (LEVEL_DATA[curCur] < 2) {
                    if (LEVEL_DATA[curCur] == 1) {
                        WCanvas.LEVEL_DATA[curCur] = 0;
                        break;
                    }
                    WCanvas.LEVEL_DATA[curCur] = 1;
                    break;
                }
                if (LEVEL_DATA[curCur] >= 6) break;
                if (LEVEL_DATA[curCur] < 5) {
                    WCanvas.LEVEL_DATA[curCur] = LEVEL_DATA[curCur] + 1;
                    break;
                }
                WCanvas.LEVEL_DATA[curCur] = 2;
                break;
            }
            case 42: {
                lastTimeAdded = 0L;
                break;
            }
            case 48: {
                break;
            }
            case 35: {
                break;
            }
            case 49: {
                break;
            }
            case 51: {
                break;
            }
            case 55: {
                break;
            }
            case 57: {
                break;
            }
            case -7: {
                midState = 0;
                Menu.menuState = 1;
                instance.loadData(0);
                hasSave = !loosed;
                sndLogo.play(true);
            }
        }
    }

    protected void keyReleased(int _keyCode) {
        switch (_keyCode) {
            case -4: 
            case -3: 
            case 52: 
            case 54: {
                break;
            }
        }
    }

    public void run() {
        while (true) {
            this.repaint();
            this.serviceRepaints();
            Thread.yield();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void generateLevel() {
        if (gameType == 0) {
            LEVEL_DATA = new int[LEVEL_WIDTH * 12];
            for (int i = 0; i < LEVEL_DATA.length; ++i) {
                WCanvas.LEVEL_DATA[i] = WCanvas.rnd(0, 6);
            }
        } else {
            int i;
            LEVEL_WIDTH = 13;
            LEVEL_DATA = new int[LEVEL_WIDTH * 12];
            for (i = 0; i < LEVEL_DATA.length; ++i) {
                WCanvas.LEVEL_DATA[i] = i < LEVEL_DATA.length / 2 ? -1 : (level < 3 ? WCanvas.rnd(0, 6) : WCanvas.rnd(0, 5));
            }
            for (i = 0; i < 12; ++i) {
                WCanvas.LEVEL_DATA[i * WCanvas.LEVEL_WIDTH] = 6;
                WCanvas.LEVEL_DATA[i * WCanvas.LEVEL_WIDTH + (WCanvas.LEVEL_WIDTH - 1)] = 6;
            }
        }
    }

    public void loadMenuData() {
        imgWater = null;
        imgTrubi = null;
        System.gc();
        imgMenuBack = WCanvas.loadImage("/mBack.png");
        if (Menu.menuState == 0) {
            imgCompanyLogo = WCanvas.loadImage("/l.png");
            imgGameLogo = WCanvas.loadImage("/logo.png");
            imgLogo = imgCompanyLogo;
        }
        imgTrubiS = WCanvas.loadImage("/trubiS.png");
        this.loadStripGirl(1);
        try {
            instance.loadTextHelp(instance, "/help.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadStripGirl(int inMenu) {
        if (gameMode == 0) {
            if (level > 0) {
                imgStrip = WCanvas.loadImage("/s" + (level - inMenu) + ".png");
                imgStripTits = WCanvas.loadImage("/s" + (level - inMenu) + "t.png");
            } else {
                imgStrip = WCanvas.loadImage("/s0.png");
                imgStripTits = WCanvas.loadImage("/s0t.png");
            }
        } else if (levelMaxed > 0) {
            imgStrip = WCanvas.loadImage("/s" + WCanvas.rnd(0, levelMaxed - 1) + ".png");
            imgStripTits = WCanvas.loadImage("/s" + WCanvas.rnd(0, levelMaxed - 1) + "t.png");
        } else {
            imgStrip = WCanvas.loadImage("/s0.png");
            imgStripTits = WCanvas.loadImage("/s0t.png");
        }
    }

    public void loadGameData() {
        imgPan = null;
        imgTrubiS = null;
        buffer = Image.createImage((int)240, (int)320);
        bufGraphics = buffer.getGraphics();
        imgTiles = WCanvas.loadImage("/tile0.png");
        imgTiles1 = WCanvas.loadImage("/tile1.png");
        imgPan = WCanvas.loadImage("/pan.png");
        imgTrubi = WCanvas.loadImage("/trubi.png");
        imgCursor = WCanvas.loadImage("/cur.png");
        imgWater = WCanvas.loadImage("/water.png");
        this.loadStripGirl(0);
        WCanvas.fillBuffer();
        justLoaded = false;
    }

    private static Image loadImage(String _path) {
        try {
            System.out.println("" + _path);
            return Image.createImage((String)_path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void drawImage(Graphics _g, Image _img, int _x, int _y, int _anchor) {
        if (_img != null) {
            _g.drawImage(_img, _x, _y, _anchor);
        }
    }

    public static void renderSubImage(Graphics _g, Image _img, int[] _bounds, int _iX, int _iY, int _iAnchor) {
        if (_img == null) {
            return;
        }
        _g.setClip(0, 0, 240, 320);
        _g.clipRect(_iX += WCanvas.getAnchorX(_bounds[2], _iAnchor), _iY += WCanvas.getAnchorY(_bounds[3], _iAnchor), _bounds[2], _bounds[3]);
        if ((_g.getClipWidth() | _g.getClipWidth()) > 0) {
            _g.drawImage(_img, _iX - _bounds[0], _iY - _bounds[1], 0);
        }
        _g.setClip(0, 0, 240, 320);
    }

    private static int getAnchorX(int _subImgWidth, int a_iAnchor) {
        if ((a_iAnchor & 1) == 1) {
            return -(_subImgWidth >>> 1);
        }
        if ((a_iAnchor & 8) == 8) {
            return -_subImgWidth;
        }
        return 0;
    }

    private static int getAnchorY(int _subImgHeight, int a_iAnchor) {
        if ((a_iAnchor & 2) == 2) {
            return -(_subImgHeight >>> 1);
        }
        if ((a_iAnchor & 0x20) == 32) {
            return -_subImgHeight;
        }
        return 0;
    }

    public static int rnd(int a_iMin, int a_iMax) {
        return a_iMin + (_rnd.nextInt() & Integer.MAX_VALUE) % (a_iMax - a_iMin + 1);
    }

    public static final short S2U(byte a_value) {
        return (short)(a_value >= 0 ? a_value : 256 + a_value);
    }

    public static void saveSettings() {
        try {
            try {
                if (WCanvas.hasRS(SET_STORE_NAME)) {
                    RecordStore.deleteRecordStore((String)SET_STORE_NAME);
                }
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
            RecordStore rs = RecordStore.openRecordStore((String)SET_STORE_NAME, (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(50);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeBoolean(Snd.getSoundOn());
            rs.addRecord(baos.toByteArray(), 0, baos.size());
            rs.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void saveGame() {
        try {
            try {
                if (WCanvas.hasRS(GAME_SAVE_STORE_NAME)) {
                    RecordStore.deleteRecordStore((String)GAME_SAVE_STORE_NAME);
                }
            }
            catch (RecordStoreException e) {
                // empty catch block
            }
            RecordStore rs = RecordStore.openRecordStore((String)GAME_SAVE_STORE_NAME, (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(500);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(level);
            dos.writeInt(levelMaxed);
            dos.writeInt(gameMode);
            dos.writeInt(lastAddedColumn);
            dos.writeInt(score);
            for (int i = 0; i < LEVEL_DATA.length; ++i) {
                dos.writeInt(LEVEL_DATA[i]);
            }
            rs.addRecord(baos.toByteArray(), 0, baos.size());
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteGameSave() {
        try {
            if (WCanvas.hasRS(GAME_SAVE_STORE_NAME)) {
                RecordStore.deleteRecordStore((String)GAME_SAVE_STORE_NAME);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private static void loadSettings() {
        RecordStore rs = null;
        try {
            if (WCanvas.hasRS(SET_STORE_NAME)) {
                rs = RecordStore.openRecordStore((String)SET_STORE_NAME, (boolean)false);
                ByteArrayInputStream bais = new ByteArrayInputStream(rs.getRecord(1));
                DataInputStream dis = new DataInputStream(bais);
                Snd.setSoundOn(dis.readBoolean());
                rs.closeRecordStore();
            }
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    public static final void loadGameSave() {
        RecordStore rs = null;
        try {
            if (WCanvas.hasRS(GAME_SAVE_STORE_NAME)) {
                rs = RecordStore.openRecordStore((String)GAME_SAVE_STORE_NAME, (boolean)false);
                ByteArrayInputStream bais = new ByteArrayInputStream(rs.getRecord(1));
                DataInputStream dis = new DataInputStream(bais);
                level = dis.readInt();
                levelMaxed = dis.readInt();
                gameMode = dis.readInt();
                lastAddedColumn = dis.readInt();
                score = dis.readInt();
                for (int i = 0; i < LEVEL_DATA.length; ++i) {
                    WCanvas.LEVEL_DATA[i] = dis.readInt();
                }
                curY = 11;
                curX = 1;
                rs.closeRecordStore();
            }
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
    }

    public static boolean hasRS(String a_name) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)a_name, (boolean)false);
            rs.closeRecordStore();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        imgLogo = imgCompanyLogo;
        trubiCords = new int[][]{{0, 0, 16, 16}, {16, 0, 16, 16}, {32, 0, 16, 16}, {48, 0, 16, 16}, {64, 0, 16, 16}, {80, 0, 16, 16}, {0, 32, 16, 16}, {96, 0, 16, 16}, {112, 0, 16, 16}, {0, 16, 16, 16}, {16, 16, 16, 16}, {32, 16, 16, 16}, {48, 16, 16, 16}, {64, 16, 16, 16}, {80, 16, 16, 16}, {0, 48, 16, 16}, {160, 3, 28, 29}};
        waterCords = new int[][]{{0, 0, 4, 24}, {4, 0, 10, 24}, {14, 0, 10, 24}};
        trubiSCords = new int[][]{{0, 0, 16, 16}, {16, 0, 32, 32}, {0, 16, 16, 16}, {48, 0, 32, 32}};
        sndLogo = new Snd("/logo.amr", 9);
        sndBattle = new Snd("/battle.amr", 10);
        sndWash = new Snd("/wash.amr", 8);
        font2Width = new int[]{9, 7, 9, 8, 9, 6, 14, 8, 8, 7, 7, 10, 12, 4, 4, 4, 4, 2, 8, 8, 8, 8, 8, 8, 8, 7, 8, 8, 12, 11, 8, 9, 8, 9, 7, 9, 8, 12, 7, 10, 10, 9, 10, 12, 10, 8, 10, 9, 7, 8, 9, 10, 9, 10, 10, 14, 14, 10, 13, 9, 7, 12, 10, 12, 10, 10, 10, 11, 10, 16, 8, 12, 12, 12, 12, 14, 12, 11, 12, 10, 10, 10, 12, 12, 12, 12, 12, 16, 16, 12, 14, 10, 10, 17, 12, 6, 6, 7, 6, 7, 8, 9, 8};
        font1Width = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        font3Width = new int[]{4, 4, 4, 4, 4, 1, 7, 5, 2, 4, 2, 4, 5, 1, 1, 1, 1, 2, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 5, 4, 4, 4, 3, 6, 4, 7, 4, 4, 4, 4, 4, 5, 4, 5, 4, 4, 4, 3, 3, 7, 3, 5, 4, 7, 8, 5, 6, 4, 4, 6, 4, 5, 6, 6, 5, 7, 5, 7, 5, 6, 6, 5, 5, 8, 6, 6, 6, 6, 6, 5, 5, 7, 5, 6, 5, 7, 8, 7, 7, 6, 6, 7, 6, 2, 2, 4, 2, 2, 5, 3, 4};
        wh14 = new DrawFont("/GASwh12.png", font2Width, 0);
        numSmall = new DrawFont("/fontNumSmall.png", font1Width, 0);
        bl10 = new DrawFont("/font_small.png", font3Width, 0);
        LEVEL_TIME = new int[]{120, 100, 80, 60, 50, 40, 40, 40, 40, 40};
        level = 0;
        levelMaxed = 0;
        levelTime = 0L;
        solved = false;
        loosed = false;
        solvedCnt = 0;
        lastAddedColumn = 1;
        lastTimeAdded = System.currentTimeMillis();
        TIME_TO_ADD_NEW_PIPE = new int[]{2000, 1800, 1600, 1400, 1200, 1000, 975, 950, 925, 800};
        deleteConnectedState = 0;
        SCORE_TO_WIN = new int[]{2000, 3500, 4500, 5000, 6000, 7000, 8000, 8500, 9000, 10000};
        waterCnt = 0;
        curX = 0;
        curY = 0;
        score = 0;
        GIRLS_NAMES = new String[]{"\u00d2\u00e0\u00ed\u00ff", "\u00c6\u00e5\u00ed\u00ff", "\u00cc\u00e0\u00f8\u00e0", "\u00ca\u00e0\u00f2\u00ff", "\u00c6\u00e0\u00ed\u00ed\u00e0", "\u00ce\u00eb\u00ff", "\u00d1\u00e2\u00e5\u00f2\u00e0", "\u00c0\u00ed\u00ff", "\u00cb\u00e8\u00e7\u00e0", "\u00d1\u00e0\u00f8\u00e0"};
        pause = false;
        loading = false;
        loadCnt = 0;
        LEVEL_WIDTH = 13;
        LEVEL_DATA = new int[LEVEL_WIDTH * 12];
        _rnd = new Random(System.currentTimeMillis());
        hasSave = false;
        justLoaded = true;
    }
}

