/*
 * Decompiled with CFR 0.152.
 */
package screens;

import font.VectorFont;
import javax.microedition.lcdui.Graphics;
import lib.Fonts;
import lib.Lib;
import main.GameManager;
import screens.MenuScreen;
import screens.elements.MenuField;

public class HelpScreen {
    public static int HELP_FIELD_HEIGHT;
    public static int ABOUT_FIELD_HEIGHT;
    public static int HELP_TEXT_WIDTH;
    public static int HELP_TEXT_INTERLINE;
    public static int[][] HELP_TEXT_LINES;
    public static int[][] ABOUT_TEXT_LINES;
    public static int[][] helpAboutTextLines;
    public static int helpTextFirstLine;
    public static int helpTextLinesOnScreen;
    public static int HELP_TEXT_TOP_MARGIN;

    public static void showHelpAbout(int type) {
        GameManager.previousScreenStack.addElement(new Integer(GameManager.currentScreen));
        helpAboutTextLines = type == 5 ? HELP_TEXT_LINES : ABOUT_TEXT_LINES;
        helpTextFirstLine = 0;
        GameManager.current.startOperation(4, 5);
    }

    public static void paint_HelpAbout(Graphics g) {
        if (!MenuField.paint_MenuBackground(g)) {
            return;
        }
        g.setColor(0);
        for (int i = 0; i < helpTextLinesOnScreen && i < helpAboutTextLines.length; ++i) {
            VectorFont currentLineFont;
            int[] line = helpAboutTextLines[i + helpTextFirstLine];
            if (line != null && line.length > 0 && (line[0] & 0xFF) == Fonts.SPECIAL_CHAR_BOLD) {
                line = VectorFont.substring(line, 1);
                currentLineFont = Fonts.fontHelpBold;
            } else {
                currentLineFont = Fonts.fontHelpPlain;
            }
            int top = 160 - HELP_FIELD_HEIGHT + HELP_TEXT_TOP_MARGIN + i * (Fonts.fontHelpPlain.getHeight() + HELP_TEXT_INTERLINE);
            if (top + Fonts.fontHelpPlain.getHeight() <= 160 - MenuField.menuFieldHeightCurrentBlocked || top >= 160 + MenuField.menuFieldHeightCurrentBlocked) continue;
            currentLineFont.drawString(g, line, 120 - GameManager.imgArrows.getWidth() / 4, top, 17);
        }
        if (helpTextFirstLine > 0) {
            Lib.drawSprite(g, GameManager.imgArrows, 240 - GameManager.imgArrows.getWidth() / 2 - 2, 160 - HELP_FIELD_HEIGHT + MenuScreen.arrowOffset / 2, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, 0, GameManager.imgArrows.getHeight() / 2);
        }
        if (helpTextFirstLine < helpAboutTextLines.length - helpTextLinesOnScreen) {
            Lib.drawSprite(g, GameManager.imgArrows, 240 - GameManager.imgArrows.getWidth() / 2 - 2, 160 + HELP_FIELD_HEIGHT - GameManager.imgArrows.getHeight() / 2 - MenuScreen.arrowOffset / 2, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2);
        }
        MenuField.drawMenuBorders(g);
    }

    public static void keyPressed_HelpAbout(int key) {
        if (MenuField.isAnimationFieldResizeInProgress) {
            return;
        }
        switch (GameManager.current.getGameAction(key)) {
            case 1: {
                if (helpTextFirstLine > 0) {
                    --helpTextFirstLine;
                }
                GameManager.repaintCurrent();
                break;
            }
            case 6: {
                if (helpTextFirstLine < helpAboutTextLines.length - helpTextLinesOnScreen) {
                    ++helpTextFirstLine;
                }
                GameManager.repaintCurrent();
                break;
            }
            case 8: {
                GameManager.current.startOperation(4, (Integer)GameManager.previousScreenStack.pop());
            }
        }
    }

    static {
        HELP_TEXT_INTERLINE = 0;
        HELP_TEXT_LINES = null;
        ABOUT_TEXT_LINES = null;
        helpAboutTextLines = null;
        helpTextFirstLine = 0;
        helpTextLinesOnScreen = 0;
        HELP_TEXT_TOP_MARGIN = 1;
    }
}

