/*
 * Decompiled with CFR 0.152.
 */
package screens;

import javax.microedition.lcdui.Graphics;
import lib.Fonts;
import lib.Lib;
import main.GameManager;
import main.MusicManager;
import screens.MenuScreen;
import screens.elements.MenuField;

public class OptionsScreen {
    public static int optionItemSelected = 0;
    public static int OPTIONS_FIELD_HEIGHT;
    public static String OPTION_TEXT_MUSIC;
    public static String OPTION_TEXT_SOUND;
    public static String OPTION_TEXT_ENABLE_SOUND;
    public static String OPTION_TEXT_OK;
    public static String OPTION_TEXT_OFF;
    public static String OPTION_TEXT_YES;
    public static String OPTION_TEXT_NO;
    public static String[] OPTIONS_TEXTS;
    public static int optionInterline;

    public static void showOptions() {
        optionItemSelected = 0;
        GameManager.previousScreenStack.push(new Integer(GameManager.currentScreen));
        GameManager.current.startOperation(4, 6);
        GameManager.current.startOperation(9);
    }

    public static void paint_Options(Graphics g) {
        if (!MenuField.paint_MenuBackground(g)) {
            return;
        }
        for (int i = 0; i < OPTIONS_TEXTS.length; ++i) {
            int top = 160 - OPTIONS_FIELD_HEIGHT + 3 * optionInterline / 2 - 1 + (OPTIONS_TEXTS.length - 1 - i) * (Fonts.fontMenu.getHeight() + optionInterline);
            String text = OPTIONS_TEXTS[i];
            if (OPTIONS_TEXTS[i] == OPTION_TEXT_MUSIC) {
                text = text + ": " + MusicManager.volumeMusic;
            } else if (OPTIONS_TEXTS[i] == OPTION_TEXT_ENABLE_SOUND) {
                text = MusicManager.isEnabledMusic ? text + ": " + OPTION_TEXT_YES : text + ": " + OPTION_TEXT_NO;
            }
            Fonts.fontMenu.drawString(g, Fonts.fontMapper.mapString(text), 120, top, 17);
            if (optionItemSelected != i) continue;
            g.setColor(MenuScreen.frameColor);
            g.drawRect(2, top, 235, Fonts.fontMenu.getHeight() + 1);
            g.drawRect(1, top - 1, 237, Fonts.fontMenu.getHeight() + 3);
            if (optionItemSelected > 0) {
                Lib.drawSprite(g, GameManager.imgArrows, MenuScreen.MENU_ARROW_SIDE_MARGIN + MenuScreen.arrowOffset / 2, top + 1 + Fonts.fontMenu.getHeight() / 2 - GameManager.imgArrows.getHeight() / 4, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, 0, 0);
                Lib.drawSprite(g, GameManager.imgArrows, 240 - MenuScreen.MENU_ARROW_SIDE_MARGIN - MenuScreen.arrowOffset / 2 - GameManager.imgArrows.getWidth() / 2, top + 1 + Fonts.fontMenu.getHeight() / 2 - GameManager.imgArrows.getHeight() / 4, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, GameManager.imgArrows.getWidth() / 2, 0);
            }
            g.setColor(0);
        }
        MenuField.drawMenuBorders(g);
    }

    public static void keyPressed_Options(int key) {
        if (MenuField.isAnimationFieldResizeInProgress) {
            return;
        }
        switch (GameManager.current.getGameAction(key)) {
            case 2: {
                if (OPTIONS_TEXTS[optionItemSelected] == OPTION_TEXT_MUSIC && MusicManager.volumeMusic > 1) {
                    --MusicManager.volumeMusic;
                }
                if (OPTIONS_TEXTS[optionItemSelected] == OPTION_TEXT_ENABLE_SOUND) {
                    boolean bl = MusicManager.isEnabledMusic = !MusicManager.isEnabledMusic;
                    if (MusicManager.isEnabledMusic) {
                        MusicManager.musicStart();
                    } else {
                        MusicManager.musicStop();
                    }
                }
                GameManager.current.repaint();
                break;
            }
            case 5: {
                if (OPTIONS_TEXTS[optionItemSelected] == OPTION_TEXT_MUSIC && MusicManager.volumeMusic < MusicManager.VOLUME_MAX) {
                    ++MusicManager.volumeMusic;
                }
                if (OPTIONS_TEXTS[optionItemSelected] == OPTION_TEXT_ENABLE_SOUND) {
                    boolean bl = MusicManager.isEnabledMusic = !MusicManager.isEnabledMusic;
                    if (MusicManager.isEnabledMusic) {
                        MusicManager.musicStart();
                    } else {
                        MusicManager.musicStop();
                    }
                }
                GameManager.repaintCurrent();
                break;
            }
            case 1: {
                ++optionItemSelected;
                optionItemSelected = Lib.mod(optionItemSelected, OPTIONS_TEXTS.length);
                GameManager.repaintCurrent();
                break;
            }
            case 6: {
                --optionItemSelected;
                optionItemSelected = Lib.mod(optionItemSelected, OPTIONS_TEXTS.length);
                GameManager.repaintCurrent();
                break;
            }
            case 8: {
                if (OPTIONS_TEXTS[optionItemSelected] != OPTION_TEXT_OK) break;
                GameManager.current.startOperation(4, (Integer)GameManager.previousScreenStack.pop());
                MenuScreen.stopFrameColorAnimation = true;
            }
        }
        if (MusicManager.isEnabledMusic) {
            switch (GameManager.current.getGameAction(key)) {
                case 2: 
                case 5: {
                    MusicManager.setMusicVolume(MusicManager.volumeMusic);
                    MusicManager.setFxVolume(MusicManager.volumeMusic);
                }
            }
            if (OPTIONS_TEXTS[optionItemSelected] == OPTION_TEXT_SOUND) {
                try {
                    MusicManager.playerMusic.stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                GameManager.pause(200);
                try {
                    if (MusicManager.playerFx.getState() != 400) {
                        MusicManager.playerFx.start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (MusicManager.playerMusic.getState() != 400) {
                try {
                    MusicManager.playerFx.stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                GameManager.pause(200);
                try {
                    MusicManager.playerMusic.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

