/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.EventQueue;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.common.ISoundController;
import com.kitmaker.games.common.StateStack;
import com.kitmaker.games.party.ArtDrawingGame;
import com.kitmaker.games.party.ArtShapeGame;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.PartyGame;
import com.kitmaker.games.party.PartyMIDlet;
import com.kitmaker.games.party.Persister;
import com.kitmaker.games.party.PsicoHowGame;
import com.kitmaker.games.party.PsicoWhatGame;
import com.kitmaker.games.party.QuizTrueOrFalseGame;
import com.kitmaker.games.party.QuizWhichGame;
import com.kitmaker.games.party.ShowKaraokeGame;
import com.kitmaker.games.party.TextBuffer;
import java.io.InputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Game
extends GameCanvas
implements Runnable {
    private static Game m_instance = null;
    private static StringBuffer m_auxStringBuffer = new StringBuffer();
    private static StringBuffer m_auxStringBuffer2 = new StringBuffer();
    protected static IPainter m_painter;
    private Thread m_thread;
    private boolean m_mustExit;
    private long m_paintTimer;
    private EventQueue m_eventQueue;
    private byte m_gameState;
    private StateStack m_stateStack;
    private PartyMIDlet m_MIDlet;
    private ISoundController m_soundController;
    protected byte m_playerIndex;
    private boolean m_soundEnabled;
    protected static short m_screenWidth;
    protected static short m_screenHeight;
    protected static short m_menuBackgroundHeight;
    protected static short diff;
    protected static TextBuffer m_textBuffer;
    private Image m_logo;
    private Image[] m_coverImages;
    private Image m_menuBackgroundImage;
    private Image[] m_menuButtons;
    private Image m_buttonEdge;
    private Image[] m_navigationButtons;
    private Image m_partnerSelectionImage;
    private Image[] m_partnerSelectorImages;
    private Image m_viewProfilePanelImage;
    private Image m_viewProfileCharacterImage;
    private Image m_partnerImage;
    private Image m_speechBubbleImage;
    private long m_splashTimer;
    protected static BitmapFont m_bigRedBitmapFont;
    protected static BitmapFont m_bigWhiteBitmapFont;
    protected static BitmapFont m_bigYellowBitmapFont;
    protected static BitmapFont m_redBitmapFont;
    protected static BitmapFont m_whiteBitmapFont;
    protected static Font m_smallFont;
    protected static Font m_mediumFont;
    protected static Font m_mediumBoldFont;
    protected static Font m_smallBoldFont;
    protected static Font m_largeFont;
    protected static Font m_italicFont;
    private byte m_menuLastSelectedOption;
    private byte m_menuSelectedOption;
    private String[] m_playerNameList;
    private byte m_nameSelectionOffset;
    private short m_scrollingTextClipHeight;
    private short m_offsetLimit;
    private Image[] m_icons;
    private boolean[] m_categoryWithoutPeanuts;
    private Image m_peanutEdgeImage;
    protected static byte m_caretPosition;
    protected static byte m_caretCharIndex;
    protected static byte m_caretTableIndex;
    protected static long m_caretTimer;
    protected static byte m_textInputMaxLength;
    protected static StringBuffer m_textInputStringBuffer;
    private Persister m_persister;
    private short m_scrollOffset;
    private short m_scrollingClipHeight;
    private long m_scrollTimer;
    private boolean m_scrollUp;
    private boolean m_scrollDown;
    private byte m_scrollValue;
    private long m_scrollDelay;
    private short[] m_offsets;
    private byte m_currentSection;
    private boolean m_aboutVisible;
    private short m_currentAboutSentenceLength;
    private short m_currentAboutIndexOffset;
    private boolean m_aboutSectionCompleted;
    private Image m_objectiveCardHandImage;
    private Image m_selectionArrowImage;
    private boolean[] m_selectedObjectiveCards;
    private Image m_checkImage;
    private Image[] m_peanutImages;
    private Image m_objectiveCardImage;
    private byte m_remainingObjectiveCardCount;
    private byte[][] m_objectiveCardDeck;
    private byte[][] m_playerObjectiveCards;
    private byte[][] m_playerPeanutsNeeded;
    private int[][] m_playerScore;
    private byte[][] m_playerObjectiveCardsPeanutStates;
    private Image[] m_diceImages;
    private boolean m_diceThrown;
    private byte m_currentDiceFrame;
    private byte m_diceResult;
    private long m_diceTimer;
    private byte m_currentCategory;
    private boolean m_losePeanut;
    private boolean m_surpriseResultCalculated;
    private byte m_partyGameToCreate;
    private PartyGame m_partyGame;
    private String[] m_playerName;
    private byte[] m_partnerIndex;
    private boolean m_inPause;
    private byte m_currentPlayer;
    private byte[] m_currentTestNumber;
    protected short[] m_currentQuestionCount;
    protected short[][] m_questionIndexes;
    protected byte[][] m_diceBuffer;
    protected byte[][] m_dicePossibleResults;
    protected byte[] m_currentDiceResultCount;
    protected byte[][][] m_categoryBuffer;
    private boolean m_partyGameCounted;
    private Object[][] m_ranking;
    private byte m_firstVisiblePositionInRanking;
    private long m_screenTitleTimer;
    private short m_screenTitleOffset;
    private boolean m_screenTitleDirLeft;
    private boolean m_screenTitleAnimationStarted;

    public static Game getInstance(PartyMIDlet midlet) {
        if (m_instance == null) {
            try {
                m_instance = new Game(midlet);
            }
            catch (Exception e) {
                m_instance = null;
            }
        }
        return m_instance;
    }

    private Game(PartyMIDlet midlet) throws Exception {
        super(false);
        this.setFullScreenMode(true);
        this.m_MIDlet = midlet;
        this.m_eventQueue = new EventQueue(5);
        this.m_stateStack = new StateStack(15);
        m_painter = (IPainter)Class.forName("com.kitmaker.games.common.midp20.Painter").newInstance();
        this.m_soundController = (ISoundController)Class.forName("com.kitmaker.games.common.midp20.SoundController").newInstance();
        this.m_soundController.initializeSound((byte)1);
        m_textBuffer = new TextBuffer();
        InputStream is = this.getClass().getResourceAsStream("/textos.txt");
        InputStream uis = this.getClass().getResourceAsStream("/unicode.txt");
        if (!m_textBuffer.initialize(is, uis, 2000, 132)) {
            throw new Exception();
        }
        try {
            is.close();
            uis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        is = null;
        uis = null;
        this.initializeNavigationButtons();
        this.m_persister = new Persister(m_textBuffer);
        this.m_persister.getOptions(this);
    }

    public void paint(Graphics g) {
        try {
            if (this.m_mustExit || this.m_stateStack.getTop() != this.m_gameState) {
                return;
            }
            if (this.m_gameState == 0 || this.m_gameState == 1 || this.m_gameState == 24) {
                g.setColor(0);
            } else {
                g.setColor(8721258);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            switch (this.m_gameState) {
                case 1: {
                    this.paintKitmakerState(g);
                    break;
                }
                case 19: {
                    this.paintCoverState(g);
                    break;
                }
                case 24: {
                    this.paintDisetState(g);
                    break;
                }
                case 18: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.paintPartnerSpeechStates(g);
                    break;
                }
                case 25: {
                    this.paintPlayerNumberState(g);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 15: 
                case 20: 
                case 21: {
                    this.paintMenuState(g);
                    break;
                }
                case 8: {
                    this.paintNameSelectionState(g);
                    break;
                }
                case 6: {
                    this.paintPartnerSelectionState(g);
                    break;
                }
                case 7: {
                    this.paintViewProfileState(g);
                    break;
                }
                case 9: {
                    this.paintNameCreationState(g);
                    break;
                }
                case 23: {
                    this.paintRankingState(g);
                    break;
                }
                case 10: {
                    this.paintAboutState(g);
                    break;
                }
                case 32: {
                    break;
                }
                case 11: {
                    this.paintHelpState(g, 100, 129, false);
                    break;
                }
                case 12: {
                    this.paintObjectiveCardSelectionState(g);
                    break;
                }
                case 13: 
                case 22: {
                    this.paintObjectiveCardViewState(g);
                    break;
                }
                case 14: {
                    this.paintDiceState(g);
                    break;
                }
                case 16: {
                    this.paintPlayState(g);
                    break;
                }
                case 17: {
                    this.paintCategorySelectionState(g);
                    break;
                }
                case 26: {
                    this.paintChoosePeanutState(g);
                }
            }
        }
        catch (Exception e) {
            if (this.m_gameState == 0 || this.m_gameState == 1) {
                g.setColor(0);
            } else {
                g.setColor(8721258);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void paintPlayerNumberState(Graphics g) {
        int y;
        int lastY = y = this.paintMenuBackground(g, (short)-1, null, 0, true);
        int x = 0;
        m_auxStringBuffer.setLength(0);
        m_auxStringBuffer.append(m_textBuffer.getText(88));
        m_auxStringBuffer.append(' ').append(this.m_currentPlayer + 1);
        String str = m_auxStringBuffer.toString();
        y = Game.drawWrappedString(null, m_painter, str, x, y, m_screenWidth, null, m_largeFont, false, true, -11454824);
        int h = y - lastY;
        y = lastY + m_menuBackgroundHeight / 2 - h / 2;
        g.setColor(8721258);
        g.fillRect(0, y - 0, (int)m_screenWidth, h + 0);
        g.setColor(-1);
        g.fillRect(0, y, (int)m_screenWidth, h);
        y = Game.drawWrappedString(g, m_painter, str, x, y, m_screenWidth, null, m_largeFont, true, true, -11454824);
        this.paintNavigationMenu(g, true, (short)6, (short)5);
    }

    private void paintPlayState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)-1, null, 0, true);
        this.m_partyGame.paint(g, m_painter, y, m_screenWidth, m_menuBackgroundHeight);
        short back = this.m_partyGame.getNavigationBackLabel();
        short ok = this.m_partyGame.getNavigationOkLabel();
        this.paintNavigationMenu(g, back != -1, ok, back);
    }

    private void paintPartnerSpeechStates(Graphics g) {
        int finalScore;
        int h;
        int y = this.m_gameState == 30 ? this.paintMenuBackground(g, (short)98, m_whiteBitmapFont, -1, true) : this.paintMenuBackground(g, (short)-1, null, 0, true);
        int tmph = h = this.m_partnerImage.getHeight();
        int w = this.m_partnerImage.getWidth();
        m_painter.drawRegion(g, this.m_partnerImage, 0, 0, 0, y += m_menuBackgroundHeight / 2 - this.m_partnerImage.getHeight() / 2, this.m_partnerImage.getWidth(), this.m_partnerImage.getHeight(), 0);
        w = this.m_speechBubbleImage.getWidth();
        h = this.m_speechBubbleImage.getHeight();
        int x = m_screenWidth - w;
        y = m_screenHeight / 2 - h / 2;
        m_painter.drawRegion(g, this.m_speechBubbleImage, 0, 0, x, y, w, h, 0);
        m_auxStringBuffer.setLength(0);
        if (this.m_gameState == 30) {
            m_auxStringBuffer.append(m_textBuffer.getText(99));
            finalScore = 0;
            if (this.m_currentTestNumber[this.m_currentPlayer] - 1 > 0) {
                finalScore = this.m_playerScore[this.m_currentPlayer][0] * 10 * this.m_playerScore[this.m_currentPlayer][1] / (this.m_currentTestNumber[this.m_currentPlayer] - 1);
            }
            m_auxStringBuffer.append(' ').append(finalScore);
        } else if (this.m_gameState == 18) {
            m_auxStringBuffer.append(m_textBuffer.getText(81));
            m_auxStringBuffer.append(' ').append(m_textBuffer.getText(131));
            finalScore = this.m_playerScore[this.m_currentPlayer][0] * 10 * this.m_playerScore[this.m_currentPlayer][1] / (this.m_currentTestNumber[this.m_currentPlayer] - 1);
            m_auxStringBuffer.append(' ').append(finalScore += 2000 / (this.m_currentTestNumber[this.m_currentPlayer] - 1));
        } else if (this.m_gameState == 29) {
            m_auxStringBuffer.append(m_textBuffer.getText(97));
        } else if (this.m_gameState == 31) {
            m_auxStringBuffer.append(m_textBuffer.getText(130));
        } else {
            if (this.m_losePeanut) {
                m_auxStringBuffer.append(m_textBuffer.getText(91));
            } else {
                m_auxStringBuffer.append(m_textBuffer.getText(90));
            }
            if (this.m_gameState == 27) {
                m_auxStringBuffer.append(' ');
                switch (this.m_currentCategory) {
                    case 3: {
                        m_auxStringBuffer.append(m_textBuffer.getText(94));
                        break;
                    }
                    case 0: {
                        m_auxStringBuffer.append(m_textBuffer.getText(92));
                        break;
                    }
                    case 1: {
                        m_auxStringBuffer.append(m_textBuffer.getText(95));
                        break;
                    }
                    case 2: {
                        m_auxStringBuffer.append(m_textBuffer.getText(93));
                    }
                }
            } else {
                m_auxStringBuffer.append(m_textBuffer.getText(96));
            }
        }
        x += 33;
        y += 30;
        String str = m_auxStringBuffer.toString();
        int height = Game.drawWrappedString(null, m_painter, str, 0, 0, w - 33 + -15, null, m_smallBoldFont, true, true, 0);
        if (height < 150) {
            Game.drawWrappedString(g, m_painter, str, x, y + 75 - height / 2, w - 33 + -15, null, m_smallBoldFont, true, true, 0);
        } else {
            this.m_scrollingTextClipHeight = (short)146;
            this.m_offsetLimit = (short)(this.m_scrollingTextClipHeight - height);
            if (this.m_offsetLimit > 0) {
                this.m_offsetLimit = 0;
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.setClip(x, y + 2, w, (int)this.m_scrollingTextClipHeight);
            Game.drawWrappedString(g, m_painter, str, x, y += this.m_scrollOffset + 2, w - 33 + -15, null, m_smallBoldFont, false, true, 0);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        boolean showCard = this.m_gameState != 18 && this.m_gameState != 30;
        this.paintNavigationMenu(g, showCard, (short)6, (short)85);
    }

    private void paintHelpState(Graphics g, int start, int last, boolean center) {
        Font lastFont = g.getFont();
        g.setFont(m_smallFont);
        int h = m_smallFont.getHeight();
        this.m_scrollingClipHeight = (short)(m_screenHeight - 10 - 36);
        int destY = this.m_scrollOffset + 10;
        g.setClip(0, 10, m_screenWidth - 0, (int)this.m_scrollingClipHeight);
        for (int i = start; i < last + 1; ++i) {
            Object gr = this.m_offsets[i - start + 1] + this.m_scrollOffset > -h ? g : null;
            Font f = m_smallFont;
            String str = m_textBuffer.getText(i);
            if (str != null) {
                int color = i == 100 || i == 106 || i == 125 ? -3584 : -1;
                destY = Game.drawWrappedString(gr, m_painter, str, 0, destY, m_screenWidth - 0, null, f, center, true, color);
            } else {
                destY += h;
            }
            if (destY > 10 + this.m_scrollingClipHeight) break;
        }
        g.setClip(0, 0, (int)m_screenWidth, (int)m_screenHeight);
        g.setFont(lastFont);
        this.paintNavigationMenu(g, true, (short)6, (short)5);
    }

    private void paintDiceState(Graphics g) {
        short backLabel;
        short label;
        byte currentImage;
        int y = this.paintMenuBackground(g, (short)-1, null, -256, true);
        int ch = m_bigWhiteBitmapFont.getCharHeight();
        Game.drawWrappedString(g, m_painter, this.m_playerName[this.m_currentPlayer], 0, y / 2 - ch / 2, m_screenWidth, m_bigWhiteBitmapFont, m_largeFont, true, false, -1);
        if (this.m_diceResult == -1) {
            currentImage = Constants.DICE_ANIMATION_FRAMES[this.m_currentDiceFrame];
            label = 50;
            backLabel = 5;
        } else {
            currentImage = this.m_diceResult;
            label = 51;
            backLabel = 85;
        }
        int w = this.m_diceImages[currentImage].getWidth();
        int h = this.m_diceImages[currentImage].getHeight();
        int x = m_screenWidth / 2 - w / 2;
        m_painter.drawRegion(g, this.m_diceImages[currentImage], 0, 0, x, y += m_menuBackgroundHeight / 2 - h / 2, w, h, 0);
        this.paintNavigationMenu(g, this.m_diceResult != -1 || !this.m_diceThrown, label, backLabel);
    }

    private void paintObjectiveCardViewState(Graphics g) {
        int x;
        int y = this.paintMenuBackground(g, (short)86, m_whiteBitmapFont, -1, true);
        int bgY = y = y + m_menuBackgroundHeight / 2 - this.m_objectiveCardImage.getHeight() / 2;
        int bgX = x = m_screenWidth / 2 - this.m_objectiveCardImage.getWidth() / 2;
        int diff = this.m_objectiveCardImage.getHeight() - m_menuBackgroundHeight;
        if (diff < 0) {
            diff = 0;
        }
        m_painter.drawRegion(g, this.m_objectiveCardImage, 0, diff / 2, x, y + diff / 2, this.m_objectiveCardImage.getWidth(), this.m_objectiveCardImage.getHeight() - diff, 0);
        int h = this.m_peanutImages[0].getHeight();
        int w = this.m_peanutImages[0].getWidth();
        int initY = y + 29;
        int gapY = 5;
        y = initY;
        int thirdWidth = 42;
        x += 17;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                int peanutIndex = 2 * i + j;
                byte state = this.m_playerObjectiveCardsPeanutStates[this.m_currentPlayer][peanutIndex];
                m_painter.drawRegion(g, this.m_peanutImages[this.m_playerObjectiveCards[this.m_currentPlayer][peanutIndex]], 0, 0, x, y, w, h, 0);
                if (state == 1) {
                    int yy = y + 99;
                    m_painter.drawRegion(g, this.m_peanutImages[this.m_playerObjectiveCards[this.m_currentPlayer][peanutIndex]], 0, 0, x, yy, w, h, 0);
                    byte stock = -this.m_playerPeanutsNeeded[this.m_currentPlayer][this.m_playerObjectiveCards[this.m_currentPlayer][peanutIndex]];
                    if (stock > 0) {
                        m_auxStringBuffer.setLength(0);
                        m_auxStringBuffer.append('+');
                        m_auxStringBuffer.append(stock);
                        String str = m_auxStringBuffer.toString();
                        g.setColor(65280);
                        g.drawString(str, x + 1, yy, 20);
                    }
                }
                y += h + gapY;
            }
            y = initY;
            x += thirdWidth;
        }
        this.paintNavigationMenu(g, this.m_gameState == 13, (short)6, (short)5);
    }

    private void paintObjectiveCardSelectionState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)49, m_whiteBitmapFont, -1, true);
        int x = 2;
        y += 0;
        y = y + m_menuBackgroundHeight / 2 - this.m_objectiveCardHandImage.getHeight() / 2;
        x = m_screenWidth / 2 - this.m_objectiveCardHandImage.getWidth() / 2;
        m_painter.drawRegion(g, this.m_objectiveCardHandImage, 0, 0, x, y, this.m_objectiveCardHandImage.getWidth(), this.m_objectiveCardHandImage.getHeight(), 0);
        x = Constants.OBJECTIVE_CARDS_SELECTION_COORDS[this.m_menuSelectedOption][0];
        y = Constants.OBJECTIVE_CARDS_SELECTION_COORDS[this.m_menuSelectedOption][1];
        m_painter.drawRegion(g, this.m_selectionArrowImage, 0, 0, x, y, this.m_selectionArrowImage.getWidth(), this.m_selectionArrowImage.getHeight(), 0);
        this.paintNavigationMenu(g, true, (short)6, (short)5);
    }

    private void paintAboutState(Graphics g) {
        int h = m_italicFont.getHeight();
        int initY = this.paintMenuBackground(g, (short)-1, null, 0, false);
        int destY = initY + m_menuBackgroundHeight / 4;
        if (this.m_aboutVisible) {
            Font f = m_italicFont;
            String text = null;
            text = this.m_currentSection == -1 ? m_textBuffer.getText(26) : m_textBuffer.getText(Constants.TEXT_ABOUT_SECTIONS[this.m_currentSection][0]);
            destY = Game.drawWrappedString(g, m_painter, text, h, destY, m_screenWidth - 2 * h, null, f, true, true, -256);
            if (this.m_currentSection > -1) {
                short s = Constants.TEXT_ABOUT_SECTIONS[this.m_currentSection][1];
                if (this.m_currentAboutSentenceLength > 0) {
                    text = m_textBuffer.getText(s + this.m_currentAboutIndexOffset);
                    text = text.substring(0, this.m_currentAboutSentenceLength);
                    destY = Game.drawWrappedString(g, m_painter, text, h, destY, m_screenWidth - 2 * h, null, f, true, true, -1);
                }
            }
            text = null;
        }
        this.paintNavigationMenu(g, true, (short)6, (short)5);
    }

    private void paintPartnerSelectionState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)15, m_whiteBitmapFont, -1, true);
        int x = 2;
        y += 0;
        y = y + m_menuBackgroundHeight / 2 - this.m_partnerSelectionImage.getHeight() / 2;
        x = m_screenWidth / 2 - this.m_partnerSelectionImage.getWidth() / 2;
        m_painter.drawRegion(g, this.m_partnerSelectionImage, 0, 0, x, y, this.m_partnerSelectionImage.getWidth(), this.m_partnerSelectionImage.getHeight(), 0);
        m_painter.drawRegion(g, this.m_partnerSelectorImages[this.m_menuSelectedOption], 0, 0, x + Constants.PARTNER_SELECTOR_COORDS[this.m_menuSelectedOption][0], y + Constants.PARTNER_SELECTOR_COORDS[this.m_menuSelectedOption][1], this.m_partnerSelectorImages[this.m_menuSelectedOption].getWidth(), this.m_partnerSelectorImages[this.m_menuSelectedOption].getHeight(), 0);
        for (int i = 0; i < Constants.PARTNER_NAMES.length; ++i) {
            int color;
            BitmapFont bf;
            int h = m_whiteBitmapFont.getCharHeight();
            if (this.isPartnerAlreadySelected((byte)i)) {
                bf = m_redBitmapFont;
                color = -65536;
            } else {
                bf = m_whiteBitmapFont;
                color = -1;
            }
            Game.drawWrappedString(g, m_painter, m_textBuffer.getText(Constants.PARTNER_NAMES[i]), x + Constants.PARTNER_NAMES_COORDS[i][0], y + Constants.PARTNER_NAMES_COORDS[i][1] + 6 - h / 2, 38, bf, m_mediumFont, true, false, color);
        }
        this.paintNavigationMenu(g, true, (short)6, (short)5);
    }

    private void paintCategorySelectionState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)87, m_whiteBitmapFont, -1, true);
        int w = this.m_icons[0].getWidth();
        int h = this.m_icons[0].getHeight();
        int width = w * 2 + 14;
        int height = h * 2 + 14;
        int x = m_screenWidth / 2 - width / 2;
        g.setColor(-16777216);
        g.fillRect(x - 5 - 3, (y += m_menuBackgroundHeight / 2 - height / 2) - 5 - 3, width + 16, height + 16);
        g.setColor(-1);
        g.fillRect(x - 5, y - 5, width + 10, height + 10);
        int initX = x;
        int selectorX = 0;
        int selectorY = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int iconIndex = i * 2 + j;
                m_painter.drawRegion(g, this.m_icons[iconIndex], 0, 0, x, y, this.m_icons[iconIndex].getWidth(), this.m_icons[iconIndex].getHeight(), 0);
                if (iconIndex == this.m_menuSelectedOption) {
                    selectorX = x;
                    selectorY = y;
                }
                x += w + 14;
            }
            x = initX;
            y += h + 14;
        }
        m_painter.drawRegion(g, this.m_selectionArrowImage, 0, 0, selectorX - this.m_selectionArrowImage.getWidth() + 15, selectorY + h - 15, this.m_selectionArrowImage.getWidth(), this.m_selectionArrowImage.getHeight(), 0);
        this.paintNavigationMenu(g, true, (short)6, (short)5);
    }

    private void paintChoosePeanutState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)89, m_whiteBitmapFont, -1, true);
        int w = this.m_icons[0].getWidth();
        int h = this.m_icons[0].getHeight();
        int width = w * 2 + 30;
        int height = h * 2 + 6;
        int x = m_screenWidth / 2 - width / 2;
        g.setColor(-16777216);
        g.fillRect(x - 20 - 3, (y += m_menuBackgroundHeight / 2 - height / 2) - 5 - 3, width + 46, height + 16);
        g.setColor(-1);
        g.fillRect(x - 20, y - 5, width + 40, height + 10);
        int initX = x;
        int selectorX = 0;
        int selectorY = 0;
        for (int i = 0; i < 2; ++i) {
            int selectionY = y;
            int selectionHeight = h + 3;
            if (i == 0) {
                selectionY -= 5;
                selectionHeight += 5;
            } else {
                selectionY -= 3;
                selectionHeight += 5;
            }
            for (int j = 0; j < 2; ++j) {
                int iconIndex = i * 2 + j;
                m_painter.drawRegion(g, this.m_icons[iconIndex], 0, 0, x, y, this.m_icons[iconIndex].getWidth(), this.m_icons[iconIndex].getHeight(), 0);
                if (this.m_categoryWithoutPeanuts != null && this.m_categoryWithoutPeanuts[iconIndex]) {
                    m_painter.drawRegion(g, this.m_peanutEdgeImage, 0, 0, x, y, this.m_icons[iconIndex].getWidth(), this.m_icons[iconIndex].getHeight(), 0);
                }
                if (iconIndex == this.m_menuSelectedOption) {
                    selectorX = x;
                    selectorY = y;
                }
                x += w + 30;
            }
            x = initX;
            y += h + 6;
        }
        m_painter.drawRegion(g, this.m_selectionArrowImage, 0, 0, selectorX - this.m_selectionArrowImage.getWidth() + 10, selectorY + h - 10, this.m_selectionArrowImage.getWidth(), this.m_selectionArrowImage.getHeight(), 0);
        this.paintNavigationMenu(g, true, (short)6, (short)85);
    }

    private void paintViewProfileState(Graphics g) {
        int y;
        int initY = y = this.paintMenuBackground(g, (short)17, m_whiteBitmapFont, -1, true);
        int x = 0;
        y = initY + m_menuBackgroundHeight / 2 - this.m_viewProfileCharacterImage.getHeight() / 2;
        m_painter.drawRegion(g, this.m_viewProfileCharacterImage, 0, 0, x, y, this.m_viewProfileCharacterImage.getWidth(), this.m_viewProfileCharacterImage.getHeight(), 0);
        y = initY + m_menuBackgroundHeight / 2 - this.m_viewProfilePanelImage.getHeight() / 2;
        x = m_screenWidth - this.m_viewProfilePanelImage.getWidth();
        int w = this.m_viewProfilePanelImage.getWidth();
        int h = this.m_viewProfilePanelImage.getHeight();
        m_painter.drawRegion(g, this.m_viewProfilePanelImage, 0, 0, x, y, w, h, 0);
        this.paintNavigationMenu(g, true, (short)6, (short)22);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(x, y + m_smallFont.getHeight() / 3, w, (int)this.m_scrollingTextClipHeight);
        Game.drawWrappedString(g, m_painter, m_textBuffer.getText(Constants.PARTNER_PROFILES[this.m_partnerIndex[this.m_currentPlayer]]), x + 10, (y += this.m_scrollOffset) + 10, this.m_viewProfilePanelImage.getWidth() - 20, null, m_smallFont, false, true, 0);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    private void paintCoverState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)-1, null, 0, true);
        for (int i = 0; i < this.m_coverImages.length; ++i) {
            int w = this.m_coverImages[i].getWidth();
            int h = this.m_coverImages[i].getHeight();
            m_painter.drawRegion(g, this.m_coverImages[i], 0, 0, Constants.COVER_COORDS[i][0], Constants.COVER_COORDS[i][1], w, h, 0);
        }
    }

    private void paintKitmakerState(Graphics g) {
        m_screenWidth = (short)g.getClipWidth();
        m_screenHeight = (short)g.getClipHeight();
        if (240 < m_screenWidth || m_screenWidth == 0) {
            m_screenWidth = (short)240;
        }
        if (320 < m_screenHeight || m_screenHeight == 0) {
            m_screenHeight = (short)320;
        }
        if (this.m_logo != null) {
            int h = this.m_logo.getHeight();
            m_painter.drawRegion(g, this.m_logo, 0, 0, 0, m_screenHeight / 2 - h / 2, this.m_logo.getWidth(), h, 0);
        }
    }

    private void paintDisetState(Graphics g) {
        if (this.m_logo != null) {
            int h = this.m_logo.getHeight();
            m_painter.drawRegion(g, this.m_logo, 0, 0, 0, m_screenHeight / 2 - h / 2, this.m_logo.getWidth(), h, 0);
        }
    }

    private int paintMenuBackground(Graphics g, short title, BitmapFont bfont, int color, boolean paintImage) {
        int x = 0;
        int y = m_screenHeight / 2 - this.m_menuBackgroundImage.getHeight() / 2 + 0;
        short diff = 0;
        if (y < 36) {
            diff = (short)(36 - y);
            y = 36;
        }
        m_menuBackgroundHeight = (short)(this.m_menuBackgroundImage.getHeight() - 2 * diff);
        if (paintImage) {
            m_painter.drawRegion(g, this.m_menuBackgroundImage, 0, diff, x, y, this.m_menuBackgroundImage.getWidth(), m_menuBackgroundHeight, 0);
        }
        if (title != -1) {
            String str = m_textBuffer.getText(title);
            int h = bfont.getCharHeight();
            int strWidth = bfont.getStringWidth(str);
            x = m_screenWidth / 2 - strWidth / 2;
            if (strWidth > m_screenWidth) {
                if (!this.m_screenTitleAnimationStarted) {
                    this.m_screenTitleAnimationStarted = true;
                    x = 0;
                    this.m_screenTitleOffset = (short)(strWidth / 2);
                }
                if (System.currentTimeMillis() - this.m_screenTitleTimer > 50L) {
                    this.m_screenTitleOffset = this.m_screenTitleDirLeft ? (short)(this.m_screenTitleOffset + 2) : (short)(this.m_screenTitleOffset - 2);
                    this.m_screenTitleTimer = System.currentTimeMillis();
                    if ((x += this.m_screenTitleOffset) > 0) {
                        this.m_screenTitleOffset = (short)(this.m_screenTitleOffset - x);
                        x = 0;
                        this.m_screenTitleDirLeft = false;
                        this.m_screenTitleTimer += 1000L;
                    } else if (x + strWidth < m_screenWidth) {
                        this.m_screenTitleOffset = (short)(this.m_screenTitleOffset + (m_screenWidth - (x + strWidth)));
                        x += m_screenWidth - (x + strWidth);
                        this.m_screenTitleDirLeft = true;
                        this.m_screenTitleTimer += 1000L;
                    }
                } else {
                    x += this.m_screenTitleOffset;
                }
            }
            Game.drawWrappedString(g, m_painter, str, x, y / 2 - h / 2, strWidth * 2, bfont, m_mediumBoldFont, false, false, color);
        }
        return y;
    }

    private void paintNameCreationState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)25, m_whiteBitmapFont, -1, true);
        this.paintNavigationMenu(g, true, (short)6, (short)22);
        int w = this.m_menuButtons[0].getWidth();
        int h = this.m_menuButtons[0].getHeight();
        int x = m_screenWidth / 2 - w / 2;
        m_painter.drawRegion(g, this.m_menuButtons[0], 0, 0, x, y += m_menuBackgroundHeight / 2 - h / 2, w, h, 0);
        int ch = m_bigWhiteBitmapFont.getCharHeight();
        Game.drawWrappedString(g, m_painter, m_textInputStringBuffer.toString(), 0, y + h / 2 - ch / 2, m_screenWidth, m_bigWhiteBitmapFont, m_mediumFont, true, false, -1);
    }

    private void paintRankingState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)8, m_whiteBitmapFont, -1, false);
        this.paintNavigationMenu(g, false, (short)6, (short)-1);
        int ch = m_bigWhiteBitmapFont.getCharHeight();
        int max = this.m_ranking.length;
        if (max > 5) {
            max = 5;
        }
        int quarterWidth = (m_screenWidth - 20) / 4;
        int initX = 10;
        y += m_menuBackgroundHeight / 2 - 5 * ch / 2;
        for (int i = this.m_firstVisiblePositionInRanking; i < this.m_firstVisiblePositionInRanking + max; ++i) {
            int x = initX;
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(i + 1).append('.').append(' ');
            m_auxStringBuffer.append(this.m_ranking[i][1]);
            Game.drawWrappedString(g, m_painter, m_auxStringBuffer.toString(), x, y, quarterWidth * 3, m_bigWhiteBitmapFont, m_mediumFont, false, false, -1);
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(this.m_ranking[i][0]);
            Game.drawWrappedString(g, m_painter, m_auxStringBuffer.toString(), x += quarterWidth * 3, y, quarterWidth, m_bigWhiteBitmapFont, m_mediumFont, true, false, -1);
            y += ch;
        }
    }

    private void paintNameSelectionState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)23, m_whiteBitmapFont, -1, true);
        this.paintNavigationMenu(g, true, (short)6, (short)5);
        int optionCount = this.m_menuButtons.length;
        int width = this.m_menuBackgroundImage.getWidth();
        short height = m_menuBackgroundHeight;
        int w = this.m_menuButtons[0].getWidth();
        int h = this.m_menuButtons[0].getHeight();
        int x = width / 2 - w / 2;
        int gap = (height - h * optionCount) / (optionCount + 1);
        y += gap;
        int ch = m_bigWhiteBitmapFont.getCharHeight();
        int selectorX = 0;
        int selectorY = 0;
        for (int i = 0; i < optionCount; ++i) {
            m_painter.drawRegion(g, this.m_menuButtons[i], 0, 0, x, y, w, h, 0);
            if (this.m_nameSelectionOffset + i < this.m_playerNameList.length) {
                int color;
                BitmapFont bfont;
                if (i == this.m_menuSelectedOption) {
                    bfont = m_bigYellowBitmapFont;
                    color = -256;
                    selectorX = x + w / 2 - this.m_buttonEdge.getWidth() / 2;
                    selectorY = y + h / 2 - this.m_buttonEdge.getHeight() / 2;
                } else {
                    bfont = m_bigWhiteBitmapFont;
                    color = -1;
                }
                String str = this.m_playerNameList[this.m_nameSelectionOffset + i];
                if (this.isNameAlreadySelected(str)) {
                    color = -65536;
                    bfont = m_bigRedBitmapFont;
                }
                Game.drawWrappedString(g, m_painter, str, 0, y + h / 2 - ch / 2, m_screenWidth, bfont, m_mediumFont, true, false, color);
                bfont = null;
            }
            y += h + gap;
        }
        m_painter.drawRegion(g, this.m_buttonEdge, 0, 0, selectorX, selectorY, this.m_buttonEdge.getWidth(), this.m_buttonEdge.getHeight(), 0);
    }

    private void paintMenuState(Graphics g) {
        int y = this.paintMenuBackground(g, (short)-1, m_whiteBitmapFont, -1, true);
        this.paintMenuItems(g, y);
        switch (this.m_gameState) {
            case 2: {
                this.paintNavigationMenu(g, false, (short)6, (short)5);
                break;
            }
            case 15: {
                this.paintNavigationMenu(g, true, (short)6, (short)22);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 20: 
            case 21: {
                this.paintNavigationMenu(g, true, (short)6, (short)5);
            }
        }
    }

    private void paintMenuItems(Graphics g, int y) {
        short[] options = null;
        switch (this.m_gameState) {
            case 2: {
                options = Constants.MAIN_MENU_OPTIONS;
                break;
            }
            case 4: {
                options = Constants.OPTIONS_MENU_OPTIONS;
                break;
            }
            case 3: {
                options = Constants.INFO_MENU_OPTIONS;
                break;
            }
            case 5: {
                options = Constants.NUMBER_OF_PLAYERS_MENU_OPTIONS;
                break;
            }
            case 15: {
                options = Constants.GAME_MENU_OPTIONS;
                break;
            }
            case 21: {
                options = Constants.CONFIRM_MENU_OPTIONS;
                break;
            }
            case 20: {
                options = Constants.CONTINUE_MENU_OPTIONS;
            }
        }
        int optionCount = options.length;
        int width = this.m_menuBackgroundImage.getWidth();
        short height = m_menuBackgroundHeight;
        int w = this.m_menuButtons[0].getWidth();
        int h = this.m_menuButtons[0].getHeight();
        int x = width / 2 - w / 2;
        int gap = (height - h * optionCount) / (optionCount + 1);
        y += gap;
        int ch = m_bigWhiteBitmapFont.getCharHeight();
        int selectorX = 0;
        int selectorY = 0;
        for (int i = 0; i < optionCount; ++i) {
            int color;
            BitmapFont bfont;
            m_painter.drawRegion(g, this.m_menuButtons[i], 0, 0, x, y, w, h, 0);
            if (i == this.m_menuSelectedOption) {
                bfont = m_bigYellowBitmapFont;
                color = -256;
                selectorX = x + w / 2 - this.m_buttonEdge.getWidth() / 2;
                selectorY = y + h / 2 - this.m_buttonEdge.getHeight() / 2;
            } else {
                bfont = m_bigWhiteBitmapFont;
                color = -1;
            }
            Game.drawWrappedString(g, m_painter, m_textBuffer.getText(options[i]), 0, y + h / 2 - ch / 2, m_screenWidth, bfont, m_mediumFont, true, false, color);
            bfont = null;
            y += h + gap;
        }
        m_painter.drawRegion(g, this.m_buttonEdge, 0, 0, selectorX, selectorY, this.m_buttonEdge.getWidth(), this.m_buttonEdge.getHeight(), 0);
        options = null;
    }

    protected void paintNavigationMenu(Graphics g, boolean backEnabled, short b1Str, short b2Str) {
        int h = this.m_navigationButtons[0].getHeight();
        int w = this.m_navigationButtons[0].getWidth();
        int y = this.paintMenuBackground(g, (short)-1, null, 0, false) + m_menuBackgroundHeight;
        int ch = m_whiteBitmapFont.getCharHeight();
        m_painter.drawRegion(g, this.m_navigationButtons[0], 0, 0, 0, y, w, h, 0);
        Game.drawWrappedString(g, m_painter, m_textBuffer.getText(b1Str), 0, y + h / 2 - ch / 2, w, m_whiteBitmapFont, m_mediumFont, true, false, -1);
        if (backEnabled) {
            m_painter.drawRegion(g, this.m_navigationButtons[1], 0, 0, m_screenWidth - w - 0, y, w, h, 0);
            Game.drawWrappedString(g, m_painter, m_textBuffer.getText(b2Str), m_screenWidth - w - 0, y + h / 2 - ch / 2, w, m_whiteBitmapFont, m_mediumFont, true, false, -1);
        }
    }

    private void controlBackActions() {
        switch (this.m_gameState) {
            case 7: {
                this.m_partnerIndex[this.m_currentPlayer] = -1;
                this.m_stateStack.popState();
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 25: {
                this.m_stateStack.pushState((short)2);
                this.m_inPause = true;
                break;
            }
            case 9: {
                this.m_stateStack.popState();
                break;
            }
            case 17: {
                this.m_stateStack.pushState((short)15);
                break;
            }
            case 10: 
            case 11: 
            case 32: {
                this.m_stateStack.returnToState((short)2);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                this.m_stateStack.pushState((short)22);
                break;
            }
            case 14: {
                if (this.m_diceResult == -1) {
                    this.m_stateStack.pushState((short)15);
                    break;
                }
                this.m_stateStack.pushState((short)22);
            }
        }
    }

    private void controlOKActions() {
        switch (this.m_gameState) {
            case 2: {
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        if (!this.m_inPause) {
                            this.m_stateStack.pushState((short)5);
                            break;
                        }
                        this.m_stateStack.pushState((short)20);
                        break;
                    }
                    case 1: {
                        this.m_stateStack.pushState((short)4);
                        break;
                    }
                    case 2: {
                        this.m_stateStack.pushState((short)3);
                        break;
                    }
                    case 3: {
                        this.exitGame();
                    }
                }
                this.m_menuLastSelectedOption = this.m_menuSelectedOption;
                break;
            }
            case 11: {
                this.m_stateStack.popState();
                break;
            }
            case 10: {
                this.m_stateStack.pushState((short)3);
                break;
            }
            case 32: {
                this.m_stateStack.pushState((short)3);
                break;
            }
            case 25: {
                this.m_stateStack.pushState((short)8);
                break;
            }
            case 28: {
                this.m_stateStack.popState();
                boolean hasPeanuts = true;
                if (this.m_losePeanut) {
                    hasPeanuts = false;
                    byte i = 0;
                    while (!hasPeanuts && i < this.m_playerPeanutsNeeded[this.m_currentPlayer].length) {
                        int stock = this.getPeanutCount(this.m_currentPlayer, i) - this.m_playerPeanutsNeeded[this.m_currentPlayer][i];
                        if (stock != 0) {
                            hasPeanuts = true;
                            continue;
                        }
                        i = (byte)(i + 1);
                    }
                }
                if (!hasPeanuts) {
                    this.m_stateStack.pushState((short)29);
                    break;
                }
                this.m_stateStack.pushState((short)26);
                break;
            }
            case 26: {
                this.m_currentCategory = this.m_menuSelectedOption;
                if (this.m_losePeanut) {
                    this.losePeanut(this.m_currentPlayer, this.m_currentCategory);
                } else {
                    this.obtainPeanut(this.m_currentPlayer, this.m_currentCategory);
                }
            }
            case 27: {
                if (this.checkCardCompleted()) break;
                this.m_currentPlayer = (byte)(this.m_currentPlayer + 1);
                if (this.m_currentPlayer == this.m_playerName.length) {
                    this.m_currentPlayer = 0;
                }
                this.m_stateStack.returnToState((short)14);
                break;
            }
            case 29: 
            case 31: {
                this.m_currentPlayer = (byte)(this.m_currentPlayer + 1);
                if (this.m_currentPlayer == this.m_playerName.length) {
                    this.m_currentPlayer = 0;
                }
                this.m_stateStack.returnToState((short)14);
                break;
            }
            case 20: {
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        this.m_stateStack.returnToState((short)2);
                        this.m_stateStack.popState();
                        break;
                    }
                    case 1: {
                        this.m_stateStack.pushState((short)21);
                    }
                }
                this.m_menuLastSelectedOption = this.m_menuSelectedOption;
                break;
            }
            case 21: {
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        this.m_stateStack.returnToState((short)2);
                        break;
                    }
                    case 1: {
                        this.clearLastGame();
                        this.m_stateStack.clearStack();
                        this.m_stateStack.pushState((short)2);
                        this.m_stateStack.pushState((short)5);
                    }
                }
                this.m_menuLastSelectedOption = this.m_menuSelectedOption;
                break;
            }
            case 23: {
                this.m_menuLastSelectedOption = 0;
                this.m_stateStack.popState();
                break;
            }
            case 15: {
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        this.m_stateStack.pushState((short)22);
                        this.m_menuLastSelectedOption = 0;
                        break;
                    }
                    case 1: {
                        this.m_stateStack.pushState((short)30);
                        this.m_menuLastSelectedOption = 1;
                        break;
                    }
                    case 2: {
                        this.m_stateStack.popState();
                        this.m_stateStack.pushState((short)2);
                        this.m_menuLastSelectedOption = 0;
                    }
                }
                break;
            }
            case 4: {
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        this.m_soundEnabled = true;
                        this.m_menuLastSelectedOption = 1;
                        this.m_stateStack.popState();
                        break;
                    }
                    case 1: {
                        this.m_soundEnabled = false;
                        this.m_menuLastSelectedOption = 1;
                        this.m_stateStack.popState();
                    }
                }
                break;
            }
            case 5: {
                int count = 0;
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        count = 1;
                        break;
                    }
                    case 1: {
                        count = 2;
                        break;
                    }
                    case 2: {
                        count = 3;
                        break;
                    }
                    case 3: {
                        count = 4;
                    }
                }
                this.m_currentPlayer = 0;
                this.m_partnerIndex = new byte[count];
                this.m_currentTestNumber = new byte[count];
                for (int i = 0; i < count; ++i) {
                    this.m_partnerIndex[i] = -1;
                    this.m_currentTestNumber[i] = 1;
                }
                this.m_playerName = new String[count];
                this.m_playerScore = new int[this.m_playerName.length][2];
                if (count > 1) {
                    this.m_stateStack.pushState((short)25);
                } else {
                    this.m_stateStack.pushState((short)8);
                }
                this.initializeRandomControl();
                this.initializeQuestionTracking();
                this.m_menuLastSelectedOption = 0;
                this.m_menuSelectedOption = 0;
                break;
            }
            case 8: {
                if (this.m_nameSelectionOffset + this.m_menuSelectedOption == 0) {
                    this.m_stateStack.pushState((short)9);
                    break;
                }
                String name = this.m_playerNameList[this.m_nameSelectionOffset + this.m_menuSelectedOption];
                if (this.isNameAlreadySelected(name)) break;
                this.m_playerName[this.m_currentPlayer] = name;
                this.m_stateStack.pushState((short)6);
                break;
            }
            case 9: {
                if (this.m_persister.createProfile(m_textInputStringBuffer.toString(), this.m_playerName) == 1) {
                    this.m_menuLastSelectedOption = 1;
                    this.m_stateStack.popState();
                    break;
                }
                Game.initializeTextInput();
                break;
            }
            case 7: {
                this.m_stateStack.pushState((short)12);
                break;
            }
            case 3: {
                switch (this.m_menuSelectedOption) {
                    case 0: {
                        this.m_ranking = this.m_persister.getRanking();
                        if (this.m_ranking == null) break;
                        this.m_stateStack.pushState((short)23);
                        break;
                    }
                    case 2: {
                        this.m_stateStack.pushState((short)10);
                        break;
                    }
                    case 1: {
                        this.m_stateStack.pushState((short)11);
                        break;
                    }
                    case 3: {
                        this.m_stateStack.pushState((short)32);
                    }
                }
                break;
            }
            case 12: {
                this.m_selectedObjectiveCards[this.m_menuSelectedOption] = true;
                this.m_stateStack.pushState((short)13);
                break;
            }
            case 13: {
                if (this.m_currentPlayer == this.m_playerName.length - 1) {
                    this.m_stateStack.pushState((short)14);
                    this.m_currentPlayer = 0;
                    break;
                }
                this.m_currentPlayer = (byte)(this.m_currentPlayer + 1);
                this.m_stateStack.returnToState((short)25);
                break;
            }
            case 30: {
                this.m_stateStack.popState();
                this.m_menuLastSelectedOption = 1;
                break;
            }
            case 22: {
                if (this.m_stateStack.getPreviousState() == 14 && !this.m_inPause) {
                    this.goToTest();
                    break;
                }
                if (this.m_inPause || this.m_stateStack.getPreviousState() == 27 || this.m_stateStack.getPreviousState() == 29 || this.m_stateStack.getPreviousState() == 31 || this.m_stateStack.getPreviousState() == 28 || this.m_stateStack.getPreviousState() == 26) {
                    this.m_stateStack.popState();
                } else {
                    this.m_stateStack.popState();
                    if (this.m_partyGame != null && this.m_partyGame.m_gameState != 3) {
                        this.m_stateStack.pushState((short)16);
                    }
                }
                if (this.m_partyGame == null) break;
                this.m_partyGame.setViewingCard(false);
                break;
            }
            case 17: {
                this.m_currentCategory = this.m_menuSelectedOption;
                this.m_partyGameToCreate = this.m_menuSelectedOption;
                if (Auxiliary.getRandomNumber(0, 99) < 25) {
                    this.goToSurprise();
                    break;
                }
                this.m_stateStack.pushState((short)16);
                break;
            }
            case 14: {
                if (this.m_diceResult == -1) {
                    if (this.m_diceThrown) break;
                    this.m_diceThrown = true;
                    this.playSound("/dado.mid");
                    this.m_diceTimer = System.currentTimeMillis();
                    break;
                }
                this.freeUnusedDiceImages();
                this.goToTest();
                break;
            }
            case 6: {
                if (this.isPartnerAlreadySelected(this.m_menuSelectedOption)) break;
                this.m_partnerIndex[this.m_currentPlayer] = this.m_menuSelectedOption;
                this.m_stateStack.pushState((short)7);
                break;
            }
            case 18: {
                this.m_stateStack.returnToState((short)2);
                this.m_menuSelectedOption = 0;
                this.clearLastGame();
            }
        }
    }

    private void controlMenuStateInput(int keyCode, int gameAction, byte optionCount) {
        if (this.m_gameState != 2 && Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            if (this.m_gameState != 15) {
                if (this.m_gameState == 5) {
                    this.m_menuLastSelectedOption = 0;
                }
                this.m_stateStack.returnToState((short)2);
            } else {
                this.m_stateStack.popState();
            }
        } else {
            boolean fire;
            boolean movingUp = keyCode == 50 || gameAction == 1;
            boolean movingDown = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (movingUp) {
                this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption - 1);
                if (this.m_menuSelectedOption < 0) {
                    this.m_menuSelectedOption = (byte)(optionCount - 1);
                }
            } else if (movingDown) {
                this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption + 1);
                if (this.m_menuSelectedOption == optionCount) {
                    this.m_menuSelectedOption = 0;
                }
            } else if (fire) {
                this.controlOKActions();
            }
        }
    }

    private void controlInput() {
        int[] event = this.m_eventQueue.popEvent();
        if (event == null) {
            return;
        }
        int keyCode = Integer.MIN_VALUE;
        int eventType = -1;
        eventType = event[1];
        keyCode = event[0];
        int gameAction = this.getGameAction(keyCode);
        if (eventType == 1) {
            switch (this.m_gameState) {
                case 2: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)4);
                    break;
                }
                case 21: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)2);
                    break;
                }
                case 20: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)2);
                    break;
                }
                case 4: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)2);
                    break;
                }
                case 3: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)4);
                    break;
                }
                case 23: {
                    this.controlRankingStateInput(keyCode, gameAction);
                    break;
                }
                case 5: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)4);
                    break;
                }
                case 15: {
                    this.controlMenuStateInput(keyCode, gameAction, (byte)3);
                    break;
                }
                case 6: {
                    this.controlPartnerSelectionStateInput(keyCode, gameAction);
                    break;
                }
                case 17: 
                case 26: {
                    this.controlCategoryAndPeanutSelectionStateInput(keyCode, gameAction);
                    break;
                }
                case 7: 
                case 11: 
                case 18: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.controlManualScrollingStatesInput(eventType, keyCode, gameAction);
                    break;
                }
                case 8: {
                    this.controlNameSelectionStateInput(keyCode, gameAction);
                    break;
                }
                case 9: {
                    this.controlNameCreationStateInput(keyCode, gameAction);
                    break;
                }
                case 13: 
                case 14: 
                case 22: 
                case 25: {
                    this.controlStandardStatesInput(keyCode, gameAction);
                    break;
                }
                case 10: {
                    this.controlStandardStatesInput(keyCode, gameAction);
                    break;
                }
                case 32: {
                    this.controlStandardStatesInput(keyCode, gameAction);
                    break;
                }
                case 12: {
                    this.controlObjectiveCardSelectionStateInput(keyCode, gameAction);
                    break;
                }
                case 16: {
                    this.m_partyGame.controlInput(keyCode, gameAction, eventType);
                }
            }
        } else {
            switch (this.m_gameState) {
                case 16: {
                    this.m_partyGame.controlInput(keyCode, gameAction, eventType);
                    break;
                }
                case 7: 
                case 11: 
                case 18: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.controlManualScrollingStatesInput(eventType, keyCode, gameAction);
                }
            }
        }
    }

    private void controlRankingStateInput(int keyCode, int gameAction) {
        if (gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction)) {
            this.controlOKActions();
        } else {
            boolean down;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean bl = down = keyCode == 56 || gameAction == 6;
            if (up) {
                this.m_firstVisiblePositionInRanking = (byte)(this.m_firstVisiblePositionInRanking - 1);
                if (this.m_firstVisiblePositionInRanking < 0) {
                    this.m_firstVisiblePositionInRanking = 0;
                }
            } else if (down) {
                this.m_firstVisiblePositionInRanking = (byte)(this.m_firstVisiblePositionInRanking + 1);
                int last = this.m_firstVisiblePositionInRanking + 5;
                if (last > this.m_ranking.length) {
                    this.m_firstVisiblePositionInRanking = (byte)(this.m_firstVisiblePositionInRanking - 1);
                }
            }
        }
    }

    private void controlManualScrollingStatesInput(int eventType, int keyCode, int gameAction) {
        boolean fire;
        boolean up = keyCode == 50 || gameAction == 1;
        boolean down = keyCode == 56 || gameAction == 6;
        boolean bl = fire = eventType == 1 && (keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction));
        if (fire) {
            this.controlOKActions();
        } else if (eventType == 1 && Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        } else if (up) {
            this.m_scrollUp = eventType == 1;
        } else if (down) {
            this.m_scrollDown = eventType == 1;
        }
    }

    private void controlStandardStatesInput(int keyCode, int gameAction) {
        if (gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction)) {
            this.controlOKActions();
        } else if (Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        }
    }

    private void controlPartnerSelectionStateInput(int keyCode, int gameAction) {
        if (keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction)) {
            this.controlOKActions();
        } else if (Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        } else {
            byte previousMenuSelectedOption = this.m_menuSelectedOption;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean left = keyCode == 52 || gameAction == 2;
            boolean right = keyCode == 54 || gameAction == 5;
            switch (this.m_menuSelectedOption) {
                case 0: {
                    if (up || down) {
                        this.m_menuSelectedOption = (byte)2;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = 1;
                    break;
                }
                case 1: {
                    if (up || down) {
                        this.m_menuSelectedOption = (byte)3;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = 0;
                    break;
                }
                case 2: {
                    if (up || down) {
                        this.m_menuSelectedOption = 0;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = (byte)3;
                    break;
                }
                case 3: {
                    if (up || down) {
                        this.m_menuSelectedOption = 1;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = (byte)2;
                }
            }
            if (this.isPartnerAlreadySelected(this.m_menuSelectedOption)) {
                this.m_menuSelectedOption = this.getClosestUnselectedPartner(previousMenuSelectedOption);
            }
        }
    }

    private void controlCategoryAndPeanutSelectionStateInput(int keyCode, int gameAction) {
        if (keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction)) {
            this.controlOKActions();
        } else if (Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        } else {
            byte lastPos = this.m_menuSelectedOption;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean left = keyCode == 52 || gameAction == 2;
            boolean right = keyCode == 54 || gameAction == 5;
            switch (this.m_menuSelectedOption) {
                case 0: {
                    if (up || down) {
                        this.m_menuSelectedOption = (byte)2;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = 1;
                    break;
                }
                case 1: {
                    if (up || down) {
                        this.m_menuSelectedOption = (byte)3;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = 0;
                    break;
                }
                case 2: {
                    if (up || down) {
                        this.m_menuSelectedOption = 0;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = (byte)3;
                    break;
                }
                case 3: {
                    if (up || down) {
                        this.m_menuSelectedOption = 1;
                        break;
                    }
                    if (!left && !right) break;
                    this.m_menuSelectedOption = (byte)2;
                }
            }
            if (this.m_categoryWithoutPeanuts != null && this.m_categoryWithoutPeanuts[this.m_menuSelectedOption]) {
                this.m_menuSelectedOption = this.getClosestCategory(lastPos);
            }
        }
    }

    private void controlNameCreationStateInput(int keyCode, int gameAction) {
        if (gameAction == 8 && keyCode != 53 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction)) {
            this.controlOKActions();
        } else if (Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        } else {
            Game.controlTextInput(keyCode, gameAction, false);
        }
    }

    protected static void controlTextInput(int keyCode, int gameAction, boolean allowDigits) {
        byte newTableIndex = -1;
        switch (keyCode) {
            case 48: {
                if (allowDigits) {
                    newTableIndex = 0;
                    break;
                }
                if (m_caretPosition == -1) break;
                m_caretPosition = (byte)(m_caretPosition - 1);
                m_textInputStringBuffer.setLength(m_caretPosition + 1);
                m_caretCharIndex = 0;
                m_caretTableIndex = 0;
                break;
            }
            case 49: {
                if (!allowDigits) break;
                newTableIndex = 1;
                break;
            }
            case 50: {
                newTableIndex = 2;
                break;
            }
            case 51: {
                newTableIndex = 3;
                break;
            }
            case 52: {
                newTableIndex = 4;
                break;
            }
            case 53: {
                newTableIndex = 5;
                break;
            }
            case 54: {
                newTableIndex = 6;
                break;
            }
            case 55: {
                newTableIndex = 7;
                break;
            }
            case 56: {
                newTableIndex = 8;
                break;
            }
            case 57: {
                newTableIndex = 9;
                break;
            }
            default: {
                switch (gameAction) {
                    case 2: {
                        if (m_caretPosition == -1) break;
                        m_caretPosition = (byte)(m_caretPosition - 1);
                        m_textInputStringBuffer.setLength(m_caretPosition + 1);
                        m_caretCharIndex = 0;
                        m_caretTableIndex = 0;
                    }
                }
                return;
            }
        }
        if (newTableIndex != -1) {
            if (newTableIndex != m_caretTableIndex || System.currentTimeMillis() - m_caretTimer > 800L) {
                if ((m_caretPosition = (byte)(m_caretPosition + 1)) == m_textInputMaxLength) {
                    m_caretPosition = (byte)(m_caretPosition - 1);
                } else if (m_textInputStringBuffer.length() < m_caretPosition + 1) {
                    m_textInputStringBuffer.setLength(m_caretPosition + 1);
                }
                m_caretTableIndex = newTableIndex;
                m_caretCharIndex = 0;
            } else {
                m_caretCharIndex = (byte)(m_caretCharIndex + 1);
                int length = Constants.KEY_MAPPING[m_caretTableIndex].length;
                if (!allowDigits) {
                    --length;
                }
                if (m_caretCharIndex == length) {
                    m_caretCharIndex = 0;
                }
            }
            m_textInputStringBuffer.setCharAt(m_caretPosition, Constants.KEY_MAPPING[m_caretTableIndex][m_caretCharIndex]);
            m_caretTimer = System.currentTimeMillis();
        }
    }

    private void controlObjectiveCardSelectionStateInput(int keyCode, int gameAction) {
        if (this.m_gameState != 2 && Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        } else {
            boolean fire;
            boolean movingLeft = keyCode == 52 || gameAction == 2;
            boolean movingRight = keyCode == 54 || gameAction == 5;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (movingLeft) {
                boolean found = false;
                while (!found) {
                    this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption - 1);
                    if (this.m_menuSelectedOption < 0) {
                        this.m_menuSelectedOption = (byte)4;
                    }
                    found = !this.m_selectedObjectiveCards[this.m_menuSelectedOption];
                }
            } else if (movingRight) {
                boolean found = false;
                while (!found) {
                    this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption + 1);
                    if (this.m_menuSelectedOption == 5) {
                        this.m_menuSelectedOption = 0;
                    }
                    found = !this.m_selectedObjectiveCards[this.m_menuSelectedOption];
                }
            } else if (fire) {
                this.controlOKActions();
            }
        }
    }

    private void controlNameSelectionStateInput(int keyCode, int gameAction) {
        if (this.m_gameState != 2 && Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.controlBackActions();
        } else {
            boolean fire;
            boolean movingUp = keyCode == 50 || gameAction == 1;
            boolean movingDown = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (movingUp) {
                boolean found = false;
                while (!found) {
                    this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption - 1);
                    if (this.m_menuSelectedOption < 0) {
                        this.m_menuSelectedOption = 0;
                        this.m_nameSelectionOffset = (byte)(this.m_nameSelectionOffset - 1);
                        if (this.m_nameSelectionOffset < 0) {
                            this.m_nameSelectionOffset = (byte)(this.m_playerNameList.length - this.m_menuButtons.length);
                            if (this.m_nameSelectionOffset < 0) {
                                this.m_nameSelectionOffset = 0;
                                this.m_menuSelectedOption = (byte)(this.m_playerNameList.length - 1);
                            } else {
                                this.m_menuSelectedOption = (byte)(this.m_menuButtons.length - 1);
                            }
                        }
                    }
                    found = !this.isNameAlreadySelected(this.m_playerNameList[this.m_nameSelectionOffset + this.m_menuSelectedOption]);
                }
            } else if (movingDown) {
                boolean found = false;
                while (!found) {
                    this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption + 1);
                    if (this.m_menuSelectedOption == this.m_playerNameList.length) {
                        this.m_menuSelectedOption = 0;
                        this.m_nameSelectionOffset = 0;
                    } else if (this.m_menuSelectedOption == this.m_menuButtons.length) {
                        this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption - 1);
                        this.m_nameSelectionOffset = (byte)(this.m_nameSelectionOffset + 1);
                        if (this.m_nameSelectionOffset > this.m_playerNameList.length - this.m_menuButtons.length) {
                            this.m_menuSelectedOption = 0;
                            this.m_nameSelectionOffset = 0;
                        }
                    }
                    found = !this.isNameAlreadySelected(this.m_playerNameList[this.m_menuSelectedOption + this.m_nameSelectionOffset]);
                }
            } else if (fire) {
                this.controlOKActions();
            }
        }
    }

    protected void keyPressed(int key) {
        if (this.m_gameState != 0 && this.m_gameState != 1 && this.m_eventQueue != null && this.m_stateStack != null) {
            if (this.m_stateStack.getTop() == this.m_gameState) {
                this.m_eventQueue.pushEvent(key, 1);
            } else {
                this.m_eventQueue.clearEvents();
            }
        }
    }

    protected void keyReleased(int key) {
        if (this.m_gameState != 0 && this.m_gameState != 1 && this.m_eventQueue != null && this.m_stateStack != null && this.m_stateStack.getTop() == this.m_gameState) {
            this.m_eventQueue.pushEvent(key, 2);
        }
    }

    public int getGameAction(int keyCode) {
        int res = Integer.MIN_VALUE;
        try {
            res = super.getGameAction(keyCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((Auxiliary.isRightSoftkeyPressed(keyCode, res) || Auxiliary.isRightSoftkeyPressed(keyCode, res)) && res == 8) {
            res = 0;
        }
        return res;
    }

    public void run() {
        this.m_stateStack.pushState((short)1);
        while (!this.m_mustExit) {
            short state;
            long aux = System.currentTimeMillis() - this.m_paintTimer;
            if (aux > 66L) {
                this.m_paintTimer = System.currentTimeMillis();
                this.repaint();
                this.serviceRepaints();
            }
            this.controlInput();
            switch (this.m_gameState) {
                case 1: {
                    this.runKitmakerState();
                    break;
                }
                case 24: {
                    this.runDisetState();
                    break;
                }
                case 19: {
                    this.runCoverState();
                    break;
                }
                case 10: {
                    this.runAboutState();
                    break;
                }
                case 32: {
                    try {
                        this.m_MIDlet.platformRequest("http://wap.x-piggy.com/");
                    }
                    catch (ConnectionNotFoundException e) {
                        this.m_MIDlet.exit();
                    }
                    this.m_MIDlet.exit();
                    break;
                }
                case 7: 
                case 18: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.runViewProfileState();
                    break;
                }
                case 11: {
                    this.runHelpState();
                    break;
                }
                case 14: {
                    this.runDiceState();
                }
            }
            if (this.m_partyGame != null) {
                if (!this.m_inPause) {
                    if (this.m_partyGame.isFinished()) {
                        this.m_playerScore[this.m_currentPlayer][0] = this.m_partyGame.getScore();
                        if (this.m_partyGame.isWon()) {
                            int[] nArray = this.m_playerScore[this.m_currentPlayer];
                            nArray[1] = nArray[1] + 1;
                            this.checkCardCompleted();
                        }
                        if (this.m_gameState == this.m_stateStack.getTop()) {
                            byte by = this.m_currentPlayer;
                            this.m_currentTestNumber[by] = (byte)(this.m_currentTestNumber[by] + 1);
                            this.m_currentPlayer = (byte)(this.m_currentPlayer + 1);
                            if (this.m_currentPlayer == this.m_playerName.length) {
                                this.m_currentPlayer = 0;
                            }
                            this.m_stateStack.returnToState((short)14);
                        }
                        this.m_partyGame.destroy();
                        this.m_partyGame = null;
                    } else if (this.m_partyGame.m_gameState == 3 && !this.m_partyGameCounted) {
                        this.m_partyGameCounted = true;
                        if (this.m_partyGame.isWon()) {
                            this.obtainPeanut(this.m_currentPlayer, this.m_partyGame.getPeanutColor());
                        }
                    } else if (this.m_gameState == 16 && this.m_partyGame.isViewingCard()) {
                        this.m_stateStack.pushState((short)22);
                    } else if (this.m_partyGame.isPaused() && this.m_gameState == 16) {
                        this.m_stateStack.pushState((short)15);
                        this.m_inPause = true;
                    } else {
                        this.m_partyGame.run();
                    }
                } else {
                    this.m_partyGame.run();
                }
            }
            if (this.m_gameState == (state = this.m_stateStack.getTop())) continue;
            this.setGameState((byte)state);
        }
        this.destroy();
        this.m_MIDlet.exit();
        this.m_thread = null;
    }

    private void runDiceState() {
        if (this.m_diceThrown) {
            if (System.currentTimeMillis() - this.m_diceTimer > 100L) {
                this.m_currentDiceFrame = (byte)(this.m_currentDiceFrame + 1);
                if (this.m_currentDiceFrame == Constants.DICE_ANIMATION_FRAMES.length) {
                    this.m_diceResult = this.getNextDiceResult();
                    this.addToDiceBuffer(this.m_diceResult);
                    this.m_diceThrown = false;
                }
                this.m_diceTimer = System.currentTimeMillis();
            }
        } else if (this.m_diceResult != -1 && System.currentTimeMillis() - this.m_diceTimer > 2000L) {
            this.goToTest();
            this.m_diceTimer = System.currentTimeMillis();
        }
    }

    private void runHelpState() {
        if (System.currentTimeMillis() - this.m_scrollTimer > this.m_scrollDelay) {
            this.m_scrollTimer = System.currentTimeMillis();
            if (this.m_scrollDown) {
                this.m_scrollOffset = (short)(this.m_scrollOffset - this.m_scrollValue);
                int limit = -this.m_offsets[this.m_offsets.length - 1];
                if (this.m_scrollOffset < (limit += 10 + this.m_scrollingClipHeight)) {
                    this.m_scrollOffset = (short)limit;
                }
            } else if (this.m_scrollUp) {
                this.m_scrollOffset = (short)(this.m_scrollOffset + this.m_scrollValue);
                if (this.m_scrollOffset > 0) {
                    this.m_scrollOffset = 0;
                }
            }
        }
    }

    private void runViewProfileState() {
        if (System.currentTimeMillis() - this.m_scrollTimer > this.m_scrollDelay) {
            this.m_scrollTimer = System.currentTimeMillis();
            if (this.m_scrollDown) {
                this.m_scrollOffset = (short)(this.m_scrollOffset - this.m_scrollValue);
                if (this.m_scrollOffset < this.m_offsetLimit) {
                    this.m_scrollOffset = this.m_offsetLimit;
                }
            } else if (this.m_scrollUp) {
                this.m_scrollOffset = (short)(this.m_scrollOffset + this.m_scrollValue);
                if (this.m_scrollOffset > 0) {
                    this.m_scrollOffset = 0;
                }
            }
        }
    }

    private void runAboutState() {
        if (this.m_currentSection == -1) {
            if (this.m_aboutVisible) {
                if (System.currentTimeMillis() - this.m_scrollTimer > 0L) {
                    this.m_aboutVisible = false;
                    this.m_scrollTimer = System.currentTimeMillis();
                }
            } else if (System.currentTimeMillis() - this.m_scrollTimer > 500L) {
                this.m_aboutVisible = true;
                this.m_currentSection = 0;
                this.m_scrollTimer = System.currentTimeMillis();
                this.m_currentAboutSentenceLength = 0;
                this.m_currentAboutIndexOffset = 0;
                this.m_aboutSectionCompleted = false;
            }
        } else if (this.m_aboutVisible) {
            if (this.m_currentAboutSentenceLength == 0 && this.m_currentAboutIndexOffset == 0) {
                if (System.currentTimeMillis() - this.m_scrollTimer > 1500L) {
                    this.m_scrollTimer = System.currentTimeMillis();
                    this.m_currentAboutSentenceLength = 1;
                }
            } else if (!this.m_aboutSectionCompleted) {
                if (System.currentTimeMillis() - this.m_scrollTimer > 100L) {
                    this.m_currentAboutSentenceLength = (short)(this.m_currentAboutSentenceLength + 1);
                    short start = Constants.TEXT_ABOUT_SECTIONS[this.m_currentSection][1];
                    int sentenceLength = m_textBuffer.getText(start + this.m_currentAboutIndexOffset).length();
                    if (this.m_currentAboutSentenceLength == sentenceLength) {
                        this.m_aboutSectionCompleted = true;
                    }
                    this.m_scrollTimer = System.currentTimeMillis();
                }
            } else if (System.currentTimeMillis() - this.m_scrollTimer > 2500L) {
                this.m_scrollTimer = System.currentTimeMillis();
                short start = Constants.TEXT_ABOUT_SECTIONS[this.m_currentSection][1];
                short end = Constants.TEXT_ABOUT_SECTIONS[this.m_currentSection][2];
                this.m_currentAboutIndexOffset = (short)(this.m_currentAboutIndexOffset + 1);
                if (this.m_currentAboutIndexOffset > end - start) {
                    this.m_aboutVisible = false;
                } else {
                    this.m_currentAboutSentenceLength = 0;
                    this.m_aboutSectionCompleted = false;
                }
            }
        } else if (System.currentTimeMillis() - this.m_scrollTimer > 500L) {
            this.m_aboutVisible = true;
            this.m_currentSection = (byte)(this.m_currentSection + 1);
            if (this.m_currentSection == Constants.TEXT_ABOUT_SECTIONS.length) {
                this.m_currentSection = (byte)(this.m_currentSection - 1);
                this.m_stateStack.pushState((short)2);
            } else {
                this.m_currentAboutSentenceLength = 0;
                this.m_currentAboutIndexOffset = 0;
                this.m_aboutSectionCompleted = false;
            }
            this.m_scrollTimer = System.currentTimeMillis();
        }
    }

    protected void runKitmakerState() {
        if (System.currentTimeMillis() - this.m_splashTimer > 1500L) {
            this.m_stateStack.pushState((short)24);
        }
    }

    protected void runCoverState() {
        if (System.currentTimeMillis() - this.m_splashTimer > 1500L) {
            this.m_stateStack.clearStack();
            this.m_stateStack.pushState((short)2);
        }
    }

    protected void runDisetState() {
        if (System.currentTimeMillis() - this.m_splashTimer > 1500L) {
            this.m_stateStack.pushState((short)19);
        }
    }

    public void setGameState(byte newState) {
        this.stopSound();
        this.m_eventQueue.clearEvents();
        switch (this.m_gameState) {
            case 1: {
                this.m_logo = null;
                break;
            }
            case 24: {
                this.m_logo = null;
                break;
            }
            case 19: {
                this.m_coverImages = null;
                break;
            }
            case 18: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.m_partnerImage = null;
                this.m_speechBubbleImage = null;
                this.m_scrollDown = false;
                this.m_scrollUp = false;
                break;
            }
            case 6: {
                this.m_partnerSelectionImage = null;
                this.m_partnerSelectorImages = null;
                if (m_redBitmapFont == null) break;
                m_redBitmapFont.destroy();
                m_redBitmapFont = null;
                break;
            }
            case 7: {
                this.m_viewProfilePanelImage = null;
                this.m_viewProfileCharacterImage = null;
                break;
            }
            case 8: {
                this.m_playerNameList = null;
                if (m_bigRedBitmapFont != null) {
                    m_bigRedBitmapFont.destroy();
                    m_bigRedBitmapFont = null;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 20: 
            case 21: {
                this.m_menuButtons = null;
                this.m_buttonEdge = null;
                break;
            }
            case 15: {
                this.m_menuButtons = null;
                this.m_buttonEdge = null;
                if (newState == 2 || newState == 22) break;
                this.m_inPause = false;
                break;
            }
            case 11: {
                this.m_offsets = null;
                this.m_scrollDown = false;
                this.m_scrollUp = false;
                break;
            }
            case 12: {
                this.m_objectiveCardHandImage = null;
                this.m_selectionArrowImage = null;
                break;
            }
            case 13: 
            case 22: {
                this.m_peanutImages = null;
                this.m_objectiveCardImage = null;
                this.m_checkImage = null;
                break;
            }
            case 14: {
                this.m_diceImages = null;
                break;
            }
            case 26: {
                this.m_categoryWithoutPeanuts = null;
                this.m_peanutEdgeImage = null;
            }
            case 17: {
                this.m_icons = null;
                this.m_selectionArrowImage = null;
                break;
            }
            case 23: {
                this.m_ranking = null;
            }
        }
        Auxiliary.callGC();
        this.m_gameState = newState;
        switch (newState) {
            case 19: {
                this.m_coverImages = new Image[Constants.COVER_IMAGES.length];
                for (int i = 0; i < Constants.COVER_IMAGES.length; ++i) {
                    this.m_coverImages[i] = Auxiliary.initializeImage(Constants.COVER_IMAGES[i]);
                }
                this.m_menuBackgroundImage = Auxiliary.initializeImage("/fondogeneral.png");
                this.m_splashTimer = System.currentTimeMillis();
                break;
            }
            case 18: {
                this.playSound("/over.mid");
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                if (this.m_gameState == 27 && !this.m_surpriseResultCalculated) {
                    this.m_surpriseResultCalculated = true;
                    if (this.m_losePeanut) {
                        this.losePeanut(this.m_currentPlayer, this.m_currentCategory);
                    } else {
                        this.obtainPeanut(this.m_currentPlayer, this.m_currentCategory);
                    }
                }
                String img = null;
                img = this.m_gameState == 18 ? Constants.PARTNER_HAPPY_IMAGES[this.m_partnerIndex[this.m_currentPlayer]] : (this.m_gameState == 27 || this.m_gameState == 28 ? (this.m_losePeanut ? Constants.PARTNER_SAD_IMAGES[this.m_partnerIndex[this.m_currentPlayer]] : Constants.PARTNER_HAPPY_IMAGES[this.m_partnerIndex[this.m_currentPlayer]]) : Constants.PROFILE_IMAGES[this.m_partnerIndex[this.m_currentPlayer]]);
                this.m_scrollOffset = 0;
                this.m_scrollValue = (byte)10;
                this.m_scrollDelay = 50L;
                this.m_partnerImage = Auxiliary.initializeImage(img);
                this.m_speechBubbleImage = Auxiliary.initializeImage("/bocadillo.png");
                break;
            }
            case 1: {
                this.m_logo = Auxiliary.initializeImage("/kitmaker.png");
                this.m_splashTimer = System.currentTimeMillis();
                break;
            }
            case 24: {
                this.m_logo = Auxiliary.initializeImage("/kitmaker.png");
                this.m_splashTimer = System.currentTimeMillis();
                break;
            }
            case 4: 
            case 15: {
                if (this.m_gameState == 15) {
                    this.m_inPause = true;
                }
            }
            case 2: {
                if (this.m_gameState == 2) {
                    this.playSound("/menu.mid");
                }
            }
            case 3: 
            case 5: 
            case 20: 
            case 21: {
                int count;
                if (this.m_menuBackgroundImage == null) {
                    this.m_menuBackgroundImage = Auxiliary.initializeImage("/fondogeneral.png");
                }
                if (m_bigYellowBitmapFont == null) {
                    m_bigYellowBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_yellow.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                }
                if (m_bigWhiteBitmapFont == null) {
                    m_bigWhiteBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_white.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                }
                if (m_whiteBitmapFont == null) {
                    m_whiteBitmapFont = Auxiliary.initializeBitmapFont("/font_white.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                }
                switch (this.m_gameState) {
                    case 15: {
                        count = 3;
                        break;
                    }
                    case 3: {
                        count = 4;
                        break;
                    }
                    default: {
                        count = 4;
                    }
                }
                this.initializeMenuButtons(count);
                this.m_menuSelectedOption = 0;
                if (this.m_gameState == 2 || this.m_gameState == 15) {
                    this.m_menuSelectedOption = this.m_menuLastSelectedOption;
                    break;
                }
                if (this.m_gameState != 4) break;
                if (this.m_soundEnabled) {
                    this.m_menuSelectedOption = 0;
                    break;
                }
                this.m_menuSelectedOption = 1;
                break;
            }
            case 6: {
                this.m_menuSelectedOption = this.isPartnerAlreadySelected((byte)0) ? this.getClosestUnselectedPartner((byte)-1) : (byte)0;
                this.m_partnerSelectionImage = Auxiliary.initializeImage("/selectcompi.png");
                if (m_redBitmapFont == null) {
                    m_redBitmapFont = Auxiliary.initializeBitmapFont("/font_red.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                }
                this.initializePartnerSelectorImages();
                break;
            }
            case 23: {
                this.m_firstVisiblePositionInRanking = 0;
                break;
            }
            case 7: {
                this.m_viewProfilePanelImage = Auxiliary.initializeImage("/panel_perfil.png");
                String path = Constants.PROFILE_IMAGES[this.m_partnerIndex[this.m_currentPlayer]];
                this.m_viewProfileCharacterImage = Auxiliary.initializeImage(path);
                this.m_scrollingTextClipHeight = (short)(this.m_viewProfilePanelImage.getHeight() - m_smallFont.getHeight() * 2 / 3);
                this.m_scrollOffset = 0;
                this.m_offsetLimit = (short)(this.m_scrollingTextClipHeight - Game.drawWrappedString(null, m_painter, m_textBuffer.getText(Constants.PARTNER_PROFILES[this.m_partnerIndex[this.m_currentPlayer]]), 0, 0, this.m_viewProfilePanelImage.getWidth() - 20, null, m_smallFont, false, true, 0) - m_smallFont.getHeight() / 3);
                if (this.m_offsetLimit > 0) {
                    this.m_offsetLimit = 0;
                }
                this.m_scrollValue = (byte)10;
                this.m_scrollDelay = 50L;
                break;
            }
            case 8: {
                this.initializeMenuButtons(4);
                this.m_nameSelectionOffset = 0;
                this.m_menuSelectedOption = this.m_menuLastSelectedOption;
                this.m_menuLastSelectedOption = 0;
                if (m_bigRedBitmapFont == null) {
                    m_bigRedBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_red.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                }
                this.m_playerNameList = this.m_persister.getSavedNames();
                break;
            }
            case 9: {
                this.initializeMenuButtons(1);
                Game.initializeTextInput();
                break;
            }
            case 10: {
                this.m_currentSection = 0;
                this.m_scrollTimer = System.currentTimeMillis();
                this.m_aboutVisible = true;
                this.m_currentAboutSentenceLength = 0;
                this.m_currentAboutIndexOffset = 0;
                this.m_aboutSectionCompleted = false;
                break;
            }
            case 11: {
                this.initializeScrollingState(100, 129);
                this.m_scrollValue = (byte)10;
                this.m_scrollDelay = 50L;
                break;
            }
            case 12: {
                this.m_objectiveCardHandImage = Auxiliary.initializeImage("/manoobj.png");
                this.m_selectionArrowImage = Auxiliary.initializeImage("/flecha.png");
                if (this.m_selectedObjectiveCards == null) {
                    this.m_selectedObjectiveCards = new boolean[5];
                }
                this.m_menuSelectedOption = 0;
                boolean found = false;
                while (!found) {
                    if (!this.m_selectedObjectiveCards[this.m_menuSelectedOption]) {
                        found = true;
                        continue;
                    }
                    this.m_menuSelectedOption = (byte)(this.m_menuSelectedOption + 1);
                }
                break;
            }
            case 13: 
            case 22: {
                this.initializePeanutImages();
                this.m_checkImage = Auxiliary.initializeImage("/check_mark.png");
                this.m_objectiveCardImage = Auxiliary.initializeImage("/carta_objetivo_cara.png");
                if (this.m_objectiveCardDeck == null) {
                    this.initializeObjectiveCardDeck();
                }
                if (this.m_playerObjectiveCards != null) break;
                this.initializePlayersObjectiveCards();
                break;
            }
            case 14: {
                if (this.m_selectedObjectiveCards != null) {
                    this.m_selectedObjectiveCards = null;
                    Auxiliary.callGC();
                }
                this.initializeDiceImages();
                if (m_bigWhiteBitmapFont == null) {
                    m_bigWhiteBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_white.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                }
                if (this.m_diceThrown) break;
                this.m_diceResult = (byte)-1;
                this.m_currentDiceFrame = 0;
                this.m_diceTimer = System.currentTimeMillis();
                break;
            }
            case 16: {
                this.m_menuLastSelectedOption = 0;
                if (this.m_partyGameToCreate != -1) {
                    this.m_partyGame = this.createPartyGame();
                }
                if (m_bigWhiteBitmapFont != null) {
                    m_bigWhiteBitmapFont.destroy();
                    m_bigWhiteBitmapFont = null;
                }
                if (this.m_partyGame != null && this.m_partyGame.isPaused()) {
                    this.m_partyGame.resume();
                }
                this.m_inPause = false;
                break;
            }
            case 26: {
                this.initializeCategoryWithoutPeanutsArray();
                this.m_menuSelectedOption = this.m_losePeanut ? this.getClosestCategory((byte)-1) : (byte)0;
                this.m_selectionArrowImage = Auxiliary.initializeImage("/flecha.png");
                this.m_peanutEdgeImage = Auxiliary.initializeImage("/contorno_perder.png");
                this.initializePeanutsIconsImages();
                break;
            }
            case 17: {
                this.initializeCategoriesIconsImages();
                this.m_selectionArrowImage = Auxiliary.initializeImage("/flecha.png");
                if (this.m_gameState != 17) break;
                this.m_menuSelectedOption = 0;
            }
        }
        this.m_screenTitleTimer = System.currentTimeMillis();
        this.m_screenTitleOffset = 0;
        this.m_screenTitleDirLeft = true;
        this.m_screenTitleAnimationStarted = false;
    }

    public byte getGameState() {
        return this.m_gameState;
    }

    public void drawString(Graphics g, BitmapFont bitmapFont, Font sysFont, int x, int y, String str) {
        BitmapFont f = bitmapFont;
        f.drawString(g, m_painter, x, y, str);
    }

    public static int drawWrappedString(Graphics g, IPainter painter, String string, int x, int y, int width, BitmapFont bitmapFont, Font sysFont, boolean centered, boolean useSystemFont, int color) {
        return Auxiliary.drawWrappedString(g, painter, string, x, y, width, bitmapFont, sysFont, centered, useSystemFont, color);
    }

    private void initializeCategoryWithoutPeanutsArray() {
        if (this.m_losePeanut) {
            this.m_categoryWithoutPeanuts = new boolean[4];
            for (byte i = 0; i < 4; i = (byte)(i + 1)) {
                this.m_categoryWithoutPeanuts[i] = this.m_playerPeanutsNeeded[this.m_currentPlayer][i] == this.getPeanutCount(this.m_currentPlayer, i);
            }
        }
    }

    private void initializeRandomControl() {
        this.m_diceBuffer = new byte[this.m_playerName.length][];
        this.m_currentDiceResultCount = new byte[this.m_playerName.length];
        this.m_dicePossibleResults = new byte[this.m_playerName.length][];
        this.m_categoryBuffer = new byte[this.m_playerName.length][][];
        for (int i = 0; i < this.m_playerName.length; ++i) {
            int j;
            this.m_diceBuffer[i] = new byte[2];
            for (j = 0; j < 2; ++j) {
                this.m_diceBuffer[i][j] = -1;
            }
            this.m_currentDiceResultCount[i] = 5;
            this.m_dicePossibleResults[i] = new byte[this.m_currentDiceResultCount[i]];
            this.m_dicePossibleResults[i][0] = 6;
            this.m_dicePossibleResults[i][1] = 7;
            this.m_dicePossibleResults[i][2] = 5;
            this.m_dicePossibleResults[i][3] = 8;
            this.m_dicePossibleResults[i][4] = 9;
            this.m_categoryBuffer[i] = new byte[4][2];
            for (j = 0; j < 4; ++j) {
                for (int u = 0; u < 2; ++u) {
                    this.m_categoryBuffer[i][j][u] = -1;
                }
            }
        }
    }

    private void initializeQuestionTracking() {
        this.m_currentQuestionCount = new short[8];
        this.m_questionIndexes = new short[8][];
        for (int i = 0; i < 8; ++i) {
            this.m_currentQuestionCount[i] = Constants.QUESTION_COUNT[i];
            this.m_questionIndexes[i] = new short[Constants.QUESTION_COUNT[i]];
            for (int j = 0; j < this.m_questionIndexes[i].length; j = (int)((short)(j + 1))) {
                this.m_questionIndexes[i][j] = j;
            }
        }
    }

    private void initializePartnerSelectorImages() {
        this.m_partnerSelectorImages = new Image[Constants.PARTNER_SELECTOR_IMAGES.length];
        for (int i = 0; i < Constants.PARTNER_SELECTOR_IMAGES.length; ++i) {
            this.m_partnerSelectorImages[i] = Auxiliary.initializeImage(Constants.PARTNER_SELECTOR_IMAGES[i]);
        }
    }

    private void initializePeanutsIconsImages() {
        this.m_icons = new Image[4];
        for (int i = 0; i < 4; ++i) {
            this.m_icons[i] = Auxiliary.initializeImage(Constants.OBJECTIVE_CARD_PEANUT_IMAGES[i]);
        }
    }

    private void initializeCategoriesIconsImages() {
        this.m_icons = new Image[4];
        for (int i = 0; i < 4; ++i) {
            this.m_icons[i] = Auxiliary.initializeImage(Constants.ICON_IMAGES[i]);
        }
    }

    private void initializeMenuButtons(int optionCount) {
        this.m_menuButtons = null;
        this.m_buttonEdge = null;
        Auxiliary.callGC();
        this.m_menuButtons = new Image[optionCount];
        Image img = null;
        if (this.m_gameState == 8 || this.m_gameState == 9) {
            img = Auxiliary.initializeImage("/boton_menu.png");
        }
        for (int i = 0; i < optionCount; ++i) {
            this.m_menuButtons[i] = this.m_gameState == 8 || this.m_gameState == 9 ? img : Auxiliary.initializeImage(Constants.MENU_BUTTONS_IMAGES[i]);
        }
        img = null;
        this.m_buttonEdge = Auxiliary.initializeImage("/contorno_menu.png");
    }

    private void initializeNavigationButtons() {
        this.m_navigationButtons = null;
        Auxiliary.callGC();
        this.m_navigationButtons = new Image[Constants.BUTTONS_IMAGES.length];
        for (int i = 0; i < this.m_navigationButtons.length; ++i) {
            this.m_navigationButtons[i] = Auxiliary.initializeImage(Constants.BUTTONS_IMAGES[i]);
        }
    }

    private void initializeScrollingState(int start, int last) {
        this.m_scrollOffset = 0;
        int h = m_smallFont.getHeight();
        int destY = this.m_scrollOffset + 10;
        this.m_offsets = new short[last - start + 2];
        for (int i = 0; i < last - start + 1; ++i) {
            this.m_offsets[i] = (short)destY;
            String str = m_textBuffer.getText(i + start);
            if (str != null) {
                destY = Game.drawWrappedString(null, null, str, 0, destY, m_screenWidth - 0, null, m_smallFont, false, true, -1);
                continue;
            }
            destY += h;
        }
        this.m_offsets[this.m_offsets.length - 1] = (short)(destY + h);
    }

    protected static void initializeTextInput() {
        m_textInputStringBuffer.setLength(0);
        m_caretCharIndex = 0;
        m_caretPosition = (byte)-1;
        m_caretTableIndex = 0;
        m_textInputMaxLength = (byte)8;
    }

    protected void initializePeanutImages() {
        this.m_peanutImages = new Image[4];
        for (int i = 0; i < 4; ++i) {
            this.m_peanutImages[i] = Auxiliary.initializeImage(Constants.OBJECTIVE_CARD_PEANUT_IMAGES[i]);
        }
    }

    protected void initializeDiceImages() {
        this.m_diceImages = new Image[Constants.DICE_IMAGES.length];
        for (int i = 0; i < Constants.DICE_IMAGES.length; ++i) {
            this.m_diceImages[i] = Auxiliary.initializeImage(Constants.DICE_IMAGES[i]);
        }
    }

    public void initThread() {
        this.m_thread = new Thread(this);
    }

    public Thread getThread() {
        return this.m_thread;
    }

    private void freeUnusedDiceImages() {
        for (int i = 0; i < this.m_diceImages.length; ++i) {
            if (i == this.m_diceResult) continue;
            this.m_diceImages[i] = null;
        }
        Auxiliary.callGC();
    }

    public void exitGame() {
        this.m_mustExit = true;
    }

    private void destroy() {
        this.setGameState((byte)0);
        m_painter = null;
        this.m_menuBackgroundImage = null;
        if (this.m_eventQueue != null) {
            this.m_eventQueue.destroy();
            this.m_eventQueue = null;
        }
        if (this.m_stateStack != null) {
            this.m_stateStack.destroy();
            this.m_stateStack = null;
        }
        if (this.m_soundController != null) {
            this.m_soundController.destroy();
            this.m_soundController = null;
        }
        if (m_textBuffer != null) {
            m_textBuffer.destroy();
            m_textBuffer = null;
        }
        if (m_bigWhiteBitmapFont != null) {
            m_bigWhiteBitmapFont.destroy();
            m_bigWhiteBitmapFont = null;
        }
        if (m_bigRedBitmapFont != null) {
            m_bigRedBitmapFont.destroy();
            m_bigRedBitmapFont = null;
        }
        if (m_bigYellowBitmapFont != null) {
            m_bigYellowBitmapFont.destroy();
            m_bigYellowBitmapFont = null;
        }
        if (m_whiteBitmapFont != null) {
            m_whiteBitmapFont.destroy();
            m_whiteBitmapFont = null;
        }
        this.m_menuButtons = null;
        this.m_buttonEdge = null;
        this.m_navigationButtons = null;
        m_largeFont = null;
        m_mediumFont = null;
        m_smallFont = null;
        m_italicFont = null;
        if (this.m_persister != null) {
            this.m_persister.writeOptions(this);
            this.m_persister = null;
        }
    }

    public void playSound(String sound) {
        if (this.m_soundEnabled) {
            this.m_soundController.close(this.m_playerIndex);
            this.m_playerIndex = this.m_soundController.loadMIDI(this.getClass().getResourceAsStream(sound));
            this.m_soundController.prefetch(this.m_playerIndex);
            this.m_soundController.play(this.m_playerIndex);
        }
    }

    public void stopSound() {
        if (this.m_soundEnabled) {
            this.m_soundController.close(this.m_playerIndex);
        }
    }

    public boolean isSoundEnabled() {
        return this.m_soundEnabled;
    }

    public void setSound(boolean value) {
        this.m_soundEnabled = value;
    }

    private void initializePlayersObjectiveCards() {
        int j;
        int i;
        this.m_playerObjectiveCards = new byte[this.m_playerName.length][];
        this.m_playerObjectiveCardsPeanutStates = new byte[this.m_playerName.length][6];
        for (i = 0; i < this.m_playerName.length; ++i) {
            this.m_playerObjectiveCards[i] = this.getObjectiveCard();
            for (j = 0; j < 6; ++j) {
                this.m_playerObjectiveCardsPeanutStates[i][j] = 0;
            }
        }
        this.m_playerPeanutsNeeded = new byte[this.m_playerName.length][4];
        for (i = 0; i < this.m_playerName.length; ++i) {
            for (j = 0; j < this.m_playerObjectiveCards[i].length; ++j) {
                byte[] byArray = this.m_playerPeanutsNeeded[i];
                byte by = this.m_playerObjectiveCards[i][j];
                byArray[by] = (byte)(byArray[by] + 1);
            }
        }
    }

    private void initializeObjectiveCardDeck() {
        this.m_remainingObjectiveCardCount = (byte)Constants.OBJECTIVE_CARDS.length;
        this.m_objectiveCardDeck = new byte[this.m_remainingObjectiveCardCount][6];
        for (int i = 0; i < this.m_remainingObjectiveCardCount; ++i) {
            System.arraycopy(Constants.OBJECTIVE_CARDS[i], 0, this.m_objectiveCardDeck[i], 0, 6);
        }
    }

    private byte[] getObjectiveCard() {
        byte[] res = null;
        if (this.m_remainingObjectiveCardCount > 0) {
            this.m_remainingObjectiveCardCount = (byte)(this.m_remainingObjectiveCardCount - 1);
            int index = Auxiliary.getRandomNumber(0, this.m_remainingObjectiveCardCount);
            res = this.m_objectiveCardDeck[index];
            this.m_objectiveCardDeck[index] = this.m_objectiveCardDeck[this.m_remainingObjectiveCardCount];
            this.m_objectiveCardDeck[this.m_remainingObjectiveCardCount] = null;
        }
        return res;
    }

    private void obtainPeanut(byte playerNum, byte peanutColor) {
        boolean found = false;
        byte[] card = this.m_playerObjectiveCards[playerNum];
        byte[] peanutStates = this.m_playerObjectiveCardsPeanutStates[playerNum];
        byte[] byArray = this.m_playerPeanutsNeeded[playerNum];
        byte by = peanutColor;
        byArray[by] = (byte)(byArray[by] - 1);
        if (this.m_playerPeanutsNeeded[playerNum][peanutColor] > -1) {
            int i = 0;
            while (i < card.length && !found) {
                if (card[i] == peanutColor && peanutStates[i] == 0) {
                    peanutStates[i] = 1;
                    found = true;
                    continue;
                }
                ++i;
            }
        }
    }

    private byte getPeanutCount(byte playerNum, byte peanutColor) {
        byte count = 0;
        byte[] card = this.m_playerObjectiveCards[playerNum];
        for (int i = 0; i < card.length; ++i) {
            if (card[i] != peanutColor) continue;
            count = (byte)(count + 1);
        }
        return count;
    }

    private void losePeanut(byte playerNum, byte peanutColor) {
        boolean found = false;
        byte[] card = this.m_playerObjectiveCards[playerNum];
        byte[] peanutStates = this.m_playerObjectiveCardsPeanutStates[playerNum];
        byte[] byArray = this.m_playerPeanutsNeeded[playerNum];
        byte by = peanutColor;
        byArray[by] = (byte)(byArray[by] + 1);
        if (this.m_playerPeanutsNeeded[this.m_currentPlayer][peanutColor] > this.getPeanutCount(playerNum, peanutColor)) {
            byte[] byArray2 = this.m_playerPeanutsNeeded[playerNum];
            byte by2 = peanutColor;
            byArray2[by2] = (byte)(byArray2[by2] - 1);
        } else if (this.m_playerPeanutsNeeded[this.m_currentPlayer][peanutColor] > 0) {
            int i = 0;
            while (i < card.length && !found) {
                if (card[i] == peanutColor && peanutStates[i] == 1) {
                    peanutStates[i] = 0;
                    found = true;
                    continue;
                }
                ++i;
            }
        }
    }

    private boolean isCardCompleted(byte playerNum) {
        boolean res = true;
        byte[] peanutStates = this.m_playerObjectiveCardsPeanutStates[playerNum];
        int i = 0;
        while (i < peanutStates.length && res) {
            if (peanutStates[i++] != 0) continue;
            res = false;
        }
        return res;
    }

    private PartyGame createPartyGame() {
        PartyGame res = null;
        BitmapFont titleBitmapFont = null;
        this.m_partyGameCounted = false;
        int randomNumber = Auxiliary.getRandomNumber(0, 99);
        boolean allEqual = true;
        byte firstValue = this.m_categoryBuffer[this.m_currentPlayer][this.m_partyGameToCreate][0];
        if (firstValue == -1) {
            allEqual = false;
        } else {
            int i = 1;
            while (allEqual && i < 2) {
                allEqual = this.m_categoryBuffer[this.m_currentPlayer][this.m_partyGameToCreate][i++] == firstValue;
            }
        }
        int prob = 50;
        switch (this.m_partyGameToCreate) {
            case 1: {
                titleBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_yellow.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                if (allEqual) {
                    prob = firstValue == 2 ? 0 : 100;
                }
                if (randomNumber < prob) {
                    res = new PsicoWhatGame(this.m_playerName[this.m_currentPlayer], "/azul.png", "/azul_peque.png", "/icono_azul.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                    this.addToCategoryBuffer((byte)1, (byte)2);
                    break;
                }
                res = new PsicoHowGame(this.m_playerName[this.m_currentPlayer], "/azul.png", "/azul_peque.png", "/icono_azul.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                this.addToCategoryBuffer((byte)1, (byte)3);
                break;
            }
            case 2: {
                titleBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_red.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                if (allEqual) {
                    prob = firstValue == 4 ? 0 : 100;
                }
                res = new ShowKaraokeGame(this.m_playerName[this.m_currentPlayer], "/amarillo.png", "/amarillo_peque.png", "/icono_amarillo.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                this.addToCategoryBuffer((byte)2, (byte)5);
                break;
            }
            case 0: {
                titleBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_blue.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                if (allEqual) {
                    prob = firstValue == 0 ? 0 : 100;
                }
                if (randomNumber < prob) {
                    res = new QuizWhichGame(this.m_playerName[this.m_currentPlayer], "/rojo.png", "/rojo_peque.png", "/icono_rojo.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                    this.addToCategoryBuffer((byte)0, (byte)0);
                    break;
                }
                res = new QuizTrueOrFalseGame(this.m_playerName[this.m_currentPlayer], "/rojo.png", "/rojo_peque.png", "/icono_rojo.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                this.addToCategoryBuffer((byte)0, (byte)1);
                break;
            }
            case 3: {
                titleBitmapFont = Auxiliary.initializeBitmapFont("/bigfont_green.png", (short)6, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789&.,:!?", (short)3);
                if (allEqual) {
                    prob = firstValue == 6 ? 0 : 100;
                }
                if (randomNumber < prob) {
                    res = new ArtDrawingGame(this.m_playerName[this.m_currentPlayer], "/verde.png", "/verde_peque.png", "/icono_verde.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                    this.addToCategoryBuffer((byte)3, (byte)6);
                    break;
                }
                res = new ArtShapeGame(this.m_playerName[this.m_currentPlayer], "/verde.png", "/verde_peque.png", "/icono_verde.png", this.m_partnerIndex[this.m_currentPlayer], titleBitmapFont, (byte)this.m_playerScore[this.m_currentPlayer][1], this.m_currentTestNumber[this.m_currentPlayer], this.m_playerScore[this.m_currentPlayer][0]);
                this.addToCategoryBuffer((byte)3, (byte)7);
            }
        }
        if (allEqual) {
            for (int j = 0; j < 2; ++j) {
                this.m_categoryBuffer[this.m_currentPlayer][this.m_partyGameToCreate][j] = -1;
            }
        }
        this.m_partyGameCounted = false;
        titleBitmapFont = null;
        this.m_partyGameToCreate = (byte)-1;
        return res;
    }

    private void clearLastGame() {
        this.m_playerName = null;
        this.m_partnerIndex = null;
        this.m_playerObjectiveCards = null;
        this.m_playerPeanutsNeeded = null;
        this.m_playerObjectiveCardsPeanutStates = null;
        this.m_objectiveCardDeck = null;
        if (this.m_partyGame != null) {
            this.m_partyGame.destroy();
            this.m_partyGame = null;
        }
        this.m_playerScore = null;
        this.m_currentTestNumber = null;
        this.m_inPause = false;
        this.m_currentQuestionCount = null;
        this.m_categoryBuffer = null;
        this.m_diceBuffer = null;
        this.m_currentDiceResultCount = null;
        this.m_dicePossibleResults = null;
        this.m_questionIndexes = null;
    }

    private boolean isPartnerAlreadySelected(byte partnerIndex) {
        boolean res = false;
        int i = 0;
        while (!res && i < this.m_partnerIndex.length) {
            if (this.m_partnerIndex[i++] != partnerIndex) continue;
            res = true;
        }
        return res;
    }

    private boolean isNameAlreadySelected(String name) {
        boolean res = false;
        for (int i = 0; !res && i < this.m_playerName.length; ++i) {
            if (this.m_playerName[i] == null || !this.m_playerName[i].equals(name)) continue;
            res = true;
        }
        return res;
    }

    private void goToTest() {
        if (this.m_diceResult == 9) {
            this.m_stateStack.pushState((short)17);
        } else {
            this.m_currentCategory = (byte)-1;
            switch (this.m_diceResult) {
                case 5: {
                    this.m_currentCategory = (byte)2;
                    break;
                }
                case 6: {
                    this.m_currentCategory = 1;
                    break;
                }
                case 8: {
                    this.m_currentCategory = (byte)3;
                    break;
                }
                case 7: {
                    this.m_currentCategory = 0;
                }
            }
            if (Auxiliary.getRandomNumber(0, 99) < 25) {
                this.goToSurprise();
            } else {
                this.m_partyGameToCreate = this.m_currentCategory;
                this.m_stateStack.pushState((short)16);
            }
        }
        this.m_diceResult = (byte)-1;
        this.m_diceThrown = false;
        this.m_currentDiceFrame = 0;
    }

    public short getQuestionIndex(byte gameIndex) {
        short res = -1;
        short count = this.m_currentQuestionCount[gameIndex];
        int index = Auxiliary.getRandomNumber(0, count - 1);
        res = this.m_questionIndexes[gameIndex][index];
        this.m_questionIndexes[gameIndex][index] = this.m_questionIndexes[gameIndex][count - 1];
        byte by = gameIndex;
        this.m_currentQuestionCount[by] = (short)(this.m_currentQuestionCount[by] - 1);
        if (this.m_currentQuestionCount[gameIndex] == 0) {
            this.m_currentQuestionCount[gameIndex] = Constants.QUESTION_COUNT[gameIndex];
            for (short i = 0; i < Constants.QUESTION_COUNT[gameIndex]; i = (short)(i + 1)) {
                this.m_questionIndexes[gameIndex][i] = i;
            }
        }
        return res;
    }

    private void addToDiceBuffer(byte resultIndex) {
        for (int i = 1; i > 0; --i) {
            this.m_diceBuffer[this.m_currentPlayer][i - 1] = this.m_diceBuffer[this.m_currentPlayer][i];
        }
        this.m_diceBuffer[this.m_currentPlayer][1] = resultIndex;
        boolean allEqual = true;
        byte firstValue = this.m_diceBuffer[this.m_currentPlayer][0];
        int i = 1;
        while (allEqual && i < 2) {
            allEqual = this.m_diceBuffer[this.m_currentPlayer][i++] == firstValue;
        }
        if (allEqual) {
            i = 0;
            boolean found = false;
            while (i < this.m_dicePossibleResults[this.m_currentPlayer].length && !found) {
                if (this.m_dicePossibleResults[this.m_currentPlayer][i] == firstValue) {
                    found = true;
                    continue;
                }
                ++i;
            }
            this.m_dicePossibleResults[this.m_currentPlayer][i] = this.m_dicePossibleResults[this.m_currentPlayer][this.m_dicePossibleResults[this.m_currentPlayer].length - 1];
            this.m_dicePossibleResults[this.m_currentPlayer][this.m_dicePossibleResults[this.m_currentPlayer].length - 1] = firstValue;
            byte by = this.m_currentPlayer;
            this.m_currentDiceResultCount[by] = (byte)(this.m_currentDiceResultCount[by] - 1);
            for (i = 0; i < this.m_diceBuffer[this.m_currentPlayer].length; ++i) {
                this.m_diceBuffer[this.m_currentPlayer][i] = -1;
            }
        }
    }

    private void addToCategoryBuffer(byte category, byte gameIndex) {
        for (int i = 1; i > 0; --i) {
            this.m_categoryBuffer[this.m_currentPlayer][category][i - 1] = this.m_categoryBuffer[this.m_currentPlayer][category][i];
        }
        this.m_categoryBuffer[this.m_currentPlayer][category][1] = gameIndex;
    }

    private byte getNextDiceResult() {
        byte res = -1;
        int index = Auxiliary.getRandomNumber(0, this.m_currentDiceResultCount[this.m_currentPlayer] - 1);
        res = this.m_dicePossibleResults[this.m_currentPlayer][index];
        if (this.m_currentDiceResultCount[this.m_currentPlayer] == 4) {
            byte by = this.m_currentPlayer;
            this.m_currentDiceResultCount[by] = (byte)(this.m_currentDiceResultCount[by] + 1);
        }
        return res;
    }

    private byte getClosestCategory(byte previousSelectedCategory) {
        byte foundPos = -1;
        int i = 1;
        if (previousSelectedCategory != -1) {
            int count = 4;
            for (int j = 0; j < 4; j = (int)((byte)(j + 1))) {
                if (!this.m_categoryWithoutPeanuts[j]) continue;
                --count;
            }
            if (count == 1) {
                return previousSelectedCategory;
            }
        }
        while (foundPos == -1) {
            byte high;
            byte low = (byte)(this.m_menuSelectedOption - i);
            if (low < 0) {
                low = (byte)(4 + low);
            }
            if ((high = (byte)(this.m_menuSelectedOption + i)) > 3) {
                high = (byte)(high - 4);
            }
            if (previousSelectedCategory != high && !this.m_categoryWithoutPeanuts[high]) {
                foundPos = high;
                continue;
            }
            if (previousSelectedCategory != low && !this.m_categoryWithoutPeanuts[low]) {
                foundPos = low;
                continue;
            }
            ++i;
        }
        return foundPos;
    }

    private byte getClosestUnselectedPartner(byte previousSelectedPartner) {
        byte foundPos = -1;
        int i = 1;
        if (previousSelectedPartner != -1) {
            int count = 4;
            for (byte j = 0; j < 4; j = (byte)(j + 1)) {
                if (!this.isPartnerAlreadySelected(j)) continue;
                --count;
            }
            if (count == 1) {
                return previousSelectedPartner;
            }
        }
        while (foundPos == -1) {
            byte high;
            byte low = (byte)(this.m_menuSelectedOption - i);
            if (low < 0) {
                low = (byte)(4 + low);
            }
            if ((high = (byte)(this.m_menuSelectedOption + i)) > 3) {
                high = (byte)(high - 4);
            }
            if (previousSelectedPartner != high && !this.isPartnerAlreadySelected(high)) {
                foundPos = high;
                continue;
            }
            if (previousSelectedPartner != low && !this.isPartnerAlreadySelected(low)) {
                foundPos = low;
                continue;
            }
            ++i;
        }
        return foundPos;
    }

    private void goToSurprise() {
        short previous = this.m_stateStack.getTop();
        int value = Auxiliary.getRandomNumber(1, 100);
        this.m_surpriseResultCalculated = false;
        if (previous == 17) {
            if (value < 50) {
                int stock = this.getPeanutCount(this.m_currentPlayer, this.m_currentCategory) - this.m_playerPeanutsNeeded[this.m_currentPlayer][this.m_currentCategory];
                if (stock == 0) {
                    this.m_stateStack.pushState((short)31);
                } else {
                    this.m_stateStack.pushState((short)27);
                }
                this.m_losePeanut = false;
            } else {
                int stock = this.getPeanutCount(this.m_currentPlayer, this.m_currentCategory) - this.m_playerPeanutsNeeded[this.m_currentPlayer][this.m_currentCategory];
                if (stock == 0) {
                    this.m_stateStack.pushState((short)31);
                } else {
                    this.m_stateStack.pushState((short)27);
                }
                this.m_losePeanut = true;
            }
        } else if (value < 35) {
            this.m_stateStack.pushState((short)27);
            this.m_losePeanut = false;
        } else if (value < 70) {
            int stock = this.getPeanutCount(this.m_currentPlayer, this.m_currentCategory) - this.m_playerPeanutsNeeded[this.m_currentPlayer][this.m_currentCategory];
            if (stock == 0) {
                this.m_stateStack.pushState((short)31);
            } else {
                this.m_stateStack.pushState((short)27);
            }
            this.m_losePeanut = true;
        } else if (value < 85) {
            this.m_stateStack.pushState((short)28);
            this.m_losePeanut = false;
        } else {
            this.m_losePeanut = true;
            this.m_stateStack.pushState((short)28);
        }
    }

    private boolean checkCardCompleted() {
        boolean res = false;
        if (this.isCardCompleted(this.m_currentPlayer)) {
            this.m_stateStack.pushState((short)18);
            int finalScore = this.m_playerScore[this.m_currentPlayer][0] * 10 * this.m_playerScore[this.m_currentPlayer][1];
            if (this.m_currentTestNumber[this.m_currentPlayer] - 1 > 0) {
                finalScore /= this.m_currentTestNumber[this.m_currentPlayer] - 1;
                finalScore += 2000 / (this.m_currentTestNumber[this.m_currentPlayer] - 1);
            }
            this.m_persister.addToRanking(this.m_playerName[this.m_currentPlayer], finalScore);
            res = true;
        }
        return res;
    }

    static {
        m_smallFont = Font.getFont((int)64, (int)0, (int)0);
        m_mediumFont = Font.getFont((int)64, (int)0, (int)16);
        m_mediumBoldFont = Font.getFont((int)64, (int)1, (int)16);
        m_smallBoldFont = Font.getFont((int)64, (int)1, (int)0);
        m_largeFont = Font.getFont((int)64, (int)0, (int)16);
        m_italicFont = Font.getFont((int)64, (int)2, (int)16);
        m_textInputStringBuffer = new StringBuffer();
    }
}

