/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.Game;
import com.kitmaker.games.party.PartyGame;
import com.kitmaker.games.party.TextBuffer;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class PsicoWhatGame
extends PartyGame {
    private String[] m_question;
    private String[] m_answers;
    private String[] m_aux;
    private byte m_correctAnswer;
    private byte m_currentSelectedAnswer;
    private short m_bodyOffset;
    private short m_questionHeight;
    private long m_bodyScrollTimer;
    boolean booltamstr;
    int tamstroff;
    long timetamstr;

    public PsicoWhatGame(String playerName, String categoryBigImagePath, String categorySmallImagePath, String iconImagePath, byte partnerIndex, BitmapFont titleBitmapFont, byte correctCount, byte testIndex, int currentScore) {
        super(playerName, categoryBigImagePath, categorySmallImagePath, iconImagePath, 30000L, (short)77, (short)78, titleBitmapFont, -3584, partnerIndex, correctCount, testIndex, currentScore);
    }

    protected void enterPlayingState(byte previousState) {
        super.enterPlayingState(previousState);
        this.m_bodyScrollTimer = System.currentTimeMillis() + 1500L;
    }

    protected void exitPlayingState(byte nextState) {
        super.exitPlayingState(nextState);
    }

    protected void paintPlayingState(Graphics g, IPainter painter, int y, int width, int height) {
        super.paintPlayingState(g, painter, y, width, height);
        y += this.m_iconImage.getHeight() + m_font.getHeight() / 2;
        int x = 10;
        width -= 20;
        short lastY = this.m_bodyY;
        y = this.m_bodyY;
        for (int i = 0; i < this.m_question.length; ++i) {
            String aux = this.m_question[i];
            y = Game.drawWrappedString(null, painter, aux, x, y, width, null, m_boldFont, false, true, -11454824);
        }
        int h = y - lastY;
        if (h > this.m_bodyHeight) {
            h = this.m_bodyHeight;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(0, (int)this.m_bodyY, (int)Game.m_screenWidth, (int)this.m_bodyHeight);
        y = this.m_bodyY + this.m_bodyHeight / 2 - h / 2;
        g.setColor(8721258);
        g.fillRect(0, y - 0, (int)Game.m_screenWidth, h + 0);
        g.setColor(-1);
        g.fillRect(0, y, (int)Game.m_screenWidth, h);
        y += this.m_bodyOffset;
        for (int i = 0; i < this.m_question.length; ++i) {
            String aux = this.m_question[i];
            y = Game.drawWrappedString(g, painter, aux, x, y, width, null, m_boldFont, true, true, -11454824);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        int ch = m_font.getHeight();
        y = this.m_bodyY + this.m_bodyHeight + 1;
        x = 10;
        int w = this.m_digitsBitmapFont.getCharWidth();
        h = this.m_digitsBitmapFont.getCharHeight();
        for (int i = 0; i < this.m_answers.length; ++i) {
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(' ').append(this.m_answers[i]);
            int previousY = y;
            String str = m_auxStringBuffer.toString();
            int Color = -1;
            if (this.m_currentSelectedAnswer == i) {
                int tamstr;
                Color = 15464709;
                if (System.currentTimeMillis() - this.timetamstr > 200L) {
                    if (this.booltamstr) {
                        ++this.tamstroff;
                    }
                    this.timetamstr = System.currentTimeMillis();
                }
                if ((tamstr = m_font.stringWidth(str)) >= width - 5) {
                    this.booltamstr = true;
                    tamstr = m_font.stringWidth(str = str.substring(this.tamstroff));
                    if (tamstr < width - 5) {
                        this.booltamstr = false;
                    }
                }
            }
            y = Game.drawWrappedString(g, painter, str, x, y, 1000, null, m_font, false, true, Color);
        }
    }

    protected void runInitState() {
    }

    protected void controlPlayingStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1) {
            boolean fire;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (up) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer - 1);
                if (this.m_currentSelectedAnswer < 0) {
                    this.m_currentSelectedAnswer = (byte)2;
                }
                this.booltamstr = false;
                this.tamstroff = 0;
            } else if (down) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer + 1);
                if (this.m_currentSelectedAnswer == 3) {
                    this.m_currentSelectedAnswer = 0;
                }
                this.booltamstr = false;
                this.tamstroff = 0;
            } else if (fire) {
                this.m_correct = this.m_currentSelectedAnswer == this.m_correctAnswer;
                this.m_nextGameState = (byte)3;
            }
        }
    }

    protected void initializeGame() throws Exception {
        int i;
        InputStream uis;
        TextBuffer gameTextBuffer = new TextBuffer();
        InputStream is = this.getClass().getResourceAsStream("/what.txt");
        if (!gameTextBuffer.initialize(is, uis = this.getClass().getResourceAsStream("/what_u.txt"), 2000, 140)) {
            throw new Exception();
        }
        try {
            is.close();
            uis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        is = null;
        uis = null;
        Game game = Game.getInstance(null);
        int index = game.getQuestionIndex((byte)2) * 140 / Constants.QUESTION_COUNT[2];
        game = null;
        this.m_question = new String[1];
        this.m_answers = new String[3];
        this.m_aux = new String[4];
        this.m_questionHeight = 0;
        for (i = 0; i < this.m_question.length; i = (int)((byte)(i + 1))) {
            this.m_question[i] = gameTextBuffer.getText(index);
            this.m_questionHeight = (short)(this.m_questionHeight + (short)Game.drawWrappedString(null, null, this.m_question[i], 0, 0, Game.m_screenWidth - 20, null, m_boldFont, true, true, 0));
            ++index;
        }
        for (i = 0; i < this.m_aux.length; i = (int)((byte)(i + 1))) {
            this.m_aux[i] = gameTextBuffer.getText(index);
            ++index;
        }
        switch (this.m_partnerIndex) {
            case 0: {
                this.m_correctAnswer = 0;
                break;
            }
            case 1: {
                this.m_correctAnswer = (byte)2;
                break;
            }
            case 2: {
                this.m_correctAnswer = (byte)3;
                break;
            }
            case 3: {
                this.m_correctAnswer = 1;
            }
        }
        index = Auxiliary.getRandomNumber(0, 3);
        if (index == this.m_correctAnswer) {
            index = index == 0 ? ++index : --index;
        }
        for (i = (int)((byte)index); i < this.m_aux.length - 1; i = (int)((byte)(i + 1))) {
            this.m_aux[i] = this.m_aux[i + 1];
        }
        if (index < this.m_correctAnswer) {
            this.m_correctAnswer = (byte)(this.m_correctAnswer - 1);
        }
        boolean m_change = true;
        for (int i2 = 0; i2 < this.m_aux.length - 1; i2 = (int)((byte)(i2 + 1))) {
            index = Auxiliary.getRandomNumber(0, 2);
            if (this.m_answers[index] == null) {
                this.m_answers[index] = this.m_aux[i2];
                if (i2 != this.m_correctAnswer || !m_change) continue;
                this.m_correctAnswer = (byte)index;
                m_change = false;
                continue;
            }
            i2 = (byte)(i2 - 1);
        }
        this.m_aux = null;
        gameTextBuffer.destroy();
        gameTextBuffer = null;
    }

    public void destroy() {
        super.destroy();
        this.m_question = null;
        this.m_answers = null;
    }

    protected void runPlayingState() {
        super.runPlayingState();
        if (this.m_questionHeight > this.m_bodyHeight && System.currentTimeMillis() - this.m_bodyScrollTimer > 150L) {
            if (this.m_bodyOffset + this.m_questionHeight > this.m_bodyHeight) {
                this.m_bodyScrollTimer = System.currentTimeMillis();
                this.m_bodyOffset = (short)(this.m_bodyOffset - 1);
            } else if (System.currentTimeMillis() - this.m_bodyScrollTimer > 3000L) {
                this.m_bodyOffset = 0;
                this.m_bodyScrollTimer = System.currentTimeMillis() + 1500L;
            }
        }
    }

    public byte getPeanutColor() {
        return 1;
    }
}

