/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.Game;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class PartyGame {
    protected boolean m_changingState;
    protected byte m_gameState;
    protected byte m_nextGameState;
    protected byte m_previousGameState;
    protected String m_playerName;
    protected boolean m_finished;
    protected byte m_partnerIndex;
    protected Image m_categoryBigImage;
    private String m_categoryBigImagePath;
    protected Image m_categorySmallImage;
    private String m_categorySmallImagePath;
    private short m_gameNameTextIndex;
    private short m_gameDescriptionTextIndex;
    private BitmapFont m_titleBitmapFont;
    private int m_titleColor;
    private short m_scrollingTextClipHeight;
    private short m_offsetLimit;
    private short m_scrollOffset;
    private long m_scrollTimer;
    private boolean m_scrollUp;
    private boolean m_scrollDown;
    private byte m_scrollValue;
    private long m_scrollDelay;
    protected Image m_iconImage;
    private String m_iconImagePath;
    protected BitmapFont m_digitsBitmapFont;
    private short m_navigationOkLabel;
    private short m_navigationBackLabel;
    protected boolean m_correct;
    protected boolean m_viewingCard;
    protected Image m_partnerImage;
    protected Image m_bubbleImage;
    protected long m_timer;
    protected long m_maxTime;
    private boolean m_timerEnabled;
    protected short m_bodyHeight;
    protected short m_bodyY;
    protected short m_footerHeight;
    private boolean m_gameStarted;
    protected int m_score;
    private byte m_correctCount;
    private byte m_testIndex;
    private int m_currentScore;
    protected static StringBuffer m_auxStringBuffer = new StringBuffer();
    protected static Font m_font = Font.getFont((int)64, (int)0, (int)0);
    protected static Font m_boldFont = Font.getFont((int)64, (int)1, (int)0);

    protected PartyGame(String playerName, String categoryBigImagePath, String categorySmallImagePath, String iconImagePath, long maxTime, short gameNameTextIndex, short gameDescTextIndex, BitmapFont titleBitmapFont, int titleColor, byte partnerIndex, byte correctCount, byte testIndex, int currentScore) {
        this.m_playerName = playerName;
        this.m_categoryBigImagePath = categoryBigImagePath;
        this.m_categorySmallImagePath = categorySmallImagePath;
        this.m_iconImagePath = iconImagePath;
        this.m_navigationOkLabel = (short)-1;
        this.m_navigationBackLabel = (short)-1;
        this.m_gameNameTextIndex = gameNameTextIndex;
        this.m_gameDescriptionTextIndex = gameDescTextIndex;
        this.m_maxTime = maxTime;
        this.m_titleBitmapFont = titleBitmapFont;
        this.m_titleColor = titleColor;
        this.m_partnerIndex = partnerIndex;
        if (maxTime > 0L) {
            this.m_timerEnabled = true;
        }
        this.m_gameStarted = false;
        this.m_score = 0;
        this.m_currentScore = currentScore;
        this.m_correctCount = correctCount;
        this.m_testIndex = testIndex;
        this.m_bodyY = (short)(69 + Game.m_mediumFont.getHeight() / 2);
        this.m_footerHeight = (short)(Game.m_smallFont.getHeight() * 3 + 36 + 4);
        this.m_bodyHeight = (short)(Game.m_screenHeight - this.m_footerHeight - this.m_bodyY);
        try {
            this.initializeGame();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setGameState((byte)0);
    }

    public void destroy() {
        this.setGameState((byte)-1);
        if (this.m_titleBitmapFont != null) {
            this.m_titleBitmapFont.destroy();
            this.m_titleBitmapFont = null;
        }
        this.m_categoryBigImage = null;
        this.m_categoryBigImagePath = null;
        this.m_categorySmallImage = null;
        this.m_categorySmallImagePath = null;
        this.m_iconImage = null;
        this.m_iconImagePath = null;
        this.m_playerName = null;
    }

    public void paint(Graphics g, IPainter painter, int y, int width, int height) {
        if (this.m_changingState) {
            return;
        }
        switch (this.m_gameState) {
            case 0: {
                this.paintInitState(g, painter, y, width, height);
                break;
            }
            case 1: {
                this.paintDescriptionState(g, painter, y, width, height);
                break;
            }
            case 2: {
                this.paintPlayingState(g, painter, y, width, height);
                break;
            }
            case 3: {
                this.paintEndState(g, painter, y, width, height);
            }
        }
    }

    protected void paintInitState(Graphics g, IPainter painter, int y, int width, int height) {
        int initY = y;
        int w = this.m_categoryBigImage.getWidth();
        int h = this.m_categoryBigImage.getHeight();
        y = initY + height / 2 - h / 2;
        int x = width / 2 - w / 2;
        painter.drawRegion(g, this.m_categoryBigImage, 0, 0, x, y, w, h, 0);
    }

    protected void paintDescriptionState(Graphics g, IPainter painter, int y, int width, int height) {
        int x;
        int initY = y;
        int w = 220;
        int h = 220;
        if (h > Game.m_screenHeight - 2 * y) {
            h = Game.m_screenHeight - 2 * y;
        }
        y = initY + height / 2 - h / 2;
        int initX = x = width / 2 - w / 2;
        g.setColor(-16777216);
        g.fillRect(x, y, w, h);
        x += 0;
        y += 0;
        w += 0;
        h += 0;
        int ch = this.m_titleBitmapFont.getCharHeight();
        int iconWidth = this.m_categorySmallImage.getWidth();
        int iconHeight = this.m_categorySmallImage.getHeight();
        int squareX = x;
        int squareY = Game.drawWrappedString(null, null, Game.m_textBuffer.getText(this.m_gameNameTextIndex), x, y, 220 - iconWidth * 3 / 2, this.m_titleBitmapFont, Game.m_largeFont, true, false, this.m_titleColor) + 15;
        int cw = 3;
        this.m_offsetLimit = (short)(this.m_scrollingTextClipHeight - Game.drawWrappedString(null, Game.m_painter, Game.m_textBuffer.getText(this.m_gameDescriptionTextIndex), cw, 0, 220 - cw * 2, null, m_font, false, true, 0) - m_font.getHeight());
        if (this.m_offsetLimit > 0) {
            this.m_offsetLimit = 0;
        }
        this.m_scrollingTextClipHeight = (short)(y + h - squareY);
        g.setColor(-1);
        g.fillRect(x, y, w, h);
        painter.drawRegion(g, this.m_categorySmallImage, 0, 0, x += w - iconWidth * 3 / 2, y += iconHeight / 4, iconWidth, iconHeight, 0);
        x = initX + 0;
        w = 220 - iconWidth * 3 / 2;
        y += iconHeight / 2 - ch / 2;
        y = Game.drawWrappedString(g, painter, Game.m_textBuffer.getText(this.m_gameNameTextIndex), x, y, w, this.m_titleBitmapFont, Game.m_largeFont, true, false, this.m_titleColor);
        y = squareY;
        w = 220;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(squareX, squareY, w, (int)this.m_scrollingTextClipHeight);
        Game.drawWrappedString(g, painter, Game.m_textBuffer.getText(this.m_gameDescriptionTextIndex), x + cw, y + this.m_scrollOffset, w - 2 * cw, null, m_font, true, true, -11454824);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    protected void paintPlayingState(Graphics g, IPainter painter, int y, int width, int height) {
        if (this.m_iconImage == null) {
            return;
        }
        int w = width;
        int h = height;
        int x = 0;
        w = this.m_iconImage.getWidth();
        h = this.m_iconImage.getHeight();
        g.setColor(8721258);
        g.fillRect(0, 0, width, h + 0 + 15 + 0 + Game.m_mediumFont.getHeight() / 2);
        g.setColor(8721258);
        g.fillRect(0, Game.m_screenHeight - this.m_footerHeight, width, (int)this.m_footerHeight);
        x = 0;
        y = 0;
        painter.drawRegion(g, this.m_iconImage, 0, 0, x, y, w, h, 0);
        x = w;
        y = 0;
        y = Game.drawWrappedString(g, painter, this.m_playerName, x, y, width - 2 * (w + 0), this.m_titleBitmapFont, Game.m_mediumBoldFont, true, false, -1);
        Game.drawWrappedString(g, painter, Game.m_textBuffer.getText(this.m_gameNameTextIndex), x, y, 240 - w * 2, this.m_titleBitmapFont, Game.m_mediumFont, true, false, -3584);
        x = width - w;
        y = 0;
        g.setColor(-16777216);
        g.fillArc(x, y, w, h, 180, 360);
        g.setColor(-1);
        g.fillArc(x + 0, y + 0, w - 0, h - 0, 180, 360);
        if (this.m_timerEnabled) {
            long value = this.m_maxTime - (System.currentTimeMillis() - this.m_timer);
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(value / 1000L);
            String str = m_auxStringBuffer.toString();
            int ch = this.m_digitsBitmapFont.getCharHeight();
            int strWidth = this.m_digitsBitmapFont.getStringWidth(str);
            Game.drawWrappedString(g, painter, str, x += w / 2 - strWidth / 2, y += h / 2 - ch / 2, width - (w + 0), this.m_digitsBitmapFont, Game.m_largeFont, false, false, 8721258);
        }
    }

    protected void paintEndState(Graphics g, IPainter painter, int y, int width, int height) {
        int initY = y;
        int w = this.m_bubbleImage.getWidth();
        int h = this.m_bubbleImage.getHeight();
        int x = width - w;
        painter.drawRegion(g, this.m_bubbleImage, 0, 0, x, y += height / 2 - h / 2 + -10, w, h, 0);
        int speechIndex = this.m_timerEnabled && this.m_maxTime == 0L ? 57 : (this.m_correct ? 55 : 56);
        x += 33;
        y += 30;
        m_auxStringBuffer.setLength(0);
        m_auxStringBuffer.append(Game.m_textBuffer.getText(speechIndex));
        int finalScore = this.m_score * 10 * this.m_correctCount / this.m_testIndex;
        m_auxStringBuffer.append(' ').append(finalScore);
        String str = m_auxStringBuffer.toString();
        int strHeight = Game.drawWrappedString(null, painter, str, 0, 0, w - 33 + -15, null, Game.m_smallBoldFont, true, true, 0);
        if (strHeight < 150) {
            Game.drawWrappedString(g, painter, str, x, y + 75 - strHeight / 2, w - 33 + -15, null, Game.m_smallBoldFont, true, true, 0);
        } else {
            this.m_scrollingTextClipHeight = (short)146;
            this.m_offsetLimit = (short)(this.m_scrollingTextClipHeight - strHeight);
            if (this.m_offsetLimit > 0) {
                this.m_offsetLimit = 0;
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            g.setClip(x, y + 2, w, (int)this.m_scrollingTextClipHeight);
            Game.drawWrappedString(g, painter, str, x, y += this.m_scrollOffset + 2, w - 33 + -15, null, Game.m_smallBoldFont, false, true, 0);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        w = this.m_partnerImage.getWidth();
        h = this.m_partnerImage.getHeight();
        x = 0;
        y = initY + height / 2 - h / 2;
        painter.drawRegion(g, this.m_partnerImage, 0, 0, x, y, w, h, 0);
    }

    public void controlInput(int keyCode, int gameAction, int eventType) {
        switch (this.m_gameState) {
            case 0: {
                this.controlInitStateInput(keyCode, gameAction, eventType);
                break;
            }
            case 1: {
                this.controlDescriptionStateInput(keyCode, gameAction, eventType);
                break;
            }
            case 2: {
                this.controlPlayingStateInput(keyCode, gameAction, eventType);
                break;
            }
            case 3: {
                this.controlEndStateInput(keyCode, gameAction, eventType);
            }
        }
        if (eventType == 1 && Auxiliary.isRightSoftkeyPressed(keyCode, gameAction) && this.m_navigationBackLabel == 5) {
            this.m_nextGameState = (byte)4;
        }
    }

    protected void controlInitStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1 && (keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction))) {
            this.m_nextGameState = 1;
        }
    }

    protected void controlDescriptionStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1 && (keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction))) {
            this.m_nextGameState = (byte)2;
        } else {
            boolean down;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean bl = down = keyCode == 56 || gameAction == 6;
            if (up) {
                this.m_scrollUp = eventType == 1;
            } else if (down) {
                this.m_scrollDown = eventType == 1;
            }
        }
    }

    protected abstract void controlPlayingStateInput(int var1, int var2, int var3);

    protected void controlEndStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1 && (keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction))) {
            this.m_finished = true;
        } else if (Auxiliary.isRightSoftkeyPressed(keyCode, gameAction)) {
            this.m_viewingCard = true;
        } else {
            boolean down;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean bl = down = keyCode == 56 || gameAction == 6;
            if (up) {
                this.m_scrollUp = eventType == 1;
            } else if (down) {
                this.m_scrollDown = eventType == 1;
            }
        }
    }

    public void run() {
        switch (this.m_gameState) {
            case 0: {
                this.runInitState();
                break;
            }
            case 1: {
                this.runDescriptionState();
                break;
            }
            case 2: {
                this.runPlayingState();
                break;
            }
            case 4: {
                if (!this.m_gameStarted) break;
                this.runPlayingState();
                break;
            }
            case 3: {
                this.runEndState();
            }
        }
        if (this.m_nextGameState != -1) {
            this.setGameState(this.m_nextGameState);
        }
    }

    protected abstract void runInitState();

    protected void runDescriptionState() {
        if (System.currentTimeMillis() - this.m_scrollTimer > this.m_scrollDelay) {
            this.m_scrollTimer = System.currentTimeMillis();
            if (this.m_scrollDown) {
                this.m_scrollOffset = (short)(this.m_scrollOffset - this.m_scrollValue);
                if (this.m_scrollOffset < this.m_offsetLimit) {
                    this.m_scrollOffset = this.m_offsetLimit;
                }
            } else if (this.m_scrollUp) {
                this.m_scrollOffset = (short)(this.m_scrollOffset + this.m_scrollValue);
                if (this.m_scrollOffset > 0) {
                    this.m_scrollOffset = 0;
                }
            }
        }
    }

    protected void runPlayingState() {
        long value;
        if (this.m_timerEnabled && (value = this.m_maxTime - (System.currentTimeMillis() - this.m_timer)) <= 0L) {
            this.m_nextGameState = (byte)3;
            this.m_maxTime = 0L;
        }
    }

    protected void runEndState() {
        if (System.currentTimeMillis() - this.m_scrollTimer > this.m_scrollDelay) {
            this.m_scrollTimer = System.currentTimeMillis();
            if (this.m_scrollDown) {
                this.m_scrollOffset = (short)(this.m_scrollOffset - this.m_scrollValue);
                if (this.m_scrollOffset < this.m_offsetLimit) {
                    this.m_scrollOffset = this.m_offsetLimit;
                }
            } else if (this.m_scrollUp) {
                this.m_scrollOffset = (short)(this.m_scrollOffset + this.m_scrollValue);
                if (this.m_scrollOffset > 0) {
                    this.m_scrollOffset = 0;
                }
            }
        }
    }

    private void setGameState(byte newState) {
        this.m_changingState = true;
        Game.getInstance(null).stopSound();
        switch (this.m_gameState) {
            case 0: {
                this.exitInitState(newState);
                break;
            }
            case 1: {
                this.exitDescriptionState(newState);
                break;
            }
            case 2: {
                this.exitPlayingState(newState);
                break;
            }
            case 3: {
                this.exitEndState(newState);
                break;
            }
            case 4: {
                this.exitPauseState(newState);
            }
        }
        Auxiliary.callGC();
        byte previousState = this.m_gameState;
        this.m_gameState = newState;
        switch (newState) {
            case 0: {
                this.enterInitState(previousState);
                break;
            }
            case 1: {
                this.enterDescriptionState(previousState);
                break;
            }
            case 2: {
                this.enterPlayingState(previousState);
                break;
            }
            case 3: {
                this.enterEndState(previousState);
                break;
            }
            case 4: {
                this.enterPauseState(previousState);
            }
        }
        this.m_nextGameState = (byte)-1;
        this.m_changingState = false;
    }

    protected void enterInitState(byte previousState) {
        this.m_categoryBigImage = Auxiliary.initializeImage(this.m_categoryBigImagePath);
        this.m_navigationOkLabel = (short)6;
        this.m_navigationBackLabel = (short)5;
    }

    protected void enterDescriptionState(byte previousState) {
        this.m_categorySmallImage = Auxiliary.initializeImage(this.m_categorySmallImagePath);
        this.m_navigationOkLabel = (short)6;
        this.m_navigationBackLabel = (short)5;
        this.m_scrollOffset = 0;
        this.m_scrollValue = (byte)10;
        this.m_scrollDelay = 50L;
    }

    protected void enterPlayingState(byte previousState) {
        this.m_gameStarted = true;
        this.m_digitsBitmapFont = Auxiliary.initializeBitmapFont("/digitos.png", (short)1, "0123456789><", (short)3);
        this.m_iconImage = Auxiliary.initializeImage(this.m_iconImagePath);
        if (previousState != 4) {
            this.m_timer = System.currentTimeMillis();
        }
    }

    protected void enterEndState(byte previousState) {
        Game game = Game.getInstance(null);
        if (this.m_correct) {
            game.playSound("/acierto.mid");
            this.m_partnerImage = Auxiliary.initializeImage(Constants.PARTNER_HAPPY_IMAGES[this.m_partnerIndex]);
            int value = (int)((this.m_maxTime - (System.currentTimeMillis() - this.m_timer)) / 1000L);
            this.m_score = 5 + value + this.m_currentScore;
            this.m_correctCount = (byte)(this.m_correctCount + 1);
        } else {
            game.playSound("/fallo.mid");
            this.m_partnerImage = Auxiliary.initializeImage(Constants.PARTNER_SAD_IMAGES[this.m_partnerIndex]);
            this.m_score = this.m_currentScore;
        }
        this.m_bubbleImage = Auxiliary.initializeImage("/bocadillo.png");
        this.m_navigationBackLabel = (short)85;
        game = null;
    }

    protected void enterPauseState(byte previousState) {
        this.m_previousGameState = previousState;
    }

    protected void exitInitState(byte nextState) {
        this.m_categoryBigImage = null;
    }

    protected void exitDescriptionState(byte nextState) {
        this.m_categorySmallImage = null;
    }

    protected void exitPlayingState(byte nextState) {
        this.m_iconImage = null;
        if (this.m_digitsBitmapFont != null) {
            this.m_digitsBitmapFont.destroy();
            this.m_digitsBitmapFont = null;
        }
    }

    protected void exitEndState(byte nextState) {
        this.m_partnerImage = null;
        this.m_bubbleImage = null;
    }

    protected void exitPauseState(byte nextState) {
    }

    public boolean isPaused() {
        return this.m_gameState == 4;
    }

    public boolean isPlaying() {
        return this.m_gameState == 2;
    }

    public void resume() {
        this.setGameState(this.m_previousGameState);
    }

    public short getNavigationOkLabel() {
        return this.m_navigationOkLabel;
    }

    public short getNavigationBackLabel() {
        return this.m_navigationBackLabel;
    }

    protected abstract void initializeGame() throws Exception;

    public boolean isFinished() {
        return this.m_finished;
    }

    public boolean isWon() {
        return this.m_correct;
    }

    public boolean isViewingCard() {
        return this.m_viewingCard;
    }

    public void setViewingCard(boolean value) {
        this.m_viewingCard = value;
    }

    public abstract byte getPeanutColor();

    public int getScore() {
        return this.m_score;
    }
}

