/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class MainScreen
extends List
implements CommandListener {
    private final Backup m_midlet;
    private final Command m_selectCommand = new Command("Select", 4, 1);
    private final Command m_exitCommand = new Command("Exit", 7, 1);

    public MainScreen(Backup midlet) {
        super("Select action", 3);
        this.m_midlet = midlet;
        this.append("Backup phone", null);
        this.append("Set backup file root", null);
        this.append("Set debug", null);
        this.append("Restore backup", null);
        this.append("Help", null);
        this.setSelectCommand(this.m_selectCommand);
        this.addCommand(this.m_exitCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_exitCommand) {
            this.m_midlet.exit();
        } else if (command == this.m_selectCommand) {
            Backup.debug("Selected item: " + this.getSelectedIndex());
            switch (this.getSelectedIndex()) {
                case 0: {
                    this.startBackup();
                    break;
                }
                case 1: {
                    this.selectRootFilesystem();
                    break;
                }
                case 2: {
                    this.setDebug();
                    break;
                }
                case 3: {
                    this.startRestore();
                    break;
                }
                case 4: {
                    this.showHelp();
                }
            }
        }
    }

    private void startBackup() {
        Backup.debug("Starting backup");
        BackupScreen screen = new BackupScreen(this.m_midlet, (Displayable)this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)screen);
    }

    private void selectRootFilesystem() {
        Backup.debug("Starting selection of root FS");
        RootFsScreen screen = new RootFsScreen(this.m_midlet, (Displayable)this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)screen);
        screen.selectRootFilesystem();
    }

    private void setDebug() {
        Backup.DEBUG = !Backup.DEBUG;
        Backup.debug("Debug set to: " + Backup.DEBUG);
        Alert alert = new Alert("Debug set", "Debug set to: " + Backup.DEBUG, null, AlertType.INFO);
        alert.setTimeout(2000);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)alert);
    }

    private void startRestore() {
        Backup.debug("Starting restore");
        RestoreScreen screen = new RestoreScreen(this.m_midlet, (Displayable)this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)screen);
    }

    private void showHelp() {
        Backup.debug("Displaying help...");
        HelpScreen screen = new HelpScreen(this.m_midlet, (Displayable)this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)screen);
    }
}

