/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;

public class BackupScreen
extends Form
implements CommandListener {
    public static final String DIVIDER = "# ========================================================================";
    public static final String EOL = "\r\n";
    private static final String[] DATA_FORMATS = new String[]{null, "VCARD/3.0", "VCALENDAR/1.0", "VCALENDAR/1.0"};
    private static final String FILE_ENCODING = "UTF-8";
    private final Backup m_midlet;
    private final Displayable m_caller;
    private final Command m_startCommand = new Command("Start", 4, 1);
    private final Command m_returnCommand = new Command("Back", 2, 1);
    private BackupFileFactory m_fileFactory = new BackupFileFactory();

    public BackupScreen(Backup midlet, Displayable caller) {
        super("Backup Phone");
        this.m_midlet = midlet;
        this.m_caller = caller;
        this.addCommand(this.m_startCommand);
        this.addCommand(this.m_returnCommand);
        this.setCommandListener(this);
        this.showStatus("Press Start to backup");
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_returnCommand) {
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent(this.m_caller);
        } else if (command == this.m_startCommand) {
            this.removeCommand(this.m_startCommand);
            this.removeCommand(this.m_returnCommand);
            this.startBackup();
            this.addCommand(this.m_returnCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackup() {
        Backup.debug("Starting in BackupScreen");
        this.deleteAll();
        this.showStatus("Backup started...");
        DataOutputStream backupStream = null;
        try {
            backupStream = this.createBackupStream();
            this.backupPimLists(backupStream, 1, "Contacts");
            this.backupPimLists(backupStream, 2, "Calendar");
            this.backupPimLists(backupStream, 3, "TODO");
        }
        catch (IOException e) {
            this.handleFileOpenError(e);
        }
        catch (Exception e) {
            this.handleGeneralException(e);
        }
        finally {
            if (backupStream != null) {
                try {
                    backupStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void showStatus(String message) {
        StringItem item = new StringItem(null, message + "\n");
        this.append((Item)item);
        System.out.println("Status message: " + message);
    }

    private DataOutputStream createBackupStream() throws IOException {
        Backup.debug("Creating backup stream");
        try {
            return this.m_fileFactory.openBackupFile(false, this);
        }
        catch (IOException e) {
            Backup.debug("Failed to open file directory - now trying to create directory and try again");
            try {
                return this.m_fileFactory.openBackupFile(true, this);
            }
            catch (IOException e2) {
                if (Backup.DEBUG) {
                    this.m_fileFactory.debugBackupFile(this);
                }
                throw e2;
            }
        }
    }

    private void backupPimLists(DataOutputStream backupFile, int listType, String title) throws IOException, PIMException {
        Backup.debug("Starting backup of lists: " + title);
        this.showStatus(title);
        String dataFormat = this.getDataFormat(listType);
        String[] lists = PIM.getInstance().listPIMLists(listType);
        for (int i = 0; i < lists.length; ++i) {
            String listName = lists[i];
            this.backupPimList(backupFile, listName, listType, title, dataFormat);
        }
    }

    private String getDataFormat(int listType) {
        String[] dataFormats = PIM.getInstance().supportedSerialFormats(listType);
        for (int i = 0; i < dataFormats.length; ++i) {
            String dataFormat = dataFormats[i];
            if (!dataFormat.equals(DATA_FORMATS[listType])) continue;
            return dataFormat;
        }
        return dataFormats[0];
    }

    private void backupPimList(DataOutputStream backupFile, String listName, int listType, String title, String dataFormat) throws IOException, PIMException {
        this.showStatus("  " + listName);
        this.writeLine(backupFile, DIVIDER);
        this.writeLine(backupFile, "# " + title + " " + listName);
        this.writeLine(backupFile, DIVIDER);
        PIMList list = PIM.getInstance().openPIMList(listType, 1, listName);
        int itemCount = 0;
        Enumeration items = list.items();
        while (items.hasMoreElements()) {
            PIMItem pimItem = (PIMItem)items.nextElement();
            this.backupPimItem(backupFile, pimItem, listType, dataFormat);
            ++itemCount;
        }
        this.writeLine(backupFile, "");
        this.writeLine(backupFile, "");
        this.showStatus("    " + itemCount + " items exported");
    }

    private void backupPimItem(DataOutputStream backupFile, PIMItem pimItem, int listType, String dataFormat) throws PIMException, IOException {
        PIM.getInstance().toSerialFormat(pimItem, (OutputStream)backupFile, FILE_ENCODING, dataFormat);
        this.writeLine(backupFile, "");
    }

    private void writeLine(DataOutputStream backupFile, String line) throws IOException {
        if (line.length() > 0) {
            ((OutputStream)backupFile).write(line.getBytes());
        }
        ((OutputStream)backupFile).write(EOL.getBytes());
        backupFile.flush();
    }

    private void handleFileOpenError(IOException e) {
        e.printStackTrace();
        String message = "Failed to open or write to backup file. Set the backup file root from the main screen, perhaps create there the folder Backup, then try again.";
        if (Backup.DEBUG) {
            message = message + "\nException: " + e.toString();
        }
        this.showErrorAlert(message);
    }

    private void handleGeneralException(Exception e) {
        e.printStackTrace();
        this.showErrorAlert("Exception: " + e.toString());
    }

    private void showErrorAlert(String message) {
        Alert alert = new Alert("Error!", message, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)alert);
    }
}

