/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.ToDo;
import javax.microedition.pim.ToDoList;

public class RestoreScreen
extends Form
implements CommandListener,
Runnable {
    private static final String FILE_ENCODING = "UTF-8";
    private final Backup m_midlet;
    private final Displayable m_caller;
    private final Command m_startCommand = new Command("Start", 4, 1);
    private final Command m_returnCommand = new Command("Cancel", 2, 1);
    private BackupFileFactory m_fileFactory = new BackupFileFactory();
    private StringBuffer debugContextInfo = new StringBuffer();
    private BackupRecordHandlerImpl recordHandler;
    private Thread restoreThread;
    private StringItem processedCountItem;

    public RestoreScreen(Backup midlet, Displayable caller) {
        super("Restore Phone");
        this.m_midlet = midlet;
        this.m_caller = caller;
        this.addCommand(this.m_startCommand);
        this.addCommand(this.m_returnCommand);
        this.setCommandListener(this);
        this.showStatus("Press Start to restore");
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_returnCommand) {
            this.stopRestoreThread();
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent(this.m_caller);
        } else if (command == this.m_startCommand) {
            this.removeCommand(this.m_startCommand);
            this.deleteAll();
            this.startRestoreThread();
        }
    }

    private void startRestoreThread() {
        if (this.restoreThread == null) {
            this.restoreThread = new Thread(this);
            this.restoreThread.start();
        }
    }

    private void stopRestoreThread() {
        if (this.restoreThread != null) {
            this.restoreThread.interrupt();
            this.restoreThread = null;
        }
        this.showStatus("Resoration interrupted.");
    }

    private void showProcessedCount(int newCount) {
        if (this.processedCountItem == null) {
            this.processedCountItem = new StringItem("Processed count:", "0");
            this.append((Item)this.processedCountItem);
        }
        this.processedCountItem.setText(String.valueOf(newCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRestore() {
        Backup.debug("Starting in RestoreScreen");
        InputStream restoreStream = null;
        try {
            restoreStream = this.createRestoreStream();
            this.restorePimLists(restoreStream);
        }
        catch (IOException e) {
            this.handleFileOpenError(e);
        }
        catch (Exception e) {
            this.handleGeneralException(e);
        }
        finally {
            if (restoreStream != null) {
                try {
                    restoreStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    void showStatus(String message) {
        StringItem item = new StringItem(null, message + "\n");
        this.append((Item)item);
        System.out.println("Status message: " + message);
    }

    private InputStream createRestoreStream() throws IOException {
        Backup.debug("Creating backup stream");
        try {
            return this.m_fileFactory.openBackupFileForRead(this);
        }
        catch (IOException e) {
            if (Backup.DEBUG) {
                this.m_fileFactory.debugRestoreFile(this);
            }
            throw e;
        }
    }

    private void restorePimLists(InputStream restoreFile) throws IOException, PIMException {
        Backup.debug("RestoreScreen.restorePimLists: Starting restore of records...");
        this.showStatus("Restore started...");
        this.recordHandler = new BackupRecordHandlerImpl(this);
        BackupParser parser = new BackupParser();
        parser.parse(restoreFile, this.recordHandler);
        this.recordHandler.close();
        this.showProcessedCount(this.recordHandler.getTotalRecordsRead());
        this.showStatus("Restore finished.\n" + this.recordHandler.getStats());
        if (Backup.DEBUG && this.recordHandler.getTotalRecordsRead() == 0) {
            this.m_fileFactory.debugRestoreFile(this);
        }
    }

    private void handleFileOpenError(IOException e) {
        e.printStackTrace();
        String message = "Failed to open the backup file.  Set the backup file root from the main screen, verify the file Backup/Backup.txt exists and try again.";
        if (Backup.DEBUG) {
            message = message + "\nException: " + e.toString();
        }
        this.showErrorAlert(message);
    }

    private void handleGeneralException(Exception e) {
        e.printStackTrace();
        String context = "";
        if (this.recordHandler != null) {
            context = "\nLast record processed: type=" + this.recordHandler.getDebugLastRecordType() + ", pim list name=" + this.recordHandler.getDebugLastPimListName();
            try {
                context = context + ", record=" + new String(this.recordHandler.getDebugLastRecord(), "ISO-8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
            context = context + "\nSo far processed: " + this.recordHandler.getStats();
        }
        this.showErrorAlert("Exception: " + e.toString() + context);
    }

    private void showErrorAlert(String message) {
        Alert alert = new Alert("Error!", message, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)alert);
    }

    public void run() {
        this.startRestore();
    }

    private static final class BackupRecordHandlerImpl
    implements BackupRecordHandler {
        private Hashtable pimLists = new Hashtable(20);
        private int contactCount = 0;
        private int eventCount = 0;
        private int todoCount = 0;
        private int failedCount = 0;
        private int currentRecordCount = 0;
        private Vector unsupportedPimListsLog = new Vector();
        private int debugLastRecordType = -1;
        private String debugLastPimListName = null;
        private byte[] debugLastRecord = null;
        private RestoreScreen parentScreen;

        public BackupRecordHandlerImpl(RestoreScreen parentScreen) {
            this.parentScreen = parentScreen;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleRecord(int recordType, String pimListName, byte[] record) {
            this.debugLastRecordType = recordType;
            this.debugLastPimListName = pimListName;
            this.debugLastRecord = record;
            ++this.currentRecordCount;
            this.parentScreen.showProcessedCount(this.currentRecordCount);
            if (record == null) {
                throw new IllegalArgumentException("record may not be null");
            }
            if (Backup.DEBUG) {
                try {
                    System.out.print("BackupRecordHandlerImpl.handleRecord(type=" + recordType + ",listName=" + pimListName + "): " + "record='" + new String(record, "ISO-8859-1") + "'.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                PIMList pimList = this.openPimList(recordType, pimListName);
                ByteArrayInputStream recordStream = new ByteArrayInputStream(record);
                PIMItem[] pimItems = PIM.getInstance().fromSerialFormat((InputStream)recordStream, RestoreScreen.FILE_ENCODING);
                PIMItem pimItem = pimItems[0];
                if (pimList instanceof ContactList) {
                    if (!(pimItem instanceof Contact)) throw new IllegalStateException("The current PIM list is a ContactList but the deserialized item isn't a Contact. This is " + this.currentRecordCount + "th record in the input file and the item is: " + pimItem);
                    pimItem = ((ContactList)pimList).importContact((Contact)pimItem);
                    ++this.contactCount;
                } else if (pimList instanceof EventList) {
                    pimItem = ((EventList)pimList).importEvent((Event)pimItem);
                    ++this.eventCount;
                } else if (pimList instanceof ToDoList) {
                    pimItem = ((ToDoList)pimList).importToDo((ToDo)pimItem);
                    ++this.todoCount;
                } else {
                    Backup.debug("WARN BackupRecordHandlerImpl.handleRecord: unknonw PIMList class: " + pimList.getClass());
                }
                pimItem.commit();
                return;
            }
            catch (PIMException e) {
                Backup.debug("BackupRecordHandlerImpl.handleRecord: exception:" + (Object)((Object)e));
                this.showError("BackupRecordHandlerImpl.handleRecord: exception:" + (Object)((Object)e));
                ++this.failedCount;
                return;
            }
            catch (IOException e) {
                Backup.debug("BackupRecordHandlerImpl.handleRecord: exception likely due to unsupported encoding 'UTF-8':" + e);
                this.showError("BackupRecordHandlerImpl.handleRecord: exception likely due to unsupported encoding 'UTF-8':" + e);
                ++this.failedCount;
            }
        }

        public void close() {
            Enumeration pimListsEnum = this.pimLists.elements();
            while (pimListsEnum.hasMoreElements()) {
                PIMList pimList = (PIMList)pimListsEnum.nextElement();
                try {
                    pimList.close();
                }
                catch (PIMException e) {
                    Backup.debug("BackupRecordHandlerImpl.close: failed for a list:" + (Object)((Object)e));
                }
            }
            this.pimLists.clear();
            Backup.debug(this.getStats());
        }

        public String getStats() {
            String unsupportedLists = this.getUnsupportedLists();
            return "Numbers of restored records: " + this.contactCount + " contacts, " + this.eventCount + " events, " + this.todoCount + " TODOs. Failed records: " + this.failedCount + ".\n" + (unsupportedLists.length() == 0 ? "" : "Lists in input that couldn't be opened (defaults used instead): " + unsupportedLists);
        }

        public int getTotalRecordsRead() {
            return this.contactCount + this.eventCount + this.todoCount;
        }

        public String getUnsupportedLists() {
            StringBuffer names = new StringBuffer();
            for (int i = 0; i < this.unsupportedPimListsLog.size(); ++i) {
                names.append(i > 0 ? "," : "");
                names.append(this.unsupportedPimListsLog.elementAt(i));
            }
            return names.toString();
        }

        public int getDebugLastRecordType() {
            return this.debugLastRecordType;
        }

        public String getDebugLastPimListName() {
            return this.debugLastPimListName;
        }

        public byte[] getDebugLastRecord() {
            return this.debugLastRecord;
        }

        private PIMList openPimList(int recordType, String pimListName) throws PIMException {
            Integer recordTypeInt;
            String qualifiedPimListName = this.getPimListTypeName(recordType) + " " + pimListName;
            PIMList pimList = null;
            if (pimListName != null && !this.unsupportedPimListsLog.contains(qualifiedPimListName) && (pimList = (PIMList)this.pimLists.get(qualifiedPimListName)) == null) {
                try {
                    pimList = PIM.getInstance().openPIMList(recordType, 2, pimListName);
                    this.pimLists.put(qualifiedPimListName, pimList);
                }
                catch (PIMException e) {
                    Backup.debug("restore: handleRecord: open pim list '" + qualifiedPimListName + "' failed: " + (Object)((Object)e));
                    this.unsupportedPimListsLog.addElement(qualifiedPimListName);
                }
                catch (Exception e) {
                    Backup.debug("restore: handleRecord: open pim list '" + qualifiedPimListName + "' failed: " + e);
                }
            }
            if (pimList == null && (pimList = (PIMList)this.pimLists.get(recordTypeInt = new Integer(recordType))) == null) {
                pimList = PIM.getInstance().openPIMList(recordType, 2);
                this.pimLists.put(recordTypeInt, pimList);
            }
            return pimList;
        }

        private String getPimListTypeName(int pimListType) {
            switch (pimListType) {
                case 1: {
                    return "Contacts";
                }
                case 2: {
                    return "Calendar";
                }
                case 3: {
                    return "TODO";
                }
            }
            return null;
        }

        private void showError(String message) {
            this.parentScreen.showStatus(message);
        }
    }
}

