/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class RootFsScreen
extends List
implements CommandListener {
    private final Backup m_midlet;
    private final Displayable m_caller;
    private final Command m_selectCommand = new Command("Select", 4, 1);
    private final Command m_returnCommand = new Command("Back", 2, 1);
    private BackupFileFactory m_fileFactory = new BackupFileFactory();

    public RootFsScreen(Backup midlet, Displayable caller) {
        super("Select backup file root", 3);
        this.m_midlet = midlet;
        this.m_caller = caller;
        this.addCommand(this.m_selectCommand);
        this.addCommand(this.m_returnCommand);
        this.setCommandListener(this);
        Display.getDisplay((MIDlet)this.m_midlet).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_selectCommand) {
            String fsRoot = this.getString(this.getSelectedIndex());
            Backup.debug("Setting backup FS root to: " + fsRoot);
            BackupFileFactory.setFilesystemRoot(fsRoot);
            String message = "Backup file root now set to:\n" + fsRoot;
            if (Backup.DEBUG) {
                message = message + this.m_fileFactory.describeFileSystem(fsRoot);
            }
            Alert alert = new Alert("Backup root set", message, null, AlertType.INFO);
            alert.setTimeout(2000);
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent(alert, this.m_caller);
        } else if (command == this.m_returnCommand) {
            Display.getDisplay((MIDlet)this.m_midlet).setCurrent(this.m_caller);
        }
    }

    public void selectRootFilesystem() {
        Enumeration fsRoots = this.m_fileFactory.getAllFilesystemRoots();
        while (fsRoots.hasMoreElements()) {
            String fsRoot = (String)fsRoots.nextElement();
            this.append(fsRoot, null);
            Backup.debug("FS root: " + fsRoot);
        }
    }
}

