/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class BufferedReader {
    protected static final int BUFFER_SIZE = 40;
    private final InputStream inputStream;
    private Vector segments = new Vector(10);
    private String readEncoding = "UTF-8";
    private int currentSegmentIdx = 0;
    private int currentOffsetInSegment = 0;

    public BufferedReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument inputStream may not be null");
        }
        this.inputStream = inputStream;
    }

    public String readLine() throws IOException {
        String result = null;
        int startSegmentIdx = this.currentSegmentIdx;
        int startSegmentOffset = this.currentOffsetInSegment;
        boolean eolFound = false;
        boolean fileEndReached = false;
        while (!(eolFound = this.moveToNextEolInSegments()) && !(fileEndReached = !this.readNextSegment())) {
        }
        boolean emptyFile = this.segments.isEmpty();
        if (eolFound || fileEndReached && !emptyFile) {
            byte[] lineBytes = this.toByteArray(startSegmentIdx, startSegmentOffset, this.currentSegmentIdx, this.currentOffsetInSegment);
            int charLength = lineBytes.length;
            result = new String(lineBytes, 0, charLength, this.getReadEncoding());
            this.discardSegmentsTillCurrent();
        }
        System.out.println("BufferedReader.readLine: read " + result);
        return result;
    }

    private void discardSegmentsTillCurrent() {
        for (int segmentIdx = 0; segmentIdx < this.currentSegmentIdx; ++segmentIdx) {
            this.segments.removeElementAt(0);
        }
        this.currentSegmentIdx = 0;
    }

    private byte[] toByteArray(int startSegmentIdx, int startSegmentOffset, int endSegmentIdx, int endSegmentOffset) {
        if (startSegmentIdx < 0 || startSegmentIdx > this.segments.size()) {
            throw new IllegalArgumentException("startSegmentIdx must be between 0 and " + this.segments.size() + " (segments.size), is: " + startSegmentIdx);
        }
        if (endSegmentIdx < startSegmentIdx || endSegmentIdx > this.segments.size()) {
            throw new IllegalArgumentException("endSegmentIdx must be between startSegmentIdx and segments.size = <" + startSegmentIdx + ", " + this.segments.size() + "> but is: " + endSegmentIdx);
        }
        if (startSegmentIdx < this.segments.size()) {
            byte[] startSegment = (byte[])this.segments.elementAt(startSegmentIdx);
            if (startSegmentOffset < 0 || startSegmentIdx >= startSegment.length) {
                throw new IllegalArgumentException("startSegmentOffset must be between 0 and " + startSegment.length + " (startSegment.length), is: " + startSegmentOffset);
            }
        }
        if (endSegmentIdx < this.segments.size()) {
            byte[] endSegment = (byte[])this.segments.elementAt(endSegmentIdx);
            if (endSegmentOffset < 0 || endSegmentOffset > endSegment.length) {
                throw new IllegalArgumentException("endSegmentOffset must be between 0 and " + endSegment.length + " (endSegment.length), is: " + endSegmentOffset);
            }
        }
        int length = 0 - startSegmentOffset + endSegmentOffset;
        for (int segmentIdx = startSegmentIdx; segmentIdx < this.segments.size() && segmentIdx < endSegmentIdx; ++segmentIdx) {
            byte[] segment = (byte[])this.segments.elementAt(segmentIdx);
            length += segment.length;
        }
        if (length < 0) {
            throw new IllegalStateException("Total length for bytes from <segments[" + startSegmentIdx + "] + " + startSegmentOffset + ", segments[" + endSegmentIdx + "] + " + endSegmentOffset + ") is " + length + ", which is not legal. Likely wrong input parameters?");
        }
        byte[] result = new byte[length];
        if (result.length > 0) {
            int currentResultOffset = 0;
            for (int segmentIdx = startSegmentIdx; segmentIdx < this.segments.size() && segmentIdx <= endSegmentIdx; ++segmentIdx) {
                int readOffset;
                byte[] segment = (byte[])this.segments.elementAt(segmentIdx);
                int n = readOffset = segmentIdx == startSegmentIdx ? startSegmentOffset : 0;
                int readLength = startSegmentIdx == endSegmentIdx ? endSegmentOffset - startSegmentOffset : (segmentIdx == startSegmentIdx ? segment.length - startSegmentOffset : (segmentIdx == endSegmentIdx ? endSegmentOffset : segment.length));
                System.arraycopy(segment, readOffset, result, currentResultOffset, readLength);
                currentResultOffset += readLength;
            }
        }
        return result;
    }

    private boolean moveToNextEolInSegments() {
        for (int i = this.currentSegmentIdx; i >= 0 && i < this.segments.size(); ++i) {
            byte[] segment = (byte[])this.segments.elementAt(i);
            int eolIdx = this.findEol(segment, this.currentOffsetInSegment);
            if (eolIdx < 0) continue;
            if (eolIdx == segment.length - 1) {
                this.currentSegmentIdx = i + 1;
                this.currentOffsetInSegment = 0;
            } else {
                this.currentSegmentIdx = i;
                this.currentOffsetInSegment = eolIdx + 1;
            }
            return true;
        }
        this.currentSegmentIdx = this.segments.size();
        this.currentOffsetInSegment = 0;
        return false;
    }

    private int findEol(byte[] haystack, int offset) {
        if (haystack == null) {
            throw new IllegalArgumentException("The byte array to search - haystack - may not be null.");
        }
        for (int i = offset; i < haystack.length; ++i) {
            if (haystack[i] != 10) continue;
            return i;
        }
        return -1;
    }

    private boolean readNextSegment() throws IOException {
        byte[] buffer = new byte[40];
        int actualReadCount = this.inputStream.read(buffer);
        if (actualReadCount <= 0) {
            return false;
        }
        if (actualReadCount < 40) {
            byte[] shrinkedBuffer = new byte[actualReadCount];
            System.arraycopy(buffer, 0, shrinkedBuffer, 0, actualReadCount);
            buffer = shrinkedBuffer;
        }
        this.segments.addElement(buffer);
        return true;
    }

    public String getReadEncoding() {
        return this.readEncoding;
    }

    public void setReadEncoding(String readEncoding) {
        if (readEncoding == null) {
            throw new IllegalArgumentException("readEncoding may not be null");
        }
        this.readEncoding = readEncoding;
    }
}

