/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

public class MTBitfield {
    private byte[] bitField;
    private int lengthInBites;

    public MTBitfield(int n, boolean bl) {
        this.lengthInBites = n;
        int n2 = n / 8;
        if (n % 8 > 0) {
            ++n2;
        }
        this.bitField = new byte[n2];
        int n3 = bl ? -1 : 0;
        for (int i = 0; i < this.bitField.length; ++i) {
            this.bitField[i] = n3;
        }
    }

    public MTBitfield(byte[] byArray) {
        this.bitField = byArray;
    }

    public void setBit(int n) {
        int n2 = n / 8;
        this.bitField[n2] = (byte)(this.bitField[n2] | 128 >> n % 8);
    }

    public void unsetBit(int n) {
        int n2 = n / 8;
        this.bitField[n2] = (byte)(this.bitField[n2] & ~(128 >> n % 8));
    }

    public boolean isNull() {
        for (int i = 0; i < this.bitField.length; ++i) {
            if (this.bitField[i] == 0) continue;
            return false;
        }
        return true;
    }

    public MTBitfield clone() {
        byte[] byArray = new byte[this.bitField.length];
        System.arraycopy(this.bitField, 0, byArray, 0, this.bitField.length);
        return new MTBitfield(byArray);
    }

    public void bitwiseNot() {
        for (int i = 0; i < this.bitField.length; ++i) {
            this.bitField[i] = ~this.bitField[i];
        }
    }

    public void bitwiseAnd(MTBitfield mTBitfield) {
        for (int i = 0; i < this.bitField.length; ++i) {
            this.bitField[i] = (byte)(this.bitField[i] & mTBitfield.data()[i]);
        }
    }

    public void set(byte[] byArray) {
        this.bitField = null;
        this.bitField = byArray;
    }

    public boolean isBitSet(int n) {
        return (128 >> n % 8 & this.bitField[n / 8]) > 0;
    }

    public byte[] data() {
        return this.bitField;
    }

    public int lengthInBytes() {
        return this.bitField.length;
    }

    public String getLogData() {
        String string = "";
        for (int i = 0; i < this.bitField.length * 8; ++i) {
            string = this.isBitSet(i) ? string + "1" : string + "0";
        }
        return string;
    }

    public int getLengthInBites() {
        return this.lengthInBites;
    }
}

