/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.game;

import com.jarbull.basket.game.TrainingCanvas;
import com.jarbull.basket.inGame.Ball;
import com.jarbull.basket.inGame.Golge;
import com.jarbull.basket.inGame.Pota;
import com.jarbull.basket.inGame.Wall;
import com.jarbull.basket.tools.ArrowCollection;
import com.jarbull.basket.tools.DirectionAssistant;
import com.jarbull.basket.tools.Gauge;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.MathEx;
import com.jarbull.basket.tools.RandomGenerator;
import com.jarbull.basket.tools.ScoreAndTimeTraining;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class TrainingProcessor
implements Runnable {
    private static boolean isRunning;
    private static boolean isPaused;
    private Thread t;
    LayerManager layerManager;
    Ball ball;
    Golge golge;
    Pota pota;
    DirectionAssistant dirAssistant;
    private boolean shootDone = false;
    private boolean placeOk = false;
    TrainingCanvas canvas;
    Gauge gauge;
    Wall normalZemin;
    Wall ilkZemin;
    boolean prepareObjectsFinished;
    ScoreAndTimeTraining scoreAndTime;
    int zeminCrashCount;
    ArrowCollection arrowCollection;
    Sprite pts2Zone;
    Sprite handSign;

    public TrainingProcessor(TrainingCanvas canvas) throws IOException {
        this.canvas = canvas;
        this.dirAssistant = new DirectionAssistant();
        this.layerManager = new LayerManager();
        this.arrowCollection = new ArrowCollection(Image.createImage((String)"/res/img/transArrow.png"), Image.createImage((String)"/res/img/normalArrow.png"), 60, 60, this.layerManager);
        this.pts2Zone = new Sprite(ImageHandler.getInstance().getImage("/res/img/2ptsZone.png"));
        this.handSign = new Sprite(ImageHandler.getInstance().getImage("/res/img/2ptsHandSign.png"));
        this.layerManager.append((Layer)this.handSign);
        this.layerManager.insert((Layer)this.pts2Zone, this.layerManager.getSize());
        this.pts2Zone.setPosition(117, 203);
        this.gauge = new Gauge();
        try {
            this.pota = new Pota(this.layerManager, 0, 20);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.handSign.setPosition(90, 0);
        try {
            this.ball = new Ball(this.layerManager, 180, 210);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        TiledLayer backLayer = new TiledLayer(1, 1, ImageHandler.getInstance().getImage("/res/img/bg.png"), 240, 320);
        backLayer.setCell(0, 0, 1);
        backLayer.setPosition(0, 0);
        this.layerManager.append((Layer)backLayer);
        this.dirAssistant.attachBall(this.ball);
        this.gauge.setSize(50, 10);
        this.golge = new Golge(this.layerManager, this.ball.getX(), this.ball.getY() + 20);
        this.normalZemin = this.generateZemin();
        this.scoreAndTime = new ScoreAndTimeTraining();
        isRunning = true;
        isPaused = false;
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void kill() {
        isRunning = false;
    }

    public void pause() {
        isPaused = true;
    }

    public void resume() {
        isPaused = false;
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void shoot() {
        this.pota.neverCheck = false;
        this.pota.ballXbeforeShoot = this.ball.getX();
        this.pota.ballYbeforeShoot = this.ball.getY();
        this.pota.check1 = false;
        this.ball.fileyeCarpti = false;
        this.ball.basketOldu = false;
        double angle = this.dirAssistant.getAngle();
        double angleRadian = Math.toRadians(angle);
        double velocity = this.gauge.getValue() / 10 + 8;
        this.gauge.setVisible(false);
        this.ball.velocityX = velocity * Math.cos(angleRadian);
        this.ball.velocityY = velocity * Math.sin(angleRadian);
        this.dirAssistant.visible = false;
        this.shootDone = true;
    }

    public void prepareObjects() {
        this.prepareObjectsFinished = false;
        RandomGenerator.getInstance().generateBallPlace(this.ball);
        this.ball.velocityX = 0.0;
        this.ball.velocityY = 0.0;
        this.golge.attachBall(this.ball);
        this.golge.setPosition(this.ball.getX(), this.ball.getY() + 20);
        this.dirAssistant.visible = false;
        this.gauge.setVisible(false);
        this.arrowCollection.setVisible(true);
        this.shootDone = false;
        this.zeminCrashCount = 0;
        this.arrowCollection.setPosition(this.ball.getX() + this.ball.getWidth() / 2 - this.arrowCollection.getWidth() / 2, this.ball.getY() + this.ball.getHeight() / 2 - this.arrowCollection.getHeight() / 2);
        this.placeOk = false;
        this.prepareObjectsFinished = true;
    }

    public int calculateAssistantAngle() {
        double radians = MathEx.atan(this.ball.getY() + this.ball.getHeight() / 2 - (this.pota.getY() + this.pota.getHeight() / 2), this.ball.getX() + this.ball.getWidth() / 2 - (this.pota.getX() + this.pota.getWidth() / 2));
        return (int)Math.toDegrees(radians);
    }

    private Wall generateZemin() {
        Image zeminImg_1 = Image.createImage((int)240, (int)24);
        zeminImg_1 = Image.createImage((int)240, (int)24);
        Graphics g = zeminImg_1.getGraphics();
        g.drawLine(0, 0, zeminImg_1.getWidth(), zeminImg_1.getHeight());
        int[] rgbData = new int[zeminImg_1.getWidth() * zeminImg_1.getHeight()];
        rgbData = new int[zeminImg_1.getWidth() * zeminImg_1.getHeight()];
        zeminImg_1.getRGB(rgbData, 0, zeminImg_1.getWidth(), 0, 0, zeminImg_1.getWidth(), zeminImg_1.getHeight());
        for (int i = 0; i < zeminImg_1.getWidth() * zeminImg_1.getHeight(); ++i) {
            if ((rgbData[i] & 0xFFFFFF) >> 16 <= 200) continue;
            rgbData[i] = 0;
        }
        zeminImg_1 = Image.createRGBImage((int[])rgbData, (int)zeminImg_1.getWidth(), (int)zeminImg_1.getHeight(), (boolean)true);
        Wall zemin = new Wall(0, 180, 2, zeminImg_1);
        return zemin;
    }

    private Wall generateZemin(Ball ball) {
        Image zeminImg = Image.createImage((int)ball.getCenterX(), (int)(ball.getCenterY() - 180 + 20));
        zeminImg = Image.createImage((int)ball.getCenterX(), (int)(ball.getCenterY() - 180 + 20));
        Graphics g = zeminImg.getGraphics();
        g.drawLine(0, 0, zeminImg.getWidth(), zeminImg.getHeight());
        int[] rgbData = new int[zeminImg.getWidth() * zeminImg.getHeight()];
        zeminImg.getRGB(rgbData, 0, zeminImg.getWidth(), 0, 0, zeminImg.getWidth(), zeminImg.getHeight());
        for (int i = 0; i < zeminImg.getWidth() * zeminImg.getHeight(); ++i) {
            if ((rgbData[i] & 0xFFFFFF) >> 16 <= 200) continue;
            rgbData[i] = 0;
        }
        zeminImg = Image.createRGBImage((int[])rgbData, (int)zeminImg.getWidth(), (int)zeminImg.getHeight(), (boolean)true);
        Wall zemin = new Wall(0, 180, 2, zeminImg);
        return zemin;
    }

    private void checkCollisions() {
        this.pota.checkCollision(this.ball);
        if (this.ball.velocityX > 0.0 && this.ball.velocityY > 0.0) {
            if (this.normalZemin.checkCollision(this.ball)) {
                this.normalZemin.responseCollision(this.ball, false);
                ++this.zeminCrashCount;
            }
        } else if (this.ilkZemin.checkCollision(this.ball)) {
            this.ilkZemin.responseCollision(this.ball, false);
            ++this.zeminCrashCount;
        }
        if (this.zeminCrashCount > 1 || this.ball.getX() < -10 || this.ball.getX() > 240 || this.ball.getY() > 320) {
            this.prepareObjects();
            this.scoreAndTime.startTime();
        }
    }

    public void checkZone() {
        if (this.ball.collidesWith(this.pts2Zone, true)) {
            this.handSign.setImage(ImageHandler.getInstance().getImage("/res/img/2ptsHandSign.png"), this.handSign.getWidth(), this.handSign.getHeight());
            this.pota.pointsToIncrease = 2;
        } else {
            this.handSign.setImage(ImageHandler.getInstance().getImage("/res/img/3ptsHandSign.png"), this.handSign.getWidth(), this.handSign.getHeight());
            this.pota.pointsToIncrease = 3;
        }
    }

    public void run() {
        this.scoreAndTime.stopTime();
        this.prepareObjects();
        this.scoreAndTime.startTime();
        while (isRunning) {
            if (!isPaused) {
                this.keyPressed();
                if (!this.shootDone) {
                    this.checkZone();
                }
                if (this.shootDone) {
                    this.ball.move();
                    this.golge.move();
                    this.checkCollisions();
                }
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.clear();
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().clearFonts();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
        System.gc();
    }

    public void clear() {
        for (int i = this.layerManager.getSize() - 1; i > -1; --i) {
            this.layerManager.remove(this.layerManager.getLayerAt(i));
        }
        this.layerManager = null;
        this.ball.kill();
        this.ball = null;
        this.dirAssistant = null;
        this.pota.clear();
        this.pota = null;
        this.canvas = null;
        this.gauge.clear();
        this.gauge = null;
        this.normalZemin = null;
        this.ilkZemin = null;
        this.scoreAndTime.clear();
        this.scoreAndTime = null;
        this.arrowCollection.clear();
        this.arrowCollection = null;
        this.pts2Zone = null;
        this.handSign = null;
        this.golge = null;
        System.gc();
    }

    public void keyPressed() {
        int keyCode = this.canvas.getKeyStates();
        if (!this.placeOk) {
            int i;
            if (keyCode == 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
            }
            if ((keyCode & 0x100) != 0) {
                this.placeOk = true;
                this.gauge.setVisible(true);
                this.gauge.setLocation(this.ball.getCenterX() - this.gauge.getWidth() / 2, this.ball.getCenterY() + 20);
                if (this.gauge.getX() + this.gauge.getWidth() > 240) {
                    this.gauge.setLocation(this.gauge.getX() - this.gauge.getWidth() / 2, this.gauge.getY());
                }
                if (this.gauge.getY() + this.gauge.getHeight() > 320) {
                    this.gauge.setLocation(this.gauge.getX(), this.gauge.getY() - 65);
                }
                this.dirAssistant.setAngle((this.calculateAssistantAngle() + 180) % 360);
                this.dirAssistant.visible = true;
                this.arrowCollection.setVisible(false);
                this.ilkZemin = this.generateZemin(this.ball);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.canvas.getKeyStates();
                return;
            }
            if ((keyCode & 4) != 0 && this.ball.getX() > 117) {
                this.ball.move(-2, 0);
                this.golge.move(-2, 0);
                this.arrowCollection.setPosition(this.arrowCollection.getX() - 2, this.arrowCollection.getY());
            }
            if ((keyCode & 0x20) != 0 && this.ball.getX() < 220) {
                this.ball.move(2, 0);
                this.golge.move(2, 0);
                this.arrowCollection.setPosition(this.arrowCollection.getX() + 2, this.arrowCollection.getY());
            }
            if ((keyCode & 2) != 0 && this.ball.getY() > 203) {
                this.ball.move(0, -2);
                this.golge.move(0, -2);
                this.arrowCollection.setPosition(this.arrowCollection.getX(), this.arrowCollection.getY() - 2);
            }
            if ((keyCode & 0x40) != 0 && this.ball.getY() < 300) {
                this.ball.move(0, 2);
                this.golge.move(0, 2);
                this.arrowCollection.setPosition(this.arrowCollection.getX(), this.arrowCollection.getY() + 2);
            }
            if ((keyCode & 4) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[2].setVisible(true);
                if ((keyCode & 0x20) != 0) {
                    this.arrowCollection.normalArrowSprites[0].setVisible(true);
                }
                if ((keyCode & 2) != 0) {
                    this.arrowCollection.normalArrowSprites[3].setVisible(true);
                }
                if ((keyCode & 0x40) != 0) {
                    this.arrowCollection.normalArrowSprites[1].setVisible(true);
                }
            } else if ((keyCode & 0x20) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[0].setVisible(true);
                if ((keyCode & 2) != 0) {
                    this.arrowCollection.normalArrowSprites[3].setVisible(true);
                }
                if ((keyCode & 0x40) != 0) {
                    this.arrowCollection.normalArrowSprites[1].setVisible(true);
                }
            } else if ((keyCode & 2) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[3].setVisible(true);
                if ((keyCode & 0x40) != 0) {
                    this.arrowCollection.normalArrowSprites[1].setVisible(true);
                }
            } else if ((keyCode & 0x40) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[1].setVisible(true);
            }
        }
        if (this.placeOk) {
            if ((keyCode & 4) != 0 && this.dirAssistant.getAngle() > 183.0) {
                this.dirAssistant.decreaseAngle();
            }
            if ((keyCode & 0x20) != 0 && this.dirAssistant.getAngle() < 267.0) {
                this.dirAssistant.increaseAngle();
            }
            if ((keyCode & 0x100) != 0 && !this.shootDone) {
                this.shoot();
                this.scoreAndTime.timeStopped = true;
            }
        }
    }
}

