/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.game;

import com.jarbull.basket.game.BasketCanvas;
import com.jarbull.basket.inGame.Ball;
import com.jarbull.basket.inGame.Golge;
import com.jarbull.basket.inGame.Pota;
import com.jarbull.basket.inGame.Wall;
import com.jarbull.basket.screens.BeforeGameScreen;
import com.jarbull.basket.screens.DefaultTextScreen;
import com.jarbull.basket.screens.ImageShowScreen;
import com.jarbull.basket.tools.ArrowCollection;
import com.jarbull.basket.tools.DataHolder;
import com.jarbull.basket.tools.DirectionAssistant;
import com.jarbull.basket.tools.Gauge;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.basket.tools.MathEx;
import com.jarbull.basket.tools.RandomGenerator;
import com.jarbull.basket.tools.ScoreAndTimeGame;
import com.jarbull.basket.tools.XML_Parser;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import com.jarbull.jbf.util.KeyCodeAdapter;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class BasketProcessor
implements Runnable {
    private static boolean isRunning;
    private static boolean isPaused;
    private Thread t;
    LayerManager layerManager;
    Ball ball;
    Golge golge;
    Pota pota;
    DirectionAssistant dirAssistant;
    private boolean shootDone = false;
    public boolean placeOk = false;
    BasketCanvas canvas;
    Gauge gauge;
    Wall normalZemin;
    Wall ilkZemin;
    boolean prepareObjectsFinished;
    ScoreAndTimeGame scoreAndTime;
    int zeminCrashCount;
    ArrowCollection arrowCollection;
    Sprite pts2Zone;
    Sprite handSign;

    public BasketProcessor(BasketCanvas canvas) throws IOException {
        this.canvas = canvas;
        this.dirAssistant = new DirectionAssistant();
        this.layerManager = new LayerManager();
        this.arrowCollection = new ArrowCollection(Image.createImage((String)"/res/img/transArrow.png"), Image.createImage((String)"/res/img/normalArrow.png"), 60, 60, this.layerManager);
        this.pts2Zone = new Sprite(ImageHandler.getInstance().getImage("/res/img/2ptsZone.png"));
        this.handSign = new Sprite(ImageHandler.getInstance().getImage("/res/img/2ptsHandSign.png"));
        this.layerManager.append((Layer)this.handSign);
        this.layerManager.insert((Layer)this.pts2Zone, this.layerManager.getSize());
        this.pts2Zone.setPosition(70, 99);
        this.gauge = new Gauge();
        try {
            this.pota = new Pota(this.layerManager, -15, -10);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.handSign.setPosition(0, 135);
        try {
            this.ball = new Ball(this.layerManager, 180, 210);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        TiledLayer backLayer = new TiledLayer(1, 1, ImageHandler.getInstance().getImage("/res/img/bg.png"), 128, 160);
        backLayer.setCell(0, 0, 1);
        backLayer.setPosition(0, 0);
        this.layerManager.append((Layer)backLayer);
        this.dirAssistant.attachBall(this.ball);
        this.gauge.setSize(50, 10);
        this.golge = new Golge(this.layerManager, this.ball.getX(), this.ball.getY() + 20);
        this.normalZemin = this.generateZemin();
        this.scoreAndTime = new ScoreAndTimeGame();
        isRunning = true;
        isPaused = false;
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void kill() {
        isRunning = false;
    }

    public void pause() {
        isPaused = true;
    }

    public void resume() {
        isPaused = false;
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void shoot() {
        this.pota.neverCheck = false;
        this.pota.ballXbeforeShoot = this.ball.getX();
        this.pota.ballYbeforeShoot = this.ball.getY();
        this.pota.check1 = false;
        this.ball.fileyeCarpti = false;
        this.ball.basketOldu = false;
        double angle = this.dirAssistant.getAngle();
        double angleRadian = Math.toRadians(angle);
        double velocity = this.gauge.getValue() / 20 + 8;
        this.gauge.setVisible(false);
        this.ball.velocityX = velocity * Math.cos(angleRadian);
        this.ball.velocityY = velocity * Math.sin(angleRadian);
        this.dirAssistant.visible = false;
        this.shootDone = true;
    }

    private void prepareLevel() {
        XML_Parser parsedFile = new XML_Parser();
        parsedFile.parseFile();
        parsedFile = null;
        this.scoreAndTime.setLevelPoints(Integer.parseInt(DataHolder.getInstance().levelInfo.get("pointToReach").toString()));
        this.scoreAndTime.setTime(Integer.parseInt(DataHolder.getInstance().levelInfo.get("timeInSec").toString()));
    }

    public void prepareObjects() {
        this.prepareObjectsFinished = false;
        RandomGenerator.getInstance().generateBallPlace(this.ball);
        this.ball.velocityX = 0.0;
        this.ball.velocityY = 0.0;
        this.golge.attachBall(this.ball);
        this.golge.setPosition(this.ball.getX(), this.ball.getY() + 20);
        this.dirAssistant.visible = false;
        this.gauge.setVisible(false);
        this.arrowCollection.setVisible(true);
        this.shootDone = false;
        this.zeminCrashCount = 0;
        this.arrowCollection.setPosition(this.ball.getX() + this.ball.getWidth() / 2 - this.arrowCollection.getWidth() / 2, this.ball.getY() + this.ball.getHeight() / 2 - this.arrowCollection.getHeight() / 2);
        this.placeOk = false;
        this.prepareObjectsFinished = true;
    }

    public int calculateAssistantAngle() {
        double radians = MathEx.atan(this.ball.getY() + this.ball.getHeight() / 2 - (this.pota.getY() + this.pota.getHeight() / 2), this.ball.getX() + this.ball.getWidth() / 2 - (this.pota.getX() + this.pota.getWidth() / 2));
        return (int)Math.toDegrees(radians);
    }

    private Wall generateZemin() {
        Image zeminImg_1 = Image.createImage((int)128, (int)12);
        zeminImg_1 = Image.createImage((int)128, (int)12);
        Graphics g = zeminImg_1.getGraphics();
        g.drawLine(0, 0, zeminImg_1.getWidth(), zeminImg_1.getHeight());
        int[] rgbData = new int[zeminImg_1.getWidth() * zeminImg_1.getHeight()];
        rgbData = new int[zeminImg_1.getWidth() * zeminImg_1.getHeight()];
        zeminImg_1.getRGB(rgbData, 0, zeminImg_1.getWidth(), 0, 0, zeminImg_1.getWidth(), zeminImg_1.getHeight());
        for (int i = 0; i < zeminImg_1.getWidth() * zeminImg_1.getHeight(); ++i) {
            if ((rgbData[i] & 0xFFFFFF) >> 16 <= 200) continue;
            rgbData[i] = 0;
        }
        zeminImg_1 = Image.createRGBImage((int[])rgbData, (int)zeminImg_1.getWidth(), (int)zeminImg_1.getHeight(), (boolean)true);
        Wall zemin = new Wall(0, 90, 2, zeminImg_1);
        return zemin;
    }

    private Wall generateZemin(Ball ball) {
        Image zeminImg = Image.createImage((int)ball.getCenterX(), (int)(ball.getCenterY() - 90 + 20));
        zeminImg = Image.createImage((int)ball.getCenterX(), (int)(ball.getCenterY() - 90 + 20));
        Graphics g = zeminImg.getGraphics();
        g.drawLine(0, 0, zeminImg.getWidth(), zeminImg.getHeight());
        int[] rgbData = new int[zeminImg.getWidth() * zeminImg.getHeight()];
        zeminImg.getRGB(rgbData, 0, zeminImg.getWidth(), 0, 0, zeminImg.getWidth(), zeminImg.getHeight());
        for (int i = 0; i < zeminImg.getWidth() * zeminImg.getHeight(); ++i) {
            if ((rgbData[i] & 0xFFFFFF) >> 16 <= 200) continue;
            rgbData[i] = 0;
        }
        zeminImg = Image.createRGBImage((int[])rgbData, (int)zeminImg.getWidth(), (int)zeminImg.getHeight(), (boolean)true);
        Wall zemin = new Wall(0, 90, 2, zeminImg);
        return zemin;
    }

    private void checkCollisions() {
        this.pota.checkCollision(this.ball);
        if (this.ball.velocityX > 0.0 && this.ball.velocityY > 0.0) {
            if (this.normalZemin.checkCollision(this.ball)) {
                this.normalZemin.responseCollision(this.ball, false);
                ++this.zeminCrashCount;
            }
        } else if (this.ilkZemin.checkCollision(this.ball)) {
            this.ilkZemin.responseCollision(this.ball, false);
            ++this.zeminCrashCount;
        }
        if (this.zeminCrashCount > 1 || this.ball.getX() < -10 || this.ball.getX() > 128 || this.ball.getY() > 160) {
            this.prepareObjects();
            this.scoreAndTime.startTime();
        }
    }

    private void checkTime() {
        if (this.scoreAndTime.getTime() > 0) {
            return;
        }
        if (this.scoreAndTime.getPoints() >= this.scoreAndTime.getLevelPoints()) {
            if (DataHolder.getInstance().levelCount == DataHolder.getInstance().levelNo) {
                this.pause();
                this.scoreAndTime.stopTime();
                int scorePoints = this.scoreAndTime.getPoints() * 100;
                int levelBonusPoints = 1000;
                int extraScorePoints = (this.scoreAndTime.getPoints() - this.scoreAndTime.getLevelPoints()) * 200;
                DataHolder.getInstance().score += scorePoints + levelBonusPoints + extraScorePoints;
                DefaultTextScreen gameFinished = new DefaultTextScreen(this.canvas.m);
                gameFinished.addText("Congratulations", "10x10-beyaz");
                gameFinished.addText("You Win", "10x10-beyaz");
                gameFinished.addText(" ");
                gameFinished.addText("Score: " + DataHolder.getInstance().score, "10x10-beyaz");
                gameFinished.addText(" ");
                gameFinished.addText("Press any key");
                gameFinished.addText("to continue...");
                System.gc();
                ImageHandler.getInstance().clearImageBuffer();
                JBManager.getInstance().addAction(new JBAction(this, "clearti"));
                ImageShowScreen imageShow = null;
                try {
                    imageShow = new ImageShowScreen(this.canvas.m, Image.createImage((String)("/res/img/figures/" + DataHolder.getInstance().levelNo + ".jpg")));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                imageShow.show();
                Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)imageShow);
                imageShow.setState(0);
                imageShow.waitForClose();
                Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)this.canvas);
                gameFinished.show();
                Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)gameFinished);
                gameFinished.setState(0);
                gameFinished.waitForClose();
                JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(DataHolder.getInstance().score));
                try {
                    if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < DataHolder.getInstance().score) {
                        JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(DataHolder.getInstance().score));
                    }
                }
                catch (Exception ex) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(DataHolder.getInstance().score));
                }
                DataHolder.getInstance().levelNo = 1;
                DataHolder.getInstance().score = 0;
                isRunning = false;
                this.canvas.stopProcessing();
                System.gc();
                ImageHandler.getInstance().clearImageBuffer();
                JBManager.getInstance().clearFonts();
                JBManager.getInstance().addAction(new JBAction(this, "clearti"));
                KeyCodeAdapter.getInstance().setCanvas(null);
                this.canvas.m.openPauseMenu();
                JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
                this.canvas.m.destroyJBApp(true, "gameOver");
                return;
            }
            this.pause();
            this.scoreAndTime.stopTime();
            int scorePoints = this.scoreAndTime.getPoints() * 100;
            int levelBonusPoints = 1000;
            int extraScorePoints = (this.scoreAndTime.getPoints() - this.scoreAndTime.getLevelPoints()) * 200;
            DataHolder.getInstance().score += scorePoints + levelBonusPoints + extraScorePoints;
            DefaultTextScreen levelEnd = new DefaultTextScreen(this.canvas.m);
            levelEnd.addText("Level Completed", "10x10-beyaz");
            levelEnd.addText(" ");
            levelEnd.addText("Points: " + DataHolder.getInstance().score, "10x10-beyaz");
            levelEnd.addText(" ");
            levelEnd.addText("Press any key for");
            levelEnd.addText("next level.");
            levelEnd.show();
            Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)levelEnd);
            levelEnd.setState(0);
            levelEnd.waitForClose();
            System.gc();
            ImageHandler.getInstance().clearImageBuffer();
            JBManager.getInstance().addAction(new JBAction(this, "clearti"));
            ImageShowScreen imageShow = null;
            try {
                imageShow = new ImageShowScreen(this.canvas.m, Image.createImage((String)("/res/img/figures/" + DataHolder.getInstance().levelNo + ".jpg")));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            imageShow.show();
            Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)imageShow);
            imageShow.setState(0);
            imageShow.waitForClose();
            Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)this.canvas);
            ++DataHolder.getInstance().levelNo;
            ScoreAndTimeGame.setPoints(0);
            this.prepareLevel();
            DefaultTextScreen levelBefore = new DefaultTextScreen(this.canvas.m);
            levelBefore.addText("Next Level:");
            levelBefore.addText(" ");
            levelBefore.addText("Time: " + DataHolder.getInstance().levelInfo.get("timeInSec"), "10x10-beyaz");
            levelBefore.addText("Target score: " + DataHolder.getInstance().levelInfo.get("pointToReach"), "10x10-beyaz");
            levelBefore.addText(" ");
            levelBefore.addText("Extra points will give you");
            levelBefore.addText("a higher score!");
            levelBefore.addText(" ");
            levelBefore.addText("Press any key.");
            levelBefore.show();
            Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)levelBefore);
            levelBefore.setState(0);
            levelBefore.waitForClose();
            Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)this.canvas);
            this.prepareObjects();
            this.resume();
            this.scoreAndTime.startTime();
        } else {
            this.pause();
            this.scoreAndTime.stopTime();
            DefaultTextScreen gameOver = new DefaultTextScreen(this.canvas.m);
            gameOver.addText("Game Over", "10x10-beyaz");
            gameOver.addText(" ");
            gameOver.addText("You Failed", "10x10-beyaz");
            gameOver.addText(" ");
            gameOver.addText("Score: " + DataHolder.getInstance().score, "10x10-beyaz");
            gameOver.addText(" ");
            gameOver.addText("Press any key");
            gameOver.addText("to continue...");
            gameOver.show();
            Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)gameOver);
            gameOver.setState(0);
            gameOver.waitForClose();
            JBManager.getInstance().gameSettings.putAndSave("score:mylast", Integer.toString(DataHolder.getInstance().score));
            try {
                if (Integer.parseInt(JBManager.getInstance().gameSettings.get("score:mytop")) < DataHolder.getInstance().score) {
                    JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(DataHolder.getInstance().score));
                }
            }
            catch (Exception ex) {
                JBManager.getInstance().gameSettings.putAndSave("score:mytop", Integer.toString(DataHolder.getInstance().score));
            }
            DataHolder.getInstance().levelNo = 1;
            DataHolder.getInstance().score = 0;
            isRunning = false;
            this.canvas.stopProcessing();
            System.gc();
            ImageHandler.getInstance().clearImageBuffer();
            JBManager.getInstance().clearFonts();
            JBManager.getInstance().addAction(new JBAction(this, "clearti"));
            KeyCodeAdapter.getInstance().setCanvas(null);
            this.canvas.m.openPauseMenu();
            JBManager.getInstance().addAction(new JBAction(this, "TOP:T0"));
            this.canvas.m.destroyJBApp(true, "gameOver");
        }
    }

    public void checkZone() {
        if (this.ball.collidesWith(this.pts2Zone, true)) {
            this.handSign.setImage(ImageHandler.getInstance().getImage("/res/img/2ptsHandSign.png"), this.handSign.getWidth(), this.handSign.getHeight());
            this.pota.pointsToIncrease = 2;
        } else {
            this.handSign.setImage(ImageHandler.getInstance().getImage("/res/img/3ptsHandSign.png"), this.handSign.getWidth(), this.handSign.getHeight());
            this.pota.pointsToIncrease = 3;
        }
    }

    public void run() {
        isPaused = true;
        int keyCode = this.canvas.getKeyStates();
        this.scoreAndTime.stopTime();
        BeforeGameScreen beforeSecreen = new BeforeGameScreen(this.canvas.m);
        beforeSecreen.show();
        beforeSecreen.waitForClose();
        Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)this.canvas);
        this.prepareLevel();
        DefaultTextScreen levelBefore = new DefaultTextScreen(this.canvas.m);
        levelBefore.addText("Next Level:");
        levelBefore.addText(" ");
        levelBefore.addText("Time: " + DataHolder.getInstance().levelInfo.get("timeInSec"), "10x10-beyaz");
        levelBefore.addText("Target score: " + DataHolder.getInstance().levelInfo.get("pointToReach"), "10x10-beyaz");
        levelBefore.addText(" ");
        levelBefore.addText("Extra points will give you");
        levelBefore.addText("a higher score!");
        levelBefore.addText(" ");
        levelBefore.addText("Press any key.");
        levelBefore.show();
        Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)levelBefore);
        levelBefore.setState(0);
        levelBefore.waitForClose();
        Display.getDisplay((MIDlet)this.canvas.m).setCurrent((Displayable)this.canvas);
        this.prepareObjects();
        isPaused = false;
        this.scoreAndTime.startTime();
        while (isRunning) {
            if (!isPaused) {
                this.keyPressed();
                if (!this.shootDone) {
                    this.checkZone();
                }
                if (this.shootDone) {
                    this.ball.move();
                    this.golge.move();
                    this.checkCollisions();
                }
                this.checkTime();
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.clear();
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().clearFonts();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
        System.gc();
    }

    public void clear() {
        for (int i = this.layerManager.getSize() - 1; i > -1; --i) {
            this.layerManager.remove(this.layerManager.getLayerAt(i));
        }
        this.layerManager = null;
        this.ball.kill();
        this.ball = null;
        this.dirAssistant = null;
        this.pota.clear();
        this.pota = null;
        this.canvas = null;
        this.gauge.clear();
        this.gauge = null;
        this.normalZemin = null;
        this.ilkZemin = null;
        this.scoreAndTime.clear();
        this.scoreAndTime = null;
        this.arrowCollection.clear();
        this.arrowCollection = null;
        this.pts2Zone = null;
        this.handSign = null;
        this.golge = null;
        System.gc();
    }

    public void keyPressed() {
        int keyCode = this.canvas.getKeyStates();
        if (!this.placeOk && Display.getDisplay((MIDlet)this.canvas.m).getCurrent().equals(this.canvas)) {
            int i;
            if (keyCode == 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
            }
            if ((keyCode & 0x100) != 0) {
                this.placeOk = true;
                this.gauge.setVisible(true);
                this.gauge.setLocation(this.ball.getCenterX() - this.gauge.getWidth() / 2, this.ball.getCenterY() + 20);
                if (this.gauge.getX() + this.gauge.getWidth() > 128) {
                    this.gauge.setLocation(this.gauge.getX() - this.gauge.getWidth() / 2, this.gauge.getY());
                }
                if (this.gauge.getY() + this.gauge.getHeight() > 160) {
                    this.gauge.setLocation(this.gauge.getX(), this.gauge.getY() - 65);
                }
                this.dirAssistant.setAngle((this.calculateAssistantAngle() + 180) % 360);
                this.dirAssistant.visible = true;
                this.arrowCollection.setVisible(false);
                this.ilkZemin = this.generateZemin(this.ball);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.canvas.getKeyStates();
                return;
            }
            if ((keyCode & 4) != 0 && this.ball.getX() > 70) {
                this.ball.move(-2, 0);
                this.golge.move(-2, 0);
                this.arrowCollection.setPosition(this.arrowCollection.getX() - 2, this.arrowCollection.getY());
            }
            if ((keyCode & 0x20) != 0 && this.ball.getX() < 108) {
                this.ball.move(2, 0);
                this.golge.move(2, 0);
                this.arrowCollection.setPosition(this.arrowCollection.getX() + 2, this.arrowCollection.getY());
            }
            if ((keyCode & 2) != 0 && this.ball.getY() > 99) {
                this.ball.move(0, -2);
                this.golge.move(0, -2);
                this.arrowCollection.setPosition(this.arrowCollection.getX(), this.arrowCollection.getY() - 2);
            }
            if ((keyCode & 0x40) != 0 && this.ball.getY() < 140) {
                this.ball.move(0, 2);
                this.golge.move(0, 2);
                this.arrowCollection.setPosition(this.arrowCollection.getX(), this.arrowCollection.getY() + 2);
            }
            if ((keyCode & 4) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[2].setVisible(true);
                if ((keyCode & 0x20) != 0) {
                    this.arrowCollection.normalArrowSprites[0].setVisible(true);
                }
                if ((keyCode & 2) != 0) {
                    this.arrowCollection.normalArrowSprites[3].setVisible(true);
                }
                if ((keyCode & 0x40) != 0) {
                    this.arrowCollection.normalArrowSprites[1].setVisible(true);
                }
            } else if ((keyCode & 0x20) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[0].setVisible(true);
                if ((keyCode & 2) != 0) {
                    this.arrowCollection.normalArrowSprites[3].setVisible(true);
                }
                if ((keyCode & 0x40) != 0) {
                    this.arrowCollection.normalArrowSprites[1].setVisible(true);
                }
            } else if ((keyCode & 2) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[3].setVisible(true);
                if ((keyCode & 0x40) != 0) {
                    this.arrowCollection.normalArrowSprites[1].setVisible(true);
                }
            } else if ((keyCode & 0x40) != 0) {
                for (i = 0; i < this.arrowCollection.normalArrowSprites.length; ++i) {
                    this.arrowCollection.normalArrowSprites[i].setVisible(false);
                }
                this.arrowCollection.normalArrowSprites[1].setVisible(true);
            }
        }
        if (this.placeOk) {
            if ((keyCode & 4) != 0 && this.dirAssistant.getAngle() > 183.0) {
                this.dirAssistant.decreaseAngle();
            }
            if ((keyCode & 0x20) != 0 && this.dirAssistant.getAngle() < 267.0) {
                this.dirAssistant.increaseAngle();
            }
            if ((keyCode & 0x100) != 0 && !this.shootDone) {
                this.shoot();
                this.scoreAndTime.timeStopped = true;
            }
        }
    }
}

