/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;

public class Gauge {
    public static final int DEFAULT_COLOR1 = 0xFFFF00;
    public static final int DEFAULT_COLOR2 = 0xFF0000;
    private static final int FLACTUATION_DELAY = 10;
    private int width;
    private int height;
    private int x;
    private int y;
    private int color1 = 0xFFFF00;
    private int color2 = 0xFF0000;
    private boolean gradient = true;
    private boolean visible = true;
    private int value = 0;
    private boolean flactuate = false;
    private Timer flactuationTimer = new Timer();
    private FlactuationTimerTask flactuationTimerTask;

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setColor(int color) {
        this.color1 = color;
        this.gradient = false;
    }

    public void setColor(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;
        this.gradient = true;
    }

    public void setFlactuation(boolean flactuate) {
        this.flactuate = flactuate;
    }

    public boolean getFlactuation() {
        return this.flactuate;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getValue() {
        return this.value;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.flactuationTimerTask = new FlactuationTimerTask();
            this.flactuationTimer.scheduleAtFixedRate((TimerTask)this.flactuationTimerTask, 0L, 10L);
        } else if (this.flactuationTimerTask != null) {
            this.flactuationTimerTask.cancel();
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void paint(Graphics g) {
        if (this.visible) {
            g.setColor(0, 0, 0);
            g.fillRect(this.x, this.y, this.width, this.height);
            this.value = this.flactuationTimerTask.getValue();
            if (this.gradient) {
                for (int i = this.width * this.value / 100 - 1; i >= 0; --i) {
                    int prop = this.width * (this.width - 1 - i) / (this.width - 1);
                    int red = ((this.color1 >> 16 & 0xFF) * prop + (this.color2 >> 16 & 0xFF) * (this.width - prop)) / this.width;
                    int green = ((this.color1 >> 8 & 0xFF) * prop + (this.color2 >> 8 & 0xFF) * (this.width - prop)) / this.width;
                    int blue = ((this.color1 & 0xFF) * prop + (this.color2 & 0xFF) * (this.width - prop)) / this.width;
                    int color = red << 16 | green << 8 | blue;
                    g.setColor(color);
                    g.setStrokeStyle(0);
                    g.drawLine(this.x + i, this.y, this.x + i, this.y + this.height - 1);
                }
            } else {
                g.setColor(this.color1);
                g.fillRect(this.x, this.y, this.width * this.value / 100, this.height);
            }
        }
    }

    public void clear() {
        if (this.flactuationTimer != null) {
            this.flactuationTimer.cancel();
            this.flactuationTimer = null;
        }
        if (this.flactuationTimerTask != null) {
            this.flactuationTimerTask.cancel();
            this.flactuationTimerTask = null;
        }
    }

    private class FlactuationTimerTask
    extends TimerTask {
        private int value = 0;
        private boolean isIncreasing = true;

        private FlactuationTimerTask() {
        }

        public int getValue() {
            return this.value;
        }

        public void run() {
            if (this.value >= 100) {
                this.isIncreasing = false;
            } else if (this.value <= 0) {
                this.isIncreasing = true;
            }
            this.value = this.isIncreasing ? ++this.value : --this.value;
        }
    }
}

