/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.helper;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public final class BBSRecStore {
    RecordStore rs;

    public BBSRecStore(String name) {
        try {
            this.rs = RecordStore.openRecordStore((String)name, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(String name, String value) {
        try {
            int id = this.find(name);
            byte[] data = (name + value).getBytes();
            if (id == -1) {
                this.rs.addRecord(data, 0, data.length);
            } else {
                this.rs.setRecord(id, data, 0, data.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String read(String name) {
        String value = "";
        try {
            int id = this.find(name);
            if (id >= 0) {
                byte[] data = this.rs.getRecord(id);
                value = new String(data, 0, data.length).substring(name.length());
                data = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private int find(String name) {
        int id = -1;
        try {
            String value;
            RecordEnumeration re = this.rs.enumerateRecords(null, null, true);
            while (re.hasNextElement()) {
                int tid = re.nextRecordId();
                byte[] data = this.rs.getRecord(tid);
                value = new String(data, 0, data.length);
                data = null;
                if (!value.startsWith(name)) continue;
                id = tid;
                break;
            }
            re.destroy();
            re = null;
            value = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        return id;
    }
}

