/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.zipme.Inflater;
import net.sf.zipme.InflaterInputStream;
import net.sf.zipme.ZipConstants;
import net.sf.zipme.ZipEntry;
import net.sf.zipme.ZipException;

public class ZipArchive
implements ZipConstants {
    static final int ENDNRD = 4;
    private byte[] buf;
    private int off;
    private int len;
    private Hashtable entries;

    public ZipArchive(byte[] b) throws ZipException {
        this(b, 0, b.length);
    }

    public ZipArchive(byte[] b, int off, int len) throws ZipException {
        if (off < 0 || len < 0 || off > b.length) {
            throw new IllegalArgumentException();
        }
        this.buf = b;
        this.off = off;
        this.len = len;
        if (this.len > this.buf.length - this.off) {
            this.len = this.buf.length - this.off;
        }
        this.checkZipArchive();
    }

    public ZipArchive(InputStream in) throws ZipException, IOException {
        int l;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((l = in.read(b)) > 0) {
            out.write(b, 0, l);
        }
        this.buf = out.toByteArray();
        this.off = 0;
        this.len = this.buf.length;
        this.checkZipArchive();
    }

    private void checkZipArchive() throws ZipException {
        if (this.len < 4) {
            throw new ZipException("Not a valid zip archive");
        }
        int sig = this.buf[this.off] & 0xFF | (this.buf[this.off + 1] & 0xFF) << 8 | (this.buf[this.off + 2] & 0xFF) << 16 | (this.buf[this.off + 3] & 0xFF) << 24;
        if ((long)sig != 67324752L) {
            throw new ZipException("Not a valid zip archive");
        }
    }

    private void readEntries() throws ZipException, IOException {
        PartialInputStream inp = new PartialInputStream(this.buf, this.off, this.len);
        int pos = this.len - 22;
        int top = Math.max(0, pos - 65536);
        do {
            if (pos < top) {
                throw new ZipException("central directory not found, probably not a zip archive");
            }
            inp.seek(this.off + pos--);
        } while ((long)inp.readLeInt() != 101010256L);
        if (inp.skip(6L) != 6L) {
            throw new EOFException();
        }
        int count = inp.readLeShort();
        if (inp.skip(4L) != 4L) {
            throw new EOFException();
        }
        int centralOffset = inp.readLeInt();
        this.entries = new Hashtable(count + count / 2);
        inp.seek(this.off + centralOffset);
        for (int i = 0; i < count; ++i) {
            if ((long)inp.readLeInt() != 33639248L) {
                throw new ZipException("Wrong Central Directory signature");
            }
            inp.skip(6L);
            int method = inp.readLeShort();
            int dostime = inp.readLeInt();
            int crc = inp.readLeInt();
            int csize = inp.readLeInt();
            int size = inp.readLeInt();
            int nameLen = inp.readLeShort();
            int extraLen = inp.readLeShort();
            int commentLen = inp.readLeShort();
            inp.skip(8L);
            int offset = inp.readLeInt();
            String name = inp.readString(nameLen);
            ZipEntry entry = new ZipEntry(name);
            entry.setMethod(method);
            entry.setCrc((long)crc & 0xFFFFFFFFL);
            entry.setSize((long)size & 0xFFFFFFFFL);
            entry.setCompressedSize((long)csize & 0xFFFFFFFFL);
            entry.setDOSTime(dostime);
            if (extraLen > 0) {
                byte[] extra = new byte[extraLen];
                inp.readFully(extra);
                entry.setExtra(extra);
            }
            if (commentLen > 0) {
                entry.setComment(inp.readString(commentLen));
            }
            entry.offset = offset;
            this.entries.put(name, entry);
        }
    }

    public Enumeration entries() {
        try {
            return this.getEntries().elements();
        }
        catch (IOException ioe) {
            return new Hashtable().elements();
        }
    }

    private Hashtable getEntries() throws IOException {
        if (this.entries == null) {
            this.readEntries();
        }
        return this.entries;
    }

    public ZipEntry getEntry(String name) {
        try {
            Hashtable entries = this.getEntries();
            ZipEntry entry = (ZipEntry)entries.get(name);
            if (entry == null && !name.endsWith("/")) {
                entry = (ZipEntry)entries.get(name + '/');
            }
            return entry != null ? new ZipEntry(entry, name) : null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public InputStream getInputStream(ZipEntry entry) throws IOException {
        String name;
        Hashtable entries = this.getEntries();
        ZipEntry zipEntry = (ZipEntry)entries.get(name = entry.getName());
        if (zipEntry == null) {
            return null;
        }
        PartialInputStream inp = new PartialInputStream(this.buf, this.off, this.len);
        inp.seek(this.off + zipEntry.offset);
        if ((long)inp.readLeInt() != 67324752L) {
            throw new ZipException("Wrong Local header signature: " + name);
        }
        inp.skip(4L);
        if (zipEntry.getMethod() != inp.readLeShort()) {
            throw new ZipException("Compression method mismatch: " + name);
        }
        inp.skip(16L);
        int nameLen = inp.readLeShort();
        int extraLen = inp.readLeShort();
        inp.skip(nameLen + extraLen);
        inp.setLength((int)zipEntry.getCompressedSize());
        int method = zipEntry.getMethod();
        switch (method) {
            case 0: {
                return inp;
            }
            case 8: {
                inp.addDummyByte();
                Inflater inf = new Inflater(true);
                final int sz = (int)entry.getSize();
                return new InflaterInputStream(inp, inf){

                    public int available() throws IOException {
                        if (sz == -1) {
                            return super.available();
                        }
                        if (super.available() != 0) {
                            return sz - this.inf.getTotalOut();
                        }
                        return 0;
                    }
                };
            }
        }
        throw new ZipException("Unknown compression method " + method);
    }

    public int size() {
        try {
            return this.getEntries().size();
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    private static final class PartialInputStream
    extends ByteArrayInputStream {
        private int dummyByteCount;

        public PartialInputStream(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        synchronized void setLength(int length) {
            this.count = this.pos + length;
            if (this.count > this.buf.length) {
                this.count = this.buf.length;
            }
        }

        public synchronized int read() {
            if (this.dummyByteCount > 0 && this.pos == this.count) {
                this.dummyByteCount = 0;
                ++this.pos;
                return 0;
            }
            return super.read();
        }

        public synchronized int read(byte[] buffer, int offset, int length) {
            int numBytes = super.read(buffer, offset, length);
            if (this.dummyByteCount > 0 && numBytes < length) {
                this.dummyByteCount = 0;
                if (this.pos < this.count) {
                    buffer[offset + numBytes++] = this.buf[this.pos++];
                } else if (this.pos == this.count) {
                    if (numBytes == -1) {
                        numBytes = 0;
                    }
                    buffer[offset + numBytes++] = 0;
                    ++this.pos;
                }
            }
            return numBytes;
        }

        void seek(int newpos) {
            this.pos = newpos;
        }

        void readFully(byte[] buf) throws EOFException {
            if (this.read(buf, 0, buf.length) != buf.length) {
                throw new EOFException();
            }
        }

        void readFully(byte[] buf, int off, int len) throws EOFException {
            if (this.read(buf, off, len) != len) {
                throw new EOFException();
            }
        }

        synchronized int readLeShort() throws EOFException {
            int b0 = this.read();
            int b1 = this.read();
            if (b1 == -1) {
                throw new EOFException();
            }
            return b0 & 0xFF | (b1 & 0xFF) << 8;
        }

        synchronized int readLeInt() throws EOFException {
            int b0 = this.read();
            int b1 = this.read();
            int b2 = this.read();
            int b3 = this.read();
            if (b3 == -1) {
                throw new EOFException();
            }
            return b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF | (b3 & 0xFF) << 8) << 16;
        }

        synchronized String readString(int length) throws EOFException {
            if (length > this.count - this.pos) {
                throw new EOFException();
            }
            try {
                byte[] b = new byte[length];
                this.readFully(b);
                return new String(b, 0, length, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
        }

        public void addDummyByte() {
            this.dummyByteCount = 1;
        }
    }
}

