/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.zipme.CRC32;
import net.sf.zipme.Deflater;
import net.sf.zipme.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 4096);
    }

    public GZIPOutputStream(OutputStream out, int size) throws IOException {
        super(out, new Deflater(-1, true), size);
        int mod_time = (int)(System.currentTimeMillis() / 1000L);
        byte[] gzipHeader = new byte[]{31, -117, 8, 0, (byte)mod_time, (byte)(mod_time >> 8), (byte)(mod_time >> 16), (byte)(mod_time >> 24), 0, -1};
        out.write(gzipHeader);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        super.finish();
        int totalin = this.def.getTotalIn();
        int crcval = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
        byte[] gzipFooter = new byte[]{(byte)crcval, (byte)(crcval >> 8), (byte)(crcval >> 16), (byte)(crcval >> 24), (byte)totalin, (byte)(totalin >> 8), (byte)(totalin >> 16), (byte)(totalin >> 24)};
        this.out.write(gzipFooter);
    }
}

