/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.zipme.CRC32;
import net.sf.zipme.Deflater;
import net.sf.zipme.DeflaterOutputStream;
import net.sf.zipme.ZipConstants;
import net.sf.zipme.ZipEntry;
import net.sf.zipme.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private Vector entries = new Vector();
    private CRC32 crc = new CRC32();
    private ZipEntry curEntry = null;
    private int curMethod;
    private int size;
    private int offset = 0;
    private byte[] zipComment = new byte[0];
    private int defaultMethod = 8;
    private static final int ZIP_STORED_VERSION = 10;
    private static final int ZIP_DEFLATED_VERSION = 20;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ZipOutputStream(OutputStream out) {
        super(out, new Deflater(-1, true));
    }

    public void setComment(String comment) {
        byte[] commentBytes;
        try {
            commentBytes = comment.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
        if (commentBytes.length > 65535) {
            throw new IllegalArgumentException("Comment too long.");
        }
        this.zipComment = commentBytes;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("Method not supported.");
        }
        this.defaultMethod = method;
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    private void writeLeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    private void writeLeInt(int value) throws IOException {
        this.writeLeShort(value);
        this.writeLeShort(value >> 16);
    }

    private void writeLeInt(long value) throws IOException {
        this.writeLeInt((int)value);
    }

    public void putNextEntry(ZipEntry entry) throws IOException {
        byte[] name;
        if (this.entries == null) {
            throw new ZipException("ZipOutputStream was finished");
        }
        int method = entry.getMethod();
        int flags = 0;
        if (method == -1) {
            method = this.defaultMethod;
        }
        if (method == 0) {
            if (entry.getCompressedSize() >= 0L) {
                if (entry.getSize() < 0L) {
                    entry.setSize(entry.getCompressedSize());
                } else if (entry.getSize() != entry.getCompressedSize()) {
                    throw new ZipException("Method STORED, but compressed size != size");
                }
            } else {
                entry.setCompressedSize(entry.getSize());
            }
            if (entry.getSize() < 0L) {
                throw new ZipException("Method STORED, but size not set");
            }
            if (entry.getCrc() < 0L) {
                throw new ZipException("Method STORED, but crc not set");
            }
        } else if (method == 8 && (entry.getCompressedSize() < 0L || entry.getSize() < 0L || entry.getCrc() < 0L)) {
            flags |= 8;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        if (entry.getTime() < 0L) {
            entry.setTime(System.currentTimeMillis());
        }
        entry.flags = flags;
        entry.offset = this.offset;
        entry.setMethod(method);
        this.curMethod = method;
        this.writeLeInt(67324752L);
        this.writeLeShort(method == 0 ? 10 : 20);
        this.writeLeShort(flags);
        this.writeLeShort(method);
        this.writeLeInt(entry.getDOSTime());
        if ((flags & 8) == 0) {
            this.writeLeInt((int)entry.getCrc());
            this.writeLeInt((int)entry.getCompressedSize());
            this.writeLeInt((int)entry.getSize());
        } else {
            this.writeLeInt(0);
            this.writeLeInt(0);
            this.writeLeInt(0);
        }
        try {
            name = entry.getName().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
        if (name.length > 65535) {
            throw new ZipException("Name too long.");
        }
        byte[] extra = entry.getExtra();
        if (extra == null) {
            extra = new byte[]{};
        }
        this.writeLeShort(name.length);
        this.writeLeShort(extra.length);
        this.out.write(name);
        this.out.write(extra);
        this.offset += 30 + name.length + extra.length;
        this.curEntry = entry;
        this.crc.reset();
        if (method == 8) {
            this.def.reset();
        }
        this.size = 0;
    }

    public void closeEntry() throws IOException {
        int csize;
        if (this.curEntry == null) {
            throw new ZipException("No open entry");
        }
        if (this.curMethod == 8) {
            super.finish();
        }
        int n = csize = this.curMethod == 8 ? this.def.getTotalOut() : this.size;
        if (this.curEntry.getSize() < 0L) {
            this.curEntry.setSize(this.size);
        } else if (this.curEntry.getSize() != (long)this.size) {
            throw new ZipException("size was " + this.size + ", but I expected " + this.curEntry.getSize());
        }
        if (this.curEntry.getCompressedSize() < 0L) {
            this.curEntry.setCompressedSize(csize);
        } else if (this.curEntry.getCompressedSize() != (long)csize) {
            throw new ZipException("compressed size was " + csize + ", but I expected " + this.curEntry.getSize());
        }
        if (this.curEntry.getCrc() < 0L) {
            this.curEntry.setCrc(this.crc.getValue());
        } else if (this.curEntry.getCrc() != this.crc.getValue()) {
            throw new ZipException("crc was " + ZipOutputStream.toHexString(this.crc.getValue()) + ", but I expected " + ZipOutputStream.toHexString(this.curEntry.getCrc()));
        }
        this.offset += csize;
        if (this.curMethod == 8 && (this.curEntry.flags & 8) != 0) {
            this.writeLeInt(134695760L);
            this.writeLeInt((int)this.curEntry.getCrc());
            this.writeLeInt((int)this.curEntry.getCompressedSize());
            this.writeLeInt((int)this.curEntry.getSize());
            this.offset += 16;
        }
        this.entries.addElement(this.curEntry);
        this.curEntry = null;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.curEntry == null) {
            throw new ZipException("No open entry.");
        }
        switch (this.curMethod) {
            case 8: {
                super.write(b, off, len);
                break;
            }
            case 0: {
                this.out.write(b, off, len);
            }
        }
        this.crc.update(b, off, len);
        this.size += len;
    }

    public void finish() throws IOException {
        if (this.entries == null) {
            return;
        }
        if (this.curEntry != null) {
            this.closeEntry();
        }
        int numEntries = 0;
        int sizeEntries = 0;
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            byte[] comment;
            byte[] name;
            ZipEntry entry = (ZipEntry)e.nextElement();
            int method = entry.getMethod();
            this.writeLeInt(33639248L);
            this.writeLeShort(method == 0 ? 10 : 20);
            this.writeLeShort(method == 0 ? 10 : 20);
            this.writeLeShort(entry.flags);
            this.writeLeShort(method);
            this.writeLeInt(entry.getDOSTime());
            this.writeLeInt((int)entry.getCrc());
            this.writeLeInt((int)entry.getCompressedSize());
            this.writeLeInt((int)entry.getSize());
            try {
                name = entry.getName().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
            if (name.length > 65535) {
                throw new ZipException("Name too long.");
            }
            byte[] extra = entry.getExtra();
            if (extra == null) {
                extra = new byte[]{};
            }
            String str = entry.getComment();
            try {
                comment = str != null ? str.getBytes("UTF-8") : new byte[]{};
            }
            catch (UnsupportedEncodingException uee) {
                throw new Error(uee.toString());
            }
            if (comment.length > 65535) {
                throw new ZipException("Comment too long.");
            }
            this.writeLeShort(name.length);
            this.writeLeShort(extra.length);
            this.writeLeShort(comment.length);
            this.writeLeShort(0);
            this.writeLeShort(0);
            this.writeLeInt(0);
            this.writeLeInt(entry.offset);
            this.out.write(name);
            this.out.write(extra);
            this.out.write(comment);
            ++numEntries;
            sizeEntries += 46 + name.length + extra.length + comment.length;
        }
        this.writeLeInt(101010256L);
        this.writeLeShort(0);
        this.writeLeShort(0);
        this.writeLeShort(numEntries);
        this.writeLeShort(numEntries);
        this.writeLeInt(sizeEntries);
        this.writeLeInt(this.offset);
        this.writeLeShort(this.zipComment.length);
        this.out.write(this.zipComment);
        this.out.flush();
        this.entries = null;
    }

    private static String toHexString(long num) {
        if (num >= 0L && (long)((int)num) == num) {
            return Integer.toHexString((int)num);
        }
        int mask = 15;
        char[] buffer = new char[64];
        int i = 64;
        do {
            buffer[--i] = digits[(int)num & mask];
        } while ((num >>>= 4) != 0L);
        return new String(buffer, i, 64 - i);
    }
}

