/*
 * Decompiled with CFR 0.152.
 */
package ru.andrew.jclazz.decompiler.engine.blocks;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ru.andrew.jclazz.core.code.ops.Operation;
import ru.andrew.jclazz.decompiler.ImportManager;
import ru.andrew.jclazz.decompiler.MethodSourceView;
import ru.andrew.jclazz.decompiler.engine.CodeItem;
import ru.andrew.jclazz.decompiler.engine.LocalVariable;
import ru.andrew.jclazz.decompiler.engine.MethodContext;
import ru.andrew.jclazz.decompiler.engine.blocks.Condition;
import ru.andrew.jclazz.decompiler.engine.blocks.IfBlock;
import ru.andrew.jclazz.decompiler.engine.blocks.Loop;
import ru.andrew.jclazz.decompiler.engine.ops.OperationView;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Block
implements CodeItem {
    public Vector a;
    public long a;
    public Block a;
    private MethodSourceView a;
    public String a;
    public MethodContext a;
    private int a;
    public Hashtable a = new Hashtable();

    public CodeItem newInstance(Operation operation, MethodSourceView methodSourceView) {
        return this;
    }

    public Block(Block block) {
        this(block, new Vector());
    }

    public Block(Block block, Vector vector) {
        this.a = vector;
        this.a = block;
        this.a = block.a;
    }

    public Block(Vector vector, MethodSourceView methodSourceView) {
        this.a = vector;
        this.a = methodSourceView;
        this.a = methodSourceView.getMethodContext();
    }

    public MethodContext getMethodContext() {
        return this.a;
    }

    public void setParent(Block block) {
        this.a = block;
    }

    public Block getParent() {
        return this.a;
    }

    public void setOperations(Vector vector) {
        this.a = vector;
    }

    public Vector getOperations() {
        return this.a;
    }

    public String getIndent() {
        return this.a;
    }

    public void setIndent(String string) {
        this.a = string;
    }

    public long getFakeStartByte() {
        return this.a;
    }

    public void setFakeStartByte(long l) {
        this.a = l;
    }

    public boolean hasMoreOperations() {
        return this.a < this.a.size();
    }

    public CodeItem nextElement() {
        CodeItem codeItem = (CodeItem)this.a.elementAt(this.a);
        ++this.a;
        return codeItem;
    }

    public void back() {
        --this.a;
    }

    public void seekEnd() {
        this.a = Integer.MAX_VALUE;
    }

    public void reset() {
        this.a = 0;
    }

    public void postCreate() {
    }

    public void postProcess() {
    }

    public Vector createSubBlock(long l, long l2, Block block) {
        Vector<CodeItem> vector = new Vector<CodeItem>();
        boolean bl = false;
        int n = 0;
        while (n < this.a.size()) {
            CodeItem codeItem = (CodeItem)this.a.elementAt(n);
            if (codeItem.getStartByte() >= l) {
                bl = true;
            }
            if (codeItem.getStartByte() >= l2) break;
            if (bl) {
                vector.addElement(codeItem);
                if (block != null && codeItem instanceof Block) {
                    ((Block)codeItem).setParent(block);
                }
                this.a.removeElementAt(n);
                if (this.a <= n || n == 0) continue;
                --this.a;
                continue;
            }
            ++n;
        }
        if (block != null) {
            this.a.insertElementAt(block, n);
            block.setOperations(vector);
            if (vector.isEmpty()) {
                block.setFakeStartByte(l);
            }
            block.setParent(this);
            block.postCreate();
        }
        return vector;
    }

    public void addOperation(int n, CodeItem codeItem) {
        if (n <= this.a && this.a != Integer.MAX_VALUE) {
            ++this.a;
        }
        this.a.insertElementAt(codeItem, n);
        if (codeItem instanceof Block) {
            ((Block)codeItem).setParent(this);
        }
    }

    public void addOperation(CodeItem codeItem, long l) {
        for (int i = 0; i < this.a.size(); ++i) {
            CodeItem codeItem2 = (CodeItem)this.a.elementAt(i);
            if (codeItem2.getStartByte() != l) continue;
            this.addOperation(i, codeItem);
            return;
        }
    }

    private CodeItem a(int n) {
        if (n <= this.a && this.a != 0 && this.a != Integer.MAX_VALUE) {
            --this.a;
        }
        CodeItem codeItem = (CodeItem)this.a.elementAt(n);
        this.a.removeElementAt(n);
        return codeItem;
    }

    public CodeItem removeLastOperation() {
        if (this.a.isEmpty()) {
            return null;
        }
        return this.a(this.a.size() - 1);
    }

    public CodeItem removeFirstOperation() {
        if (!this.a.isEmpty()) {
            return this.a(0);
        }
        return null;
    }

    public CodeItem removeOperation(long l) {
        for (int i = 0; i < this.a.size(); ++i) {
            if (((CodeItem)this.a.elementAt(i)).getStartByte() != l) continue;
            if (i <= this.a && this.a != 0 && this.a != Integer.MAX_VALUE) {
                --this.a;
            }
            CodeItem codeItem = (CodeItem)this.a.elementAt(i);
            this.a.removeElementAt(i);
            return codeItem;
        }
        return null;
    }

    public CodeItem getOperationPriorTo(long l) {
        for (int i = 0; i < this.a.size(); ++i) {
            if (((CodeItem)this.a.elementAt(i)).getStartByte() < l) continue;
            if (i == 0) {
                return null;
            }
            return (CodeItem)this.a.elementAt(i - 1);
        }
        return this.getLastOperation();
    }

    public CodeItem getOperationAfter(long l) {
        for (int i = 0; i < this.a.size(); ++i) {
            if (((CodeItem)this.a.elementAt(i)).getStartByte() <= l) continue;
            return (CodeItem)this.a.elementAt(i);
        }
        return null;
    }

    public CodeItem getOperationByStartByte(long l) {
        for (int i = 0; i < this.a.size(); ++i) {
            if (((CodeItem)this.a.elementAt(i)).getStartByte() != l) continue;
            return (CodeItem)this.a.elementAt(i);
        }
        return null;
    }

    public OperationView removePriorPushOperation() {
        int n = this.a != Integer.MAX_VALUE ? this.a - 2 : this.a.size() - 1;
        for (int i = n; i >= 0; --i) {
            OperationView operationView;
            if (this.a.elementAt(i) instanceof Block) {
                operationView = Block.a((Block)this.a.elementAt(i));
                if (operationView == null) continue;
                return operationView;
            }
            if (!((OperationView)this.a.elementAt(i)).isPush()) continue;
            if (this.a != Integer.MAX_VALUE) {
                --this.a;
            }
            operationView = (OperationView)this.a.elementAt(i);
            this.a.removeElementAt(i);
            return operationView;
        }
        return null;
    }

    private static OperationView a(Block block) {
        block.seekEnd();
        return block.removePriorPushOperation();
    }

    public CodeItem removeCurrentOperation() {
        --this.a;
        CodeItem codeItem = (CodeItem)this.a.elementAt(this.a);
        this.a.removeElementAt(this.a);
        return codeItem;
    }

    public OperationView getPriorPushOperation() {
        int n = this.a != Integer.MAX_VALUE ? this.a - 2 : this.a.size() - 1;
        for (int i = n; i >= 0; --i) {
            if (this.a.elementAt(i) instanceof Block) {
                OperationView operationView = Block.a((Block)this.a.elementAt(i));
                if (operationView == null) continue;
                return operationView;
            }
            if (!((OperationView)this.a.elementAt(i)).isPush()) continue;
            return (OperationView)this.a.elementAt(i);
        }
        return null;
    }

    public CodeItem getPreviousOperation() {
        return this.a - 2 >= 0 ? this.a.elementAt(this.a - 2) : null;
    }

    public CodeItem removePreviousOperation() {
        if (this.a - 2 >= 0) {
            CodeItem codeItem = (CodeItem)this.a.elementAt(this.a - 2);
            this.a.removeElementAt(this.a - 2);
            CodeItem codeItem2 = codeItem;
            --this.a;
            return codeItem2;
        }
        return null;
    }

    public CodeItem getNextOperation() {
        if (this.hasMoreOperations()) {
            return (CodeItem)this.a.elementAt(this.a);
        }
        return null;
    }

    public void replaceOperation(long l, CodeItem codeItem) {
        for (int i = 0; i < this.a.size(); ++i) {
            if (((CodeItem)this.a.elementAt(i)).getStartByte() != l) continue;
            this.a.removeElementAt(i);
            this.a.insertElementAt(codeItem, i);
            return;
        }
    }

    public void replaceCurrentOperation(CodeItem codeItem) {
        if (this.a > 0 && this.a != Integer.MAX_VALUE) {
            if (codeItem != null) {
                this.a.insertElementAt(codeItem, this.a - 1);
                if (codeItem instanceof Block) {
                    ((Block)codeItem).setParent(this);
                    return;
                }
            } else {
                this.a.removeElementAt(this.a - 1);
                --this.a;
            }
        }
    }

    public void truncate(long l) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
        }
    }

    public MethodSourceView getMethodView() {
        Block block = this;
        while (block.a != null) {
            block = block.a;
        }
        return block.a;
    }

    public boolean isEmpty() {
        return this.a == null || this.a.isEmpty();
    }

    public int size() {
        if (this.a == null) {
            return 0;
        }
        return this.a.size();
    }

    public int printedSize() {
        int n = 0;
        for (int i = 0; i < this.a.size(); ++i) {
            if (!(this.a.elementAt(i) instanceof Block) && !((OperationView)this.a.elementAt(i)).isPrintable()) continue;
            ++n;
        }
        return n;
    }

    public CodeItem getFirstOperation() {
        if (this.a.isEmpty()) {
            return null;
        }
        return (CodeItem)this.a.elementAt(0);
    }

    public CodeItem getLastOperation() {
        if (this.a.isEmpty()) {
            return null;
        }
        return (CodeItem)this.a.elementAt(this.a.size() - 1);
    }

    public CodeItem getFirstPrintedOperation() {
        for (int i = 0; i < this.a.size(); ++i) {
            CodeItem codeItem = (CodeItem)this.a.elementAt(i);
            if (!(codeItem instanceof Block) && !((OperationView)codeItem).isPrintable()) continue;
            return codeItem;
        }
        return null;
    }

    public CodeItem getLastPrintedOperation() {
        for (int i = this.a.size() - 1; i >= 0; --i) {
            CodeItem codeItem = (CodeItem)this.a.elementAt(i);
            if (!(codeItem instanceof Block) && !((OperationView)codeItem).isPrintable()) continue;
            return codeItem;
        }
        return null;
    }

    public long getStartByte() {
        if (this.a == null || this.a.isEmpty()) {
            return this.a;
        }
        return ((CodeItem)this.a.elementAt(0)).getStartByte();
    }

    public String getSource() {
        return this.a + "{" + "\n" + this.getOperationsSource() + this.a + "}" + "\n";
    }

    public String getOperationsSource() {
        return this.getOperationsSource(-1);
    }

    public String getOperationsSource(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = "yes".equals(this.getMethodView().getClazzView().getDecompileParameter("--ln")) && this.getMethodView().getMethod().getCodeBlock() != null && this.getMethodView().getMethod().getLineNumberTable() != null;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            CodeItem codeItem = (CodeItem)enumeration.nextElement();
            if (n != -1 && codeItem.getStartByte() >= (long)n) break;
            if (bl && (!(codeItem instanceof Block) || codeItem instanceof IfBlock || codeItem instanceof Loop && ((Loop)codeItem).isPrintPrecondition())) {
                int n2;
                if (codeItem instanceof Loop) {
                    Condition condition = (Condition)((Vector)((Loop)codeItem).getConditions().elementAt(0)).elementAt(0);
                    n2 = (int)condition.getIfOperation().getStartByte();
                } else {
                    n2 = (int)codeItem.getStartByte();
                }
                int n3 = this.getMethodView().getMethod().getLineNumberTable().getLineNumber(n2);
                if (n3 != -1) {
                    stringBuffer.append(this.a).append("    ").append("/* ").append(n3).append(" */");
                }
            }
            if (codeItem instanceof Block) {
                ((Block)codeItem).setIndent(this.a + "    ");
                stringBuffer.append(((Block)codeItem).getSource());
                continue;
            }
            OperationView operationView = (OperationView)codeItem;
            if (!operationView.isPrintable() || (string = operationView.source2()) == null) continue;
            stringBuffer.append(this.a).append("    ").append(string).append(";").append("\n");
        }
        return stringBuffer.toString();
    }

    public final String a(String string) {
        return ImportManager.getInstance().importClass(string, this.getMethodView().getClazzView());
    }

    public void analyze(Block block) {
    }

    public LocalVariable getLocalVariable(int n, String string) {
        LocalVariable localVariable = (LocalVariable)this.a.get(new Integer(n));
        Block block = this;
        while (localVariable == null && block != null) {
            localVariable = (LocalVariable)block.a.get(new Integer(n));
            block = block.a;
        }
        if (!(localVariable == null || string == null || "_UNKNOWN_TYPE_".equals(localVariable.getType()) || localVariable.getType().equals(string) || Block.a(string, localVariable.getType()))) {
            localVariable = null;
        }
        if (localVariable != null && string != null && "_UNKNOWN_TYPE_".equals(localVariable.getType())) {
            localVariable.renewType(string);
        }
        if (localVariable == null) {
            localVariable = new LocalVariable(n, string, this.getMethodView());
            this.a(n, localVariable);
        }
        return localVariable;
    }

    public void a(int n, LocalVariable localVariable) {
        this.a.put(new Integer(n), localVariable);
    }

    private static boolean a(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        try {
            return Block.widePrimitiveConversion(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Class<?> clazz = Class.forName(string);
                Class<?> clazz2 = Class.forName(string2);
                return clazz2.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
        }
    }

    public static boolean widePrimitiveConversion(String string, String string2) {
        if ("boolean".equals(string2) && "int".equals(string)) {
            return true;
        }
        if ("byte".equals(string)) {
            return "short".equals(string2) || "int".equals(string2) || "long".equals(string2) || "float".equals(string2) || "double".equals(string2);
        }
        if ("short".equals(string)) {
            return "int".equals(string2) || "long".equals(string2) || "float".equals(string2) || "double".equals(string2);
        }
        if ("char".equals(string)) {
            return "int".equals(string2) || "long".equals(string2) || "float".equals(string2) || "double".equals(string2);
        }
        if ("int".equals(string)) {
            return "long".equals(string2) || "float".equals(string2) || "double".equals(string2);
        }
        if ("long".equals(string)) {
            return "float".equals(string2) || "double".equals(string2);
        }
        if ("float".equals(string)) {
            return "double".equals(string2);
        }
        if ("double".equals(string)) {
            return false;
        }
        if ("boolean".equals(string)) {
            return false;
        }
        if ("void".equals(string)) {
            return false;
        }
        throw new IllegalArgumentException("Not a primitive type");
    }

    public void analyze2(Block block) {
        this.analyze(block);
    }
}

