/*
 * Decompiled with CFR 0.152.
 */
package ru.andrew.jclazz.decompiler;

import ru.andrew.jclazz.core.MethodInfo;
import ru.andrew.jclazz.core.signature.ClassSignature;
import ru.andrew.jclazz.core.signature.ClassTypeSignature;
import ru.andrew.jclazz.core.signature.FieldTypeSignature;
import ru.andrew.jclazz.core.signature.FormalTypeParameter;
import ru.andrew.jclazz.core.signature.MethodSignature;
import ru.andrew.jclazz.core.signature.SimpleClassTypeSignature;
import ru.andrew.jclazz.core.signature.TypeArgument;
import ru.andrew.jclazz.core.signature.TypeSignature;
import ru.andrew.jclazz.decompiler.ClazzSourceView;
import ru.andrew.jclazz.decompiler.ImportManager;
import ru.andrew.jclazz.decompiler.MethodSourceView;
import ru.andrew.jclazz.decompiler.engine.LocalVariable;

public class SignatureView {
    public static String asString(Object object, ClazzSourceView clazzSourceView) {
        if (object instanceof TypeSignature) {
            return SignatureView.a((TypeSignature)object, clazzSourceView);
        }
        if (object instanceof TypeArgument) {
            return SignatureView.a((TypeArgument)object, clazzSourceView);
        }
        if (object instanceof SimpleClassTypeSignature) {
            return SignatureView.a((SimpleClassTypeSignature)object, clazzSourceView);
        }
        if (object instanceof FormalTypeParameter) {
            return SignatureView.a((FormalTypeParameter)object, clazzSourceView);
        }
        if (object instanceof FieldTypeSignature) {
            return SignatureView.a((FieldTypeSignature)object, clazzSourceView);
        }
        if (object instanceof ClassTypeSignature) {
            return SignatureView.a((ClassTypeSignature)object, clazzSourceView);
        }
        if (object instanceof MethodSignature) {
            return SignatureView.a();
        }
        if (object instanceof ClassSignature) {
            return SignatureView.classSignature((ClassSignature)object, clazzSourceView);
        }
        throw new RuntimeException("Unknown signature type");
    }

    public static String a(TypeSignature typeSignature, ClazzSourceView clazzSourceView) {
        if (typeSignature.getFieldType() != null) {
            return SignatureView.asString(typeSignature.getFieldType(), clazzSourceView);
        }
        return typeSignature.getBaseType();
    }

    public static String a(TypeArgument typeArgument, ClazzSourceView clazzSourceView) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (typeArgument.getModifier()) {
            case '*': {
                stringBuffer.append("?");
                break;
            }
            case '-': {
                stringBuffer.append("? super ");
                break;
            }
            case '+': {
                stringBuffer.append("? extends ");
            }
        }
        if (typeArgument.getFieldType() != null) {
            stringBuffer.append(SignatureView.asString(typeArgument.getFieldType(), clazzSourceView));
        }
        return stringBuffer.toString();
    }

    public static String a(SimpleClassTypeSignature simpleClassTypeSignature, ClazzSourceView clazzSourceView) {
        StringBuffer stringBuffer = new StringBuffer(simpleClassTypeSignature.getName());
        TypeArgument[] typeArgumentArray = simpleClassTypeSignature.getTypeArguments();
        if (typeArgumentArray != null && typeArgumentArray.length > 0) {
            stringBuffer.append("<");
            for (int i = 0; i < typeArgumentArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(SignatureView.asString(typeArgumentArray[i], clazzSourceView));
            }
            stringBuffer.append("> ");
        }
        return stringBuffer.toString();
    }

    public static String a() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public static String preMethodSignature(MethodSignature methodSignature, MethodInfo methodInfo, ClazzSourceView clazzSourceView) {
        StringBuffer stringBuffer = new StringBuffer();
        FormalTypeParameter[] formalTypeParameterArray = methodSignature.getTypeParameters();
        if (formalTypeParameterArray != null && formalTypeParameterArray.length > 0) {
            stringBuffer.append("<");
            for (int i = 0; i < formalTypeParameterArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(SignatureView.asString(formalTypeParameterArray[i], clazzSourceView));
            }
            stringBuffer.append("> ");
        }
        if (methodSignature.isVoidReturned()) {
            if (!methodInfo.isInit()) {
                stringBuffer.append("void ");
            }
        } else {
            stringBuffer.append(SignatureView.asString(methodSignature.getReturnType(), clazzSourceView)).append(" ");
        }
        return stringBuffer.toString();
    }

    public static String postMethodSignature(MethodSignature methodSignature, MethodSourceView methodSourceView, ClazzSourceView clazzSourceView) {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n2 = n = methodSourceView.getMethod().isStatic() ? 0 : 1;
        if (methodSourceView.getMethod().isInit() && clazzSourceView.getClazz().isEnumeration()) {
            n += 2;
        }
        TypeSignature[] typeSignatureArray = methodSignature.getParamTypes();
        int n3 = 0;
        for (int i = 0; i < typeSignatureArray.length - 1; ++i) {
            object = SignatureView.asString(typeSignatureArray[i], clazzSourceView);
            String string = ((String)object).indexOf(60) != -1 ? ((String)object).substring(0, ((String)object).indexOf(60)) : object;
            LocalVariable localVariable = methodSourceView.getTopBlock().getLocalVariable(n3 + n, string);
            localVariable.setPrinted(true);
            n3 = "long".equals(string) || "double".equals(string) ? (n3 += 2) : ++n3;
            stringBuffer.append((String)object).append(" ").append(localVariable.getName()).append(", ");
        }
        if (typeSignatureArray.length > 0) {
            String string = SignatureView.asString(typeSignatureArray[typeSignatureArray.length - 1], clazzSourceView);
            object = methodSourceView.getTopBlock().getLocalVariable(n3 + n, string.indexOf(60) != -1 ? string.substring(0, string.indexOf(60)) : string);
            ((LocalVariable)object).setPrinted(true);
            if (!methodSourceView.getMethod().isVarargs()) {
                stringBuffer.append(string);
            } else {
                string = string.substring(0, string.length() - 2);
                stringBuffer.append(string).append("...");
            }
            stringBuffer.append(" ").append(((LocalVariable)object).getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String throwMethodSignature(MethodSignature methodSignature, MethodInfo methodInfo, ClazzSourceView clazzSourceView) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        ClassTypeSignature[] classTypeSignatureArray = methodSignature.getThrownClassType();
        String[] stringArray = methodSignature.getThrownVariables();
        if (classTypeSignatureArray.length > 0 || stringArray.length > 0) {
            stringBuffer.append(" throws ");
        }
        for (n = 0; n < classTypeSignatureArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(SignatureView.asString(classTypeSignatureArray[n], clazzSourceView));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n]);
        }
        return stringBuffer.toString();
    }

    public static String a(FormalTypeParameter formalTypeParameter, ClazzSourceView clazzSourceView) {
        StringBuffer stringBuffer = new StringBuffer(formalTypeParameter.getName());
        ClassTypeSignature classTypeSignature = formalTypeParameter.getClassBound().getClassType();
        boolean bl = false;
        if (classTypeSignature != null && !"java.lang.Object".equals(classTypeSignature.getPackage() + "." + classTypeSignature.getClassType().getName())) {
            stringBuffer.append(" extends ").append(SignatureView.asString(formalTypeParameter.getClassBound(), clazzSourceView));
            bl = true;
        }
        FieldTypeSignature[] fieldTypeSignatureArray = formalTypeParameter.getInterfaceBounds();
        for (int i = 0; i < fieldTypeSignatureArray.length; ++i) {
            if (!bl) {
                stringBuffer.append(" extends ").append(SignatureView.asString(fieldTypeSignatureArray[i], clazzSourceView));
                continue;
            }
            stringBuffer.append("&").append(SignatureView.asString(fieldTypeSignatureArray[i], clazzSourceView));
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static String a(FieldTypeSignature fieldTypeSignature, ClazzSourceView clazzSourceView) {
        if (fieldTypeSignature.getClassType() != null) {
            return SignatureView.asString(fieldTypeSignature.getClassType(), clazzSourceView);
        }
        if (fieldTypeSignature.getArrayType() != null) {
            return SignatureView.asString(fieldTypeSignature.getArrayType(), clazzSourceView) + "[]";
        }
        return fieldTypeSignature.getVariable();
    }

    public static String a(ClassTypeSignature classTypeSignature, ClazzSourceView clazzSourceView) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        SimpleClassTypeSignature simpleClassTypeSignature = classTypeSignature.getClassType();
        String string = (classTypeSignature.getPackage().length() > 0 ? classTypeSignature.getPackage() + "." : "") + simpleClassTypeSignature.getName();
        stringBuffer.append(ImportManager.getInstance().importClass(string, clazzSourceView));
        if (simpleClassTypeSignature.getTypeArguments().length > 0) {
            stringBuffer.append("<");
            for (n = 0; n < simpleClassTypeSignature.getTypeArguments().length; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(SignatureView.asString(simpleClassTypeSignature.getTypeArguments()[n], clazzSourceView));
            }
            stringBuffer.append(">");
        }
        for (n = 0; n < classTypeSignature.getSuffix().length; ++n) {
            stringBuffer.append(".").append(simpleClassTypeSignature.getName());
            if (simpleClassTypeSignature.getTypeArguments().length <= 0) continue;
            stringBuffer.append("<");
            for (int i = 0; i < simpleClassTypeSignature.getTypeArguments().length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(SignatureView.asString(simpleClassTypeSignature.getTypeArguments()[i], clazzSourceView));
            }
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    public static String classSignature(ClassSignature classSignature, ClazzSourceView clazzSourceView) {
        ClassTypeSignature[] classTypeSignatureArray;
        ClassTypeSignature classTypeSignature;
        StringBuffer stringBuffer = new StringBuffer();
        FormalTypeParameter[] formalTypeParameterArray = classSignature.getTypeParameters();
        if (formalTypeParameterArray != null && formalTypeParameterArray.length > 0) {
            stringBuffer.append("<");
            for (int i = 0; i < formalTypeParameterArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(SignatureView.asString(formalTypeParameterArray[i], clazzSourceView));
            }
            stringBuffer.append(">");
        }
        if ((classTypeSignature = classSignature.getSuperClass()) != null && !"java.lang.Object".equals(classTypeSignature.getPackage() + "." + classTypeSignature.getClassType().getName())) {
            stringBuffer.append(" extends ").append(SignatureView.asString(classTypeSignature, clazzSourceView));
        }
        if ((classTypeSignatureArray = classSignature.getInterfaces()).length > 0) {
            stringBuffer.append(" implements ");
        }
        for (int i = 0; i < classTypeSignatureArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(SignatureView.asString(classTypeSignatureArray[i], clazzSourceView));
        }
        return stringBuffer.toString();
    }
}

