/*
 * Decompiled with CFR 0.152.
 */
package ru.andrew.jclazz.decompiler.engine.blockdetectors;

import java.util.Vector;
import ru.andrew.jclazz.decompiler.engine.CodeItem;
import ru.andrew.jclazz.decompiler.engine.blockdetectors.Detector;
import ru.andrew.jclazz.decompiler.engine.blocks.Block;
import ru.andrew.jclazz.decompiler.engine.blocks.Catch;
import ru.andrew.jclazz.decompiler.engine.blocks.Loop;
import ru.andrew.jclazz.decompiler.engine.blocks.Try;
import ru.andrew.jclazz.decompiler.engine.ops.GoToView;
import ru.andrew.jclazz.decompiler.engine.ops.IfView;
import ru.andrew.jclazz.decompiler.engine.ops.NopView;

public class BackLoopDetector
implements Detector {
    public void analyze(Block block) {
        block.reset();
        while (block.hasMoreOperations()) {
            IfView ifView;
            CodeItem codeItem = block.nextElement();
            if (!(codeItem instanceof IfView) || (ifView = (IfView)codeItem).isForwardBranch()) continue;
            BackLoopDetector.a(block, ifView);
        }
    }

    private static void a(Block block, IfView ifView) {
        Object object;
        CodeItem codeItem = block.getOperationPriorTo(ifView.getTargetOperation());
        boolean bl = false;
        if (codeItem != null && codeItem instanceof GoToView && ((GoToView)codeItem).isForwardBranch() && ((GoToView)codeItem).getTargetOperation() < ifView.getStartByte()) {
            bl = true;
            block.removeOperation(codeItem.getStartByte());
        }
        Loop loop = new Loop(block, true);
        loop.setPrintPrecondition(bl);
        boolean bl2 = false;
        if (block instanceof Catch && ((Block)(object = (Try)block.getParent().getOperationPriorTo(block.getStartByte()))).getStartByte() >= ifView.getTargetOperation()) {
            block.getParent().createSubBlock(ifView.getTargetOperation(), ifView.getStartByte(), loop);
            bl2 = true;
        }
        if (!bl2) {
            block.createSubBlock(ifView.getTargetOperation(), ifView.getStartByte(), loop);
        }
        object = block.createSubBlock(ifView.getStartByte(), ifView.getStartByte() + 1L, null);
        loop.addAndConditions((Vector)object);
    }

    public Loop collapseBackLoops(Block block) {
        if (!(block instanceof Loop) || block.size() > 2 || block.size() == 0 || !(block.getFirstOperation() instanceof Loop)) {
            return null;
        }
        if (block.size() == 2 && !(block.getLastOperation() instanceof NopView)) {
            return null;
        }
        Loop loop = (Loop)block.getFirstOperation();
        if (!loop.isBackLoop()) {
            return null;
        }
        loop.addAndConditions2(((Loop)block).getConditions());
        loop.setParent(block.getParent());
        return loop;
    }
}

