/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StarManager {
    public static final int NUMBER_OF_STARS = 50;
    public static final int BLACKCOLOR = 0;
    public static final int WHITECOLOR = 0xFFFFFF;
    private int m_numStars;
    private int m_width;
    private int m_height;
    private Image m_image;
    private int[] m_xPos;
    private int[] m_yPos;

    public StarManager(int n, int n2, int n3, int n4) {
        this.m_numStars = n3;
        this.m_width = n;
        this.m_height = n2;
        this.m_image = Image.createImage((int)this.m_width, (int)this.m_height);
        this.m_xPos = new int[this.m_numStars];
        this.m_yPos = new int[this.m_numStars];
        this.generateStars();
        this.generateStarImage(n4);
    }

    public StarManager(int n, int n2, int n3) {
        this(n, n2, 50, n3);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.m_image, 0, 0, 20);
    }

    public void generateStars() {
        int n = 0;
        while (n < this.m_numStars) {
            this.m_xPos[n] = AstrosmashMidlet.getAbsRandomInt() % this.m_width;
            this.m_yPos[n] = AstrosmashMidlet.getAbsRandomInt() % this.m_height;
            ++n;
        }
    }

    public void generateStarImage(int n) {
        Graphics graphics = this.m_image.getGraphics();
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.m_width, this.m_height);
        graphics.setColor(0xFFFFFF);
        int n2 = 0;
        while (n2 < this.m_numStars) {
            graphics.drawLine(this.m_xPos[n2], this.m_yPos[n2], this.m_xPos[n2], this.m_yPos[n2]);
            ++n2;
        }
    }

    public Image getStarImage() {
        return this.m_image;
    }
}

