/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.Drawable;
import com.lavastorm.astrosmash.GameWorld;

public class Collidable
extends Drawable {
    protected int m_nVelocityX = 0;
    protected int m_nVelocityY = 0;
    protected long m_nDuration = 0L;
    protected volatile boolean m_bCollided = false;
    protected long m_nAccumDistanceXTimesTime = 0L;
    protected long m_nAccumDistanceYTimesTime = 0L;

    public Collidable() {
        this.reset();
    }

    public void reset() {
        this.m_nVelocityX = 0;
        this.m_nVelocityY = 0;
        this.m_nDuration = 0L;
        this.m_bCollided = false;
        this.m_nAccumDistanceXTimesTime = 0L;
        this.m_nAccumDistanceYTimesTime = 0L;
    }

    public void moveX(int n) {
        int n2 = this.getX();
        this.setX(n2 + n);
    }

    public void moveY(int n) {
        int n2 = this.getY();
        this.setY(n2 + n);
    }

    public void setVelocity(int n, int n2, long l) {
        this.m_nVelocityX = n;
        this.m_nVelocityY = n2;
        this.m_nDuration = l;
    }

    public void tick(long l, GameWorld gameWorld) {
        long l2 = (long)this.m_nVelocityX * l + this.m_nAccumDistanceXTimesTime;
        long l3 = (long)this.m_nVelocityY * l + this.m_nAccumDistanceYTimesTime;
        this.m_nAccumDistanceXTimesTime = l2 % this.m_nDuration;
        this.m_nAccumDistanceYTimesTime = l3 % this.m_nDuration;
        long l4 = l2 / this.m_nDuration;
        long l5 = l3 / this.m_nDuration;
        this.moveX((int)l4);
        this.moveY((int)l5);
    }

    public boolean intersects(Collidable collidable) {
        return this.intersects(collidable, 1, 1);
    }

    public boolean intersects(Collidable collidable, int n, int n2) {
        int n3 = this.getX();
        int n4 = n3 + n * this.getWidth();
        int n5 = this.getY();
        int n6 = n5 + n2 * this.getHeight();
        int n7 = collidable.getX();
        int n8 = n7 + collidable.getWidth();
        int n9 = collidable.getY();
        int n10 = n9 + collidable.getHeight();
        if ((n7 >= n3 && n7 < n4 || n8 >= n3 && n8 < n4 || n3 >= n7 && n3 < n8 || n4 >= n7 && n4 < n8) && (n9 >= n5 && n9 < n6 || n10 >= n5 && n10 < n6 || n5 >= n9 && n5 < n10 || n6 >= n9 && n6 < n10)) {
            this.setCollided(true);
            collidable.setCollided(true);
            return true;
        }
        return false;
    }

    public boolean getCollided() {
        return this.m_bCollided;
    }

    public void setCollided(boolean bl) {
        this.m_bCollided = bl;
    }
}

