/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.mobile;

import com.nokia.mid.ui.DirectGraphics;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import org.recompile.mobile.PlatformImage;

public class PlatformGraphics
extends Graphics
implements DirectGraphics {
    protected BufferedImage canvas;
    protected Graphics2D gc;
    protected Color awtColor;
    protected int strokeStyle = 0;
    protected Font font = Font.getFont(0, 0, 0);
    public PlatformGraphics platformGraphics;
    public PlatformImage platformImage;
    private int colorAlpha;

    public PlatformGraphics(PlatformImage image) {
        this.canvas = image.getCanvas();
        this.gc = this.canvas.createGraphics();
        this.platformImage = image;
        this.platformGraphics = this;
        this.clipX = 0;
        this.clipY = 0;
        this.clipWidth = this.canvas.getWidth();
        this.clipHeight = this.canvas.getHeight();
        this.setColor(0, 0, 0);
        this.gc.setBackground(new Color(0, 0, 0, 0));
        this.gc.setFont(this.font.platformFont.awtFont);
    }

    public Graphics2D getGraphics2D() {
        return this.gc;
    }

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    public void clearRect(int x, int y, int width, int height) {
        this.gc.clearRect(x, y, width, height);
    }

    @Override
    public void copyArea(int subx, int suby, int subw, int subh, int x, int y, int anchor) {
        x = this.AnchorX(x, subw, anchor);
        y = this.AnchorY(y, subh, anchor);
        BufferedImage sub = this.canvas.getSubimage(subx, suby, subw, subh);
        this.gc.drawImage((Image)sub, x, y, null);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawChar(char character, int x, int y, int anchor) {
        this.drawString(Character.toString(character), x, y, anchor);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y, int anchor) {
        this.drawString(data.toString(), x, y, anchor);
    }

    @Override
    public void drawImage(javax.microedition.lcdui.Image image, int x, int y, int anchor) {
        try {
            int imgWidth = image.getWidth();
            int imgHeight = image.getHeight();
            x = this.AnchorX(x, imgWidth, anchor);
            y = this.AnchorY(y, imgHeight, anchor);
            this.gc.drawImage((Image)image.platformImage.getCanvas(), x, y, null);
        }
        catch (Exception e) {
            System.out.println("drawImage A:" + e.getMessage());
        }
    }

    public void drawImage(javax.microedition.lcdui.Image image, int x, int y) {
        try {
            this.gc.drawImage((Image)image.platformImage.getCanvas(), x, y, null);
        }
        catch (Exception e) {
            System.out.println("drawImage B:" + e.getMessage());
        }
    }

    public void drawImage(BufferedImage image, int x, int y) {
        try {
            this.gc.drawImage((Image)image, x, y, null);
        }
        catch (Exception e) {
            System.out.println("drawImage C:" + e.getMessage());
        }
    }

    public void flushGraphics(javax.microedition.lcdui.Image image, int x, int y, int width, int height) {
        try {
            BufferedImage sub = image.platformImage.getCanvas().getSubimage(x, y, width, height);
            this.gc.drawImage((Image)sub, x, y, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drawRegion(javax.microedition.lcdui.Image image, int subx, int suby, int subw, int subh, int transform, int x, int y, int anchor) {
        try {
            if (transform == 0) {
                BufferedImage sub = image.platformImage.getCanvas().getSubimage(subx, suby, subw, subh);
                x = this.AnchorX(x, subw, anchor);
                y = this.AnchorY(y, subh, anchor);
                this.gc.drawImage((Image)sub, x, y, null);
            } else {
                PlatformImage sub = new PlatformImage(image, subx, suby, subw, subh, transform);
                x = this.AnchorX(x, sub.width, anchor);
                y = this.AnchorY(y, sub.height, anchor);
                this.gc.drawImage((Image)sub.getCanvas(), x, y, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        int i;
        if (width < 1 || height < 1) {
            return;
        }
        if (!processAlpha) {
            i = offset;
            while (i < rgbData.length) {
                int n = i;
                rgbData[n] = rgbData[n] & 0xFFFFFF;
                int n2 = i++;
                rgbData[n2] = rgbData[n2] | 0xFF000000;
            }
        } else {
            i = offset;
            while (i < rgbData.length) {
                int n = i;
                rgbData[n] = rgbData[n] | 0;
                int n3 = i++;
                rgbData[n3] = rgbData[n3] & 0xFFFFFFFF;
            }
        }
        BufferedImage temp = new BufferedImage(width, height, 2);
        temp.setRGB(0, 0, width, height, rgbData, offset, scanlength);
        this.gc.drawImage((Image)temp, x, y, null);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.gc.drawRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawString(String str, int x, int y, int anchor) {
        if (str != null) {
            x = this.AnchorX(x, this.gc.getFontMetrics().stringWidth(str), anchor);
            y = y + this.gc.getFontMetrics().getAscent() - 1;
            y = this.AnchorY(y, this.gc.getFontMetrics().getHeight(), anchor);
            this.gc.drawString(str, x, y);
        }
    }

    @Override
    public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        if (str.length() >= offset + len) {
            this.drawString(str.substring(offset, offset + len), x, y, anchor);
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.gc.fillRect(x, y, width, height);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.gc.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void setColor(int rgb) {
        this.setColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    @Override
    public void setColor(int r, int g, int b) {
        this.color = (r << 16) + (g << 8) + b;
        this.awtColor = new Color(r, g, b);
        this.gc.setColor(this.awtColor);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.gc.setFont(font.platformFont.awtFont);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.gc.setClip(x, y, width, height);
        this.clipX = (int)this.gc.getClipBounds().getX();
        this.clipY = (int)this.gc.getClipBounds().getY();
        this.clipWidth = (int)this.gc.getClipBounds().getWidth();
        this.clipHeight = (int)this.gc.getClipBounds().getHeight();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.gc.clipRect(x, y, width, height);
        this.clipX = (int)this.gc.getClipBounds().getX();
        this.clipY = (int)this.gc.getClipBounds().getY();
        this.clipWidth = (int)this.gc.getClipBounds().getWidth();
        this.clipHeight = (int)this.gc.getClipBounds().getHeight();
    }

    @Override
    public void translate(int x, int y) {
        this.translateX += x;
        this.translateY += y;
        this.gc.translate((double)x, (double)y);
    }

    private int AnchorX(int x, int width, int anchor) {
        int xout = x;
        if ((anchor & 1) > 0) {
            xout = x - width / 2;
        }
        if ((anchor & 8) > 0) {
            xout = x - width;
        }
        if ((anchor & 4) > 0) {
            xout = x;
        }
        return xout;
    }

    private int AnchorY(int y, int height, int anchor) {
        int yout = y;
        if ((anchor & 2) > 0) {
            yout = y - height / 2;
        }
        if ((anchor & 0x10) > 0) {
            yout = y;
        }
        if ((anchor & 0x20) > 0) {
            yout = y - height;
        }
        if ((anchor & 0x40) > 0) {
            yout = y + height;
        }
        return yout;
    }

    public void setAlphaRGB(int ARGB) {
        this.gc.setColor(new Color(ARGB, true));
    }

    @Override
    public int getNativePixelFormat() {
        return 8888;
    }

    @Override
    public int getAlphaComponent() {
        return this.colorAlpha;
    }

    @Override
    public void setARGBColor(int argbColor) {
        this.colorAlpha = argbColor >>> 24 & 0xFF;
        this.setColor(argbColor);
    }

    @Override
    public void drawImage(javax.microedition.lcdui.Image img, int x, int y, int anchor, int manipulation) {
        BufferedImage image = this.manipulateImage(img.platformImage.getCanvas(), manipulation);
        x = this.AnchorX(x, image.getWidth(), anchor);
        y = this.AnchorY(y, image.getHeight(), anchor);
        this.drawImage(image, x, y);
    }

    @Override
    public void drawPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        int[] Type1 = new int[]{-1, -16777216, 0xFFFFFF, 0};
        int c = 0;
        switch (format) {
            case -1: {
                int[] data = new int[pixels.length * 8];
                int row = 0;
                int col = 0;
                for (int b = offset / 8; b < pixels.length; ++b) {
                    for (int j = 0; j < 8; ++j) {
                        c = pixels[b] >> j & 1;
                        if (transparencyMask != null) {
                            c |= (transparencyMask[b] >> j & 1 ^ 1) << 1;
                        }
                        data[(row + j) * width + col] = Type1[c];
                    }
                    if (++col != width) continue;
                    col = 0;
                    row += 8;
                }
                BufferedImage temp = new BufferedImage(width, height, 2);
                temp.setRGB(0, 0, width, height, data, 0, scanlength);
                this.drawImage(this.manipulateImage(temp, manipulation), x, y);
                break;
            }
            case 1: {
                int[] data = new int[pixels.length * 8];
                for (int i = offset / 8; i < pixels.length; ++i) {
                    for (int j = 7; j >= 0; --j) {
                        c = pixels[i] >> j & 1;
                        if (transparencyMask != null) {
                            c |= (transparencyMask[i] >> j & 1 ^ 1) << 1;
                        }
                        data[i * 8 + (7 - j)] = Type1[c];
                    }
                }
                BufferedImage temp = new BufferedImage(width, height, 2);
                temp.setRGB(0, 0, width, height, data, 0, scanlength);
                this.drawImage(this.manipulateImage(temp, manipulation), x, y);
                break;
            }
            default: {
                System.out.println("drawPixels A : Format " + format + " Not Implemented");
            }
        }
    }

    @Override
    public void drawPixels(int[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        BufferedImage temp = new BufferedImage(width, height, 2);
        temp.setRGB(0, 0, width, height, pixels, offset, scanlength);
        BufferedImage temp2 = this.manipulateImage(temp, manipulation);
        this.drawImage(temp2, x, y);
    }

    @Override
    public void drawPixels(short[] pixels, boolean transparency, int offset, int scanlength, int x, int y, int width, int height, int manipulation, int format) {
        int[] data = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            data[i] = this.pixelToColor(pixels[i], format);
        }
        BufferedImage temp = new BufferedImage(width, height, 2);
        temp.setRGB(0, 0, width, height, data, offset, scanlength);
        this.drawImage(this.manipulateImage(temp, manipulation), x, y);
    }

    @Override
    public void drawPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        int temp = this.color;
        this.setColor(argbColor);
        int i = 0;
        while (i < nPoints) {
            int n = i;
            xPoints[n] = xPoints[n] + xOffset;
            int n2 = i++;
            yPoints[n2] = yPoints[n2] + yOffset;
        }
        this.gc.drawPolygon(xPoints, yPoints, nPoints);
        this.setColor(temp);
    }

    @Override
    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        int temp = this.color;
        this.setColor(argbColor);
        this.gc.drawPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
        this.setColor(temp);
    }

    @Override
    public void fillPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, int argbColor) {
        int temp = this.color;
        this.setColor(argbColor);
        int i = 0;
        while (i < nPoints) {
            int n = i;
            xPoints[n] = xPoints[n] + xOffset;
            int n2 = i++;
            yPoints[n2] = yPoints[n2] + yOffset;
        }
        this.gc.fillPolygon(xPoints, yPoints, nPoints);
        this.setColor(temp);
    }

    @Override
    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int argbColor) {
        int temp = this.color;
        this.setColor(argbColor);
        this.gc.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
        this.setColor(temp);
    }

    @Override
    public void getPixels(byte[] pixels, byte[] transparencyMask, int offset, int scanlength, int x, int y, int width, int height, int format) {
    }

    @Override
    public void getPixels(int[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
        this.canvas.getRGB(x, y, width, height, pixels, offset, scanlength);
    }

    @Override
    public void getPixels(short[] pixels, int offset, int scanlength, int x, int y, int width, int height, int format) {
        int i = offset;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                pixels[i] = this.colorToShortPixel(this.canvas.getRGB(col + x, row + y), format);
                ++i;
            }
        }
    }

    private int pixelToColor(short c, int format) {
        int a = 255;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (format) {
            case 1555: {
                a = (c >> 15 & 1) * 255;
                r = c >> 10 & 0x1F;
                g = c >> 5 & 0x1F;
                b = c & 0x1F;
                r = r << 3 | r >> 2;
                g = g << 3 | g >> 2;
                b = b << 3 | b >> 2;
                break;
            }
            case 444: {
                r = c >> 8 & 0xF;
                g = c >> 4 & 0xF;
                b = c & 0xF;
                r = r << 4 | r;
                g = g << 4 | g;
                b = b << 4 | b;
                break;
            }
            case 4444: {
                a = c >> 12 & 0xF;
                r = c >> 8 & 0xF;
                g = c >> 4 & 0xF;
                b = c & 0xF;
                a = a << 4 | a;
                r = r << 4 | r;
                g = g << 4 | g;
                b = b << 4 | b;
                break;
            }
            case 555: {
                r = c >> 10 & 0x1F;
                g = c >> 5 & 0x1F;
                b = c & 0x1F;
                r = r << 3 | r >> 2;
                g = g << 3 | g >> 2;
                b = b << 3 | b >> 2;
                break;
            }
            case 565: {
                r = c >> 11 & 0x1F;
                g = c >> 5 & 0x3F;
                b = c & 0x1F;
                r = r << 3 | r >> 2;
                g = g << 2 | g >> 4;
                b = b << 3 | b >> 2;
            }
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    private short colorToShortPixel(int c, int format) {
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int out = 0;
        switch (format) {
            case 1555: {
                a = c >>> 31;
                r = c >> 19 & 0x1F;
                g = c >> 11 & 0x1F;
                b = c >> 3 & 0x1F;
                out = a << 15 | r << 10 | g << 5 | b;
                break;
            }
            case 444: {
                r = c >> 20 & 0xF;
                g = c >> 12 & 0xF;
                b = c >> 4 & 0xF;
                out = r << 8 | g << 4 | b;
                break;
            }
            case 4444: {
                a = c >>> 28 & 0xF;
                r = c >> 20 & 0xF;
                g = c >> 12 & 0xF;
                b = c >> 4 & 0xF;
                out = a << 12 | r << 8 | g << 4 | b;
                break;
            }
            case 555: {
                r = c >> 19 & 0x1F;
                g = c >> 11 & 0x1F;
                b = c >> 3 & 0x1F;
                out = r << 10 | g << 5 | b;
                break;
            }
            case 565: {
                r = c >> 19 & 0x1F;
                g = c >> 10 & 0x3F;
                b = c >> 3 & 0x1F;
                out = r << 11 | g << 5 | b;
            }
        }
        return (short)out;
    }

    private BufferedImage manipulateImage(BufferedImage image, int manipulation) {
        int HV = 24576;
        int H90 = 8282;
        switch (manipulation) {
            case 8192: {
                return PlatformImage.transformImage(image, 2);
            }
            case 16384: {
                return PlatformImage.transformImage(image, 1);
            }
            case 90: {
                return PlatformImage.transformImage(image, 5);
            }
            case 180: {
                return PlatformImage.transformImage(image, 3);
            }
            case 270: {
                return PlatformImage.transformImage(image, 6);
            }
            case 24576: {
                return PlatformImage.transformImage(image, 3);
            }
            case 8282: {
                return PlatformImage.transformImage(PlatformImage.transformImage(image, 2), 6);
            }
        }
        return image;
    }
}

