/*
 * Decompiled with CFR 0.152.
 */
package code.HUD;

import code.Gameplay.GameScreen;
import code.HUD.Base.Font;
import code.HUD.GUIScreen;
import code.utils.Main;
import javax.microedition.lcdui.Graphics;

public final class LoadingScreen
extends GUIScreen {
    private final Main main;
    private int frames = 0;
    private int lvl;
    private boolean loadSave;
    private boolean loadPos;

    public LoadingScreen(Main main, int lvl, boolean loadSave, boolean loadPos) {
        this.main = main;
        this.lvl = lvl;
        this.loadSave = loadSave;
        this.loadPos = loadPos;
        this.setFont(Main.getFont());
    }

    public final void destroy() {
        super.destroy();
    }

    protected final void paint(Graphics g) {
        if (this.frames == 0) {
            Font font = this.getFont();
            int y = this.getHeight() / 2 - font.height() / 2;
            Main.drawBck(g, y - font.height() / 2, y + font.height() / 2);
            font.drawString(g, Main.getGameText().getDef("LOADING_SCREEN", "LOADING_SCREEN"), this.getWidth() / 2, y, 3);
        }
        ++this.frames;
        if (this.frames < 2) {
            this.repaint();
        } else if (this.frames == 2) {
            GameScreen gs = new GameScreen(this.main, this.lvl, null);
            if (this.loadSave) {
                Main.loadGame(gs.player, this.getWidth(), this.getHeight(), gs.scene);
                gs.scene.getG3D().updateFov((int)gs.player.fov);
                Main.loadObjects(gs.player, gs.getWidth(), gs.getHeight(), gs.scene, gs.levelNumber);
                if (this.loadPos) {
                    Main.loadPosition(gs.player);
                }
            }
            gs.player.copyNewToUsed();
            gs.start();
            gs.scene.deleteUsedObjects(gs.player);
            gs.scene.removeKilledBots();
            Main.setCurrent(gs);
        }
    }
}

