/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.Gameplay.Map.LightMapper;
import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Texture;
import code.Rendering.Vertex;

public abstract class RenderObject {
    public int sz;
    public int nx;
    public int ny;
    public int nz;
    public static final int normal_fp = 12;
    public static final int normal_FP = 4096;

    public RenderObject() {
        this.nz = 0;
        this.ny = 0;
        this.nx = 0;
    }

    public RenderObject(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.y - ver2.y) * (long)(ver1.z - ver3.z) - (long)(ver1.z - ver2.z) * (long)(ver1.y - ver3.y);
        long y = (long)(ver1.z - ver2.z) * (long)(ver1.x - ver3.x) - (long)(ver1.x - ver2.x) * (long)(ver1.z - ver3.z);
        long z = (long)(ver1.x - ver2.x) * (long)(ver1.y - ver3.y) - (long)(ver1.y - ver2.y) * (long)(ver1.x - ver3.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public void calculateNormals(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.y - ver2.y) * (long)(ver1.z - ver3.z) - (long)(ver1.z - ver2.z) * (long)(ver1.y - ver3.y);
        long y = (long)(ver1.z - ver2.z) * (long)(ver1.x - ver3.x) - (long)(ver1.x - ver2.x) * (long)(ver1.z - ver3.z);
        long z = (long)(ver1.x - ver2.x) * (long)(ver1.y - ver3.y) - (long)(ver1.y - ver2.y) * (long)(ver1.x - ver3.x);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public void calculateNormalsProjected(Vertex ver1, Vertex ver2, Vertex ver3) {
        long x = (long)(ver1.sy - ver2.sy) * (long)(ver1.rz - ver3.rz) - (long)(ver1.rz - ver2.rz) * (long)(ver1.sy - ver3.sy);
        long y = (long)(ver1.rz - ver2.rz) * (long)(ver1.sx - ver3.sx) - (long)(ver1.sx - ver2.sx) * (long)(ver1.rz - ver3.rz);
        long z = (long)(ver1.sx - ver2.sx) * (long)(ver1.sy - ver3.sy) - (long)(ver1.sy - ver2.sy) * (long)(ver1.sx - ver3.sx);
        double sqrt = Math.sqrt(x * x + y * y + z * z) / 4096.0;
        this.nx = (short)((double)x / sqrt);
        this.ny = (short)((double)y / sqrt);
        this.nz = (short)((double)z / sqrt);
    }

    public abstract void render(DirectX7 var1, Texture var2);

    public abstract void renderFast(DirectX7 var1, Texture var2);

    public abstract boolean isVisible(int var1, int var2, int var3, int var4);

    public int getLight(Vertex a, int la, DirectX7 g3d) {
        int la2;
        int lightLen = g3d.flashlightEnabled ? 6500 : 5000;
        int lita = -a.rz < DirectX7.fDist || DirectX7.fDist <= 1 ? 255 : 0;
        int fa = 0;
        int vec = 255;
        if (DirectX7.fDist > 1 && LightMapper.cameraVectorLight || (g3d.shootIntensity > 0 || g3d.flashlightEnabled) && -a.rz < lightLen) {
            vec = MathUtils.microCalcLight(this.nx, this.ny, this.nz, a.x - g3d.camera.m03, a.y - g3d.camera.m13, a.z - g3d.camera.m23);
        }
        if (DirectX7.fDist > 1 && -a.rz < DirectX7.fDist) {
            lita = 255 + a.rz * 255 / DirectX7.fDist;
            if (LightMapper.cameraVectorLight) {
                lita = lita * vec / 255;
            }
            if (lita < 0) {
                lita = 0;
            } else if (lita > 255) {
                lita = 255;
            }
        }
        if ((g3d.shootIntensity > 0 || g3d.flashlightEnabled) && -a.rz < lightLen) {
            fa = (255 + a.rz * 255 / lightLen) * vec / 255;
            if (!g3d.flashlightEnabled) {
                fa = fa * g3d.shootIntensity / g3d.shootLength;
            }
            if (fa < 0) {
                fa = 0;
            } else if (fa > 255) {
                return 255;
            }
        }
        if ((la2 = (la * lita >> 8) + fa) > 255) {
            return 255;
        }
        return la2;
    }

    public int[] getLight(Vertex a, int la, int la2, int la3, DirectX7 g3d) {
        int lightLen = g3d.flashlightEnabled ? 6500 : 5000;
        int lita = -a.rz < DirectX7.fDist || DirectX7.fDist <= 1 ? 255 : 0;
        int fa = 0;
        int vec = 255;
        if (DirectX7.fDist > 1 && LightMapper.cameraVectorLight || (g3d.shootIntensity > 0 || g3d.flashlightEnabled) && -a.rz < lightLen) {
            vec = MathUtils.microCalcLight(this.nx, this.ny, this.nz, a.x - g3d.camera.m03, a.y - g3d.camera.m13, a.z - g3d.camera.m23);
        }
        if (DirectX7.fDist > 1 && -a.rz < DirectX7.fDist) {
            lita = 255 + a.rz * 255 / DirectX7.fDist;
            if (LightMapper.cameraVectorLight) {
                lita = lita * vec / 255;
            }
            if (lita < 0) {
                lita = 0;
            } else if (lita > 255) {
                lita = 255;
            }
        }
        if ((g3d.shootIntensity > 0 || g3d.flashlightEnabled) && -a.rz < lightLen) {
            fa = (255 + a.rz * 255 / lightLen) * vec / 255;
            if (!g3d.flashlightEnabled) {
                fa = fa * g3d.shootIntensity / g3d.shootLength;
            }
            if (fa < 0) {
                fa = 0;
            } else if (fa > 255) {
                fa = 255;
            }
        }
        int[] out = new int[3];
        out[0] = la * lita / 255 + fa;
        if (out[0] > 255) {
            out[0] = 255;
        }
        out[1] = la2 * lita / 255 + fa;
        if (out[1] > 255) {
            out[1] = 255;
        }
        out[2] = la3 * lita / 255 + fa;
        if (out[2] > 255) {
            out[2] = 255;
        }
        return out;
    }
}

