/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import code.utils.StringTools;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IniFile {
    final Hashtable hashtable;

    public static IniFile createFromResource(String file) {
        return IniFile.createFromResource(file, false);
    }

    public static IniFile createFromResource(String file, boolean keys) {
        file = StringTools.getStringFromResource(file);
        return new IniFile(file, keys);
    }

    public static Object[] createGroups(String file) {
        file = StringTools.getStringFromResource(file);
        String[] lines = StringTools.cutOnStrings(file, '\n');
        return IniFile.createGroups(lines);
    }

    public static Object[] createGroups(String[] lines) {
        Vector<String> groupsNames = new Vector<String>();
        Vector<IniFile> allGroups = new Vector<IniFile>();
        Hashtable<String, String> currentGroup = null;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() <= 0 || line.startsWith("#") || lines[i].startsWith(";")) continue;
            if (line.charAt(0) == '[') {
                groupsNames.addElement(line.substring(1, line.length() - 1));
                currentGroup = new Hashtable<String, String>();
                allGroups.addElement(new IniFile(currentGroup));
                continue;
            }
            int charIndex = line.indexOf(61);
            if (charIndex < 0) continue;
            String key = line.substring(0, charIndex).trim();
            String val = line.substring(charIndex + 1).trim();
            currentGroup.put(key, val);
        }
        String[] namesM = new String[groupsNames.size()];
        IniFile[] groupsM = new IniFile[namesM.length];
        for (int i = 0; i < namesM.length; ++i) {
            namesM[i] = (String)groupsNames.elementAt(i);
            groupsM[i] = (IniFile)allGroups.elementAt(i);
        }
        return new Object[]{namesM, groupsM};
    }

    public static void save(Hashtable hashtable, PrintStream stream) throws IOException {
        Enumeration keys = hashtable.keys();
        Enumeration els = hashtable.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object obj = els.nextElement();
            if (obj instanceof Hashtable) {
                stream.print('[');
                stream.print(key);
                stream.print("]\n");
                IniFile.save((Hashtable)obj, stream);
                continue;
            }
            if (!(obj instanceof String)) continue;
            stream.print(key);
            stream.print('=');
            stream.print(obj);
            stream.print('\n');
        }
    }

    public IniFile(Hashtable hash) {
        this.hashtable = hash;
    }

    public IniFile(String str, boolean keys) {
        this.hashtable = new Hashtable();
        String[] lines = StringTools.cutOnStrings(str, '\n');
        this.set(lines, keys);
    }

    public IniFile(String[] lines, boolean keys) {
        this.hashtable = new Hashtable();
        this.set(lines, keys);
    }

    public void set(String[] lines, boolean useGroups) {
        Hashtable<String, String> currentGroup = this.hashtable;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() <= 0 || line.startsWith("#") || line.startsWith(";")) continue;
            if (line.charAt(0) == '[' && useGroups) {
                String group = line.substring(1, line.length() - 1);
                currentGroup = new Hashtable<String, String>();
                this.hashtable.put(group, currentGroup);
                continue;
            }
            int charIndex = line.indexOf(61);
            if (charIndex < 0) continue;
            String key = line.substring(0, charIndex).trim();
            String val = line.substring(charIndex + 1).trim();
            currentGroup.put(key, val);
        }
    }

    public void save(PrintStream ps) throws IOException {
        IniFile.save(this.hashtable, ps);
    }

    public String[] keys() {
        String[] out = new String[this.hashtable.size()];
        Enumeration keys = this.hashtable.keys();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)keys.nextElement();
        }
        return out;
    }

    public Hashtable[] hashtables() {
        Hashtable[] out = new Hashtable[this.hashtable.size()];
        Enumeration hashtables = this.hashtable.elements();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Hashtable)hashtables.nextElement();
        }
        return out;
    }

    public boolean groupExists(String group) {
        return this.hashtable.get(group) != null;
    }

    public void put(String group, String key, String value) {
        Object val = this.hashtable.get(group);
        if (val instanceof Hashtable) {
            ((Hashtable)val).put(key, value);
        } else {
            Hashtable<String, String> n = new Hashtable<String, String>();
            n.put(key, value);
            this.hashtable.put(group, n);
        }
    }

    public void put(String key, String value) {
        this.hashtable.put(key, value);
    }

    public String get(String group, String key) {
        Object val = this.hashtable.get(group);
        if (val != null && val instanceof Hashtable) {
            return (String)((Hashtable)val).get(key);
        }
        return null;
    }

    public String getDef(String group, String key, String defaultValue) {
        String val = null;
        Object hash = this.hashtable.get(group);
        if (hash != null && hash instanceof Hashtable) {
            val = (String)((Hashtable)hash).get(key);
        }
        return val == null ? defaultValue : val;
    }

    public byte getByte(String group, String key) {
        return StringTools.parseByte(this.get(group, key));
    }

    public float getFloat(String group, String key) {
        return StringTools.parseFloat(this.get(group, key));
    }

    public float getFloat(String group, String key, float defaultValue) {
        String tmp = this.get(group, key);
        return tmp == null ? defaultValue : StringTools.parseFloat(tmp);
    }

    public int getInt(String group, String key) {
        return StringTools.parseInt(this.get(group, key));
    }

    public int getInt(String group, String key, int defaultValue) {
        String tmp = this.get(group, key);
        return tmp == null ? defaultValue : StringTools.parseInt(tmp);
    }

    public long getLong(String group, String key) {
        return StringTools.parseLong(this.get(group, key));
    }

    public String get(String key) {
        Object val = this.hashtable.get(key);
        return val != null && val instanceof String ? (String)val : null;
    }

    public String getDef(String key, String def) {
        Object val = this.hashtable.get(key);
        return val != null && val instanceof String ? (String)val : def;
    }

    public byte getByte(String key) {
        return StringTools.parseByte(this.get(key));
    }

    public float getFloat(String key) {
        return StringTools.parseFloat(this.get(key));
    }

    public float getFloat(String key, float def) {
        String tmp = this.get(key);
        return tmp == null ? def : StringTools.parseFloat(tmp);
    }

    public int getInt(String key) {
        return StringTools.parseInt(this.get(key));
    }

    public int getInt(String key, int def) {
        String tmp = this.get(key);
        return tmp == null ? def : StringTools.parseInt(tmp);
    }

    public long getLong(String key) {
        return StringTools.parseLong(this.get(key));
    }
}

