/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Objects;

import code.AI.Player;
import code.Gameplay.GameScreen;
import code.Gameplay.Map.House;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Shop;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.utils.Asset;
import code.utils.Main;

public final class ShopObject
extends RoomObject {
    private Vector3D pos;
    private int[] newshop;
    private int[] prices;
    private String[] files;

    public ShopObject(int[] ns, int[] p, String[] f, int x, int y, int z) {
        this.pos = new Vector3D(x, y, z);
        this.newshop = ns;
        for (int i = 0; i < this.newshop.length; ++i) {
            if (this.newshop[i] != -1) continue;
            this.newshop[i] = Shop.weapon_count;
        }
        this.prices = p;
        this.files = f;
        this.activable = true;
        this.clickable = true;
    }

    public final void destroy() {
        this.pos = null;
        this.prices = null;
        this.newshop = null;
        this.files = null;
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
    }

    public final int getPosX() {
        return this.pos.x;
    }

    public final void setPos(int x, int y, int z) {
        this.pos.set(x, y, z);
    }

    public final int getPosZ() {
        return this.pos.z;
    }

    public final int getPosY() {
        return this.pos.y;
    }

    public void activate(House house, Player player, GameScreen gs) {
        if (this.lastActivate > 0L && this.lastActivate + this.timeToReset > GameScreen.time) {
            return;
        }
        if (!this.isAllCollected(Player.usedPoints, player, house, gs)) {
            if (this.errMessage != null) {
                this.errMsg(gs);
            }
            return;
        }
        if (this.sound != null && Main.isSounds && Main.sounds != 0) {
            Asset.getSound(this.sound).start(Main.sounds);
        }
        if (!(this.singleUse && this.activated || this.message == null)) {
            this.prMsg(gs);
        }
        if (!this.singleUse || !this.activated) {
            this.give(this.additional, player, house, gs);
        }
        if (!this.contains(Player.usedPoints, this.name)) {
            int i;
            System.arraycopy(Shop.bckFiles, 0, Shop.files, 0, Shop.files.length);
            System.arraycopy(Shop.bckPrices, 0, Shop.prices, 0, Shop.prices.length);
            this.give(this.name, player);
            Shop.items = this.newshop;
            Shop.index = this.newshop[0];
            this.activated = true;
            if (this.prices != null) {
                for (i = 0; i < this.newshop.length; ++i) {
                    Shop.prices[this.newshop[i]] = this.prices[i];
                }
            }
            if (this.files != null) {
                for (i = 0; i < this.newshop.length; ++i) {
                    Shop.files[this.newshop[i]] = this.files[i];
                }
            }
            if (this.lastActivate >= 0L) {
                this.lastActivate = GameScreen.time;
            }
            gs.openShop();
        }
        if (this.destroyOnUse) {
            house.removeObject(this);
        }
    }
}

