/*
 * Decompiled with CFR 0.152.
 */
package code.AI;

import code.AI.Player;
import code.Math.Matrix;
import code.Rendering.Camera;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.MeshClone;
import code.Rendering.Meshes.Morphing;
import code.Rendering.Meshes.Sprite;
import code.Rendering.MultyTexture;
import code.Rendering.Texture;
import code.Rendering.Vertex;
import code.utils.Asset;
import code.utils.FPS;
import code.utils.GameIni;
import code.utils.Main;
import code.utils.StringTools;

public class TPPose {
    public static TPPose[] meshPoses;
    static Matrix mat;
    static Matrix tmp;
    static MultyTexture mt;
    static byte[] defDrawModes;
    static boolean inited;
    static int radius;
    static int height;
    public String poseName;
    Morphing walk;
    Morphing attack;
    Morphing secondWalk;
    Morphing secondAttack;
    Morphing walkSight;
    Morphing attackSight;
    Morphing secondWalkSight;
    Morphing secondAttackSight;
    MultyTexture secondMt;
    public byte[] drawModesSecond;
    public Sprite muzzleFlash;
    public Vertex muzzleFlashPos;
    public int muzzleFlashTimer;
    int animationSpeedAttack;
    int animationSpeed;
    boolean show3D;
    boolean show2D;
    boolean show3DSight;
    boolean show2DSight;
    boolean showSecond;
    boolean showSecondSight;
    boolean canWalk;
    boolean canWalkSight;
    boolean canJump;
    boolean canJumpSight;
    boolean canLookX;
    boolean canLookXSight;
    boolean canAttack;
    boolean canAttackSight;
    int camX;
    int camY;
    int camZ;
    int camRotX;
    int camXSight;
    int camYSight;
    int camZSight;
    int camRotXSight;
    int camSmoothSteps;
    int camSmoothStepsSight;
    boolean rotModelX;
    boolean rotModelXSight;
    int rotModelY;
    int rotModelYSight;
    float lookSpeed;
    float lookSpeedSight;

    static void init() {
        inited = true;
        if (!Main.isExist("/thirdperson.txt")) {
            return;
        }
        Object[] obj = GameIni.createGroups("/thirdperson.txt");
        String[] names = (String[])obj[0];
        GameIni[] groups = (GameIni[])obj[1];
        meshPoses = new TPPose[groups.length - 1];
        GameIni set = groups[0];
        float scale = set.getFloat("SCALE", 1.0f);
        String tmp = set.get("MODEL");
        Mesh[] models = null;
        MeshClone mc = null;
        Mesh clone = null;
        if (tmp != null) {
            models = Asset.getMeshes(tmp, scale, scale, scale);
            mt = new MultyTexture(set.get("TEX"), false);
            mc = new MeshClone(models[0]);
            clone = mc.copy();
            int sizex = clone.maxX() - clone.minX();
            int sizez = clone.maxZ() - clone.minZ();
            radius = (int)(Math.sqrt(sizex * sizex + sizez * sizez) / 2.0);
            height = clone.maxY() - clone.minY();
            mc.destroy();
        }
        if ((tmp = set.get("DRAW_MODES")) != null) {
            defDrawModes = TPPose.loadModes(tmp);
        }
        for (int i = 0; i < meshPoses.length; ++i) {
            TPPose.meshPoses[i] = new TPPose(names[i + 1], models, clone, groups[i + 1], groups[1]);
        }
    }

    static byte[] loadModes(String tmp) {
        String[] cut = GameIni.cutOnStrings(tmp, ',', ';');
        byte[] out = new byte[cut.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = cut[i].trim().equalsIgnoreCase("std") ? -128 : StringTools.parseByte(cut[i]);
        }
        return out;
    }

    public static void applyRenderModes() {
        if (defDrawModes != null && mt != null) {
            TPPose.applyModes(TPPose.mt.textures, defDrawModes);
        }
        for (int i = 0; i < meshPoses.length; ++i) {
            MultyTexture mt = TPPose.meshPoses[i].secondMt;
            byte[] modes = TPPose.meshPoses[i].drawModesSecond;
            if (mt == null || modes == null) continue;
            TPPose.applyModes(mt.textures, modes);
        }
    }

    private static void applyModes(Texture[] texs, byte[] modes) {
        int len = texs.length > modes.length ? modes.length : texs.length;
        for (int i = 0; i < len; ++i) {
            if (modes[i] == -128) {
                texs[i].drawmode = DirectX7.standartDrawmode;
            }
            texs[i].drawmode = modes[i];
        }
    }

    public TPPose(String poseName, Mesh[] meshes, Mesh clone, GameIni ini, GameIni def) {
        this.poseName = poseName;
        this.walk = TPPose.makeMorphing("WALK", meshes, clone, ini, def, true);
        this.attack = TPPose.makeMorphing("ATTACK", meshes, clone, ini, def, false);
        this.walkSight = TPPose.makeMorphing("WALK_SIGHT", meshes, clone, ini, def, false);
        this.attackSight = TPPose.makeMorphing("ATTACK_SIGHT", meshes, clone, ini, def, false);
        String tmp = ini.getDef("SECOND_DRAW_MODES", def.get("SECOND_DRAW_MODES"));
        if (tmp != null) {
            this.drawModesSecond = TPPose.loadModes(tmp);
        }
        Mesh[] secondModels = null;
        Mesh cloneSecond = null;
        tmp = ini.getDef("SECOND_MODEL", def.get("SECOND_MODEL"));
        if (tmp != null) {
            float scale = ini.getFloat("SECOND_SCALE", def.getFloat("SECOND_SCALE", 1.0f));
            secondModels = Asset.getMeshes(tmp, scale, scale, scale);
            this.secondMt = new MultyTexture(ini.getDef("SECOND_TEX", def.get("SECOND_TEX")), false);
            MeshClone mc = new MeshClone(secondModels[0]);
            cloneSecond = mc.copy();
            mc.destroy();
        }
        this.secondWalk = TPPose.makeMorphing("SECOND_WALK", secondModels, cloneSecond, ini, def, true);
        this.secondAttack = TPPose.makeMorphing("SECOND_ATTACK", secondModels, cloneSecond, ini, def, false);
        this.secondWalkSight = TPPose.makeMorphing("SECOND_WALK_SIGHT", secondModels, cloneSecond, ini, def, false);
        this.secondAttackSight = TPPose.makeMorphing("SECOND_ATTACK_SIGHT", secondModels, cloneSecond, ini, def, false);
        this.show3D = ini.getInt("SHOW_3D", def.getInt("SHOW_3D", 1)) == 1;
        this.show2D = ini.getInt("SHOW_2D", def.getInt("SHOW_2D", 0)) == 1;
        this.showSecond = ini.getInt("SECOND_SHOW_3D", def.getInt("SECOND_SHOW_3D", this.secondWalk == null ? 0 : 1)) == 1;
        this.show3DSight = ini.getInt("SHOW_3D_SIGHT", def.getInt("SHOW_3D_SIGHT", 1)) == 1;
        this.show2DSight = ini.getInt("SHOW_2D_SIGHT", def.getInt("SHOW_2D_SIGHT", 0)) == 1;
        this.showSecondSight = ini.getInt("SECOND_SHOW_3D_SIGHT", def.getInt("SECOND_SHOW_3D_SIGHT", this.secondWalk == null ? 0 : 1)) == 1;
        this.canWalk = ini.getInt("CAN_WALK", def.getInt("CAN_WALK", 1)) == 1;
        this.canWalkSight = ini.getInt("CAN_WALK_SIGHT", def.getInt("CAN_WALK_SIGHT", 1)) == 1;
        this.canJump = ini.getInt("CAN_JUMP", def.getInt("CAN_JUMP", 1)) == 1;
        this.canJumpSight = ini.getInt("CAN_JUMP_SIGHT", def.getInt("CAN_JUMP_SIGHT", 1)) == 1;
        this.canLookX = ini.getInt("CAN_LOOK_X", def.getInt("CAN_LOOK_X", 1)) == 1;
        this.canLookXSight = ini.getInt("CAN_LOOK_X_SIGHT", def.getInt("CAN_LOOK_X_SIGHT", 1)) == 1;
        this.canAttack = ini.getInt("CAN_ATTACK", def.getInt("CAN_ATTACK", 1)) == 1;
        this.canAttackSight = ini.getInt("CAN_ATTACK_SIGHT", def.getInt("CAN_ATTACK_SIGHT", 1)) == 1;
        this.lookSpeed = ini.getFloat("LOOK_SPEED", def.getFloat("LOOK_SPEED", 1.0f));
        this.lookSpeedSight = ini.getFloat("LOOK_SPEED_SIGHT", def.getFloat("LOOK_SPEED_SIGHT", 0.71f));
        tmp = ini.getDef("CAM_POS", def.get("CAM_POS"));
        if (tmp != null) {
            int[] pos = StringTools.cutOnInts(tmp, ',');
            this.camX = pos[0];
            this.camY = pos[1];
            this.camZ = pos[2];
        }
        this.camRotX = ini.getInt("CAM_ROT_X", def.getInt("CAM_ROT_X", 0));
        this.rotModelY = ini.getInt("MODEL_ROT_Y", def.getInt("MODEL_ROT_Y", 0));
        this.camSmoothSteps = ini.getInt("CAM_SMOOTH_STEPS", def.getInt("CAM_SMOOTH_STEPS", 3));
        tmp = ini.getDef("CAM_POS_SIGHT", def.get("CAM_POS_SIGHT"));
        if (tmp != null) {
            int[] pos = StringTools.cutOnInts(tmp, ',');
            this.camXSight = pos[0];
            this.camYSight = pos[1];
            this.camZSight = pos[2];
        }
        this.camRotXSight = ini.getInt("CAM_ROT_X_SIGHT", def.getInt("CAM_ROT_X_SIGHT", 0));
        this.rotModelYSight = ini.getInt("MODEL_ROT_Y_SIGHT", def.getInt("MODEL_ROT_Y_SIGHT", 0));
        this.camSmoothStepsSight = ini.getInt("CAM_SMOOTH_STEPS_SIGHT", def.getInt("CAM_SMOOTH_STEPS_SIGHT", 2));
        this.rotModelX = ini.getInt("ROT_MODEL_X", def.getInt("ROT_MODEL_X", 0)) == 1;
        this.rotModelXSight = ini.getInt("ROT_MODEL_X_SIGHT", def.getInt("ROT_MODEL_X_SIGHT", 0)) == 1;
        tmp = ini.getDef("MUZZLE_FLASH_POS", def.get("MUZZLE_FLASH_POS"));
        if (tmp != null) {
            this.muzzleFlashPos = new Vertex(GameIni.cutOnInts(tmp, ',', ';'));
            this.muzzleFlash = new Sprite(Asset.getTexture(ini.getDef("MUZZLE_FLASH", def.get("MUZZLE_FLASH"))), ini.getInt("MUZZLE_FLASH_SCALE", def.getInt("MUZZLE_FLASH_SCALE", 1)));
            if (this.muzzleFlash.textures[0].rImg.alphaMixing) {
                this.muzzleFlash.mode = (byte)3;
            }
            this.muzzleFlash.fog = false;
            this.muzzleFlashTimer = ini.getInt("MUZZLE_FLASH_TIMER", def.getInt("MUZZLE_FLASH_TIMER", 0));
        }
        this.animationSpeed = ini.getInt("ANIMATION_SPEED", def.getInt("ANIMATION_SPEED", 100));
        this.animationSpeedAttack = ini.getInt("ANIMATION_SPEED_ATTACK", def.getInt("ANIMATION_SPEED_ATTACK", this.animationSpeed));
    }

    public boolean show2D(Player player) {
        return player.zoom ? this.show2DSight : this.show2D;
    }

    public boolean canWalk(Player player) {
        return player.zoom ? this.canWalkSight : this.canWalk;
    }

    public boolean canJump(Player player) {
        return player.zoom ? this.canJumpSight : this.canJump;
    }

    public boolean canLookX(Player player) {
        return player.zoom ? this.canLookXSight : this.canLookX;
    }

    public boolean canAttack(Player player) {
        return player.zoom ? this.canAttackSight : this.canAttack;
    }

    public void update(Camera cam, Player player) {
        boolean zoom = player.zoom;
        cam.x = zoom ? this.camXSight : this.camX;
        cam.y = zoom ? this.camYSight : this.camY;
        cam.z = zoom ? this.camZSight : this.camZ;
        cam.rotX = zoom ? this.camRotXSight : this.camRotX;
        cam.smoothSteps = zoom ? this.camSmoothStepsSight : this.camSmoothSteps;
        Matrix plmat = player.character.getTransform();
        if (!this.canLookX(player) && player.rotateX != 0.0f) {
            player.rotateX = 0.0f;
            player.updateMatrix();
        }
        cam.set(plmat);
    }

    public void draw(Player player, DirectX7 g3d, int x1, int y1, int x2, int y2) {
        boolean zoom = player.zoom;
        Matrix plmat = player.character.getTransform();
        if (zoom ? this.show3DSight : this.show3D) {
            Morphing sec;
            int len;
            mat.set(plmat);
            tmp.setRotY(180 + (zoom ? this.rotModelYSight : this.rotModelY));
            mat.mul(tmp);
            if (!(!zoom ? this.rotModelX : this.rotModelXSight)) {
                tmp.setRotX((int)player.rotateX);
                mat.mul(tmp);
            }
            Morphing thisAttack = this.attack(zoom);
            Morphing thisSecondAttack = this.secondAttack(zoom);
            Morphing anim = this.walk(zoom);
            Morphing second = this.secondWalk(zoom);
            if ((thisAttack != null || thisSecondAttack != null) && player.attackFrame <= (len = (sec = thisAttack == null ? thisSecondAttack : thisAttack).getMaxFrame())) {
                if (thisAttack != null) {
                    anim = thisAttack;
                    anim.setFrameNI(player.attackFrame);
                }
                if (thisSecondAttack != null) {
                    second = thisSecondAttack;
                    second.setFrameNI(player.attackFrame);
                }
                player.attackFrame += this.animationSpeedAttack * FPS.frameTime / 50;
            }
            if (anim != null && (anim == this.walk || anim == this.walkSight)) {
                anim.setFrameNI(player.walkFrame);
            }
            if (second != null && (second == this.secondWalk || second == this.secondWalkSight)) {
                second.setFrameNI(player.walkFrame);
            }
            if (player.character.speed.x != 0 || player.character.speed.z != 0) {
                Morphing w = this.walk(zoom);
                player.walkFrame += this.animationSpeed * FPS.frameTime / 50;
                if (w != null && w.getMaxFrame() != 0) {
                    player.walkFrame %= w.getMaxFrame();
                }
            }
            if (anim != null) {
                anim.setFrame(anim.getFrame());
                g3d.transformAndProjectVertices(anim.getMesh(), g3d.computeFinalMatrix(mat));
                g3d.addMesh(anim.getMesh(), x1, y1, x2, y2, mt);
                if (radius != 0) {
                    anim.getMesh().increaseMeshSz(radius * 4);
                }
            }
            if ((zoom ? this.showSecondSight : this.showSecond) && second != null) {
                second.setFrame(second.getFrame());
                g3d.transformAndProjectVertices(second.getMesh(), g3d.computeFinalMatrix(mat));
                g3d.addMesh(second.getMesh(), x1, y1, x2, y2, this.secondMt);
                if (radius != 0) {
                    second.getMesh().increaseMeshSz(radius * 4);
                }
            }
            if (this.muzzleFlash != null && player.muzzleFrame > 0) {
                this.muzzleFlashPos.transform(mat);
                this.muzzleFlash.pos.set(this.muzzleFlashPos.sx, this.muzzleFlashPos.sy - this.muzzleFlash.getHeight() / 2, this.muzzleFlashPos.rz);
                this.muzzleFlash.project(g3d.getInvCamera(), g3d);
                g3d.addRenderObject(this.muzzleFlash, x1, y1, x2, y2);
                this.muzzleFlash.sz += radius * 4;
                player.muzzleFrame -= FPS.frameTime;
            }
        }
    }

    float lookSpeed(Player player) {
        return player.zoom ? this.lookSpeedSight : this.lookSpeed;
    }

    private static Morphing makeMorphing(String animName, Mesh[] models, Mesh clone, GameIni ini, GameIni def, boolean createIfNo) {
        if (models == null) {
            return null;
        }
        int walkStart = 0;
        int walkEnd = 1;
        String tmp = ini.getDef(animName, def.get(animName));
        if (tmp != null) {
            int[] cycle = StringTools.cutOnInts(tmp, '-');
            walkStart = cycle[0];
            walkEnd = cycle[cycle.length == 1 ? 0 : 1] + 1;
        } else if (!createIfNo) {
            return null;
        }
        short[][] anim = Morphing.create(models, walkStart, walkEnd);
        return new Morphing(anim, clone);
    }

    private Morphing walk(boolean zoom) {
        if (this.walkSight == null) {
            return this.walk;
        }
        return zoom ? this.walkSight : this.walk;
    }

    private Morphing secondWalk(boolean zoom) {
        if (this.secondWalkSight == null) {
            return this.secondWalk;
        }
        return zoom ? this.secondWalkSight : this.secondWalk;
    }

    private Morphing attack(boolean zoom) {
        if (this.attackSight == null) {
            return this.attack;
        }
        return zoom ? this.attackSight : this.attack;
    }

    private Morphing secondAttack(boolean zoom) {
        if (this.secondAttackSight == null) {
            return this.secondAttack;
        }
        return zoom ? this.secondAttackSight : this.secondAttack;
    }

    static {
        mat = new Matrix();
        tmp = new Matrix();
    }
}

