/*
 * Decompiled with CFR 0.152.
 */
package code.utils;

import code.AI.NPC;
import code.AI.Player;
import code.AI.misc.Blood;
import code.AI.misc.Splinter;
import code.Gameplay.GameScreen;
import code.Gameplay.Inventory.ItemsEngine;
import code.Gameplay.InventoryScreen;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Map.Scene;
import code.Gameplay.Objects.ItemsBag;
import code.Gameplay.Objects.NPCSpawner;
import code.Gameplay.Shop;
import code.Gameplay.Weapon;
import code.HUD.Base.Font;
import code.HUD.Base.GameKeyboard;
import code.HUD.DeveloperMenu;
import code.HUD.GameHelp;
import code.HUD.Menu;
import code.HUD.SplashScreen;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.Texture;
import code.utils.GameIni;
import code.utils.IniFile;
import code.utils.RmsUtils;
import code.utils.Sound;
import code.utils.StringTools;
import code.utils.WeaponCreator;
import code.utils.canvas.MainCanvas;
import code.utils.canvas.MyCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class Main
extends MIDlet {
    private boolean run = false;
    public static int lastLevel;
    private static Font font;
    public static IniFile gameText;
    public static String Blood;
    public static float bloodscale;
    public static float splinterscale;
    public static boolean fullScreenSight;
    private static String savename;
    public static boolean corpses;
    public static boolean hideHud;
    public static boolean blood;
    public static boolean frameskip;
    public static boolean mipMapping;
    public static int displaySize;
    public static int floorOffsetSZ;
    public static int lang;
    public static int q;
    public static String life_icon;
    public static String hand_icon;
    public static String money_icon;
    public static String patron_icon;
    public static String sight_icon;
    public static String skull_icon;
    public static String background_logo;
    public static String background;
    public static String shop_patron;
    public static String shop_medkit;
    public static String low_life_icon;
    public static String low_patron_icon;
    public static String patron_no_weapon_icon;
    public static String[] splash;
    public static String[] stepSound;
    public static String jumpSound;
    public static String menuMusic;
    public static boolean canSave;
    public static boolean canSelectLevel;
    public static boolean levelSelectorLoadData;
    public static boolean pauseScreenSave;
    public static boolean saveOnQuit;
    public static boolean hasZoom;
    public static int stdFov;
    public static int zoomFov;
    public static String[] langs;
    public static Image bcks;
    public static Image bcks2;
    public static boolean updateOnlyNear;
    public static boolean updateOnlyNearPhysics;
    public static GameIni settings;
    public static boolean playerHasInventory;
    public static boolean hidesight;
    public static int fogQ;
    public static int pixelsQ;
    public static int persQ;
    public static int availableLevel;
    public static boolean forceLQFog;
    public static boolean originalSight;
    public static boolean originalUseIcon;
    public static int music;
    public static int sounds;
    public static int footsteps;
    public static int mouseSpeed;
    public static boolean isMusic;
    public static boolean isSounds;
    public static boolean isFootsteps;
    public static Sound musicPlayer;
    public static boolean verticalShopScroll;
    public static MainCanvas mainCanvas;
    public static final int s60Optimization = 0;
    public static boolean levelCounter;
    public static boolean resizeWeapons;
    public static boolean symbian;

    public static boolean isExist(String file) {
        try {
            InputStream is = file.getClass().getResourceAsStream(file);
            if (is == null) {
                return false;
            }
            is.close();
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    protected final void startApp() {
        if (!this.run) {
            this.init();
        }
    }

    private void init() {
        String tmp;
        block17: {
            this.run = true;
            settings = GameIni.createGameIniFromResource("/setting.txt", true);
            savename = settings.getDef("SAVE_NAME", "ZOMBIE");
            DeveloperMenu.debugMode = settings.getInt("DEBUG", 0) == 1;
            splinterscale = settings.getFloat("SPLINTER_SCALE", 1.0f);
            bloodscale = settings.getFloat("BLOOD_SCALE", 1.0f);
            canSave = settings.getInt("CANSAVE", 1) == 1;
            saveOnQuit = settings.getInt("SAVESTATE", 0) == 1;
            canSelectLevel = settings.getInt("CANSELECTLEVEL", 1) == 1;
            levelSelectorLoadData = settings.getInt("LEVELSELECTOR_LOAD_DATA", 1) == 1;
            pauseScreenSave = settings.getInt("PAUSE_SCREEN_SAVE", 0) == 1;
            tmp = settings.getNoLang("SHOPSCROLL");
            if (tmp != null) {
                verticalShopScroll = tmp.equals("VERTICAL");
            }
            hidesight = settings.getInt("HIDESIGHT", 0) == 1;
            menuMusic = settings.getNoLang("MENU_MUSIC");
            this.setLanguage("/languages/english.txt");
            Splinter.texture = Texture.createTexture(settings.getNoLang("SPLINTER_SPRITE", "/splinter.png"));
            Splinter.cache();
            String bloodTexture = settings.getNoLang("BLOOD_SPRITE", "/blood.png");
            if (bloodTexture != null) {
                code.AI.misc.Blood.blood = Texture.createTexture(bloodTexture);
            }
            if ((tmp = settings.getNoLang("TEXT_BCK")) != null) {
                try {
                    bcks = Image.createImage((String)tmp);
                }
                catch (Exception var3) {
                    System.out.println("No text background");
                }
            }
            if ((tmp = settings.getNoLang("DIALOG_BCK")) != null) {
                try {
                    bcks2 = Image.createImage((String)tmp);
                }
                catch (Exception var3) {
                    System.out.println("No dialog background");
                }
            }
            life_icon = settings.getNoLang("LIFE_ICON", "/life.png");
            low_life_icon = settings.getNoLang("LOW_LIFE_ICON", null);
            money_icon = settings.getNoLang("MONEY_ICON", "/money.png");
            patron_icon = settings.getNoLang("PATRON_ICON", "/patron.png");
            low_patron_icon = settings.getNoLang("LOW_PATRON_ICON", "/patron_low.png");
            patron_no_weapon_icon = settings.getNoLang("PATRON_NO_WEAPON_ICON", "/patron_no_weapon.png");
            skull_icon = settings.getNoLang("SKULL_ICON", "/skull.png");
            hand_icon = settings.getNoLang("HAND_ICON", "/hand.png");
            background_logo = settings.getNoLang("BACKGROUND_LOGO", "/background.png");
            background = settings.getNoLang("BACKGROUND", "/background2.png");
            shop_patron = settings.getNoLang("SHOP_PATRON_ICON", "/icon_patron.png");
            shop_medkit = settings.getNoLang("SHOP_MEDKIT_ICON", "/icon_medicine_chest.png");
            splash = GameIni.cutOnStrings(settings.getNoLang("SPLASH", "/splash.png"), ',', ';');
            levelCounter = settings.getInt("COUNT_LEVELS", 0) == 1;
            playerHasInventory = settings.getInt("PLAYER_HAS_INVENTORY", 0) == 1;
            InventoryScreen.proportionalInventory = settings.getInt("INVENTORY_PROPORTIONAL", 1) == 1;
            ItemsEngine.init();
            try {
                if (RmsUtils.hasStore(savename)) {
                    byte[] var2 = RmsUtils.openStore(savename);
                    ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                    DataInputStream var6 = new DataInputStream(var5);
                    music = var6.readInt();
                    sounds = var6.readInt();
                    footsteps = var6.readInt();
                    displaySize = var6.readInt();
                    availableLevel = var6.readInt();
                    Main.setPersQ(var6.readInt());
                    fogQ = var6.readInt();
                    pixelsQ = var6.readInt();
                    frameskip = var6.readBoolean();
                    corpses = var6.readBoolean();
                    blood = var6.readBoolean();
                    mipMapping = var6.readBoolean();
                    DeveloperMenu.debugMode = var6.readBoolean();
                    lang = var6.readInt();
                    mouseSpeed = var6.readInt();
                    hideHud = var6.readBoolean();
                    resizeWeapons = var6.readBoolean();
                    lastLevel = var6.readInt();
                    try {
                        int codes = var6.readInt();
                        GameKeyboard.keyCodes = new int[codes];
                        GameKeyboard.hasKeyCodes = new boolean[codes];
                        for (int i = 0; i < codes; ++i) {
                            if (!var6.readBoolean()) continue;
                            GameKeyboard.hasKeyCodes[i] = true;
                            GameKeyboard.keyCodes[i] = var6.readInt();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in keycodes loading");
                        GameKeyboard.keyCodes = null;
                    }
                    if (Main.isExist("/level" + (lastLevel + 1) + ".txt") || !Main.isExist("/level" + lastLevel + ".txt")) {
                        Main.updateLevelCount();
                    }
                    break block17;
                }
                throw new Exception();
            }
            catch (Exception exc) {
                Main.defaultSettings();
            }
        }
        Shop.initShop();
        tmp = settings.getNoLang("OPEN_LEVELS");
        if (tmp != null) {
            availableLevel = tmp.equals("ALL") ? lastLevel : Math.max(availableLevel, StringTools.parseInt(tmp));
        }
        langs = StringTools.cutOnStrings(StringTools.getStringFromResource("/languages/languages.txt"), ',');
        if (lang != -1) {
            String path = "/languages/" + langs[lang].toLowerCase() + ".txt";
            this.setLanguage(path);
        }
        mainCanvas = new MainCanvas(this);
        Main.setCurrent(new SplashScreen(this));
    }

    private static void defaultSettings() {
        music = 100;
        sounds = 100;
        footsteps = 100;
        displaySize = 80;
        availableLevel = 1;
        persQ = 2;
        q = 24;
        pixelsQ = 2;
        fogQ = 2;
        corpses = false;
        blood = false;
        mipMapping = true;
        lang = -1;
        mouseSpeed = 66;
        hideHud = false;
        resizeWeapons = settings.getIntNoLang("RESIZE_WEAPONS", 0) == 1;
        symbian = false;
        String platform = System.getProperty("microedition.platform");
        String osName = System.getProperty("os.name");
        if (osName != null) {
            osName = osName.toLowerCase();
            symbian = osName.equals("symbian");
        } else {
            String[] devicesS60 = new String[]{"NokiaE71", "NokiaE66", "NokiaE63", "Nokia6124", "NokiaN95", "NokiaN82", "NokiaN81", "NokiaN76", "NokiaE90", "NokiaE51", "Nokia6290", "Nokia6121", "Nokia6110", "Nokia5700", "NokiaN77", "NokiaE65", "NokiaE61", "NokiaN93", "NokiaN92", "NokiaN91", "NokiaN80", "NokiaN75", "NokiaN73", "NokiaN71", "NokiaE70", "NokiaE62", "NokiaE60", "NokiaE50", "Nokia3250", "NokiaN91", "NokiaN72", "NokiaN90", "NokiaN70", "Nokia6681", "Nokia6680", "Nokia6630"};
            for (int i = 0; i < devicesS60.length; ++i) {
                if (platform.indexOf(devicesS60[i]) <= -1) continue;
                symbian = true;
                break;
            }
        }
        frameskip = !symbian;
        boolean maxQuality = platform.equals("pstros");
        if (!maxQuality && osName != null) {
            boolean bl = maxQuality = osName.indexOf("win") > -1 || osName.indexOf("mac") > -1 || osName.indexOf("nix") > -1 || osName.indexOf("nux") > -1 || osName.indexOf("aix") > -1 || osName.indexOf("android") > -1;
        }
        if (maxQuality) {
            displaySize = 100;
            frameskip = true;
            Main.setPersQ(4);
        }
        Main.updateLevelCount();
    }

    private static void updateLevelCount() {
        lastLevel = 0;
        while (Main.isExist("/level" + (lastLevel + 1) + ".txt")) {
            ++lastLevel;
        }
    }

    protected final void pauseApp() {
        if (mainCanvas.getScreen() instanceof GameScreen) {
            GameScreen scr = (GameScreen)mainCanvas.getScreen();
            scr.openPause();
        }
    }

    protected final void destroyApp(boolean var1) {
    }

    public static final void setCurrent(MyCanvas canvas) {
        mainCanvas.setScreen(canvas);
    }

    public final void resetCanvas() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)mainCanvas);
    }

    public final void setCanvas(Displayable disp) {
        Display.getDisplay((MIDlet)this).setCurrent(disp);
    }

    public static final void setCurrentRepaint(MyCanvas canvas) {
        mainCanvas.setScreen(canvas);
        canvas.repaint();
    }

    public final void setLanguage(String file) {
        gameText = IniFile.createFromResource(file);
        font = new Font(gameText.get("FONT"));
    }

    public static final Font getFont() {
        return font;
    }

    public static IniFile getGameText() {
        return gameText;
    }

    public static final boolean isFrameskip() {
        return frameskip;
    }

    public static final boolean isCorpses() {
        return corpses;
    }

    public static final boolean isMipMapping() {
        return mipMapping;
    }

    public final boolean isBlood() {
        return blood;
    }

    public static final void setDisplaySize(int size) {
        if (size < 50) {
            size = 50;
        }
        if (size > 100) {
            size = 100;
        }
        displaySize = size;
    }

    public static final int getDisplaySize() {
        return displaySize;
    }

    public final int getAvailableLevelCount() {
        return Math.min(availableLevel, lastLevel);
    }

    public final void setAvailableLevelCount(int i) {
        availableLevel = i;
        this.saveSettingToStore();
    }

    public final void addAvailableLevel(int level) {
        if (level + 1 > availableLevel && level + 1 <= lastLevel) {
            availableLevel = level + 1;
            this.saveSettingToStore();
        }
    }

    public static final boolean isLastLevel(int level) {
        return level >= lastLevel;
    }

    public final void saveSettingToStore() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(music);
            dos.writeInt(sounds);
            dos.writeInt(footsteps);
            dos.writeInt(displaySize);
            dos.writeInt(availableLevel);
            dos.writeInt(persQ);
            dos.writeInt(fogQ);
            dos.writeInt(pixelsQ);
            dos.writeBoolean(frameskip);
            dos.writeBoolean(corpses);
            dos.writeBoolean(blood);
            dos.writeBoolean(mipMapping);
            dos.writeBoolean(DeveloperMenu.debugMode);
            dos.writeInt(lang);
            dos.writeInt(mouseSpeed);
            dos.writeBoolean(hideHud);
            dos.writeBoolean(resizeWeapons);
            dos.writeInt(lastLevel);
            dos.writeInt(GameKeyboard.keyCodes.length);
            for (int i = 0; i < GameKeyboard.keyCodes.length; ++i) {
                if (GameKeyboard.hasKeyCodes[i]) {
                    dos.writeBoolean(true);
                    dos.writeInt(GameKeyboard.keyCodes[i]);
                    continue;
                }
                dos.writeBoolean(false);
            }
            byte[] data = baos.toByteArray();
            dos.close();
            baos.close();
            RmsUtils.removeStore(savename);
            RmsUtils.saveStore(savename, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void drawBck(Graphics g, int beginy, int endy) {
        int y;
        if (bcks == null) {
            return;
        }
        int imgh = bcks.getHeight();
        int imgw = bcks.getWidth();
        int iy = 0;
        for (y = beginy - 1; y > beginy - imgh; --y) {
            g.drawRegion(bcks, 0, imgh - 2 - iy, imgw, 1, 0, 0, y, 0);
            ++iy;
        }
        for (y = beginy; y < endy; ++y) {
            g.drawRegion(bcks, 0, imgh - 1, imgw, 1, 0, 0, y, 0);
        }
        iy = imgh - 1;
        for (y = endy; y < endy + imgh; ++y) {
            g.drawRegion(bcks, 0, iy, imgw, 1, 0, 0, y, 0);
            --iy;
        }
    }

    public static void drawBckDialog(Graphics g, int beginy, int endy) {
        int y;
        if (bcks2 == null) {
            return;
        }
        int imgh = bcks2.getHeight();
        int imgw = bcks2.getWidth();
        int iy = 0;
        for (y = beginy - 1; y > beginy - imgh; --y) {
            g.drawRegion(bcks2, 0, imgh - 2 - iy, imgw, 1, 0, 0, y, 0);
            ++iy;
        }
        for (y = beginy; y < endy; ++y) {
            g.drawRegion(bcks2, 0, imgh - 1, imgw, 1, 0, 0, y, 0);
        }
        iy = imgh - 1;
        for (y = endy; y < endy + imgh; ++y) {
            g.drawRegion(bcks2, 0, iy, imgw, 1, 0, 0, y, 0);
            --iy;
        }
    }

    public static final void saveGame(int levelNum, Player player, Scene scene) {
        if (!canSave) {
            return;
        }
        try {
            int i;
            String savname = savename + "_Player";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(-3);
            dos.writeInt(levelNum + 1);
            Matrix pos = player.getCharacter().getTransform();
            dos.writeInt(pos.m03);
            dos.writeInt(pos.m13);
            dos.writeInt(pos.m23);
            player.updateMatrix();
            dos.writeInt((int)player.rotateY << 12);
            dos.writeInt((int)player.rotateX << 12);
            dos.writeInt(player.getCharacter().getSpeed().x);
            dos.writeInt(player.getCharacter().getSpeed().y);
            dos.writeInt(player.getCharacter().getSpeed().z);
            dos.writeInt(player.money);
            dos.writeInt(player.getHp());
            dos.writeInt((int)player.fov);
            dos.writeInt(player.stdFov);
            dos.writeInt(player.zoomFov);
            dos.writeBoolean(player.zoom);
            dos.writeBoolean(scene.getG3D().flashlightEnabled);
            int weapons = 0;
            int weapons2 = 0;
            Weapon[] weaps = player.arsenal.getWeapons();
            if (weaps != null) {
                weapons = weaps.length;
            }
            for (i = 0; i < weapons; ++i) {
                if (weaps[i] == null) continue;
                ++weapons2;
            }
            System.out.println("write weapons count");
            dos.writeInt(weapons2);
            System.out.println("write weapon current");
            dos.writeInt(player.arsenal.current);
            for (i = 0; i < weapons; ++i) {
                Weapon weapon = weaps[i];
                if (weapon == null) continue;
                dos.writeInt(i);
                dos.writeShort(weapon.magazine.ammo);
                dos.writeShort(weapon.magazine.rounds);
            }
            System.out.println("write keys");
            if (Player.usedPoints != null) {
                int el = Player.usedPoints.size();
                dos.writeInt(el);
                for (int i2 = 0; i2 < el; ++i2) {
                    dos.writeUTF((String)Player.usedPoints.elementAt(i2));
                }
            } else {
                dos.writeInt(0);
            }
            if (playerHasInventory) {
                player.items.writeSave(dos);
            }
            System.out.println("Game saved");
            byte[] data = baos.toByteArray();
            dos.close();
            baos.close();
            RmsUtils.removeStore(savname);
            RmsUtils.saveStore(savname, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void saveObjects(int levelNum, Player player, Scene scene) {
        if (!canSave) {
            return;
        }
        try {
            RoomObject obj;
            int i;
            boolean saveBots;
            String savname = savename + "_lvl" + String.valueOf(levelNum);
            boolean bl = saveBots = scene.rmsBots != null;
            if (saveBots) {
                saveBots = !scene.rmsBots.isEmpty();
            }
            Vector bags = scene.getItemBags();
            if (!saveBots && bags.isEmpty() && scene.rmsObjects.isEmpty()) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            if (saveBots) {
                dos.writeInt(scene.rmsBots.size());
                for (i = 0; i < scene.rmsBots.size(); ++i) {
                    obj = (RoomObject)scene.rmsBots.elementAt(i);
                    if (obj instanceof NPC) {
                        dos.writeBoolean(((NPC)obj).isDead());
                        continue;
                    }
                    if (obj instanceof NPCSpawner) {
                        dos.writeBoolean(((NPCSpawner)obj).deathCheck());
                        continue;
                    }
                    dos.writeBoolean(false);
                }
            } else {
                dos.writeInt(0);
            }
            dos.writeInt(bags.size());
            for (i = 0; i < bags.size(); ++i) {
                obj = (ItemsBag)bags.elementAt(i);
                ((ItemsBag)obj).writeSave(dos);
            }
            dos.writeInt(scene.rmsObjects.size());
            for (i = 0; i < scene.rmsObjects.size(); ++i) {
                obj = (RoomObject)scene.rmsObjects.elementAt(i);
                dos.writeBoolean(obj.activated);
            }
            System.out.println("Game saved");
            byte[] data = baos.toByteArray();
            dos.close();
            baos.close();
            RmsUtils.removeStore(savname);
            RmsUtils.saveStore(savname, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void loadGame(Player player, int w, int h, Scene scene) {
        if (!canSave) {
            return;
        }
        try {
            if (RmsUtils.hasStore(savename + "_Player")) {
                byte[] data = RmsUtils.openStore(savename + "_Player");
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                int version = dis.readInt();
                if (version < 0) {
                    dis.readInt();
                }
                if (version >= 0) {
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                } else if (version <= -1) {
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                }
                player.money = dis.readInt();
                player.setHp(dis.readInt());
                player.fov = dis.readInt();
                player.stdFov = dis.readInt();
                player.zoomFov = dis.readInt();
                player.zoom = dis.readBoolean();
                if (version <= -3) {
                    scene.getG3D().flashlightEnabled = dis.readBoolean();
                }
                int weapc = dis.readInt();
                int current = dis.readInt();
                player.arsenal.destroy();
                player.arsenal.current = current;
                Weapon[] weapons = new Weapon[Shop.weapon_count];
                for (int i = 0; i < weapc; ++i) {
                    int tw = dis.readInt();
                    weapons[tw] = WeaponCreator.createWeapon(tw);
                    weapons[tw].createSprite(w, h * displaySize / 100);
                    weapons[tw].magazine.set(dis.readShort(), dis.readShort());
                }
                player.arsenal.weapons = weapons;
                Player.usedPoints.removeAllElements();
                int objs = dis.readInt();
                for (int i = 0; i < objs; ++i) {
                    Player.usedPoints.addElement(dis.readUTF());
                }
                if (version <= -2 && playerHasInventory) {
                    player.items.loadSave(dis);
                }
                dis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading save file");
        }
    }

    public static final void loadObjects(Player player, int w, int h, Scene scene, int levelNumber) {
        if (!canSave) {
            return;
        }
        String savname = savename + "_lvl" + String.valueOf(levelNumber);
        try {
            if (RmsUtils.hasStore(savname)) {
                byte[] data = RmsUtils.openStore(savname);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                int savedBots = dis.readInt();
                if (savedBots == 0) {
                    scene.rmsBotsKilled = null;
                } else {
                    scene.rmsBotsKilled = new boolean[savedBots];
                    for (int i = 0; i < savedBots; ++i) {
                        scene.rmsBotsKilled[i] = dis.readBoolean();
                    }
                }
                int savedBags = dis.readInt();
                for (int i = 0; i < savedBags; ++i) {
                    ItemsBag bag = new ItemsBag(new Vector3D(0, 0, 0));
                    bag.loadSave(dis);
                    scene.getHouse().addObject(bag);
                }
                int savedObjs = dis.readInt();
                if (savedObjs == 0) {
                    scene.rmsObjectsDestroyed = null;
                } else {
                    scene.rmsObjectsDestroyed = new boolean[savedObjs];
                    for (int i = 0; i < savedObjs; ++i) {
                        scene.rmsObjectsDestroyed[i] = dis.readBoolean();
                    }
                }
                dis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading objects file");
        }
    }

    public static final void loadPosition(Player player) {
        if (!canSave) {
            return;
        }
        try {
            if (RmsUtils.hasStore(savename + "_Player")) {
                byte[] data = RmsUtils.openStore(savename + "_Player");
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                int version = dis.readInt();
                if (version < 0) {
                    dis.readInt();
                }
                if (version >= 0) {
                    player.getCharacter().getTransform().set(dis.readInt() * 0, dis.readInt() * 0, dis.readInt() * 0, dis.readInt(), dis.readInt() * 0, dis.readInt() * 0, dis.readInt() * 0, dis.readInt(), dis.readInt() * 0, dis.readInt() * 0, dis.readInt() * 0, dis.readInt());
                    player.getCharacter().getSpeed().set(dis.readInt(), dis.readInt(), dis.readInt());
                    player.updateMatrix();
                } else if (version <= -1) {
                    player.getCharacter().getTransform().setIdentity();
                    player.getCharacter().getTransform().setPosition(dis.readInt(), dis.readInt(), dis.readInt());
                    player.rotateY = (float)dis.readInt() / 4096.0f;
                    player.rotateX = (float)dis.readInt() / 4096.0f;
                    player.getCharacter().getSpeed().set(dis.readInt(), dis.readInt(), dis.readInt());
                    player.updateMatrix();
                }
                dis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading player position save");
        }
    }

    public static final void loadLevel(boolean loadSave, boolean loadpos, int levelNumber, Object hudInfo, Main main, Menu menu) {
        Main.loadLevel(loadSave, loadpos, levelNumber, hudInfo, main, menu, 1);
    }

    public static final void loadLevel(boolean loadSave, boolean loadpos, int levelNumber, Object hudInfo, Main main, Menu menu, int helpState) {
        try {
            System.gc();
            Thread.sleep(5L);
            if (!GameHelp.needToShow(levelNumber, helpState, false)) {
                if (menu != null) {
                    menu.destroy();
                }
                GameScreen gs = new GameScreen(main, levelNumber, hudInfo);
                if (loadSave) {
                    Main.loadGame(gs.player, gs.getWidth(), gs.getHeight(), gs.scene);
                    gs.scene.getG3D().updateFov((int)gs.player.fov);
                    Main.loadObjects(gs.player, gs.getWidth(), gs.getHeight(), gs.scene, gs.levelNumber);
                    if (loadpos) {
                        Main.loadPosition(gs.player);
                    }
                }
                gs.player.copyNewToUsed();
                gs.start();
                gs.scene.deleteUsedObjects(gs.player);
                gs.scene.removeKilledBots();
                Main.setCurrent(gs);
            } else {
                GameHelp gh = new GameHelp(main, menu, levelNumber, false, hudInfo, helpState);
                GameHelp.loadSave = loadSave;
                GameHelp.loadpos = loadpos;
                Main.setCurrent(gh);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static final void removeSave() {
        if (!canSave) {
            return;
        }
        RmsUtils.removeStore(savename + "_Player");
        for (int i = 0; i < lastLevel; ++i) {
            RmsUtils.removeStore(savename + "_lvl" + String.valueOf(i));
        }
    }

    public static final int getContinueLevel() {
        if (!canSave) {
            return 1;
        }
        try {
            if (RmsUtils.hasStore(savename + "_Player")) {
                byte[] data = RmsUtils.openStore(savename + "_Player");
                ByteArrayInputStream baos = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(baos);
                int lvl = dis.readInt();
                if (lvl < 0) {
                    lvl = dis.readInt();
                }
                dis.close();
                baos.close();
                return lvl - 1;
            }
            return 1;
        }
        catch (Exception e) {
            System.out.println("Error getting continue level number");
            return 1;
        }
    }

    public static final boolean hasSave() {
        if (!canSave) {
            return false;
        }
        try {
            if (!RmsUtils.hasStore(savename + "_Player")) {
                return false;
            }
            byte[] var2 = RmsUtils.openStore(savename + "_Player");
            ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
            DataInputStream var6 = new DataInputStream(var5);
            int lvl = var6.readInt();
            if (lvl < 0) {
                lvl = var6.readInt();
            }
            return lvl != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setPersQ(int pq) {
        persQ = pq;
        q = 12;
        if (persQ <= 2) {
            q = 24;
        }
    }

    static {
        Blood = "/blood.png";
        fullScreenSight = false;
        corpses = false;
        hideHud = false;
        blood = false;
        frameskip = false;
        mipMapping = true;
        displaySize = 80;
        floorOffsetSZ = 0;
        lang = -1;
        q = 24;
        stepSound = null;
        jumpSound = null;
        menuMusic = null;
        canSave = true;
        levelSelectorLoadData = false;
        pauseScreenSave = false;
        hasZoom = true;
        stdFov = 74;
        zoomFov = 44;
        langs = null;
        bcks = null;
        bcks2 = null;
        updateOnlyNear = false;
        updateOnlyNearPhysics = false;
        fogQ = 2;
        pixelsQ = 2;
        persQ = 2;
        availableLevel = 1;
        forceLQFog = false;
        originalSight = false;
        originalUseIcon = false;
        music = 100;
        sounds = 100;
        footsteps = 100;
        mouseSpeed = 66;
        isMusic = true;
        isSounds = true;
        isFootsteps = true;
        musicPlayer = Sound.createMusicPlayer();
        verticalShopScroll = false;
        levelCounter = true;
        resizeWeapons = false;
        symbian = false;
    }
}

