/*
 * Decompiled with CFR 0.152.
 */
package com.AI;

import com.AI.Bot;
import com.AI.Player;
import com.Gameplay.Map.House;
import com.Gameplay.Map.Portal;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.GameObject;
import com.Math.MathUtils;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.Rendering.Fps;
import com.Rendering.Meshes.BoundingBox;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.Meshes.Sprite;
import com.Rendering.MultyTexture;
import com.Rendering.Vertex;
import com.misc.Main;
import java.util.Vector;

public final class NPC
extends Bot {
    private static Fps fps;
    private static Main main;
    private static final Matrix tmpMatrix;
    public int animspeed = 140;
    public int attackanimspeed = 700;
    public int damage = 1;
    public float attackradius = 1.2f;
    public int jumpheight = 140;
    public float jumpspeed = 1.2f;
    public int speed = 140;
    public int reacttimer = 8;
    public int attacktimer = 8;
    public int ai = 1;
    public int playerreaction = 2;
    public int attacktrigger = 2;
    public int moneyOnDeath = 0;
    public int fragsOnDeath = 0;
    public int fragsOnAnyDeath = 0;
    public int damageSleepTime = 0;
    private long lastDamage = 0L;
    public long maxEnemyDistance = -1L;
    public boolean attackOnDamageOnlyPlayer = false;
    public int spawnerId = -1;
    private int maxHp = 100;
    public int model_height;
    private int state = -1;
    public MeshImage meshImage;
    public int[] toAttack;
    public int[] toFollow;
    public int[] friendlyFire;
    private GameObject enemy;
    public final MultyTexture mt;
    private GameObject follower;
    public Vector unicalEnemies;
    private boolean notCol = false;
    private final Vector3D dir = new Vector3D();
    public Sprite stayFront;
    public Sprite stayBack;
    public Sprite staySide;
    public Sprite attackFront;
    public Sprite attackBack;
    public Sprite attackSide;
    public Sprite deathFront;
    public Sprite deathBack;
    public Sprite deathSide;
    public Sprite damageFront;
    public Sprite damageBack;
    public Sprite damageSide;
    public Sprite walkFront;
    public Sprite walkBack;
    public Sprite walkSide;
    public Sprite currentSprite;
    public Sprite muzzleFlash;
    public Vertex muzzleFlashPos;
    public int muzzleFlashTimer;
    public long lastAttack;
    public BoundingBox boundingBox;

    public NPC(Vector3D pos, MeshImage mi, int hp, MultyTexture mts) {
        this.maxHp = hp;
        this.meshImage = mi;
        if (mi != null) {
            this.model_height = mi.getMesh().maxY() - mi.getMesh().minY();
            this.boundingBox = new BoundingBox(this.meshImage.getAnimation());
        }
        this.mt = mts;
        this.fraction = 3;
        this.toAttack = new int[]{1, 2};
        this.toFollow = new int[]{0};
        this.name = "NPC";
        this.visiblityCheck = true;
        this.init(pos);
    }

    public final void init(Vector3D pos) {
        if (this.meshImage != null) {
            this.meshImage.setFrame(0);
        }
        super.set(pos);
        this.setHp(this.maxHp);
        this.dir.set(pos.x + 50, pos.y, pos.z + 50);
        this.lookAt(pos.x + 50, pos.z + 50);
        this.setSprite(this.stayFront, this.staySide, this.stayBack);
        if (this.stayFront != null) {
            this.model_height = this.stayFront.getHeight() * (this.stayFront.textures[0].rImg.scale < 2 ? 2 : 1);
        }
        this.setCharacterSize(this.model_height);
        if (this.unicalEnemies != null) {
            this.unicalEnemies.removeAllElements();
        }
        this.lastDamage = 0L;
        this.state = -1;
        this.follower = null;
        this.enemy = null;
        this.currentSprite = null;
        this.notCol = false;
    }

    public final void initStaySprite() {
        this.setSprite(this.stayFront, this.staySide, this.stayBack);
        if (this.stayFront != null) {
            this.model_height = this.stayFront.getHeight() * (this.stayFront.textures[0].rImg.scale < 2 ? 2 : 1);
        }
    }

    public final void destroy() {
        super.destroy();
        this.enemy = null;
        this.meshImage = null;
        this.boundingBox = null;
    }

    public final boolean checkVisiblity(DirectX7 g3d, int x, int y, int z, int x1, int y1, int x2, int y2) {
        if (this.boundingBox != null) {
            tmpMatrix.setIdentity();
            tmpMatrix.setPosition(x, y, z);
            Matrix fmat = g3d.computeFinalMatrix(tmpMatrix);
            return this.boundingBox.isVisible(g3d, fmat, x1, y1, x2, y2);
        }
        if (this.stayFront != null) {
            this.stayFront.getPosition().set(x, y, z);
            this.stayFront.project(g3d.getInvCamera(), g3d);
            return this.stayFront.isVisible(x1, y1, x2, y2);
        }
        return false;
    }

    public final void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        if (!this.visible) {
            return;
        }
        if (this.meshImage != null) {
            Matrix mat = this.character.getTransform();
            Matrix fmat = g3d.computeFinalMatrix(mat);
            if (this.boundingBox != null && !this.boundingBox.isVisible(g3d, fmat, x1, y1, x2, y2)) {
                return;
            }
            if (mat.m11 == 16384) {
                if (this.state == 1) {
                    this.meshImage.setFrame(this.getFrameInter() * this.animspeed / 100);
                }
                if (this.state == 2) {
                    this.meshImage.setFrame(this.getFrameInter() * this.attackanimspeed / 100);
                }
            }
            this.meshImage.setMatrix(fmat);
            this.meshImage.setTexture(this.mt);
            g3d.addRenderObject(this.meshImage, x1, y1, x2, y2);
            this.meshImage.sz += this.character.getRadius();
            if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.meshImage.sz) {
                this.character.oldFloorPoly.sz = this.meshImage.sz - 1;
            }
        } else if (this.currentSprite != null) {
            this.currentSprite.getPosition().set(this.getPosX(), this.getPosY(), this.getPosZ());
            this.currentSprite.updateFrame();
            this.currentSprite.project(g3d.getInvCamera(), g3d);
            if (!this.currentSprite.isVisible(x1, y1, x2, y2)) {
                return;
            }
            g3d.addRenderObject(this.currentSprite, x1, y1, x2, y2);
            this.currentSprite.sz += this.character.getRadius() * 2;
            if (this.character.oldFloorPoly != null && this.character.oldFloorPoly.sz > this.currentSprite.sz) {
                this.character.oldFloorPoly.sz = this.currentSprite.sz - 1;
            }
        }
        if (this.muzzleFlash != null && System.currentTimeMillis() - this.lastAttack <= (long)this.muzzleFlashTimer) {
            this.muzzleFlashPos.transform(this.character.transform);
            this.muzzleFlash.pos.set(this.muzzleFlashPos.sx, this.muzzleFlashPos.sy - this.muzzleFlash.getHeight() / 2, this.muzzleFlashPos.rz);
            this.muzzleFlash.project(g3d.getInvCamera(), g3d);
            g3d.addRenderObject(this.muzzleFlash, x1, y1, x2, y2);
            this.muzzleFlash.sz += this.character.getRadius();
        }
        this.renderBlood(g3d, 1500);
    }

    protected final void action(Scene scene) {
        if (System.currentTimeMillis() - this.lastDamage < (long)this.damageSleepTime) {
            return;
        }
        if (Math.abs(this.getFrameInterDiv()) % this.reacttimer == 2) {
            House house = scene.getHouse();
            Vector objs = house.getObjects();
            if (this.enemy != null && this.enemy.isDead()) {
                this.enemy = null;
            }
            if (this.unicalEnemies != null && !this.unicalEnemies.isEmpty()) {
                for (int i = 0; i < this.unicalEnemies.size(); ++i) {
                    GameObject tmp;
                    if (!(this.unicalEnemies.elementAt(i) instanceof GameObject) || !(tmp = (GameObject)this.unicalEnemies.elementAt(i)).isDead()) continue;
                    this.unicalEnemies.removeElementAt(i);
                    --i;
                }
            }
            if (this.enemy != null && !NPC.canSeeCheck(this, this.enemy) && this.visiblityCheck) {
                this.enemy = null;
            }
            GameObject oldenemy = this.enemy;
            this.enemy = this.findBot(objs, this, this.toAttack);
            GameObject enemy2 = null;
            if (this.unicalEnemies != null) {
                enemy2 = this.findBot(this.unicalEnemies, this, null);
            }
            this.follower = this.findBot(objs, this, this.toFollow);
            if (this.enemy != null && enemy2 != null && this.character.distance(this.enemy.getCharacter()) > this.character.distance(enemy2.getCharacter())) {
                this.enemy = enemy2;
            }
            if (this.enemy == null && enemy2 != null) {
                this.enemy = enemy2;
            }
            if (this.enemy != null && oldenemy != null && this.character.distance(this.enemy.getCharacter()) > this.character.distance(oldenemy.getCharacter())) {
                this.enemy = oldenemy;
            }
            if (this.enemy == null && oldenemy != null) {
                this.enemy = oldenemy;
            }
            if (this.enemy != null && this.maxEnemyDistance > -1L && this.character.distance(this.enemy.getCharacter()) >= this.maxEnemyDistance * this.maxEnemyDistance) {
                this.enemy = null;
            }
            if (this.enemy != null || this.follower != null) {
                GameObject bot = this.enemy;
                if (this.follower != null && this.character.distance(this.follower.getCharacter()) >= 90000000L) {
                    bot = this.follower;
                }
                if (this.follower != null && this.enemy == null) {
                    bot = this.follower;
                }
                if (this.follower != null && bot == this.follower && this.character.distance(this.follower.getCharacter()) < 9000000L) {
                    bot = null;
                    this.state = -1;
                }
                if (bot == null) {
                    this.state = -1;
                }
                if (bot != null) {
                    if (this.notCollided(house, bot) && scene.getHouse().isNear(this.getPart(), bot.getPart())) {
                        Matrix mat = bot.getCharacter().getTransform();
                        this.dir.set(mat.m03, mat.m13, mat.m23);
                        this.notCol = true;
                    } else {
                        int nextPart = scene.getNext(this.getPart(), bot.getPart());
                        Portal portal = NPC.commonPortal(house, this.getPart(), nextPart);
                        if (portal != null) {
                            NPC.computeCentre(portal, this.dir);
                        }
                        this.notCol = false;
                    }
                    Matrix m = this.character.getTransform();
                    this.lookAt(this.dir.x, this.dir.z);
                    long dist = this.character.distance(bot.getCharacter());
                    if (this.notCol && (float)dist <= (float)NPC.sqr(this.character.getRadius() + bot.getCharacter().getRadius()) * this.attackradius) {
                        if (bot == this.enemy) {
                            this.state = this.playerreaction;
                        }
                    } else {
                        if (this.character.isCollision()) {
                            this.character.jump(this.jumpheight, this.jumpspeed);
                        }
                        this.state = this.ai;
                    }
                }
            }
        }
        if (this.state == 1) {
            this.walk(this.speed);
        }
        if (this.state == this.attacktrigger && this.getFrameInterDiv() % this.attacktimer == 0 && this.enemy != null && this.notCol) {
            this.attack(this.enemy, this.damage);
        }
    }

    protected final void drop(Scene scene) {
        super.drop(scene);
        this.state = -1;
    }

    private void walk(int spd) {
        this.moveZ(spd);
        this.setSprite(this.walkFront, this.walkSide, this.walkBack);
    }

    private void attack(GameObject en, int dam) {
        en.damage(this, dam);
        this.setSprite(this.attackFront, this.attackSide, this.attackBack);
        if (this.muzzleFlash != null) {
            this.lastAttack = System.currentTimeMillis();
        }
    }

    public void setSprite(Sprite front, Sprite side, Sprite back) {
        Sprite nextSpr = null;
        int degree = 0;
        if (DirectX7.camera != null) {
            degree = MathUtils.fixDegree(180 + MathUtils.getAnglez(this.getPosX(), this.getPosZ(), DirectX7.camera.m03, DirectX7.camera.m23) - this.character.getTransform().getRotZ());
        }
        if (front != null) {
            nextSpr = front;
        }
        if (back != null && degree > 90 && degree < 270) {
            nextSpr = back;
        }
        if (side != null && degree > 45 && degree < 135) {
            side.mirX = false;
            nextSpr = side;
        }
        if (side != null && degree > 225 && degree < 315) {
            side.mirX = true;
            nextSpr = side;
        }
        if (this.currentSprite != null && nextSpr != null && (this.currentSprite == this.deathFront || this.currentSprite == this.deathSide || this.currentSprite == this.deathBack)) {
            return;
        }
        if (this.currentSprite != null && nextSpr != null && (this.currentSprite == this.damageFront || this.currentSprite == this.damageSide || this.currentSprite == this.damageBack || this.currentSprite == this.attackFront || this.currentSprite == this.attackSide || this.currentSprite == this.attackBack) && nextSpr != this.damageFront && nextSpr != this.damageSide && nextSpr != this.damageBack && (float)(this.currentSprite.animationBegin - System.currentTimeMillis()) >= (float)(-this.currentSprite.textures.length * 1000) / this.currentSprite.animation_speed) {
            return;
        }
        if (nextSpr == null || nextSpr == this.currentSprite) {
            return;
        }
        this.currentSprite = nextSpr;
        if (this.currentSprite != null) {
            this.currentSprite.animationBegin = System.currentTimeMillis();
        }
    }

    public boolean damage(GameObject obj, int dmg) {
        if (this.friendlyFire != null && (obj instanceof Bot ? Bot.contains(this.friendlyFire, ((Bot)obj).fraction) : obj instanceof Player && Bot.contains(this.friendlyFire, 0))) {
            return false;
        }
        if (System.currentTimeMillis() - this.lastDamage > (long)this.damageSleepTime) {
            this.lastDamage = System.currentTimeMillis();
        }
        int tf = -1;
        if (obj instanceof Player) {
            tf = 0;
        }
        if (obj instanceof Bot && !this.attackOnDamageOnlyPlayer) {
            tf = ((Bot)obj).fraction;
        }
        if (tf != -1 && this.unicalEnemies != null && !NPC.contains(this.toAttack, tf) && !this.unicalEnemies.contains(obj)) {
            this.unicalEnemies.addElement(obj);
        }
        if (this.getHp() - dmg > 0) {
            this.setSprite(this.damageFront, this.damageSide, this.damageBack);
        }
        return super.damage(obj, dmg);
    }

    static {
        tmpMatrix = new Matrix();
    }
}

